/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains success information for an entry that is associated with the <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html"
 * >BatchGetAssetPropertyValueHistory</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAssetPropertyValueHistorySuccessEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetAssetPropertyValueHistorySuccessEntry.Builder, BatchGetAssetPropertyValueHistorySuccessEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryId").getter(getter(BatchGetAssetPropertyValueHistorySuccessEntry::entryId))
            .setter(setter(Builder::entryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()).build();

    private static final SdkField<List<AssetPropertyValue>> ASSET_PROPERTY_VALUE_HISTORY_FIELD = SdkField
            .<List<AssetPropertyValue>> builder(MarshallingType.LIST)
            .memberName("assetPropertyValueHistory")
            .getter(getter(BatchGetAssetPropertyValueHistorySuccessEntry::assetPropertyValueHistory))
            .setter(setter(Builder::assetPropertyValueHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetPropertyValueHistory").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetPropertyValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetPropertyValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD,
            ASSET_PROPERTY_VALUE_HISTORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entryId;

    private final List<AssetPropertyValue> assetPropertyValueHistory;

    private BatchGetAssetPropertyValueHistorySuccessEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.assetPropertyValueHistory = builder.assetPropertyValueHistory;
    }

    /**
     * <p>
     * The ID of the entry.
     * </p>
     * 
     * @return The ID of the entry.
     */
    public final String entryId() {
        return entryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetPropertyValueHistory property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssetPropertyValueHistory() {
        return assetPropertyValueHistory != null && !(assetPropertyValueHistory instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The requested historical values for the specified asset property.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetPropertyValueHistory} method.
     * </p>
     * 
     * @return The requested historical values for the specified asset property.
     */
    public final List<AssetPropertyValue> assetPropertyValueHistory() {
        return assetPropertyValueHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetPropertyValueHistory() ? assetPropertyValueHistory() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyValueHistorySuccessEntry)) {
            return false;
        }
        BatchGetAssetPropertyValueHistorySuccessEntry other = (BatchGetAssetPropertyValueHistorySuccessEntry) obj;
        return Objects.equals(entryId(), other.entryId())
                && hasAssetPropertyValueHistory() == other.hasAssetPropertyValueHistory()
                && Objects.equals(assetPropertyValueHistory(), other.assetPropertyValueHistory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAssetPropertyValueHistorySuccessEntry").add("EntryId", entryId())
                .add("AssetPropertyValueHistory", hasAssetPropertyValueHistory() ? assetPropertyValueHistory() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryId":
            return Optional.ofNullable(clazz.cast(entryId()));
        case "assetPropertyValueHistory":
            return Optional.ofNullable(clazz.cast(assetPropertyValueHistory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyValueHistorySuccessEntry, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyValueHistorySuccessEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetAssetPropertyValueHistorySuccessEntry> {
        /**
         * <p>
         * The ID of the entry.
         * </p>
         * 
         * @param entryId
         *        The ID of the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryId(String entryId);

        /**
         * <p>
         * The requested historical values for the specified asset property.
         * </p>
         * 
         * @param assetPropertyValueHistory
         *        The requested historical values for the specified asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetPropertyValueHistory(Collection<AssetPropertyValue> assetPropertyValueHistory);

        /**
         * <p>
         * The requested historical values for the specified asset property.
         * </p>
         * 
         * @param assetPropertyValueHistory
         *        The requested historical values for the specified asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetPropertyValueHistory(AssetPropertyValue... assetPropertyValueHistory);

        /**
         * <p>
         * The requested historical values for the specified asset property.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AssetPropertyValue>.Builder}
         * avoiding the need to create one manually via {@link List<AssetPropertyValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetPropertyValue>.Builder#build()} is called immediately
         * and its result is passed to {@link #assetPropertyValueHistory(List<AssetPropertyValue>)}.
         * 
         * @param assetPropertyValueHistory
         *        a consumer that will call methods on {@link List<AssetPropertyValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetPropertyValueHistory(List<AssetPropertyValue>)
         */
        Builder assetPropertyValueHistory(Consumer<AssetPropertyValue.Builder>... assetPropertyValueHistory);
    }

    static final class BuilderImpl implements Builder {
        private String entryId;

        private List<AssetPropertyValue> assetPropertyValueHistory = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyValueHistorySuccessEntry model) {
            entryId(model.entryId);
            assetPropertyValueHistory(model.assetPropertyValueHistory);
        }

        public final String getEntryId() {
            return entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final List<AssetPropertyValue.Builder> getAssetPropertyValueHistory() {
            List<AssetPropertyValue.Builder> result = AssetPropertyValueHistoryCopier
                    .copyToBuilder(this.assetPropertyValueHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetPropertyValueHistory(Collection<AssetPropertyValue.BuilderImpl> assetPropertyValueHistory) {
            this.assetPropertyValueHistory = AssetPropertyValueHistoryCopier.copyFromBuilder(assetPropertyValueHistory);
        }

        @Override
        public final Builder assetPropertyValueHistory(Collection<AssetPropertyValue> assetPropertyValueHistory) {
            this.assetPropertyValueHistory = AssetPropertyValueHistoryCopier.copy(assetPropertyValueHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetPropertyValueHistory(AssetPropertyValue... assetPropertyValueHistory) {
            assetPropertyValueHistory(Arrays.asList(assetPropertyValueHistory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetPropertyValueHistory(Consumer<AssetPropertyValue.Builder>... assetPropertyValueHistory) {
            assetPropertyValueHistory(Stream.of(assetPropertyValueHistory)
                    .map(c -> AssetPropertyValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetAssetPropertyValueHistorySuccessEntry build() {
            return new BatchGetAssetPropertyValueHistorySuccessEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
