/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains success information for an entry that is associated with the <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html"
 * >BatchGetAssetPropertyValue</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAssetPropertyValueSuccessEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetAssetPropertyValueSuccessEntry.Builder, BatchGetAssetPropertyValueSuccessEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryId").getter(getter(BatchGetAssetPropertyValueSuccessEntry::entryId))
            .setter(setter(Builder::entryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()).build();

    private static final SdkField<AssetPropertyValue> ASSET_PROPERTY_VALUE_FIELD = SdkField
            .<AssetPropertyValue> builder(MarshallingType.SDK_POJO).memberName("assetPropertyValue")
            .getter(getter(BatchGetAssetPropertyValueSuccessEntry::assetPropertyValue))
            .setter(setter(Builder::assetPropertyValue)).constructor(AssetPropertyValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetPropertyValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD,
            ASSET_PROPERTY_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entryId;

    private final AssetPropertyValue assetPropertyValue;

    private BatchGetAssetPropertyValueSuccessEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.assetPropertyValue = builder.assetPropertyValue;
    }

    /**
     * <p>
     * The ID of the entry.
     * </p>
     * 
     * @return The ID of the entry.
     */
    public final String entryId() {
        return entryId;
    }

    /**
     * Returns the value of the AssetPropertyValue property for this object.
     * 
     * @return The value of the AssetPropertyValue property for this object.
     */
    public final AssetPropertyValue assetPropertyValue() {
        return assetPropertyValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryId());
        hashCode = 31 * hashCode + Objects.hashCode(assetPropertyValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyValueSuccessEntry)) {
            return false;
        }
        BatchGetAssetPropertyValueSuccessEntry other = (BatchGetAssetPropertyValueSuccessEntry) obj;
        return Objects.equals(entryId(), other.entryId()) && Objects.equals(assetPropertyValue(), other.assetPropertyValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAssetPropertyValueSuccessEntry").add("EntryId", entryId())
                .add("AssetPropertyValue", assetPropertyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryId":
            return Optional.ofNullable(clazz.cast(entryId()));
        case "assetPropertyValue":
            return Optional.ofNullable(clazz.cast(assetPropertyValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyValueSuccessEntry, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyValueSuccessEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetAssetPropertyValueSuccessEntry> {
        /**
         * <p>
         * The ID of the entry.
         * </p>
         * 
         * @param entryId
         *        The ID of the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryId(String entryId);

        /**
         * Sets the value of the AssetPropertyValue property for this object.
         *
         * @param assetPropertyValue
         *        The new value for the AssetPropertyValue property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetPropertyValue(AssetPropertyValue assetPropertyValue);

        /**
         * Sets the value of the AssetPropertyValue property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AssetPropertyValue.Builder} avoiding the
         * need to create one manually via {@link AssetPropertyValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssetPropertyValue.Builder#build()} is called immediately and its
         * result is passed to {@link #assetPropertyValue(AssetPropertyValue)}.
         * 
         * @param assetPropertyValue
         *        a consumer that will call methods on {@link AssetPropertyValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetPropertyValue(AssetPropertyValue)
         */
        default Builder assetPropertyValue(Consumer<AssetPropertyValue.Builder> assetPropertyValue) {
            return assetPropertyValue(AssetPropertyValue.builder().applyMutation(assetPropertyValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String entryId;

        private AssetPropertyValue assetPropertyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyValueSuccessEntry model) {
            entryId(model.entryId);
            assetPropertyValue(model.assetPropertyValue);
        }

        public final String getEntryId() {
            return entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final AssetPropertyValue.Builder getAssetPropertyValue() {
            return assetPropertyValue != null ? assetPropertyValue.toBuilder() : null;
        }

        public final void setAssetPropertyValue(AssetPropertyValue.BuilderImpl assetPropertyValue) {
            this.assetPropertyValue = assetPropertyValue != null ? assetPropertyValue.build() : null;
        }

        @Override
        public final Builder assetPropertyValue(AssetPropertyValue assetPropertyValue) {
            this.assetPropertyValue = assetPropertyValue;
            return this;
        }

        @Override
        public BatchGetAssetPropertyValueSuccessEntry build() {
            return new BatchGetAssetPropertyValueSuccessEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
