/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains error information from updating a batch of asset property values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutAssetPropertyError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchPutAssetPropertyError.Builder, BatchPutAssetPropertyError> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchPutAssetPropertyError::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(BatchPutAssetPropertyError::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<List<TimeInNanos>> TIMESTAMPS_FIELD = SdkField
            .<List<TimeInNanos>> builder(MarshallingType.LIST)
            .memberName("timestamps")
            .getter(getter(BatchPutAssetPropertyError::timestamps))
            .setter(setter(Builder::timestamps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeInNanos> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeInNanos::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_MESSAGE_FIELD, TIMESTAMPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorMessage;

    private final List<TimeInNanos> timestamps;

    private BatchPutAssetPropertyError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.timestamps = builder.timestamps;
    }

    /**
     * <p>
     * The error code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchPutAssetPropertyValueErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code.
     * @see BatchPutAssetPropertyValueErrorCode
     */
    public final BatchPutAssetPropertyValueErrorCode errorCode() {
        return BatchPutAssetPropertyValueErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchPutAssetPropertyValueErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code.
     * @see BatchPutAssetPropertyValueErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The associated error message.
     * </p>
     * 
     * @return The associated error message.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Timestamps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTimestamps() {
        return timestamps != null && !(timestamps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of timestamps for each error, if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimestamps} method.
     * </p>
     * 
     * @return A list of timestamps for each error, if any.
     */
    public final List<TimeInNanos> timestamps() {
        return timestamps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasTimestamps() ? timestamps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutAssetPropertyError)) {
            return false;
        }
        BatchPutAssetPropertyError other = (BatchPutAssetPropertyError) obj;
        return Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && hasTimestamps() == other.hasTimestamps()
                && Objects.equals(timestamps(), other.timestamps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutAssetPropertyError").add("ErrorCode", errorCodeAsString())
                .add("ErrorMessage", errorMessage()).add("Timestamps", hasTimestamps() ? timestamps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "timestamps":
            return Optional.ofNullable(clazz.cast(timestamps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutAssetPropertyError, T> g) {
        return obj -> g.apply((BatchPutAssetPropertyError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchPutAssetPropertyError> {
        /**
         * <p>
         * The error code.
         * </p>
         * 
         * @param errorCode
         *        The error code.
         * @see BatchPutAssetPropertyValueErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchPutAssetPropertyValueErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code.
         * </p>
         * 
         * @param errorCode
         *        The error code.
         * @see BatchPutAssetPropertyValueErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchPutAssetPropertyValueErrorCode
         */
        Builder errorCode(BatchPutAssetPropertyValueErrorCode errorCode);

        /**
         * <p>
         * The associated error message.
         * </p>
         * 
         * @param errorMessage
         *        The associated error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * A list of timestamps for each error, if any.
         * </p>
         * 
         * @param timestamps
         *        A list of timestamps for each error, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamps(Collection<TimeInNanos> timestamps);

        /**
         * <p>
         * A list of timestamps for each error, if any.
         * </p>
         * 
         * @param timestamps
         *        A list of timestamps for each error, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamps(TimeInNanos... timestamps);

        /**
         * <p>
         * A list of timestamps for each error, if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TimeInNanos>.Builder} avoiding the
         * need to create one manually via {@link List<TimeInNanos>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TimeInNanos>.Builder#build()} is called immediately and its
         * result is passed to {@link #timestamps(List<TimeInNanos>)}.
         * 
         * @param timestamps
         *        a consumer that will call methods on {@link List<TimeInNanos>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestamps(List<TimeInNanos>)
         */
        Builder timestamps(Consumer<TimeInNanos.Builder>... timestamps);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String errorMessage;

        private List<TimeInNanos> timestamps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutAssetPropertyError model) {
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            timestamps(model.timestamps);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(BatchPutAssetPropertyValueErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final List<TimeInNanos.Builder> getTimestamps() {
            List<TimeInNanos.Builder> result = TimestampsCopier.copyToBuilder(this.timestamps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimestamps(Collection<TimeInNanos.BuilderImpl> timestamps) {
            this.timestamps = TimestampsCopier.copyFromBuilder(timestamps);
        }

        @Override
        public final Builder timestamps(Collection<TimeInNanos> timestamps) {
            this.timestamps = TimestampsCopier.copy(timestamps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestamps(TimeInNanos... timestamps) {
            timestamps(Arrays.asList(timestamps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestamps(Consumer<TimeInNanos.Builder>... timestamps) {
            timestamps(Stream.of(timestamps).map(c -> TimeInNanos.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchPutAssetPropertyError build() {
            return new BatchPutAssetPropertyError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
