/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssetsResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<ListAssetsResponse.Builder, ListAssetsResponse> {
    private static final SdkField<List<AssetSummary>> ASSET_SUMMARIES_FIELD = SdkField
            .<List<AssetSummary>> builder(MarshallingType.LIST)
            .memberName("assetSummaries")
            .getter(getter(ListAssetsResponse::assetSummaries))
            .setter(setter(Builder::assetSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AssetSummary> assetSummaries;

    private final String nextToken;

    private ListAssetsResponse(BuilderImpl builder) {
        super(builder);
        this.assetSummaries = builder.assetSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetSummaries() {
        return assetSummaries != null && !(assetSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that summarizes each asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetSummaries} method.
     * </p>
     * 
     * @return A list that summarizes each asset.
     */
    public final List<AssetSummary> assetSummaries() {
        return assetSummaries;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetSummaries() ? assetSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetsResponse)) {
            return false;
        }
        ListAssetsResponse other = (ListAssetsResponse) obj;
        return hasAssetSummaries() == other.hasAssetSummaries() && Objects.equals(assetSummaries(), other.assetSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssetsResponse").add("AssetSummaries", hasAssetSummaries() ? assetSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetSummaries":
            return Optional.ofNullable(clazz.cast(assetSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssetsResponse, T> g) {
        return obj -> g.apply((ListAssetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAssetsResponse> {
        /**
         * <p>
         * A list that summarizes each asset.
         * </p>
         * 
         * @param assetSummaries
         *        A list that summarizes each asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetSummaries(Collection<AssetSummary> assetSummaries);

        /**
         * <p>
         * A list that summarizes each asset.
         * </p>
         * 
         * @param assetSummaries
         *        A list that summarizes each asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetSummaries(AssetSummary... assetSummaries);

        /**
         * <p>
         * A list that summarizes each asset.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AssetSummary>.Builder} avoiding the
         * need to create one manually via {@link List<AssetSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #assetSummaries(List<AssetSummary>)}.
         * 
         * @param assetSummaries
         *        a consumer that will call methods on {@link List<AssetSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetSummaries(List<AssetSummary>)
         */
        Builder assetSummaries(Consumer<AssetSummary.Builder>... assetSummaries);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private List<AssetSummary> assetSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetsResponse model) {
            super(model);
            assetSummaries(model.assetSummaries);
            nextToken(model.nextToken);
        }

        public final List<AssetSummary.Builder> getAssetSummaries() {
            List<AssetSummary.Builder> result = AssetSummariesCopier.copyToBuilder(this.assetSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetSummaries(Collection<AssetSummary.BuilderImpl> assetSummaries) {
            this.assetSummaries = AssetSummariesCopier.copyFromBuilder(assetSummaries);
        }

        @Override
        public final Builder assetSummaries(Collection<AssetSummary> assetSummaries) {
            this.assetSummaries = AssetSummariesCopier.copy(assetSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetSummaries(AssetSummary... assetSummaries) {
            assetSummaries(Arrays.asList(assetSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetSummaries(Consumer<AssetSummary.Builder>... assetSummaries) {
            assetSummaries(Stream.of(assetSummaries).map(c -> AssetSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssetsResponse build() {
            return new ListAssetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
