/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGatewaysResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<ListGatewaysResponse.Builder, ListGatewaysResponse> {
    private static final SdkField<List<GatewaySummary>> GATEWAY_SUMMARIES_FIELD = SdkField
            .<List<GatewaySummary>> builder(MarshallingType.LIST)
            .memberName("gatewaySummaries")
            .getter(getter(ListGatewaysResponse::gatewaySummaries))
            .setter(setter(Builder::gatewaySummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewaySummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GatewaySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(GatewaySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListGatewaysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<GatewaySummary> gatewaySummaries;

    private final String nextToken;

    private ListGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.gatewaySummaries = builder.gatewaySummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the GatewaySummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGatewaySummaries() {
        return gatewaySummaries != null && !(gatewaySummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that summarizes each gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGatewaySummaries} method.
     * </p>
     * 
     * @return A list that summarizes each gateway.
     */
    public final List<GatewaySummary> gatewaySummaries() {
        return gatewaySummaries;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGatewaySummaries() ? gatewaySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGatewaysResponse)) {
            return false;
        }
        ListGatewaysResponse other = (ListGatewaysResponse) obj;
        return hasGatewaySummaries() == other.hasGatewaySummaries()
                && Objects.equals(gatewaySummaries(), other.gatewaySummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGatewaysResponse")
                .add("GatewaySummaries", hasGatewaySummaries() ? gatewaySummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewaySummaries":
            return Optional.ofNullable(clazz.cast(gatewaySummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGatewaysResponse, T> g) {
        return obj -> g.apply((ListGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGatewaysResponse> {
        /**
         * <p>
         * A list that summarizes each gateway.
         * </p>
         * 
         * @param gatewaySummaries
         *        A list that summarizes each gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewaySummaries(Collection<GatewaySummary> gatewaySummaries);

        /**
         * <p>
         * A list that summarizes each gateway.
         * </p>
         * 
         * @param gatewaySummaries
         *        A list that summarizes each gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewaySummaries(GatewaySummary... gatewaySummaries);

        /**
         * <p>
         * A list that summarizes each gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<GatewaySummary>.Builder} avoiding
         * the need to create one manually via {@link List<GatewaySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GatewaySummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #gatewaySummaries(List<GatewaySummary>)}.
         * 
         * @param gatewaySummaries
         *        a consumer that will call methods on {@link List<GatewaySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewaySummaries(List<GatewaySummary>)
         */
        Builder gatewaySummaries(Consumer<GatewaySummary.Builder>... gatewaySummaries);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private List<GatewaySummary> gatewaySummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGatewaysResponse model) {
            super(model);
            gatewaySummaries(model.gatewaySummaries);
            nextToken(model.nextToken);
        }

        public final List<GatewaySummary.Builder> getGatewaySummaries() {
            List<GatewaySummary.Builder> result = GatewaySummariesCopier.copyToBuilder(this.gatewaySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGatewaySummaries(Collection<GatewaySummary.BuilderImpl> gatewaySummaries) {
            this.gatewaySummaries = GatewaySummariesCopier.copyFromBuilder(gatewaySummaries);
        }

        @Override
        public final Builder gatewaySummaries(Collection<GatewaySummary> gatewaySummaries) {
            this.gatewaySummaries = GatewaySummariesCopier.copy(gatewaySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewaySummaries(GatewaySummary... gatewaySummaries) {
            gatewaySummaries(Arrays.asList(gatewaySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewaySummaries(Consumer<GatewaySummary.Builder>... gatewaySummaries) {
            gatewaySummaries(Stream.of(gatewaySummaries).map(c -> GatewaySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGatewaysResponse build() {
            return new ListGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
