/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccessPolicyResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeAccessPolicyResponse.Builder, DescribeAccessPolicyResponse> {
    private static final SdkField<String> ACCESS_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPolicyId").getter(getter(DescribeAccessPolicyResponse::accessPolicyId))
            .setter(setter(Builder::accessPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyId").build()).build();

    private static final SdkField<String> ACCESS_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPolicyArn").getter(getter(DescribeAccessPolicyResponse::accessPolicyArn))
            .setter(setter(Builder::accessPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyArn").build()).build();

    private static final SdkField<Identity> ACCESS_POLICY_IDENTITY_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("accessPolicyIdentity").getter(getter(DescribeAccessPolicyResponse::accessPolicyIdentity))
            .setter(setter(Builder::accessPolicyIdentity)).constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyIdentity").build())
            .build();

    private static final SdkField<Resource> ACCESS_POLICY_RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("accessPolicyResource").getter(getter(DescribeAccessPolicyResponse::accessPolicyResource))
            .setter(setter(Builder::accessPolicyResource)).constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyResource").build())
            .build();

    private static final SdkField<String> ACCESS_POLICY_PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPolicyPermission").getter(getter(DescribeAccessPolicyResponse::accessPolicyPermissionAsString))
            .setter(setter(Builder::accessPolicyPermission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyPermission").build())
            .build();

    private static final SdkField<Instant> ACCESS_POLICY_CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("accessPolicyCreationDate")
            .getter(getter(DescribeAccessPolicyResponse::accessPolicyCreationDate))
            .setter(setter(Builder::accessPolicyCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyCreationDate").build())
            .build();

    private static final SdkField<Instant> ACCESS_POLICY_LAST_UPDATE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("accessPolicyLastUpdateDate")
            .getter(getter(DescribeAccessPolicyResponse::accessPolicyLastUpdateDate))
            .setter(setter(Builder::accessPolicyLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyLastUpdateDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICY_ID_FIELD,
            ACCESS_POLICY_ARN_FIELD, ACCESS_POLICY_IDENTITY_FIELD, ACCESS_POLICY_RESOURCE_FIELD, ACCESS_POLICY_PERMISSION_FIELD,
            ACCESS_POLICY_CREATION_DATE_FIELD, ACCESS_POLICY_LAST_UPDATE_DATE_FIELD));

    private final String accessPolicyId;

    private final String accessPolicyArn;

    private final Identity accessPolicyIdentity;

    private final Resource accessPolicyResource;

    private final String accessPolicyPermission;

    private final Instant accessPolicyCreationDate;

    private final Instant accessPolicyLastUpdateDate;

    private DescribeAccessPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.accessPolicyId = builder.accessPolicyId;
        this.accessPolicyArn = builder.accessPolicyArn;
        this.accessPolicyIdentity = builder.accessPolicyIdentity;
        this.accessPolicyResource = builder.accessPolicyResource;
        this.accessPolicyPermission = builder.accessPolicyPermission;
        this.accessPolicyCreationDate = builder.accessPolicyCreationDate;
        this.accessPolicyLastUpdateDate = builder.accessPolicyLastUpdateDate;
    }

    /**
     * <p>
     * The ID of the access policy.
     * </p>
     * 
     * @return The ID of the access policy.
     */
    public final String accessPolicyId() {
        return accessPolicyId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access
     * policy, which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         access policy, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code>
     */
    public final String accessPolicyArn() {
        return accessPolicyArn;
    }

    /**
     * <p>
     * The identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) to which this access
     * policy applies.
     * </p>
     * 
     * @return The identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) to which this
     *         access policy applies.
     */
    public final Identity accessPolicyIdentity() {
        return accessPolicyIdentity;
    }

    /**
     * <p>
     * The IoT SiteWise Monitor resource (portal or project) to which this access policy provides access.
     * </p>
     * 
     * @return The IoT SiteWise Monitor resource (portal or project) to which this access policy provides access.
     */
    public final Resource accessPolicyResource() {
        return accessPolicyResource;
    }

    /**
     * <p>
     * The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessPolicyPermission} will return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #accessPolicyPermissionAsString}.
     * </p>
     * 
     * @return The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a project
     *         owner.
     * @see Permission
     */
    public final Permission accessPolicyPermission() {
        return Permission.fromValue(accessPolicyPermission);
    }

    /**
     * <p>
     * The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessPolicyPermission} will return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #accessPolicyPermissionAsString}.
     * </p>
     * 
     * @return The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a project
     *         owner.
     * @see Permission
     */
    public final String accessPolicyPermissionAsString() {
        return accessPolicyPermission;
    }

    /**
     * <p>
     * The date the access policy was created, in Unix epoch time.
     * </p>
     * 
     * @return The date the access policy was created, in Unix epoch time.
     */
    public final Instant accessPolicyCreationDate() {
        return accessPolicyCreationDate;
    }

    /**
     * <p>
     * The date the access policy was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the access policy was last updated, in Unix epoch time.
     */
    public final Instant accessPolicyLastUpdateDate() {
        return accessPolicyLastUpdateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyResource());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyPermissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyLastUpdateDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccessPolicyResponse)) {
            return false;
        }
        DescribeAccessPolicyResponse other = (DescribeAccessPolicyResponse) obj;
        return Objects.equals(accessPolicyId(), other.accessPolicyId())
                && Objects.equals(accessPolicyArn(), other.accessPolicyArn())
                && Objects.equals(accessPolicyIdentity(), other.accessPolicyIdentity())
                && Objects.equals(accessPolicyResource(), other.accessPolicyResource())
                && Objects.equals(accessPolicyPermissionAsString(), other.accessPolicyPermissionAsString())
                && Objects.equals(accessPolicyCreationDate(), other.accessPolicyCreationDate())
                && Objects.equals(accessPolicyLastUpdateDate(), other.accessPolicyLastUpdateDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccessPolicyResponse").add("AccessPolicyId", accessPolicyId())
                .add("AccessPolicyArn", accessPolicyArn()).add("AccessPolicyIdentity", accessPolicyIdentity())
                .add("AccessPolicyResource", accessPolicyResource())
                .add("AccessPolicyPermission", accessPolicyPermissionAsString())
                .add("AccessPolicyCreationDate", accessPolicyCreationDate())
                .add("AccessPolicyLastUpdateDate", accessPolicyLastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPolicyId":
            return Optional.ofNullable(clazz.cast(accessPolicyId()));
        case "accessPolicyArn":
            return Optional.ofNullable(clazz.cast(accessPolicyArn()));
        case "accessPolicyIdentity":
            return Optional.ofNullable(clazz.cast(accessPolicyIdentity()));
        case "accessPolicyResource":
            return Optional.ofNullable(clazz.cast(accessPolicyResource()));
        case "accessPolicyPermission":
            return Optional.ofNullable(clazz.cast(accessPolicyPermissionAsString()));
        case "accessPolicyCreationDate":
            return Optional.ofNullable(clazz.cast(accessPolicyCreationDate()));
        case "accessPolicyLastUpdateDate":
            return Optional.ofNullable(clazz.cast(accessPolicyLastUpdateDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccessPolicyResponse, T> g) {
        return obj -> g.apply((DescribeAccessPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAccessPolicyResponse> {
        /**
         * <p>
         * The ID of the access policy.
         * </p>
         * 
         * @param accessPolicyId
         *        The ID of the access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyId(String accessPolicyId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * access policy, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code>
         * </p>
         * 
         * @param accessPolicyArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the access policy, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyArn(String accessPolicyArn);

        /**
         * <p>
         * The identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) to which this access
         * policy applies.
         * </p>
         * 
         * @param accessPolicyIdentity
         *        The identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) to which this
         *        access policy applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyIdentity(Identity accessPolicyIdentity);

        /**
         * <p>
         * The identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) to which this access
         * policy applies.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identity.Builder} avoiding the need to
         * create one manually via {@link Identity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #accessPolicyIdentity(Identity)}.
         * 
         * @param accessPolicyIdentity
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicyIdentity(Identity)
         */
        default Builder accessPolicyIdentity(Consumer<Identity.Builder> accessPolicyIdentity) {
            return accessPolicyIdentity(Identity.builder().applyMutation(accessPolicyIdentity).build());
        }

        /**
         * <p>
         * The IoT SiteWise Monitor resource (portal or project) to which this access policy provides access.
         * </p>
         * 
         * @param accessPolicyResource
         *        The IoT SiteWise Monitor resource (portal or project) to which this access policy provides access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyResource(Resource accessPolicyResource);

        /**
         * <p>
         * The IoT SiteWise Monitor resource (portal or project) to which this access policy provides access.
         * </p>
         * This is a convenience method that creates an instance of the {@link Resource.Builder} avoiding the need to
         * create one manually via {@link Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #accessPolicyResource(Resource)}.
         * 
         * @param accessPolicyResource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicyResource(Resource)
         */
        default Builder accessPolicyResource(Consumer<Resource.Builder> accessPolicyResource) {
            return accessPolicyResource(Resource.builder().applyMutation(accessPolicyResource).build());
        }

        /**
         * <p>
         * The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a project
         * owner.
         * </p>
         * 
         * @param accessPolicyPermission
         *        The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a
         *        project owner.
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder accessPolicyPermission(String accessPolicyPermission);

        /**
         * <p>
         * The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a project
         * owner.
         * </p>
         * 
         * @param accessPolicyPermission
         *        The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a
         *        project owner.
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder accessPolicyPermission(Permission accessPolicyPermission);

        /**
         * <p>
         * The date the access policy was created, in Unix epoch time.
         * </p>
         * 
         * @param accessPolicyCreationDate
         *        The date the access policy was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyCreationDate(Instant accessPolicyCreationDate);

        /**
         * <p>
         * The date the access policy was last updated, in Unix epoch time.
         * </p>
         * 
         * @param accessPolicyLastUpdateDate
         *        The date the access policy was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyLastUpdateDate(Instant accessPolicyLastUpdateDate);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String accessPolicyId;

        private String accessPolicyArn;

        private Identity accessPolicyIdentity;

        private Resource accessPolicyResource;

        private String accessPolicyPermission;

        private Instant accessPolicyCreationDate;

        private Instant accessPolicyLastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccessPolicyResponse model) {
            super(model);
            accessPolicyId(model.accessPolicyId);
            accessPolicyArn(model.accessPolicyArn);
            accessPolicyIdentity(model.accessPolicyIdentity);
            accessPolicyResource(model.accessPolicyResource);
            accessPolicyPermission(model.accessPolicyPermission);
            accessPolicyCreationDate(model.accessPolicyCreationDate);
            accessPolicyLastUpdateDate(model.accessPolicyLastUpdateDate);
        }

        public final String getAccessPolicyId() {
            return accessPolicyId;
        }

        public final void setAccessPolicyId(String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
        }

        @Override
        public final Builder accessPolicyId(String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
            return this;
        }

        public final String getAccessPolicyArn() {
            return accessPolicyArn;
        }

        public final void setAccessPolicyArn(String accessPolicyArn) {
            this.accessPolicyArn = accessPolicyArn;
        }

        @Override
        public final Builder accessPolicyArn(String accessPolicyArn) {
            this.accessPolicyArn = accessPolicyArn;
            return this;
        }

        public final Identity.Builder getAccessPolicyIdentity() {
            return accessPolicyIdentity != null ? accessPolicyIdentity.toBuilder() : null;
        }

        public final void setAccessPolicyIdentity(Identity.BuilderImpl accessPolicyIdentity) {
            this.accessPolicyIdentity = accessPolicyIdentity != null ? accessPolicyIdentity.build() : null;
        }

        @Override
        public final Builder accessPolicyIdentity(Identity accessPolicyIdentity) {
            this.accessPolicyIdentity = accessPolicyIdentity;
            return this;
        }

        public final Resource.Builder getAccessPolicyResource() {
            return accessPolicyResource != null ? accessPolicyResource.toBuilder() : null;
        }

        public final void setAccessPolicyResource(Resource.BuilderImpl accessPolicyResource) {
            this.accessPolicyResource = accessPolicyResource != null ? accessPolicyResource.build() : null;
        }

        @Override
        public final Builder accessPolicyResource(Resource accessPolicyResource) {
            this.accessPolicyResource = accessPolicyResource;
            return this;
        }

        public final String getAccessPolicyPermission() {
            return accessPolicyPermission;
        }

        public final void setAccessPolicyPermission(String accessPolicyPermission) {
            this.accessPolicyPermission = accessPolicyPermission;
        }

        @Override
        public final Builder accessPolicyPermission(String accessPolicyPermission) {
            this.accessPolicyPermission = accessPolicyPermission;
            return this;
        }

        @Override
        public final Builder accessPolicyPermission(Permission accessPolicyPermission) {
            this.accessPolicyPermission(accessPolicyPermission == null ? null : accessPolicyPermission.toString());
            return this;
        }

        public final Instant getAccessPolicyCreationDate() {
            return accessPolicyCreationDate;
        }

        public final void setAccessPolicyCreationDate(Instant accessPolicyCreationDate) {
            this.accessPolicyCreationDate = accessPolicyCreationDate;
        }

        @Override
        public final Builder accessPolicyCreationDate(Instant accessPolicyCreationDate) {
            this.accessPolicyCreationDate = accessPolicyCreationDate;
            return this;
        }

        public final Instant getAccessPolicyLastUpdateDate() {
            return accessPolicyLastUpdateDate;
        }

        public final void setAccessPolicyLastUpdateDate(Instant accessPolicyLastUpdateDate) {
            this.accessPolicyLastUpdateDate = accessPolicyLastUpdateDate;
        }

        @Override
        public final Builder accessPolicyLastUpdateDate(Instant accessPolicyLastUpdateDate) {
            this.accessPolicyLastUpdateDate = accessPolicyLastUpdateDate;
            return this;
        }

        @Override
        public DescribeAccessPolicyResponse build() {
            return new DescribeAccessPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
