/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssetPropertyAggregatesRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<GetAssetPropertyAggregatesRequest.Builder, GetAssetPropertyAggregatesRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(GetAssetPropertyAggregatesRequest::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetId").build()).build();

    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyId").getter(getter(GetAssetPropertyAggregatesRequest::propertyId))
            .setter(setter(Builder::propertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("propertyId").build()).build();

    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyAlias").getter(getter(GetAssetPropertyAggregatesRequest::propertyAlias))
            .setter(setter(Builder::propertyAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("propertyAlias").build()).build();

    private static final SdkField<List<String>> AGGREGATE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("aggregateTypes")
            .getter(getter(GetAssetPropertyAggregatesRequest::aggregateTypesAsStrings))
            .setter(setter(Builder::aggregateTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("aggregateTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolution").getter(getter(GetAssetPropertyAggregatesRequest::resolution))
            .setter(setter(Builder::resolution))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolution").build()).build();

    private static final SdkField<List<String>> QUALITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("qualities")
            .getter(getter(GetAssetPropertyAggregatesRequest::qualitiesAsStrings))
            .setter(setter(Builder::qualitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("qualities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDate").getter(getter(GetAssetPropertyAggregatesRequest::startDate))
            .setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startDate").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endDate").getter(getter(GetAssetPropertyAggregatesRequest::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endDate").build()).build();

    private static final SdkField<String> TIME_ORDERING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeOrdering").getter(getter(GetAssetPropertyAggregatesRequest::timeOrderingAsString))
            .setter(setter(Builder::timeOrdering))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("timeOrdering").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetAssetPropertyAggregatesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetAssetPropertyAggregatesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, AGGREGATE_TYPES_FIELD, RESOLUTION_FIELD, QUALITIES_FIELD, START_DATE_FIELD,
            END_DATE_FIELD, TIME_ORDERING_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String assetId;

    private final String propertyId;

    private final String propertyAlias;

    private final List<String> aggregateTypes;

    private final String resolution;

    private final List<String> qualities;

    private final Instant startDate;

    private final Instant endDate;

    private final String timeOrdering;

    private final String nextToken;

    private final Integer maxResults;

    private GetAssetPropertyAggregatesRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.aggregateTypes = builder.aggregateTypes;
        this.resolution = builder.resolution;
        this.qualities = builder.qualities;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.timeOrdering = builder.timeOrdering;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the asset.
     * </p>
     * 
     * @return The ID of the asset.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The ID of the asset property.
     * </p>
     * 
     * @return The ID of the asset property.
     */
    public final String propertyId() {
        return propertyId;
    }

    /**
     * <p>
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
     * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     *         <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
     *         industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String propertyAlias() {
        return propertyAlias;
    }

    /**
     * <p>
     * The data aggregating function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregateTypes} method.
     * </p>
     * 
     * @return The data aggregating function.
     */
    public final List<AggregateType> aggregateTypes() {
        return AggregateTypesCopier.copyStringToEnum(aggregateTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregateTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregateTypes() {
        return aggregateTypes != null && !(aggregateTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data aggregating function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregateTypes} method.
     * </p>
     * 
     * @return The data aggregating function.
     */
    public final List<String> aggregateTypesAsStrings() {
        return aggregateTypes;
    }

    /**
     * <p>
     * The time interval over which to aggregate data.
     * </p>
     * 
     * @return The time interval over which to aggregate data.
     */
    public final String resolution() {
        return resolution;
    }

    /**
     * <p>
     * The quality by which to filter asset data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQualities} method.
     * </p>
     * 
     * @return The quality by which to filter asset data.
     */
    public final List<Quality> qualities() {
        return QualitiesCopier.copyStringToEnum(qualities);
    }

    /**
     * For responses, this returns true if the service returned a value for the Qualities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQualities() {
        return qualities != null && !(qualities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The quality by which to filter asset data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQualities} method.
     * </p>
     * 
     * @return The quality by which to filter asset data.
     */
    public final List<String> qualitiesAsStrings() {
        return qualities;
    }

    /**
     * <p>
     * The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.
     * </p>
     * 
     * @return The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch
     *         time.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.
     * </p>
     * 
     * @return The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch
     *         time.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * The chronological sorting order of the requested information.
     * </p>
     * <p>
     * Default: <code>ASCENDING</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeOrdering} will
     * return {@link TimeOrdering#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeOrderingAsString}.
     * </p>
     * 
     * @return The chronological sorting order of the requested information.</p>
     *         <p>
     *         Default: <code>ASCENDING</code>
     * @see TimeOrdering
     */
    public final TimeOrdering timeOrdering() {
        return TimeOrdering.fromValue(timeOrdering);
    }

    /**
     * <p>
     * The chronological sorting order of the requested information.
     * </p>
     * <p>
     * Default: <code>ASCENDING</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeOrdering} will
     * return {@link TimeOrdering#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeOrderingAsString}.
     * </p>
     * 
     * @return The chronological sorting order of the requested information.</p>
     *         <p>
     *         Default: <code>ASCENDING</code>
     * @see TimeOrdering
     */
    public final String timeOrderingAsString() {
        return timeOrdering;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return for each paginated request.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * 
     * @return The maximum number of results to return for each paginated request.</p>
     *         <p>
     *         Default: 100
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregateTypes() ? aggregateTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resolution());
        hashCode = 31 * hashCode + Objects.hashCode(hasQualities() ? qualitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(timeOrderingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssetPropertyAggregatesRequest)) {
            return false;
        }
        GetAssetPropertyAggregatesRequest other = (GetAssetPropertyAggregatesRequest) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(propertyId(), other.propertyId())
                && Objects.equals(propertyAlias(), other.propertyAlias()) && hasAggregateTypes() == other.hasAggregateTypes()
                && Objects.equals(aggregateTypesAsStrings(), other.aggregateTypesAsStrings())
                && Objects.equals(resolution(), other.resolution()) && hasQualities() == other.hasQualities()
                && Objects.equals(qualitiesAsStrings(), other.qualitiesAsStrings())
                && Objects.equals(startDate(), other.startDate()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(timeOrderingAsString(), other.timeOrderingAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAssetPropertyAggregatesRequest").add("AssetId", assetId()).add("PropertyId", propertyId())
                .add("PropertyAlias", propertyAlias())
                .add("AggregateTypes", hasAggregateTypes() ? aggregateTypesAsStrings() : null).add("Resolution", resolution())
                .add("Qualities", hasQualities() ? qualitiesAsStrings() : null).add("StartDate", startDate())
                .add("EndDate", endDate()).add("TimeOrdering", timeOrderingAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "propertyId":
            return Optional.ofNullable(clazz.cast(propertyId()));
        case "propertyAlias":
            return Optional.ofNullable(clazz.cast(propertyAlias()));
        case "aggregateTypes":
            return Optional.ofNullable(clazz.cast(aggregateTypesAsStrings()));
        case "resolution":
            return Optional.ofNullable(clazz.cast(resolution()));
        case "qualities":
            return Optional.ofNullable(clazz.cast(qualitiesAsStrings()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "endDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "timeOrdering":
            return Optional.ofNullable(clazz.cast(timeOrderingAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssetPropertyAggregatesRequest, T> g) {
        return obj -> g.apply((GetAssetPropertyAggregatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAssetPropertyAggregatesRequest> {
        /**
         * <p>
         * The ID of the asset.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The ID of the asset property.
         * </p>
         * 
         * @param propertyId
         *        The ID of the asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyId(String propertyId);

        /**
         * <p>
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
         * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param propertyAlias
         *        The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         *        <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
         *        industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyAlias(String propertyAlias);

        /**
         * <p>
         * The data aggregating function.
         * </p>
         * 
         * @param aggregateTypes
         *        The data aggregating function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateTypesWithStrings(Collection<String> aggregateTypes);

        /**
         * <p>
         * The data aggregating function.
         * </p>
         * 
         * @param aggregateTypes
         *        The data aggregating function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateTypesWithStrings(String... aggregateTypes);

        /**
         * <p>
         * The data aggregating function.
         * </p>
         * 
         * @param aggregateTypes
         *        The data aggregating function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateTypes(Collection<AggregateType> aggregateTypes);

        /**
         * <p>
         * The data aggregating function.
         * </p>
         * 
         * @param aggregateTypes
         *        The data aggregating function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateTypes(AggregateType... aggregateTypes);

        /**
         * <p>
         * The time interval over which to aggregate data.
         * </p>
         * 
         * @param resolution
         *        The time interval over which to aggregate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolution(String resolution);

        /**
         * <p>
         * The quality by which to filter asset data.
         * </p>
         * 
         * @param qualities
         *        The quality by which to filter asset data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualitiesWithStrings(Collection<String> qualities);

        /**
         * <p>
         * The quality by which to filter asset data.
         * </p>
         * 
         * @param qualities
         *        The quality by which to filter asset data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualitiesWithStrings(String... qualities);

        /**
         * <p>
         * The quality by which to filter asset data.
         * </p>
         * 
         * @param qualities
         *        The quality by which to filter asset data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualities(Collection<Quality> qualities);

        /**
         * <p>
         * The quality by which to filter asset data.
         * </p>
         * 
         * @param qualities
         *        The quality by which to filter asset data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualities(Quality... qualities);

        /**
         * <p>
         * The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch
         * time.
         * </p>
         * 
         * @param startDate
         *        The exclusive start of the range from which to query historical data, expressed in seconds in Unix
         *        epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.
         * </p>
         * 
         * @param endDate
         *        The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * The chronological sorting order of the requested information.
         * </p>
         * <p>
         * Default: <code>ASCENDING</code>
         * </p>
         * 
         * @param timeOrdering
         *        The chronological sorting order of the requested information.</p>
         *        <p>
         *        Default: <code>ASCENDING</code>
         * @see TimeOrdering
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeOrdering
         */
        Builder timeOrdering(String timeOrdering);

        /**
         * <p>
         * The chronological sorting order of the requested information.
         * </p>
         * <p>
         * Default: <code>ASCENDING</code>
         * </p>
         * 
         * @param timeOrdering
         *        The chronological sorting order of the requested information.</p>
         *        <p>
         *        Default: <code>ASCENDING</code>
         * @see TimeOrdering
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeOrdering
         */
        Builder timeOrdering(TimeOrdering timeOrdering);

        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return for each paginated request.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for each paginated request.</p>
         *        <p>
         *        Default: 100
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetId;

        private String propertyId;

        private String propertyAlias;

        private List<String> aggregateTypes = DefaultSdkAutoConstructList.getInstance();

        private String resolution;

        private List<String> qualities = DefaultSdkAutoConstructList.getInstance();

        private Instant startDate;

        private Instant endDate;

        private String timeOrdering;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssetPropertyAggregatesRequest model) {
            super(model);
            assetId(model.assetId);
            propertyId(model.propertyId);
            propertyAlias(model.propertyAlias);
            aggregateTypesWithStrings(model.aggregateTypes);
            resolution(model.resolution);
            qualitiesWithStrings(model.qualities);
            startDate(model.startDate);
            endDate(model.endDate);
            timeOrdering(model.timeOrdering);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getPropertyId() {
            return propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final String getPropertyAlias() {
            return propertyAlias;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final Collection<String> getAggregateTypes() {
            if (aggregateTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return aggregateTypes;
        }

        public final void setAggregateTypes(Collection<String> aggregateTypes) {
            this.aggregateTypes = AggregateTypesCopier.copy(aggregateTypes);
        }

        @Override
        public final Builder aggregateTypesWithStrings(Collection<String> aggregateTypes) {
            this.aggregateTypes = AggregateTypesCopier.copy(aggregateTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateTypesWithStrings(String... aggregateTypes) {
            aggregateTypesWithStrings(Arrays.asList(aggregateTypes));
            return this;
        }

        @Override
        public final Builder aggregateTypes(Collection<AggregateType> aggregateTypes) {
            this.aggregateTypes = AggregateTypesCopier.copyEnumToString(aggregateTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateTypes(AggregateType... aggregateTypes) {
            aggregateTypes(Arrays.asList(aggregateTypes));
            return this;
        }

        public final String getResolution() {
            return resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public final Collection<String> getQualities() {
            if (qualities instanceof SdkAutoConstructList) {
                return null;
            }
            return qualities;
        }

        public final void setQualities(Collection<String> qualities) {
            this.qualities = QualitiesCopier.copy(qualities);
        }

        @Override
        public final Builder qualitiesWithStrings(Collection<String> qualities) {
            this.qualities = QualitiesCopier.copy(qualities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualitiesWithStrings(String... qualities) {
            qualitiesWithStrings(Arrays.asList(qualities));
            return this;
        }

        @Override
        public final Builder qualities(Collection<Quality> qualities) {
            this.qualities = QualitiesCopier.copyEnumToString(qualities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualities(Quality... qualities) {
            qualities(Arrays.asList(qualities));
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getTimeOrdering() {
            return timeOrdering;
        }

        public final void setTimeOrdering(String timeOrdering) {
            this.timeOrdering = timeOrdering;
        }

        @Override
        public final Builder timeOrdering(String timeOrdering) {
            this.timeOrdering = timeOrdering;
            return this;
        }

        @Override
        public final Builder timeOrdering(TimeOrdering timeOrdering) {
            this.timeOrdering(timeOrdering == null ? null : timeOrdering.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAssetPropertyAggregatesRequest build() {
            return new GetAssetPropertyAggregatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
