/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a composite model property on an asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompositeModelProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<CompositeModelProperty.Builder, CompositeModelProperty> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CompositeModelProperty::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CompositeModelProperty::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Property> ASSET_PROPERTY_FIELD = SdkField.<Property> builder(MarshallingType.SDK_POJO)
            .memberName("assetProperty").getter(getter(CompositeModelProperty::assetProperty))
            .setter(setter(Builder::assetProperty)).constructor(Property::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetProperty").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            ASSET_PROPERTY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final Property assetProperty;

    private CompositeModelProperty(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.assetProperty = builder.assetProperty;
    }

    /**
     * <p>
     * The name of the property.
     * </p>
     * 
     * @return The name of the property.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the composite model that defines this property.
     * </p>
     * 
     * @return The type of the composite model that defines this property.
     */
    public final String type() {
        return type;
    }

    /**
     * Returns the value of the AssetProperty property for this object.
     * 
     * @return The value of the AssetProperty property for this object.
     */
    public final Property assetProperty() {
        return assetProperty;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(assetProperty());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositeModelProperty)) {
            return false;
        }
        CompositeModelProperty other = (CompositeModelProperty) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(type(), other.type())
                && Objects.equals(assetProperty(), other.assetProperty());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompositeModelProperty").add("Name", name()).add("Type", type())
                .add("AssetProperty", assetProperty()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "assetProperty":
            return Optional.ofNullable(clazz.cast(assetProperty()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompositeModelProperty, T> g) {
        return obj -> g.apply((CompositeModelProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompositeModelProperty> {
        /**
         * <p>
         * The name of the property.
         * </p>
         * 
         * @param name
         *        The name of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the composite model that defines this property.
         * </p>
         * 
         * @param type
         *        The type of the composite model that defines this property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * Sets the value of the AssetProperty property for this object.
         *
         * @param assetProperty
         *        The new value for the AssetProperty property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetProperty(Property assetProperty);

        /**
         * Sets the value of the AssetProperty property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Property.Builder} avoiding the need to
         * create one manually via {@link Property#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Property.Builder#build()} is called immediately and its result is
         * passed to {@link #assetProperty(Property)}.
         * 
         * @param assetProperty
         *        a consumer that will call methods on {@link Property.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetProperty(Property)
         */
        default Builder assetProperty(Consumer<Property.Builder> assetProperty) {
            return assetProperty(Property.builder().applyMutation(assetProperty).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private Property assetProperty;

        private BuilderImpl() {
        }

        private BuilderImpl(CompositeModelProperty model) {
            name(model.name);
            type(model.type);
            assetProperty(model.assetProperty);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Property.Builder getAssetProperty() {
            return assetProperty != null ? assetProperty.toBuilder() : null;
        }

        public final void setAssetProperty(Property.BuilderImpl assetProperty) {
            this.assetProperty = assetProperty != null ? assetProperty.build() : null;
        }

        @Override
        public final Builder assetProperty(Property assetProperty) {
            this.assetProperty = assetProperty;
            return this;
        }

        @Override
        public CompositeModelProperty build() {
            return new CompositeModelProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
