/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssetResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<CreateAssetResponse.Builder, CreateAssetResponse> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(CreateAssetResponse::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> ASSET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetArn").getter(getter(CreateAssetResponse::assetArn)).setter(setter(Builder::assetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetArn").build()).build();

    private static final SdkField<AssetStatus> ASSET_STATUS_FIELD = SdkField.<AssetStatus> builder(MarshallingType.SDK_POJO)
            .memberName("assetStatus").getter(getter(CreateAssetResponse::assetStatus)).setter(setter(Builder::assetStatus))
            .constructor(AssetStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            ASSET_ARN_FIELD, ASSET_STATUS_FIELD));

    private final String assetId;

    private final String assetArn;

    private final AssetStatus assetStatus;

    private CreateAssetResponse(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.assetArn = builder.assetArn;
        this.assetStatus = builder.assetStatus;
    }

    /**
     * <p>
     * The ID of the asset. This ID uniquely identifies the asset within IoT SiteWise and can be used with other IoT
     * SiteWise APIs.
     * </p>
     * 
     * @return The ID of the asset. This ID uniquely identifies the asset within IoT SiteWise and can be used with other
     *         IoT SiteWise APIs.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset,
     * which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         asset, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
     */
    public final String assetArn() {
        return assetArn;
    }

    /**
     * <p>
     * The status of the asset, which contains a state (<code>CREATING</code> after successfully calling this operation)
     * and any error message.
     * </p>
     * 
     * @return The status of the asset, which contains a state (<code>CREATING</code> after successfully calling this
     *         operation) and any error message.
     */
    public final AssetStatus assetStatus() {
        return assetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(assetArn());
        hashCode = 31 * hashCode + Objects.hashCode(assetStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetResponse)) {
            return false;
        }
        CreateAssetResponse other = (CreateAssetResponse) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(assetArn(), other.assetArn())
                && Objects.equals(assetStatus(), other.assetStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssetResponse").add("AssetId", assetId()).add("AssetArn", assetArn())
                .add("AssetStatus", assetStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "assetArn":
            return Optional.ofNullable(clazz.cast(assetArn()));
        case "assetStatus":
            return Optional.ofNullable(clazz.cast(assetStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetResponse, T> g) {
        return obj -> g.apply((CreateAssetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssetResponse> {
        /**
         * <p>
         * The ID of the asset. This ID uniquely identifies the asset within IoT SiteWise and can be used with other IoT
         * SiteWise APIs.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset. This ID uniquely identifies the asset within IoT SiteWise and can be used with
         *        other IoT SiteWise APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * asset, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
         * </p>
         * 
         * @param assetArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the asset, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetArn(String assetArn);

        /**
         * <p>
         * The status of the asset, which contains a state (<code>CREATING</code> after successfully calling this
         * operation) and any error message.
         * </p>
         * 
         * @param assetStatus
         *        The status of the asset, which contains a state (<code>CREATING</code> after successfully calling this
         *        operation) and any error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetStatus(AssetStatus assetStatus);

        /**
         * <p>
         * The status of the asset, which contains a state (<code>CREATING</code> after successfully calling this
         * operation) and any error message.
         * </p>
         * This is a convenience that creates an instance of the {@link AssetStatus.Builder} avoiding the need to create
         * one manually via {@link AssetStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssetStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #assetStatus(AssetStatus)}.
         * 
         * @param assetStatus
         *        a consumer that will call methods on {@link AssetStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetStatus(AssetStatus)
         */
        default Builder assetStatus(Consumer<AssetStatus.Builder> assetStatus) {
            return assetStatus(AssetStatus.builder().applyMutation(assetStatus).build());
        }
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String assetId;

        private String assetArn;

        private AssetStatus assetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetResponse model) {
            super(model);
            assetId(model.assetId);
            assetArn(model.assetArn);
            assetStatus(model.assetStatus);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        @Transient
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetArn() {
            return assetArn;
        }

        public final void setAssetArn(String assetArn) {
            this.assetArn = assetArn;
        }

        @Override
        @Transient
        public final Builder assetArn(String assetArn) {
            this.assetArn = assetArn;
            return this;
        }

        public final AssetStatus.Builder getAssetStatus() {
            return assetStatus != null ? assetStatus.toBuilder() : null;
        }

        public final void setAssetStatus(AssetStatus.BuilderImpl assetStatus) {
            this.assetStatus = assetStatus != null ? assetStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder assetStatus(AssetStatus assetStatus) {
            this.assetStatus = assetStatus;
            return this;
        }

        @Override
        public CreateAssetResponse build() {
            return new CreateAssetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
