/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a time interval window used for data aggregate computations (for example, average, sum, count, and so on).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricWindow implements SdkPojo, Serializable, ToCopyableBuilder<MetricWindow.Builder, MetricWindow> {
    private static final SdkField<TumblingWindow> TUMBLING_FIELD = SdkField.<TumblingWindow> builder(MarshallingType.SDK_POJO)
            .memberName("tumbling").getter(getter(MetricWindow::tumbling)).setter(setter(Builder::tumbling))
            .constructor(TumblingWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tumbling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUMBLING_FIELD));

    private static final long serialVersionUID = 1L;

    private final TumblingWindow tumbling;

    private MetricWindow(BuilderImpl builder) {
        this.tumbling = builder.tumbling;
    }

    /**
     * <p>
     * The tumbling time interval window.
     * </p>
     * 
     * @return The tumbling time interval window.
     */
    public final TumblingWindow tumbling() {
        return tumbling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tumbling());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricWindow)) {
            return false;
        }
        MetricWindow other = (MetricWindow) obj;
        return Objects.equals(tumbling(), other.tumbling());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricWindow").add("Tumbling", tumbling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tumbling":
            return Optional.ofNullable(clazz.cast(tumbling()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricWindow, T> g) {
        return obj -> g.apply((MetricWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricWindow> {
        /**
         * <p>
         * The tumbling time interval window.
         * </p>
         * 
         * @param tumbling
         *        The tumbling time interval window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tumbling(TumblingWindow tumbling);

        /**
         * <p>
         * The tumbling time interval window.
         * </p>
         * This is a convenience that creates an instance of the {@link TumblingWindow.Builder} avoiding the need to
         * create one manually via {@link TumblingWindow#builder()}.
         *
         * When the {@link Consumer} completes, {@link TumblingWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #tumbling(TumblingWindow)}.
         * 
         * @param tumbling
         *        a consumer that will call methods on {@link TumblingWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tumbling(TumblingWindow)
         */
        default Builder tumbling(Consumer<TumblingWindow.Builder> tumbling) {
            return tumbling(TumblingWindow.builder().applyMutation(tumbling).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TumblingWindow tumbling;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricWindow model) {
            tumbling(model.tumbling);
        }

        public final TumblingWindow.Builder getTumbling() {
            return tumbling != null ? tumbling.toBuilder() : null;
        }

        public final void setTumbling(TumblingWindow.BuilderImpl tumbling) {
            this.tumbling = tumbling != null ? tumbling.build() : null;
        }

        @Override
        @Transient
        public final Builder tumbling(TumblingWindow tumbling) {
            this.tumbling = tumbling;
            return this;
        }

        @Override
        public MetricWindow build() {
            return new MetricWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
