/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutStorageConfigurationRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<PutStorageConfigurationRequest.Builder, PutStorageConfigurationRequest> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageType").getter(getter(PutStorageConfigurationRequest::storageTypeAsString))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<MultiLayerStorage> MULTI_LAYER_STORAGE_FIELD = SdkField
            .<MultiLayerStorage> builder(MarshallingType.SDK_POJO).memberName("multiLayerStorage")
            .getter(getter(PutStorageConfigurationRequest::multiLayerStorage)).setter(setter(Builder::multiLayerStorage))
            .constructor(MultiLayerStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiLayerStorage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD,
            MULTI_LAYER_STORAGE_FIELD));

    private final String storageType;

    private final MultiLayerStorage multiLayerStorage;

    private PutStorageConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.storageType = builder.storageType;
        this.multiLayerStorage = builder.multiLayerStorage;
    }

    /**
     * <p>
     * The type of storage that you specified for your data. The storage type can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and saves a
     * copy of your raw data and metadata in an Amazon S3 object that you specified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The type of storage that you specified for your data. The storage type can be one of the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed
     *         database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and
     *         saves a copy of your raw data and metadata in an Amazon S3 object that you specified.
     *         </p>
     *         </li>
     * @see StorageType
     */
    public final StorageType storageType() {
        return StorageType.fromValue(storageType);
    }

    /**
     * <p>
     * The type of storage that you specified for your data. The storage type can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and saves a
     * copy of your raw data and metadata in an Amazon S3 object that you specified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The type of storage that you specified for your data. The storage type can be one of the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed
     *         database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and
     *         saves a copy of your raw data and metadata in an Amazon S3 object that you specified.
     *         </p>
     *         </li>
     * @see StorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * <p>
     * Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type, you
     * must specify a <code>MultiLayerStorage</code> object.
     * </p>
     * 
     * @return Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type,
     *         you must specify a <code>MultiLayerStorage</code> object.
     */
    public final MultiLayerStorage multiLayerStorage() {
        return multiLayerStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(multiLayerStorage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutStorageConfigurationRequest)) {
            return false;
        }
        PutStorageConfigurationRequest other = (PutStorageConfigurationRequest) obj;
        return Objects.equals(storageTypeAsString(), other.storageTypeAsString())
                && Objects.equals(multiLayerStorage(), other.multiLayerStorage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutStorageConfigurationRequest").add("StorageType", storageTypeAsString())
                .add("MultiLayerStorage", multiLayerStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "multiLayerStorage":
            return Optional.ofNullable(clazz.cast(multiLayerStorage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutStorageConfigurationRequest, T> g) {
        return obj -> g.apply((PutStorageConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutStorageConfigurationRequest> {
        /**
         * <p>
         * The type of storage that you specified for your data. The storage type can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and
         * saves a copy of your raw data and metadata in an Amazon S3 object that you specified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param storageType
         *        The type of storage that you specified for your data. The storage type can be one of the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed
         *        database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database
         *        and saves a copy of your raw data and metadata in an Amazon S3 object that you specified.
         *        </p>
         *        </li>
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The type of storage that you specified for your data. The storage type can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and
         * saves a copy of your raw data and metadata in an Amazon S3 object that you specified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param storageType
         *        The type of storage that you specified for your data. The storage type can be one of the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed
         *        database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database
         *        and saves a copy of your raw data and metadata in an Amazon S3 object that you specified.
         *        </p>
         *        </li>
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(StorageType storageType);

        /**
         * <p>
         * Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type, you
         * must specify a <code>MultiLayerStorage</code> object.
         * </p>
         * 
         * @param multiLayerStorage
         *        Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage
         *        type, you must specify a <code>MultiLayerStorage</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiLayerStorage(MultiLayerStorage multiLayerStorage);

        /**
         * <p>
         * Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type, you
         * must specify a <code>MultiLayerStorage</code> object.
         * </p>
         * This is a convenience that creates an instance of the {@link MultiLayerStorage.Builder} avoiding the need to
         * create one manually via {@link MultiLayerStorage#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiLayerStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #multiLayerStorage(MultiLayerStorage)}.
         * 
         * @param multiLayerStorage
         *        a consumer that will call methods on {@link MultiLayerStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiLayerStorage(MultiLayerStorage)
         */
        default Builder multiLayerStorage(Consumer<MultiLayerStorage.Builder> multiLayerStorage) {
            return multiLayerStorage(MultiLayerStorage.builder().applyMutation(multiLayerStorage).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String storageType;

        private MultiLayerStorage multiLayerStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(PutStorageConfigurationRequest model) {
            super(model);
            storageType(model.storageType);
            multiLayerStorage(model.multiLayerStorage);
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        @Transient
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        @Transient
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final MultiLayerStorage.Builder getMultiLayerStorage() {
            return multiLayerStorage != null ? multiLayerStorage.toBuilder() : null;
        }

        public final void setMultiLayerStorage(MultiLayerStorage.BuilderImpl multiLayerStorage) {
            this.multiLayerStorage = multiLayerStorage != null ? multiLayerStorage.build() : null;
        }

        @Override
        @Transient
        public final Builder multiLayerStorage(MultiLayerStorage multiLayerStorage) {
            this.multiLayerStorage = multiLayerStorage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutStorageConfigurationRequest build() {
            return new PutStorageConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
