/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an IoT SiteWise Monitor resource ID for a portal or project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<PortalResource> PORTAL_FIELD = SdkField.<PortalResource> builder(MarshallingType.SDK_POJO)
            .memberName("portal").getter(getter(Resource::portal)).setter(setter(Builder::portal))
            .constructor(PortalResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portal").build()).build();

    private static final SdkField<ProjectResource> PROJECT_FIELD = SdkField.<ProjectResource> builder(MarshallingType.SDK_POJO)
            .memberName("project").getter(getter(Resource::project)).setter(setter(Builder::project))
            .constructor(ProjectResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_FIELD, PROJECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final PortalResource portal;

    private final ProjectResource project;

    private Resource(BuilderImpl builder) {
        this.portal = builder.portal;
        this.project = builder.project;
    }

    /**
     * <p>
     * A portal resource.
     * </p>
     * 
     * @return A portal resource.
     */
    public final PortalResource portal() {
        return portal;
    }

    /**
     * <p>
     * A project resource.
     * </p>
     * 
     * @return A project resource.
     */
    public final ProjectResource project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(portal());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(portal(), other.portal()) && Objects.equals(project(), other.project());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Resource").add("Portal", portal()).add("Project", project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portal":
            return Optional.ofNullable(clazz.cast(portal()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * <p>
         * A portal resource.
         * </p>
         * 
         * @param portal
         *        A portal resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portal(PortalResource portal);

        /**
         * <p>
         * A portal resource.
         * </p>
         * This is a convenience that creates an instance of the {@link PortalResource.Builder} avoiding the need to
         * create one manually via {@link PortalResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link PortalResource.Builder#build()} is called immediately and its
         * result is passed to {@link #portal(PortalResource)}.
         * 
         * @param portal
         *        a consumer that will call methods on {@link PortalResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portal(PortalResource)
         */
        default Builder portal(Consumer<PortalResource.Builder> portal) {
            return portal(PortalResource.builder().applyMutation(portal).build());
        }

        /**
         * <p>
         * A project resource.
         * </p>
         * 
         * @param project
         *        A project resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(ProjectResource project);

        /**
         * <p>
         * A project resource.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectResource.Builder} avoiding the need to
         * create one manually via {@link ProjectResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectResource.Builder#build()} is called immediately and its
         * result is passed to {@link #project(ProjectResource)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link ProjectResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(ProjectResource)
         */
        default Builder project(Consumer<ProjectResource.Builder> project) {
            return project(ProjectResource.builder().applyMutation(project).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PortalResource portal;

        private ProjectResource project;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            portal(model.portal);
            project(model.project);
        }

        public final PortalResource.Builder getPortal() {
            return portal != null ? portal.toBuilder() : null;
        }

        public final void setPortal(PortalResource.BuilderImpl portal) {
            this.portal = portal != null ? portal.build() : null;
        }

        @Override
        @Transient
        public final Builder portal(PortalResource portal) {
            this.portal = portal;
            return this;
        }

        public final ProjectResource.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        public final void setProject(ProjectResource.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        @Transient
        public final Builder project(ProjectResource project) {
            this.project = project;
            return this;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
