/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies a property value used in an expression.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VariableValue implements SdkPojo, Serializable, ToCopyableBuilder<VariableValue.Builder, VariableValue> {
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyId").getter(getter(VariableValue::propertyId)).setter(setter(Builder::propertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()).build();

    private static final SdkField<String> HIERARCHY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hierarchyId").getter(getter(VariableValue::hierarchyId)).setter(setter(Builder::hierarchyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hierarchyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_ID_FIELD,
            HIERARCHY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String propertyId;

    private final String hierarchyId;

    private VariableValue(BuilderImpl builder) {
        this.propertyId = builder.propertyId;
        this.hierarchyId = builder.hierarchyId;
    }

    /**
     * <p>
     * The ID of the property to use as the variable. You can use the property <code>name</code> if it's from the same
     * asset model.
     * </p>
     * 
     * @return The ID of the property to use as the variable. You can use the property <code>name</code> if it's from
     *         the same asset model.
     */
    public final String propertyId() {
        return propertyId;
    }

    /**
     * <p>
     * The ID of the hierarchy to query for the property ID. You can use the hierarchy's name instead of the hierarchy's
     * ID.
     * </p>
     * <p>
     * You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same model and
     * therefore the same <code>propertyId</code>. For example, you might have separately grouped assets that come from
     * the same asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the hierarchy to query for the property ID. You can use the hierarchy's name instead of the
     *         hierarchy's ID.</p>
     *         <p>
     *         You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same
     *         model and therefore the same <code>propertyId</code>. For example, you might have separately grouped
     *         assets that come from the same asset model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
     *         hierarchies</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String hierarchyId() {
        return hierarchyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableValue)) {
            return false;
        }
        VariableValue other = (VariableValue) obj;
        return Objects.equals(propertyId(), other.propertyId()) && Objects.equals(hierarchyId(), other.hierarchyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VariableValue").add("PropertyId", propertyId()).add("HierarchyId", hierarchyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "propertyId":
            return Optional.ofNullable(clazz.cast(propertyId()));
        case "hierarchyId":
            return Optional.ofNullable(clazz.cast(hierarchyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VariableValue, T> g) {
        return obj -> g.apply((VariableValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VariableValue> {
        /**
         * <p>
         * The ID of the property to use as the variable. You can use the property <code>name</code> if it's from the
         * same asset model.
         * </p>
         * 
         * @param propertyId
         *        The ID of the property to use as the variable. You can use the property <code>name</code> if it's from
         *        the same asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyId(String propertyId);

        /**
         * <p>
         * The ID of the hierarchy to query for the property ID. You can use the hierarchy's name instead of the
         * hierarchy's ID.
         * </p>
         * <p>
         * You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same model
         * and therefore the same <code>propertyId</code>. For example, you might have separately grouped assets that
         * come from the same asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param hierarchyId
         *        The ID of the hierarchy to query for the property ID. You can use the hierarchy's name instead of the
         *        hierarchy's ID.</p>
         *        <p>
         *        You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same
         *        model and therefore the same <code>propertyId</code>. For example, you might have separately grouped
         *        assets that come from the same asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
         *        hierarchies</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyId(String hierarchyId);
    }

    static final class BuilderImpl implements Builder {
        private String propertyId;

        private String hierarchyId;

        private BuilderImpl() {
        }

        private BuilderImpl(VariableValue model) {
            propertyId(model.propertyId);
            hierarchyId(model.hierarchyId);
        }

        public final String getPropertyId() {
            return propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        @Transient
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final String getHierarchyId() {
            return hierarchyId;
        }

        public final void setHierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
        }

        @Override
        @Transient
        public final Builder hierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
            return this;
        }

        @Override
        public VariableValue build() {
            return new VariableValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
