/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains error information for asset property value entries that are associated with the <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html"
 * >BatchPutAssetPropertyValue</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutAssetPropertyErrorEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchPutAssetPropertyErrorEntry.Builder, BatchPutAssetPropertyErrorEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryId").getter(getter(BatchPutAssetPropertyErrorEntry::entryId)).setter(setter(Builder::entryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()).build();

    private static final SdkField<List<BatchPutAssetPropertyError>> ERRORS_FIELD = SdkField
            .<List<BatchPutAssetPropertyError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchPutAssetPropertyErrorEntry::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchPutAssetPropertyError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchPutAssetPropertyError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD, ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entryId;

    private final List<BatchPutAssetPropertyError> errors;

    private BatchPutAssetPropertyErrorEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * The ID of the failed entry.
     * </p>
     * 
     * @return The ID of the failed entry.
     */
    public final String entryId() {
        return entryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of update property value errors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return The list of update property value errors.
     */
    public final List<BatchPutAssetPropertyError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutAssetPropertyErrorEntry)) {
            return false;
        }
        BatchPutAssetPropertyErrorEntry other = (BatchPutAssetPropertyErrorEntry) obj;
        return Objects.equals(entryId(), other.entryId()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutAssetPropertyErrorEntry").add("EntryId", entryId())
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryId":
            return Optional.ofNullable(clazz.cast(entryId()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutAssetPropertyErrorEntry, T> g) {
        return obj -> g.apply((BatchPutAssetPropertyErrorEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchPutAssetPropertyErrorEntry> {
        /**
         * <p>
         * The ID of the failed entry.
         * </p>
         * 
         * @param entryId
         *        The ID of the failed entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryId(String entryId);

        /**
         * <p>
         * The list of update property value errors.
         * </p>
         * 
         * @param errors
         *        The list of update property value errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchPutAssetPropertyError> errors);

        /**
         * <p>
         * The list of update property value errors.
         * </p>
         * 
         * @param errors
         *        The list of update property value errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchPutAssetPropertyError... errors);

        /**
         * <p>
         * The list of update property value errors.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchPutAssetPropertyError>.Builder}
         * avoiding the need to create one manually via {@link List<BatchPutAssetPropertyError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchPutAssetPropertyError>.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<BatchPutAssetPropertyError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<BatchPutAssetPropertyError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<BatchPutAssetPropertyError>)
         */
        Builder errors(Consumer<BatchPutAssetPropertyError.Builder>... errors);
    }

    static final class BuilderImpl implements Builder {
        private String entryId;

        private List<BatchPutAssetPropertyError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutAssetPropertyErrorEntry model) {
            entryId(model.entryId);
            errors(model.errors);
        }

        public final String getEntryId() {
            return entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        @Transient
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final List<BatchPutAssetPropertyError.Builder> getErrors() {
            List<BatchPutAssetPropertyError.Builder> result = BatchPutAssetPropertyErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchPutAssetPropertyError.BuilderImpl> errors) {
            this.errors = BatchPutAssetPropertyErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        @Transient
        public final Builder errors(Collection<BatchPutAssetPropertyError> errors) {
            this.errors = BatchPutAssetPropertyErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(BatchPutAssetPropertyError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(Consumer<BatchPutAssetPropertyError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchPutAssetPropertyError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchPutAssetPropertyErrorEntry build() {
            return new BatchPutAssetPropertyErrorEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
