/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an access policy that defines an identity's access to an IoT SiteWise Monitor resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessPolicySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessPolicySummary.Builder, AccessPolicySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AccessPolicySummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Identity> IDENTITY_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("identity").getter(getter(AccessPolicySummary::identity)).setter(setter(Builder::identity))
            .constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identity").build()).build();

    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("resource").getter(getter(AccessPolicySummary::resource)).setter(setter(Builder::resource))
            .constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permission").getter(getter(AccessPolicySummary::permissionAsString)).setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permission").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(AccessPolicySummary::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateDate").getter(getter(AccessPolicySummary::lastUpdateDate))
            .setter(setter(Builder::lastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, IDENTITY_FIELD,
            RESOURCE_FIELD, PERMISSION_FIELD, CREATION_DATE_FIELD, LAST_UPDATE_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Identity identity;

    private final Resource resource;

    private final String permission;

    private final Instant creationDate;

    private final Instant lastUpdateDate;

    private AccessPolicySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.identity = builder.identity;
        this.resource = builder.resource;
        this.permission = builder.permission;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
    }

    /**
     * <p>
     * The ID of the access policy.
     * </p>
     * 
     * @return The ID of the access policy.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user).
     * </p>
     * 
     * @return The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user).
     */
    public final Identity identity() {
        return identity;
    }

    /**
     * <p>
     * The IoT SiteWise Monitor resource (a portal or project).
     * </p>
     * 
     * @return The IoT SiteWise Monitor resource (a portal or project).
     */
    public final Resource resource() {
        return resource;
    }

    /**
     * <p>
     * The permissions for the access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project
     * owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return The permissions for the access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a
     *         project owner.
     * @see Permission
     */
    public final Permission permission() {
        return Permission.fromValue(permission);
    }

    /**
     * <p>
     * The permissions for the access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project
     * owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return The permissions for the access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a
     *         project owner.
     * @see Permission
     */
    public final String permissionAsString() {
        return permission;
    }

    /**
     * <p>
     * The date the access policy was created, in Unix epoch time.
     * </p>
     * 
     * @return The date the access policy was created, in Unix epoch time.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date the access policy was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the access policy was last updated, in Unix epoch time.
     */
    public final Instant lastUpdateDate() {
        return lastUpdateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPolicySummary)) {
            return false;
        }
        AccessPolicySummary other = (AccessPolicySummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(identity(), other.identity())
                && Objects.equals(resource(), other.resource())
                && Objects.equals(permissionAsString(), other.permissionAsString())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastUpdateDate(), other.lastUpdateDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessPolicySummary").add("Id", id()).add("Identity", identity()).add("Resource", resource())
                .add("Permission", permissionAsString()).add("CreationDate", creationDate())
                .add("LastUpdateDate", lastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "identity":
            return Optional.ofNullable(clazz.cast(identity()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "permission":
            return Optional.ofNullable(clazz.cast(permissionAsString()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastUpdateDate":
            return Optional.ofNullable(clazz.cast(lastUpdateDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessPolicySummary, T> g) {
        return obj -> g.apply((AccessPolicySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessPolicySummary> {
        /**
         * <p>
         * The ID of the access policy.
         * </p>
         * 
         * @param id
         *        The ID of the access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user).
         * </p>
         * 
         * @param identity
         *        The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(Identity identity);

        /**
         * <p>
         * The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user).
         * </p>
         * This is a convenience that creates an instance of the {@link Identity.Builder} avoiding the need to create
         * one manually via {@link Identity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #identity(Identity)}.
         * 
         * @param identity
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identity(Identity)
         */
        default Builder identity(Consumer<Identity.Builder> identity) {
            return identity(Identity.builder().applyMutation(identity).build());
        }

        /**
         * <p>
         * The IoT SiteWise Monitor resource (a portal or project).
         * </p>
         * 
         * @param resource
         *        The IoT SiteWise Monitor resource (a portal or project).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(Resource resource);

        /**
         * <p>
         * The IoT SiteWise Monitor resource (a portal or project).
         * </p>
         * This is a convenience that creates an instance of the {@link Resource.Builder} avoiding the need to create
         * one manually via {@link Resource#builder()}.
         *
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #resource(Resource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(Resource)
         */
        default Builder resource(Consumer<Resource.Builder> resource) {
            return resource(Resource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * The permissions for the access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a
         * project owner.
         * </p>
         * 
         * @param permission
         *        The permissions for the access policy. Note that a project <code>ADMINISTRATOR</code> is also known as
         *        a project owner.
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(String permission);

        /**
         * <p>
         * The permissions for the access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a
         * project owner.
         * </p>
         * 
         * @param permission
         *        The permissions for the access policy. Note that a project <code>ADMINISTRATOR</code> is also known as
         *        a project owner.
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(Permission permission);

        /**
         * <p>
         * The date the access policy was created, in Unix epoch time.
         * </p>
         * 
         * @param creationDate
         *        The date the access policy was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date the access policy was last updated, in Unix epoch time.
         * </p>
         * 
         * @param lastUpdateDate
         *        The date the access policy was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDate(Instant lastUpdateDate);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Identity identity;

        private Resource resource;

        private String permission;

        private Instant creationDate;

        private Instant lastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPolicySummary model) {
            id(model.id);
            identity(model.identity);
            resource(model.resource);
            permission(model.permission);
            creationDate(model.creationDate);
            lastUpdateDate(model.lastUpdateDate);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Identity.Builder getIdentity() {
            return identity != null ? identity.toBuilder() : null;
        }

        public final void setIdentity(Identity.BuilderImpl identity) {
            this.identity = identity != null ? identity.build() : null;
        }

        @Override
        @Transient
        public final Builder identity(Identity identity) {
            this.identity = identity;
            return this;
        }

        public final Resource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        @Transient
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final String getPermission() {
            return permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        @Transient
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        @Transient
        public final Builder permission(Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        @Transient
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        @Override
        public AccessPolicySummary build() {
            return new AccessPolicySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
