/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssetModelRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<CreateAssetModelRequest.Builder, CreateAssetModelRequest> {
    private static final SdkField<String> ASSET_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelName").getter(getter(CreateAssetModelRequest::assetModelName))
            .setter(setter(Builder::assetModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelName").build()).build();

    private static final SdkField<String> ASSET_MODEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelDescription").getter(getter(CreateAssetModelRequest::assetModelDescription))
            .setter(setter(Builder::assetModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelDescription").build())
            .build();

    private static final SdkField<List<AssetModelPropertyDefinition>> ASSET_MODEL_PROPERTIES_FIELD = SdkField
            .<List<AssetModelPropertyDefinition>> builder(MarshallingType.LIST)
            .memberName("assetModelProperties")
            .getter(getter(CreateAssetModelRequest::assetModelProperties))
            .setter(setter(Builder::assetModelProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelPropertyDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelPropertyDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetModelHierarchyDefinition>> ASSET_MODEL_HIERARCHIES_FIELD = SdkField
            .<List<AssetModelHierarchyDefinition>> builder(MarshallingType.LIST)
            .memberName("assetModelHierarchies")
            .getter(getter(CreateAssetModelRequest::assetModelHierarchies))
            .setter(setter(Builder::assetModelHierarchies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelHierarchies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelHierarchyDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelHierarchyDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetModelCompositeModelDefinition>> ASSET_MODEL_COMPOSITE_MODELS_FIELD = SdkField
            .<List<AssetModelCompositeModelDefinition>> builder(MarshallingType.LIST)
            .memberName("assetModelCompositeModels")
            .getter(getter(CreateAssetModelRequest::assetModelCompositeModels))
            .setter(setter(Builder::assetModelCompositeModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelCompositeModelDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelCompositeModelDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAssetModelRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAssetModelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_NAME_FIELD,
            ASSET_MODEL_DESCRIPTION_FIELD, ASSET_MODEL_PROPERTIES_FIELD, ASSET_MODEL_HIERARCHIES_FIELD,
            ASSET_MODEL_COMPOSITE_MODELS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String assetModelName;

    private final String assetModelDescription;

    private final List<AssetModelPropertyDefinition> assetModelProperties;

    private final List<AssetModelHierarchyDefinition> assetModelHierarchies;

    private final List<AssetModelCompositeModelDefinition> assetModelCompositeModels;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateAssetModelRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelName = builder.assetModelName;
        this.assetModelDescription = builder.assetModelDescription;
        this.assetModelProperties = builder.assetModelProperties;
        this.assetModelHierarchies = builder.assetModelHierarchies;
        this.assetModelCompositeModels = builder.assetModelCompositeModels;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique, friendly name for the asset model.
     * </p>
     * 
     * @return A unique, friendly name for the asset model.
     */
    public final String assetModelName() {
        return assetModelName;
    }

    /**
     * <p>
     * A description for the asset model.
     * </p>
     * 
     * @return A description for the asset model.
     */
    public final String assetModelDescription() {
        return assetModelDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetModelProperties() {
        return assetModelProperties != null && !(assetModelProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The property definitions of the asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * You can specify up to 200 properties per asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise
     * User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelProperties} method.
     * </p>
     * 
     * @return The property definitions of the asset model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset
     *         properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
     *         <p>
     *         You can specify up to 200 properties per asset model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     */
    public final List<AssetModelPropertyDefinition> assetModelProperties() {
        return assetModelProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelHierarchies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssetModelHierarchies() {
        return assetModelHierarchies != null && !(assetModelHierarchies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be
     * children of any other assets created from this asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * You can specify up to 10 hierarchies per asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise
     * User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelHierarchies} method.
     * </p>
     * 
     * @return The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be
     *         children of any other assets created from this asset model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
     *         hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
     *         <p>
     *         You can specify up to 10 hierarchies per asset model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     */
    public final List<AssetModelHierarchyDefinition> assetModelHierarchies() {
        return assetModelHierarchies;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelCompositeModels property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssetModelCompositeModels() {
        return assetModelCompositeModels != null && !(assetModelCompositeModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The composite asset models that are part of this asset model. Composite asset models are asset models that
     * contain specific properties. Each composite model has a type that defines the properties that the composite model
     * supports. Use composite asset models to define alarms on this asset model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelCompositeModels} method.
     * </p>
     * 
     * @return The composite asset models that are part of this asset model. Composite asset models are asset models
     *         that contain specific properties. Each composite model has a type that defines the properties that the
     *         composite model supports. Use composite asset models to define alarms on this asset model.
     */
    public final List<AssetModelCompositeModelDefinition> assetModelCompositeModels() {
        return assetModelCompositeModels;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs that contain metadata for the asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
     * resources</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that contain metadata for the asset model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT
     *         SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetModelName());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetModelProperties() ? assetModelProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetModelHierarchies() ? assetModelHierarchies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetModelCompositeModels() ? assetModelCompositeModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetModelRequest)) {
            return false;
        }
        CreateAssetModelRequest other = (CreateAssetModelRequest) obj;
        return Objects.equals(assetModelName(), other.assetModelName())
                && Objects.equals(assetModelDescription(), other.assetModelDescription())
                && hasAssetModelProperties() == other.hasAssetModelProperties()
                && Objects.equals(assetModelProperties(), other.assetModelProperties())
                && hasAssetModelHierarchies() == other.hasAssetModelHierarchies()
                && Objects.equals(assetModelHierarchies(), other.assetModelHierarchies())
                && hasAssetModelCompositeModels() == other.hasAssetModelCompositeModels()
                && Objects.equals(assetModelCompositeModels(), other.assetModelCompositeModels())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssetModelRequest").add("AssetModelName", assetModelName())
                .add("AssetModelDescription", assetModelDescription())
                .add("AssetModelProperties", hasAssetModelProperties() ? assetModelProperties() : null)
                .add("AssetModelHierarchies", hasAssetModelHierarchies() ? assetModelHierarchies() : null)
                .add("AssetModelCompositeModels", hasAssetModelCompositeModels() ? assetModelCompositeModels() : null)
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelName":
            return Optional.ofNullable(clazz.cast(assetModelName()));
        case "assetModelDescription":
            return Optional.ofNullable(clazz.cast(assetModelDescription()));
        case "assetModelProperties":
            return Optional.ofNullable(clazz.cast(assetModelProperties()));
        case "assetModelHierarchies":
            return Optional.ofNullable(clazz.cast(assetModelHierarchies()));
        case "assetModelCompositeModels":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModels()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetModelRequest, T> g) {
        return obj -> g.apply((CreateAssetModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssetModelRequest> {
        /**
         * <p>
         * A unique, friendly name for the asset model.
         * </p>
         * 
         * @param assetModelName
         *        A unique, friendly name for the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelName(String assetModelName);

        /**
         * <p>
         * A description for the asset model.
         * </p>
         * 
         * @param assetModelDescription
         *        A description for the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelDescription(String assetModelDescription);

        /**
         * <p>
         * The property definitions of the asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 200 properties per asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelProperties
         *        The property definitions of the asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset
         *        properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        You can specify up to 200 properties per asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         *        SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelProperties(Collection<AssetModelPropertyDefinition> assetModelProperties);

        /**
         * <p>
         * The property definitions of the asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 200 properties per asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelProperties
         *        The property definitions of the asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset
         *        properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        You can specify up to 200 properties per asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         *        SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelProperties(AssetModelPropertyDefinition... assetModelProperties);

        /**
         * <p>
         * The property definitions of the asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 200 properties per asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssetModelPropertyDefinition>.Builder}
         * avoiding the need to create one manually via {@link List<AssetModelPropertyDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetModelPropertyDefinition>.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModelProperties(List<AssetModelPropertyDefinition>)}.
         * 
         * @param assetModelProperties
         *        a consumer that will call methods on {@link List<AssetModelPropertyDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelProperties(List<AssetModelPropertyDefinition>)
         */
        Builder assetModelProperties(Consumer<AssetModelPropertyDefinition.Builder>... assetModelProperties);

        /**
         * <p>
         * The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be
         * children of any other assets created from this asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 10 hierarchies per asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelHierarchies
         *        The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can
         *        be children of any other assets created from this asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
         *        hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        You can specify up to 10 hierarchies per asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         *        SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelHierarchies(Collection<AssetModelHierarchyDefinition> assetModelHierarchies);

        /**
         * <p>
         * The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be
         * children of any other assets created from this asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 10 hierarchies per asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelHierarchies
         *        The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can
         *        be children of any other assets created from this asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
         *        hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        You can specify up to 10 hierarchies per asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         *        SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelHierarchies(AssetModelHierarchyDefinition... assetModelHierarchies);

        /**
         * <p>
         * The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be
         * children of any other assets created from this asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 10 hierarchies per asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssetModelHierarchyDefinition>.Builder}
         * avoiding the need to create one manually via {@link List<AssetModelHierarchyDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetModelHierarchyDefinition>.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModelHierarchies(List<AssetModelHierarchyDefinition>)}.
         * 
         * @param assetModelHierarchies
         *        a consumer that will call methods on {@link List<AssetModelHierarchyDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelHierarchies(List<AssetModelHierarchyDefinition>)
         */
        Builder assetModelHierarchies(Consumer<AssetModelHierarchyDefinition.Builder>... assetModelHierarchies);

        /**
         * <p>
         * The composite asset models that are part of this asset model. Composite asset models are asset models that
         * contain specific properties. Each composite model has a type that defines the properties that the composite
         * model supports. Use composite asset models to define alarms on this asset model.
         * </p>
         * 
         * @param assetModelCompositeModels
         *        The composite asset models that are part of this asset model. Composite asset models are asset models
         *        that contain specific properties. Each composite model has a type that defines the properties that the
         *        composite model supports. Use composite asset models to define alarms on this asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModels(Collection<AssetModelCompositeModelDefinition> assetModelCompositeModels);

        /**
         * <p>
         * The composite asset models that are part of this asset model. Composite asset models are asset models that
         * contain specific properties. Each composite model has a type that defines the properties that the composite
         * model supports. Use composite asset models to define alarms on this asset model.
         * </p>
         * 
         * @param assetModelCompositeModels
         *        The composite asset models that are part of this asset model. Composite asset models are asset models
         *        that contain specific properties. Each composite model has a type that defines the properties that the
         *        composite model supports. Use composite asset models to define alarms on this asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModels(AssetModelCompositeModelDefinition... assetModelCompositeModels);

        /**
         * <p>
         * The composite asset models that are part of this asset model. Composite asset models are asset models that
         * contain specific properties. Each composite model has a type that defines the properties that the composite
         * model supports. Use composite asset models to define alarms on this asset model.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AssetModelCompositeModelDefinition>.Builder} avoiding the need to create one manually via {@link List
         * <AssetModelCompositeModelDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetModelCompositeModelDefinition>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #assetModelCompositeModels(List<AssetModelCompositeModelDefinition>)}.
         * 
         * @param assetModelCompositeModels
         *        a consumer that will call methods on {@link List<AssetModelCompositeModelDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelCompositeModels(List<AssetModelCompositeModelDefinition>)
         */
        Builder assetModelCompositeModels(Consumer<AssetModelCompositeModelDefinition.Builder>... assetModelCompositeModels);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT
         *        SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetModelName;

        private String assetModelDescription;

        private List<AssetModelPropertyDefinition> assetModelProperties = DefaultSdkAutoConstructList.getInstance();

        private List<AssetModelHierarchyDefinition> assetModelHierarchies = DefaultSdkAutoConstructList.getInstance();

        private List<AssetModelCompositeModelDefinition> assetModelCompositeModels = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetModelRequest model) {
            super(model);
            assetModelName(model.assetModelName);
            assetModelDescription(model.assetModelDescription);
            assetModelProperties(model.assetModelProperties);
            assetModelHierarchies(model.assetModelHierarchies);
            assetModelCompositeModels(model.assetModelCompositeModels);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getAssetModelName() {
            return assetModelName;
        }

        public final void setAssetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
        }

        @Override
        @Transient
        public final Builder assetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
            return this;
        }

        public final String getAssetModelDescription() {
            return assetModelDescription;
        }

        public final void setAssetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
        }

        @Override
        @Transient
        public final Builder assetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
            return this;
        }

        public final List<AssetModelPropertyDefinition.Builder> getAssetModelProperties() {
            List<AssetModelPropertyDefinition.Builder> result = AssetModelPropertyDefinitionsCopier
                    .copyToBuilder(this.assetModelProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelProperties(Collection<AssetModelPropertyDefinition.BuilderImpl> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertyDefinitionsCopier.copyFromBuilder(assetModelProperties);
        }

        @Override
        @Transient
        public final Builder assetModelProperties(Collection<AssetModelPropertyDefinition> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertyDefinitionsCopier.copy(assetModelProperties);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assetModelProperties(AssetModelPropertyDefinition... assetModelProperties) {
            assetModelProperties(Arrays.asList(assetModelProperties));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assetModelProperties(Consumer<AssetModelPropertyDefinition.Builder>... assetModelProperties) {
            assetModelProperties(Stream.of(assetModelProperties)
                    .map(c -> AssetModelPropertyDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetModelHierarchyDefinition.Builder> getAssetModelHierarchies() {
            List<AssetModelHierarchyDefinition.Builder> result = AssetModelHierarchyDefinitionsCopier
                    .copyToBuilder(this.assetModelHierarchies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelHierarchies(Collection<AssetModelHierarchyDefinition.BuilderImpl> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchyDefinitionsCopier.copyFromBuilder(assetModelHierarchies);
        }

        @Override
        @Transient
        public final Builder assetModelHierarchies(Collection<AssetModelHierarchyDefinition> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchyDefinitionsCopier.copy(assetModelHierarchies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assetModelHierarchies(AssetModelHierarchyDefinition... assetModelHierarchies) {
            assetModelHierarchies(Arrays.asList(assetModelHierarchies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assetModelHierarchies(Consumer<AssetModelHierarchyDefinition.Builder>... assetModelHierarchies) {
            assetModelHierarchies(Stream.of(assetModelHierarchies)
                    .map(c -> AssetModelHierarchyDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetModelCompositeModelDefinition.Builder> getAssetModelCompositeModels() {
            List<AssetModelCompositeModelDefinition.Builder> result = AssetModelCompositeModelDefinitionsCopier
                    .copyToBuilder(this.assetModelCompositeModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModels(
                Collection<AssetModelCompositeModelDefinition.BuilderImpl> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelDefinitionsCopier.copyFromBuilder(assetModelCompositeModels);
        }

        @Override
        @Transient
        public final Builder assetModelCompositeModels(Collection<AssetModelCompositeModelDefinition> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelDefinitionsCopier.copy(assetModelCompositeModels);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assetModelCompositeModels(AssetModelCompositeModelDefinition... assetModelCompositeModels) {
            assetModelCompositeModels(Arrays.asList(assetModelCompositeModels));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assetModelCompositeModels(
                Consumer<AssetModelCompositeModelDefinition.Builder>... assetModelCompositeModels) {
            assetModelCompositeModels(Stream.of(assetModelCompositeModels)
                    .map(c -> AssetModelCompositeModelDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssetModelRequest build() {
            return new CreateAssetModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
