/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDashboardRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<CreateDashboardRequest.Builder, CreateDashboardRequest> {
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(CreateDashboardRequest::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<String> DASHBOARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardName").getter(getter(CreateDashboardRequest::dashboardName))
            .setter(setter(Builder::dashboardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardName").build()).build();

    private static final SdkField<String> DASHBOARD_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardDescription").getter(getter(CreateDashboardRequest::dashboardDescription))
            .setter(setter(Builder::dashboardDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardDescription").build())
            .build();

    private static final SdkField<String> DASHBOARD_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardDefinition").getter(getter(CreateDashboardRequest::dashboardDefinition))
            .setter(setter(Builder::dashboardDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardDefinition").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateDashboardRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateDashboardRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ID_FIELD,
            DASHBOARD_NAME_FIELD, DASHBOARD_DESCRIPTION_FIELD, DASHBOARD_DEFINITION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String projectId;

    private final String dashboardName;

    private final String dashboardDescription;

    private final String dashboardDefinition;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateDashboardRequest(BuilderImpl builder) {
        super(builder);
        this.projectId = builder.projectId;
        this.dashboardName = builder.dashboardName;
        this.dashboardDescription = builder.dashboardDescription;
        this.dashboardDefinition = builder.dashboardDefinition;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the project in which to create the dashboard.
     * </p>
     * 
     * @return The ID of the project in which to create the dashboard.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * A friendly name for the dashboard.
     * </p>
     * 
     * @return A friendly name for the dashboard.
     */
    public final String dashboardName() {
        return dashboardName;
    }

    /**
     * <p>
     * A description for the dashboard.
     * </p>
     * 
     * @return A description for the dashboard.
     */
    public final String dashboardDescription() {
        return dashboardDescription;
    }

    /**
     * <p>
     * The dashboard definition specified in a JSON literal. For detailed information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating
     * dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The dashboard definition specified in a JSON literal. For detailed information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html"
     *         >Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String dashboardDefinition() {
        return dashboardDefinition;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs that contain metadata for the dashboard. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
     * resources</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that contain metadata for the dashboard. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT
     *         SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardName());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardDescription());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDashboardRequest)) {
            return false;
        }
        CreateDashboardRequest other = (CreateDashboardRequest) obj;
        return Objects.equals(projectId(), other.projectId()) && Objects.equals(dashboardName(), other.dashboardName())
                && Objects.equals(dashboardDescription(), other.dashboardDescription())
                && Objects.equals(dashboardDefinition(), other.dashboardDefinition())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDashboardRequest").add("ProjectId", projectId()).add("DashboardName", dashboardName())
                .add("DashboardDescription", dashboardDescription()).add("DashboardDefinition", dashboardDefinition())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "dashboardName":
            return Optional.ofNullable(clazz.cast(dashboardName()));
        case "dashboardDescription":
            return Optional.ofNullable(clazz.cast(dashboardDescription()));
        case "dashboardDefinition":
            return Optional.ofNullable(clazz.cast(dashboardDefinition()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDashboardRequest, T> g) {
        return obj -> g.apply((CreateDashboardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDashboardRequest> {
        /**
         * <p>
         * The ID of the project in which to create the dashboard.
         * </p>
         * 
         * @param projectId
         *        The ID of the project in which to create the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * A friendly name for the dashboard.
         * </p>
         * 
         * @param dashboardName
         *        A friendly name for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardName(String dashboardName);

        /**
         * <p>
         * A description for the dashboard.
         * </p>
         * 
         * @param dashboardDescription
         *        A description for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardDescription(String dashboardDescription);

        /**
         * <p>
         * The dashboard definition specified in a JSON literal. For detailed information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html"
         * >Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param dashboardDefinition
         *        The dashboard definition specified in a JSON literal. For detailed information, see <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html"
         *        >Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardDefinition(String dashboardDefinition);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the dashboard. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the dashboard. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT
         *        SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String projectId;

        private String dashboardName;

        private String dashboardDescription;

        private String dashboardDefinition;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDashboardRequest model) {
            super(model);
            projectId(model.projectId);
            dashboardName(model.dashboardName);
            dashboardDescription(model.dashboardDescription);
            dashboardDefinition(model.dashboardDefinition);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        @Transient
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getDashboardName() {
            return dashboardName;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        @Override
        @Transient
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public final String getDashboardDescription() {
            return dashboardDescription;
        }

        public final void setDashboardDescription(String dashboardDescription) {
            this.dashboardDescription = dashboardDescription;
        }

        @Override
        @Transient
        public final Builder dashboardDescription(String dashboardDescription) {
            this.dashboardDescription = dashboardDescription;
            return this;
        }

        public final String getDashboardDefinition() {
            return dashboardDefinition;
        }

        public final void setDashboardDefinition(String dashboardDefinition) {
            this.dashboardDefinition = dashboardDefinition;
        }

        @Override
        @Transient
        public final Builder dashboardDefinition(String dashboardDefinition) {
            this.dashboardDefinition = dashboardDefinition;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDashboardRequest build() {
            return new CreateDashboardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
