/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The processing configuration for the given measurement property. You can configure measurements to be kept at the
 * edge or forwarded to the Amazon Web Services Cloud. By default, measurements are forwarded to the cloud.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MeasurementProcessingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MeasurementProcessingConfig.Builder, MeasurementProcessingConfig> {
    private static final SdkField<ForwardingConfig> FORWARDING_CONFIG_FIELD = SdkField
            .<ForwardingConfig> builder(MarshallingType.SDK_POJO).memberName("forwardingConfig")
            .getter(getter(MeasurementProcessingConfig::forwardingConfig)).setter(setter(Builder::forwardingConfig))
            .constructor(ForwardingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forwardingConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORWARDING_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final ForwardingConfig forwardingConfig;

    private MeasurementProcessingConfig(BuilderImpl builder) {
        this.forwardingConfig = builder.forwardingConfig;
    }

    /**
     * <p>
     * The forwarding configuration for the given measurement property.
     * </p>
     * 
     * @return The forwarding configuration for the given measurement property.
     */
    public final ForwardingConfig forwardingConfig() {
        return forwardingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forwardingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeasurementProcessingConfig)) {
            return false;
        }
        MeasurementProcessingConfig other = (MeasurementProcessingConfig) obj;
        return Objects.equals(forwardingConfig(), other.forwardingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MeasurementProcessingConfig").add("ForwardingConfig", forwardingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "forwardingConfig":
            return Optional.ofNullable(clazz.cast(forwardingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeasurementProcessingConfig, T> g) {
        return obj -> g.apply((MeasurementProcessingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MeasurementProcessingConfig> {
        /**
         * <p>
         * The forwarding configuration for the given measurement property.
         * </p>
         * 
         * @param forwardingConfig
         *        The forwarding configuration for the given measurement property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingConfig(ForwardingConfig forwardingConfig);

        /**
         * <p>
         * The forwarding configuration for the given measurement property.
         * </p>
         * This is a convenience that creates an instance of the {@link ForwardingConfig.Builder} avoiding the need to
         * create one manually via {@link ForwardingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ForwardingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #forwardingConfig(ForwardingConfig)}.
         * 
         * @param forwardingConfig
         *        a consumer that will call methods on {@link ForwardingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forwardingConfig(ForwardingConfig)
         */
        default Builder forwardingConfig(Consumer<ForwardingConfig.Builder> forwardingConfig) {
            return forwardingConfig(ForwardingConfig.builder().applyMutation(forwardingConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ForwardingConfig forwardingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(MeasurementProcessingConfig model) {
            forwardingConfig(model.forwardingConfig);
        }

        public final ForwardingConfig.Builder getForwardingConfig() {
            return forwardingConfig != null ? forwardingConfig.toBuilder() : null;
        }

        public final void setForwardingConfig(ForwardingConfig.BuilderImpl forwardingConfig) {
            this.forwardingConfig = forwardingConfig != null ? forwardingConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder forwardingConfig(ForwardingConfig forwardingConfig) {
            this.forwardingConfig = forwardingConfig;
            return this;
        }

        @Override
        public MeasurementProcessingConfig build() {
            return new MeasurementProcessingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
