/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGatewayCapabilityConfigurationResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<UpdateGatewayCapabilityConfigurationResponse.Builder, UpdateGatewayCapabilityConfigurationResponse> {
    private static final SdkField<String> CAPABILITY_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capabilityNamespace").getter(getter(UpdateGatewayCapabilityConfigurationResponse::capabilityNamespace))
            .setter(setter(Builder::capabilityNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityNamespace").build())
            .build();

    private static final SdkField<String> CAPABILITY_SYNC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capabilitySyncStatus")
            .getter(getter(UpdateGatewayCapabilityConfigurationResponse::capabilitySyncStatusAsString))
            .setter(setter(Builder::capabilitySyncStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilitySyncStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITY_NAMESPACE_FIELD,
            CAPABILITY_SYNC_STATUS_FIELD));

    private final String capabilityNamespace;

    private final String capabilitySyncStatus;

    private UpdateGatewayCapabilityConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.capabilityNamespace = builder.capabilityNamespace;
        this.capabilitySyncStatus = builder.capabilitySyncStatus;
    }

    /**
     * <p>
     * The namespace of the gateway capability.
     * </p>
     * 
     * @return The namespace of the gateway capability.
     */
    public final String capabilityNamespace() {
        return capabilityNamespace;
    }

    /**
     * <p>
     * The synchronization status of the capability configuration. The sync status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_SYNC</code> – The gateway is running the capability configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the gateway
     * receives and applies or rejects the updated configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capabilitySyncStatus} will return {@link CapabilitySyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #capabilitySyncStatusAsString}.
     * </p>
     * 
     * @return The synchronization status of the capability configuration. The sync status can be one of the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code> – The gateway is running the capability configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the
     *         gateway receives and applies or rejects the updated configuration.
     * @see CapabilitySyncStatus
     */
    public final CapabilitySyncStatus capabilitySyncStatus() {
        return CapabilitySyncStatus.fromValue(capabilitySyncStatus);
    }

    /**
     * <p>
     * The synchronization status of the capability configuration. The sync status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_SYNC</code> – The gateway is running the capability configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the gateway
     * receives and applies or rejects the updated configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capabilitySyncStatus} will return {@link CapabilitySyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #capabilitySyncStatusAsString}.
     * </p>
     * 
     * @return The synchronization status of the capability configuration. The sync status can be one of the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code> – The gateway is running the capability configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the
     *         gateway receives and applies or rejects the updated configuration.
     * @see CapabilitySyncStatus
     */
    public final String capabilitySyncStatusAsString() {
        return capabilitySyncStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capabilityNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(capabilitySyncStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGatewayCapabilityConfigurationResponse)) {
            return false;
        }
        UpdateGatewayCapabilityConfigurationResponse other = (UpdateGatewayCapabilityConfigurationResponse) obj;
        return Objects.equals(capabilityNamespace(), other.capabilityNamespace())
                && Objects.equals(capabilitySyncStatusAsString(), other.capabilitySyncStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGatewayCapabilityConfigurationResponse").add("CapabilityNamespace", capabilityNamespace())
                .add("CapabilitySyncStatus", capabilitySyncStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capabilityNamespace":
            return Optional.ofNullable(clazz.cast(capabilityNamespace()));
        case "capabilitySyncStatus":
            return Optional.ofNullable(clazz.cast(capabilitySyncStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGatewayCapabilityConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateGatewayCapabilityConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGatewayCapabilityConfigurationResponse> {
        /**
         * <p>
         * The namespace of the gateway capability.
         * </p>
         * 
         * @param capabilityNamespace
         *        The namespace of the gateway capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityNamespace(String capabilityNamespace);

        /**
         * <p>
         * The synchronization status of the capability configuration. The sync status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_SYNC</code> – The gateway is running the capability configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
         * </p>
         * </li>
         * </ul>
         * <p>
         * After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the gateway
         * receives and applies or rejects the updated configuration.
         * </p>
         * 
         * @param capabilitySyncStatus
         *        The synchronization status of the capability configuration. The sync status can be one of the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code> – The gateway is running the capability configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the
         *        gateway receives and applies or rejects the updated configuration.
         * @see CapabilitySyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilitySyncStatus
         */
        Builder capabilitySyncStatus(String capabilitySyncStatus);

        /**
         * <p>
         * The synchronization status of the capability configuration. The sync status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_SYNC</code> – The gateway is running the capability configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
         * </p>
         * </li>
         * </ul>
         * <p>
         * After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the gateway
         * receives and applies or rejects the updated configuration.
         * </p>
         * 
         * @param capabilitySyncStatus
         *        The synchronization status of the capability configuration. The sync status can be one of the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code> – The gateway is running the capability configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the
         *        gateway receives and applies or rejects the updated configuration.
         * @see CapabilitySyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilitySyncStatus
         */
        Builder capabilitySyncStatus(CapabilitySyncStatus capabilitySyncStatus);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String capabilityNamespace;

        private String capabilitySyncStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGatewayCapabilityConfigurationResponse model) {
            super(model);
            capabilityNamespace(model.capabilityNamespace);
            capabilitySyncStatus(model.capabilitySyncStatus);
        }

        public final String getCapabilityNamespace() {
            return capabilityNamespace;
        }

        public final void setCapabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
        }

        @Override
        @Transient
        public final Builder capabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
            return this;
        }

        public final String getCapabilitySyncStatus() {
            return capabilitySyncStatus;
        }

        public final void setCapabilitySyncStatus(String capabilitySyncStatus) {
            this.capabilitySyncStatus = capabilitySyncStatus;
        }

        @Override
        @Transient
        public final Builder capabilitySyncStatus(String capabilitySyncStatus) {
            this.capabilitySyncStatus = capabilitySyncStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder capabilitySyncStatus(CapabilitySyncStatus capabilitySyncStatus) {
            this.capabilitySyncStatus(capabilitySyncStatus == null ? null : capabilitySyncStatus.toString());
            return this;
        }

        @Override
        public UpdateGatewayCapabilityConfigurationResponse build() {
            return new UpdateGatewayCapabilityConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
