/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotsitewise.DefaultIoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.DefaultIoTSiteWiseBaseClientBuilder;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClientBuilder;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseServiceClientConfiguration;
import software.amazon.awssdk.services.iotsitewise.endpoints.IoTSiteWiseEndpointProvider;

@SdkInternalApi
final class DefaultIoTSiteWiseAsyncClientBuilder
extends DefaultIoTSiteWiseBaseClientBuilder<IoTSiteWiseAsyncClientBuilder, IoTSiteWiseAsyncClient>
implements IoTSiteWiseAsyncClientBuilder {
    DefaultIoTSiteWiseAsyncClientBuilder() {
    }

    @Override
    public DefaultIoTSiteWiseAsyncClientBuilder endpointProvider(IoTSiteWiseEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IoTSiteWiseAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIoTSiteWiseAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IoTSiteWiseServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIoTSiteWiseAsyncClient client = new DefaultIoTSiteWiseAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IoTSiteWiseServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IoTSiteWiseServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

