/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an asset measurement property. For more information, see <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#measurements">Measurements</a>
 * in the <i>IoT SiteWise User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Measurement implements SdkPojo, Serializable, ToCopyableBuilder<Measurement.Builder, Measurement> {
    private static final SdkField<MeasurementProcessingConfig> PROCESSING_CONFIG_FIELD = SdkField
            .<MeasurementProcessingConfig> builder(MarshallingType.SDK_POJO).memberName("processingConfig")
            .getter(getter(Measurement::processingConfig)).setter(setter(Builder::processingConfig))
            .constructor(MeasurementProcessingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSING_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final MeasurementProcessingConfig processingConfig;

    private Measurement(BuilderImpl builder) {
        this.processingConfig = builder.processingConfig;
    }

    /**
     * <p>
     * The processing configuration for the given measurement property. You can configure measurements to be kept at the
     * edge or forwarded to the Amazon Web Services Cloud. By default, measurements are forwarded to the cloud.
     * </p>
     * 
     * @return The processing configuration for the given measurement property. You can configure measurements to be
     *         kept at the edge or forwarded to the Amazon Web Services Cloud. By default, measurements are forwarded to
     *         the cloud.
     */
    public final MeasurementProcessingConfig processingConfig() {
        return processingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(processingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Measurement)) {
            return false;
        }
        Measurement other = (Measurement) obj;
        return Objects.equals(processingConfig(), other.processingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Measurement").add("ProcessingConfig", processingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "processingConfig":
            return Optional.ofNullable(clazz.cast(processingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Measurement, T> g) {
        return obj -> g.apply((Measurement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Measurement> {
        /**
         * <p>
         * The processing configuration for the given measurement property. You can configure measurements to be kept at
         * the edge or forwarded to the Amazon Web Services Cloud. By default, measurements are forwarded to the cloud.
         * </p>
         * 
         * @param processingConfig
         *        The processing configuration for the given measurement property. You can configure measurements to be
         *        kept at the edge or forwarded to the Amazon Web Services Cloud. By default, measurements are forwarded
         *        to the cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfig(MeasurementProcessingConfig processingConfig);

        /**
         * <p>
         * The processing configuration for the given measurement property. You can configure measurements to be kept at
         * the edge or forwarded to the Amazon Web Services Cloud. By default, measurements are forwarded to the cloud.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeasurementProcessingConfig.Builder}
         * avoiding the need to create one manually via {@link MeasurementProcessingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeasurementProcessingConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #processingConfig(MeasurementProcessingConfig)}.
         * 
         * @param processingConfig
         *        a consumer that will call methods on {@link MeasurementProcessingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfig(MeasurementProcessingConfig)
         */
        default Builder processingConfig(Consumer<MeasurementProcessingConfig.Builder> processingConfig) {
            return processingConfig(MeasurementProcessingConfig.builder().applyMutation(processingConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MeasurementProcessingConfig processingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Measurement model) {
            processingConfig(model.processingConfig);
        }

        public final MeasurementProcessingConfig.Builder getProcessingConfig() {
            return processingConfig != null ? processingConfig.toBuilder() : null;
        }

        public final void setProcessingConfig(MeasurementProcessingConfig.BuilderImpl processingConfig) {
            this.processingConfig = processingConfig != null ? processingConfig.build() : null;
        }

        @Override
        public final Builder processingConfig(MeasurementProcessingConfig processingConfig) {
            this.processingConfig = processingConfig;
            return this;
        }

        @Override
        public Measurement build() {
            return new Measurement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
