/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertySummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesResponse;

public class ListAssetModelPropertiesIterable
implements SdkIterable<ListAssetModelPropertiesResponse> {
    private final IoTSiteWiseClient client;
    private final ListAssetModelPropertiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssetModelPropertiesIterable(IoTSiteWiseClient client, ListAssetModelPropertiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAssetModelPropertiesResponseFetcher();
    }

    public Iterator<ListAssetModelPropertiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetModelPropertySummary> assetModelPropertySummaries() {
        Function<ListAssetModelPropertiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetModelPropertySummaries() != null) {
                return response.assetModelPropertySummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssetModelPropertiesResponseFetcher
    implements SyncPageFetcher<ListAssetModelPropertiesResponse> {
        private ListAssetModelPropertiesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetModelPropertiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssetModelPropertiesResponse nextPage(ListAssetModelPropertiesResponse previousPage) {
            if (previousPage == null) {
                return ListAssetModelPropertiesIterable.this.client.listAssetModelProperties(ListAssetModelPropertiesIterable.this.firstRequest);
            }
            return ListAssetModelPropertiesIterable.this.client.listAssetModelProperties((ListAssetModelPropertiesRequest)((Object)ListAssetModelPropertiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

