/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iotsitewise.model.AssociateAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.AssociateAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.AssociateTimeSeriesToAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.AssociateTimeSeriesToAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueResponse;
import software.amazon.awssdk.services.iotsitewise.model.ConflictingOperationException;
import software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreatePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreatePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateProjectResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeletePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeletePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteProjectResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeLoggingOptionsRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeLoggingOptionsResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeProjectResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse;
import software.amazon.awssdk.services.iotsitewise.model.InternalFailureException;
import software.amazon.awssdk.services.iotsitewise.model.InvalidRequestException;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseException;
import software.amazon.awssdk.services.iotsitewise.model.LimitExceededException;
import software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListDashboardsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iotsitewise.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotsitewise.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iotsitewise.model.TagResourceRequest;
import software.amazon.awssdk.services.iotsitewise.model.TagResourceResponse;
import software.amazon.awssdk.services.iotsitewise.model.ThrottlingException;
import software.amazon.awssdk.services.iotsitewise.model.TooManyTagsException;
import software.amazon.awssdk.services.iotsitewise.model.UnauthorizedException;
import software.amazon.awssdk.services.iotsitewise.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotsitewise.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdatePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateProjectResponse;
import software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyAggregatesIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueHistoryIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyAggregatesIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyValueHistoryIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.GetInterpolatedAssetPropertyValuesIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAccessPoliciesIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelPropertiesIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelsIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAssetPropertiesIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAssetRelationshipsIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAssetsIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAssociatedAssetsIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListBulkImportJobsIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListDashboardsIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListGatewaysIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListPortalsIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListProjectAssetsIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListProjectsIterable;
import software.amazon.awssdk.services.iotsitewise.paginators.ListTimeSeriesIterable;
import software.amazon.awssdk.services.iotsitewise.waiters.IoTSiteWiseWaiter;

/**
 * Service client for accessing AWS IoT SiteWise. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Welcome to the IoT SiteWise API Reference. IoT SiteWise is an Amazon Web Services service that connects <a
 * href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">Industrial Internet of Things
 * (IIoT)</a> devices to the power of the Amazon Web Services Cloud. For more information, see the <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/">IoT SiteWise User Guide</a>. For information about
 * IoT SiteWise quotas, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a>
 * in the <i>IoT SiteWise User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IoTSiteWiseClient extends AwsClient {
    String SERVICE_NAME = "iotsitewise";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "iotsitewise";

    /**
     * <p>
     * Associates a child asset with the given parent asset through a hierarchy defined in the parent asset's model. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html">Associating
     * assets</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param associateAssetsRequest
     * @return Result of the AssociateAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.AssociateAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateAssetsResponse associateAssets(AssociateAssetsRequest associateAssetsRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            LimitExceededException, ThrottlingException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a child asset with the given parent asset through a hierarchy defined in the parent asset's model. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html">Associating
     * assets</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAssetsRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateAssetsRequest#builder()}
     * </p>
     *
     * @param associateAssetsRequest
     *        A {@link Consumer} that will call methods on {@link AssociateAssetsRequest.Builder} to create a request.
     * @return Result of the AssociateAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.AssociateAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateAssetsResponse associateAssets(Consumer<AssociateAssetsRequest.Builder> associateAssetsRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            LimitExceededException, ThrottlingException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return associateAssets(AssociateAssetsRequest.builder().applyMutation(associateAssetsRequest).build());
    }

    /**
     * <p>
     * Associates a time series (data stream) with an asset property.
     * </p>
     *
     * @param associateTimeSeriesToAssetPropertyRequest
     * @return Result of the AssociateTimeSeriesToAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.AssociateTimeSeriesToAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateTimeSeriesToAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTimeSeriesToAssetPropertyResponse associateTimeSeriesToAssetProperty(
            AssociateTimeSeriesToAssetPropertyRequest associateTimeSeriesToAssetPropertyRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ConflictingOperationException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a time series (data stream) with an asset property.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTimeSeriesToAssetPropertyRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateTimeSeriesToAssetPropertyRequest#builder()}
     * </p>
     *
     * @param associateTimeSeriesToAssetPropertyRequest
     *        A {@link Consumer} that will call methods on {@link AssociateTimeSeriesToAssetPropertyRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateTimeSeriesToAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.AssociateTimeSeriesToAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateTimeSeriesToAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTimeSeriesToAssetPropertyResponse associateTimeSeriesToAssetProperty(
            Consumer<AssociateTimeSeriesToAssetPropertyRequest.Builder> associateTimeSeriesToAssetPropertyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return associateTimeSeriesToAssetProperty(AssociateTimeSeriesToAssetPropertyRequest.builder()
                .applyMutation(associateTimeSeriesToAssetPropertyRequest).build());
    }

    /**
     * <p>
     * Associates a group (batch) of assets with an IoT SiteWise Monitor project.
     * </p>
     *
     * @param batchAssociateProjectAssetsRequest
     * @return Result of the BatchAssociateProjectAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchAssociateProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchAssociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateProjectAssetsResponse batchAssociateProjectAssets(
            BatchAssociateProjectAssetsRequest batchAssociateProjectAssetsRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a group (batch) of assets with an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchAssociateProjectAssetsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchAssociateProjectAssetsRequest#builder()}
     * </p>
     *
     * @param batchAssociateProjectAssetsRequest
     *        A {@link Consumer} that will call methods on {@link BatchAssociateProjectAssetsRequest.Builder} to create
     *        a request.
     * @return Result of the BatchAssociateProjectAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchAssociateProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchAssociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateProjectAssetsResponse batchAssociateProjectAssets(
            Consumer<BatchAssociateProjectAssetsRequest.Builder> batchAssociateProjectAssetsRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return batchAssociateProjectAssets(BatchAssociateProjectAssetsRequest.builder()
                .applyMutation(batchAssociateProjectAssetsRequest).build());
    }

    /**
     * <p>
     * Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.
     * </p>
     *
     * @param batchDisassociateProjectAssetsRequest
     * @return Result of the BatchDisassociateProjectAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchDisassociateProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchDisassociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateProjectAssetsResponse batchDisassociateProjectAssets(
            BatchDisassociateProjectAssetsRequest batchDisassociateProjectAssetsRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDisassociateProjectAssetsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDisassociateProjectAssetsRequest#builder()}
     * </p>
     *
     * @param batchDisassociateProjectAssetsRequest
     *        A {@link Consumer} that will call methods on {@link BatchDisassociateProjectAssetsRequest.Builder} to
     *        create a request.
     * @return Result of the BatchDisassociateProjectAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchDisassociateProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchDisassociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateProjectAssetsResponse batchDisassociateProjectAssets(
            Consumer<BatchDisassociateProjectAssetsRequest.Builder> batchDisassociateProjectAssetsRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return batchDisassociateProjectAssets(BatchDisassociateProjectAssetsRequest.builder()
                .applyMutation(batchDisassociateProjectAssetsRequest).build());
    }

    /**
     * <p>
     * Gets aggregated values (for example, average, minimum, and maximum) for one or more asset properties. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchGetAssetPropertyAggregatesRequest
     * @return Result of the BatchGetAssetPropertyAggregates operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyAggregatesResponse batchGetAssetPropertyAggregates(
            BatchGetAssetPropertyAggregatesRequest batchGetAssetPropertyAggregatesRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets aggregated values (for example, average, minimum, and maximum) for one or more asset properties. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAssetPropertyAggregatesRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetAssetPropertyAggregatesRequest#builder()}
     * </p>
     *
     * @param batchGetAssetPropertyAggregatesRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetAssetPropertyAggregatesRequest.Builder} to
     *        create a request.
     * @return Result of the BatchGetAssetPropertyAggregates operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyAggregatesResponse batchGetAssetPropertyAggregates(
            Consumer<BatchGetAssetPropertyAggregatesRequest.Builder> batchGetAssetPropertyAggregatesRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return batchGetAssetPropertyAggregates(BatchGetAssetPropertyAggregatesRequest.builder()
                .applyMutation(batchGetAssetPropertyAggregatesRequest).build());
    }

    /**
     * <p>
     * Gets aggregated values (for example, average, minimum, and maximum) for one or more asset properties. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #batchGetAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyAggregatesIterable responses = client.batchGetAssetPropertyAggregatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyAggregatesIterable responses = client
     *             .batchGetAssetPropertyAggregatesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyAggregatesIterable responses = client.batchGetAssetPropertyAggregatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param batchGetAssetPropertyAggregatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyAggregatesIterable batchGetAssetPropertyAggregatesPaginator(
            BatchGetAssetPropertyAggregatesRequest batchGetAssetPropertyAggregatesRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets aggregated values (for example, average, minimum, and maximum) for one or more asset properties. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #batchGetAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyAggregatesIterable responses = client.batchGetAssetPropertyAggregatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyAggregatesIterable responses = client
     *             .batchGetAssetPropertyAggregatesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyAggregatesIterable responses = client.batchGetAssetPropertyAggregatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAssetPropertyAggregatesRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetAssetPropertyAggregatesRequest#builder()}
     * </p>
     *
     * @param batchGetAssetPropertyAggregatesRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetAssetPropertyAggregatesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyAggregatesIterable batchGetAssetPropertyAggregatesPaginator(
            Consumer<BatchGetAssetPropertyAggregatesRequest.Builder> batchGetAssetPropertyAggregatesRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return batchGetAssetPropertyAggregatesPaginator(BatchGetAssetPropertyAggregatesRequest.builder()
                .applyMutation(batchGetAssetPropertyAggregatesRequest).build());
    }

    /**
     * <p>
     * Gets the current value for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchGetAssetPropertyValueRequest
     * @return Result of the BatchGetAssetPropertyValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyValueResponse batchGetAssetPropertyValue(
            BatchGetAssetPropertyValueRequest batchGetAssetPropertyValueRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the current value for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAssetPropertyValueRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetAssetPropertyValueRequest#builder()}
     * </p>
     *
     * @param batchGetAssetPropertyValueRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetAssetPropertyValueRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetAssetPropertyValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyValueResponse batchGetAssetPropertyValue(
            Consumer<BatchGetAssetPropertyValueRequest.Builder> batchGetAssetPropertyValueRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return batchGetAssetPropertyValue(BatchGetAssetPropertyValueRequest.builder()
                .applyMutation(batchGetAssetPropertyValueRequest).build());
    }

    /**
     * <p>
     * Gets the current value for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #batchGetAssetPropertyValue(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueIterable responses = client.batchGetAssetPropertyValuePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueIterable responses = client
     *             .batchGetAssetPropertyValuePaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueIterable responses = client.batchGetAssetPropertyValuePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetAssetPropertyValue(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest)}
     * operation.</b>
     * </p>
     *
     * @param batchGetAssetPropertyValueRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyValueIterable batchGetAssetPropertyValuePaginator(
            BatchGetAssetPropertyValueRequest batchGetAssetPropertyValueRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the current value for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #batchGetAssetPropertyValue(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueIterable responses = client.batchGetAssetPropertyValuePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueIterable responses = client
     *             .batchGetAssetPropertyValuePaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueIterable responses = client.batchGetAssetPropertyValuePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetAssetPropertyValue(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAssetPropertyValueRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetAssetPropertyValueRequest#builder()}
     * </p>
     *
     * @param batchGetAssetPropertyValueRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetAssetPropertyValueRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyValueIterable batchGetAssetPropertyValuePaginator(
            Consumer<BatchGetAssetPropertyValueRequest.Builder> batchGetAssetPropertyValueRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return batchGetAssetPropertyValuePaginator(BatchGetAssetPropertyValueRequest.builder()
                .applyMutation(batchGetAssetPropertyValueRequest).build());
    }

    /**
     * <p>
     * Gets the historical values for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchGetAssetPropertyValueHistoryRequest
     * @return Result of the BatchGetAssetPropertyValueHistory operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyValueHistoryResponse batchGetAssetPropertyValueHistory(
            BatchGetAssetPropertyValueHistoryRequest batchGetAssetPropertyValueHistoryRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the historical values for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAssetPropertyValueHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetAssetPropertyValueHistoryRequest#builder()}
     * </p>
     *
     * @param batchGetAssetPropertyValueHistoryRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetAssetPropertyValueHistoryRequest.Builder} to
     *        create a request.
     * @return Result of the BatchGetAssetPropertyValueHistory operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyValueHistoryResponse batchGetAssetPropertyValueHistory(
            Consumer<BatchGetAssetPropertyValueHistoryRequest.Builder> batchGetAssetPropertyValueHistoryRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return batchGetAssetPropertyValueHistory(BatchGetAssetPropertyValueHistoryRequest.builder()
                .applyMutation(batchGetAssetPropertyValueHistoryRequest).build());
    }

    /**
     * <p>
     * Gets the historical values for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #batchGetAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueHistoryIterable responses = client.batchGetAssetPropertyValueHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueHistoryIterable responses = client
     *             .batchGetAssetPropertyValueHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueHistoryIterable responses = client.batchGetAssetPropertyValueHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param batchGetAssetPropertyValueHistoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyValueHistoryIterable batchGetAssetPropertyValueHistoryPaginator(
            BatchGetAssetPropertyValueHistoryRequest batchGetAssetPropertyValueHistoryRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the historical values for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #batchGetAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueHistoryIterable responses = client.batchGetAssetPropertyValueHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueHistoryIterable responses = client
     *             .batchGetAssetPropertyValueHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueHistoryIterable responses = client.batchGetAssetPropertyValueHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAssetPropertyValueHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetAssetPropertyValueHistoryRequest#builder()}
     * </p>
     *
     * @param batchGetAssetPropertyValueHistoryRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetAssetPropertyValueHistoryRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchGetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyValueHistoryIterable batchGetAssetPropertyValueHistoryPaginator(
            Consumer<BatchGetAssetPropertyValueHistoryRequest.Builder> batchGetAssetPropertyValueHistoryRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return batchGetAssetPropertyValueHistoryPaginator(BatchGetAssetPropertyValueHistoryRequest.builder()
                .applyMutation(batchGetAssetPropertyValueHistoryRequest).build());
    }

    /**
     * <p>
     * Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value (TQV) data point.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html">Ingesting data using the API</a>
     * in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more than 7 days in
     * the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps outside of the inclusive
     * range of [-7 days, +10 minutes] and returns a <code>TimestampOutOfRangeException</code> error.
     * </p>
     * <p>
     * For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer TQV has a
     * different quality. For example, if you store a TQV <code>{T1, GOOD, V1}</code>, then storing
     * <code>{T1, GOOD, V2}</code> replaces the existing TQV.
     * </p>
     * </important>
     * <p>
     * IoT SiteWise authorizes access to each <code>BatchPutAssetPropertyValue</code> entry individually. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action"
     * >BatchPutAssetPropertyValue authorization</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchPutAssetPropertyValueRequest
     * @return Result of the BatchPutAssetPropertyValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchPutAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchPutAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutAssetPropertyValueResponse batchPutAssetPropertyValue(
            BatchPutAssetPropertyValueRequest batchPutAssetPropertyValueRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, LimitExceededException,
            ServiceUnavailableException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value (TQV) data point.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html">Ingesting data using the API</a>
     * in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more than 7 days in
     * the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps outside of the inclusive
     * range of [-7 days, +10 minutes] and returns a <code>TimestampOutOfRangeException</code> error.
     * </p>
     * <p>
     * For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer TQV has a
     * different quality. For example, if you store a TQV <code>{T1, GOOD, V1}</code>, then storing
     * <code>{T1, GOOD, V2}</code> replaces the existing TQV.
     * </p>
     * </important>
     * <p>
     * IoT SiteWise authorizes access to each <code>BatchPutAssetPropertyValue</code> entry individually. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action"
     * >BatchPutAssetPropertyValue authorization</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutAssetPropertyValueRequest.Builder} avoiding
     * the need to create one manually via {@link BatchPutAssetPropertyValueRequest#builder()}
     * </p>
     *
     * @param batchPutAssetPropertyValueRequest
     *        A {@link Consumer} that will call methods on {@link BatchPutAssetPropertyValueRequest.Builder} to create a
     *        request.
     * @return Result of the BatchPutAssetPropertyValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.BatchPutAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchPutAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutAssetPropertyValueResponse batchPutAssetPropertyValue(
            Consumer<BatchPutAssetPropertyValueRequest.Builder> batchPutAssetPropertyValueRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, ServiceUnavailableException, ConflictingOperationException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return batchPutAssetPropertyValue(BatchPutAssetPropertyValueRequest.builder()
                .applyMutation(batchPutAssetPropertyValueRequest).build());
    }

    /**
     * <p>
     * Creates an access policy that grants the specified identity (IAM Identity Center user, IAM Identity Center group,
     * or IAM user) access to the specified IoT SiteWise Monitor portal or project resource.
     * </p>
     *
     * @param createAccessPolicyRequest
     * @return Result of the CreateAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessPolicyResponse createAccessPolicy(CreateAccessPolicyRequest createAccessPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an access policy that grants the specified identity (IAM Identity Center user, IAM Identity Center group,
     * or IAM user) access to the specified IoT SiteWise Monitor portal or project resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAccessPolicyRequest#builder()}
     * </p>
     *
     * @param createAccessPolicyRequest
     *        A {@link Consumer} that will call methods on {@link CreateAccessPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessPolicyResponse createAccessPolicy(Consumer<CreateAccessPolicyRequest.Builder> createAccessPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return createAccessPolicy(CreateAccessPolicyRequest.builder().applyMutation(createAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Creates an asset from an existing asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param createAssetRequest
     * @return Result of the CreateAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAssetResponse createAsset(CreateAssetRequest createAssetRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an asset from an existing asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAssetRequest#builder()}
     * </p>
     *
     * @param createAssetRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssetRequest.Builder} to create a request.
     * @return Result of the CreateAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAssetResponse createAsset(Consumer<CreateAssetRequest.Builder> createAssetRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            ThrottlingException, LimitExceededException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return createAsset(CreateAssetRequest.builder().applyMutation(createAssetRequest).build());
    }

    /**
     * <p>
     * Creates an asset model from specified property and hierarchy definitions. You create assets from asset models.
     * With asset models, you can easily create assets of the same type that have standardized definitions. Each asset
     * created from a model inherits the asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param createAssetModelRequest
     * @return Result of the CreateAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAssetModelResponse createAssetModel(CreateAssetModelRequest createAssetModelRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            ThrottlingException, LimitExceededException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an asset model from specified property and hierarchy definitions. You create assets from asset models.
     * With asset models, you can easily create assets of the same type that have standardized definitions. Each asset
     * created from a model inherits the asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetModelRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssetModelRequest#builder()}
     * </p>
     *
     * @param createAssetModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssetModelRequest.Builder} to create a request.
     * @return Result of the CreateAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAssetModelResponse createAssetModel(Consumer<CreateAssetModelRequest.Builder> createAssetModelRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            ThrottlingException, LimitExceededException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return createAssetModel(CreateAssetModelRequest.builder().applyMutation(createAssetModelRequest).build());
    }

    /**
     * <p>
     * Defines a job to ingest data to IoT SiteWise from Amazon S3. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/CreateBulkImportJob.html">Create a bulk import
     * job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <important>
     * <p>
     * You must enable IoT SiteWise to export data to Amazon S3 before you create a bulk import job. For more
     * information about how to configure storage settings, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_PutStorageConfiguration.html"
     * >PutStorageConfiguration</a>.
     * </p>
     * </important>
     *
     * @param createBulkImportJobRequest
     * @return Result of the CreateBulkImportJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateBulkImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBulkImportJobResponse createBulkImportJob(CreateBulkImportJobRequest createBulkImportJobRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            ThrottlingException, LimitExceededException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines a job to ingest data to IoT SiteWise from Amazon S3. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/CreateBulkImportJob.html">Create a bulk import
     * job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <important>
     * <p>
     * You must enable IoT SiteWise to export data to Amazon S3 before you create a bulk import job. For more
     * information about how to configure storage settings, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_PutStorageConfiguration.html"
     * >PutStorageConfiguration</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBulkImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBulkImportJobRequest#builder()}
     * </p>
     *
     * @param createBulkImportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateBulkImportJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateBulkImportJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateBulkImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBulkImportJobResponse createBulkImportJob(
            Consumer<CreateBulkImportJobRequest.Builder> createBulkImportJobRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return createBulkImportJob(CreateBulkImportJobRequest.builder().applyMutation(createBulkImportJobRequest).build());
    }

    /**
     * <p>
     * Creates a dashboard in an IoT SiteWise Monitor project.
     * </p>
     *
     * @param createDashboardRequest
     * @return Result of the CreateDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDashboardResponse createDashboard(CreateDashboardRequest createDashboardRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a dashboard in an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDashboardRequest#builder()}
     * </p>
     *
     * @param createDashboardRequest
     *        A {@link Consumer} that will call methods on {@link CreateDashboardRequest.Builder} to create a request.
     * @return Result of the CreateDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDashboardResponse createDashboard(Consumer<CreateDashboardRequest.Builder> createDashboardRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return createDashboard(CreateDashboardRequest.builder().applyMutation(createDashboardRequest).build());
    }

    /**
     * <p>
     * Creates a gateway, which is a virtual or edge device that delivers industrial data streams from local servers to
     * IoT SiteWise. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a
     * gateway</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param createGatewayRequest
     * @return Result of the CreateGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGatewayResponse createGateway(CreateGatewayRequest createGatewayRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, InternalFailureException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a gateway, which is a virtual or edge device that delivers industrial data streams from local servers to
     * IoT SiteWise. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a
     * gateway</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGatewayRequest#builder()}
     * </p>
     *
     * @param createGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateGatewayRequest.Builder} to create a request.
     * @return Result of the CreateGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGatewayResponse createGateway(Consumer<CreateGatewayRequest.Builder> createGatewayRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, InternalFailureException, ThrottlingException,
            LimitExceededException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return createGateway(CreateGatewayRequest.builder().applyMutation(createGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses IAM Identity Center or IAM
     * to authenticate portal users and manage user permissions.
     * </p>
     * <note>
     * <p>
     * Before you can sign in to a new portal, you must add at least one identity to that portal. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins"
     * >Adding or removing portal administrators</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * </note>
     *
     * @param createPortalRequest
     * @return Result of the CreatePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePortalResponse createPortal(CreatePortalRequest createPortalRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses IAM Identity Center or IAM
     * to authenticate portal users and manage user permissions.
     * </p>
     * <note>
     * <p>
     * Before you can sign in to a new portal, you must add at least one identity to that portal. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins"
     * >Adding or removing portal administrators</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePortalRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePortalRequest#builder()}
     * </p>
     *
     * @param createPortalRequest
     *        A {@link Consumer} that will call methods on {@link CreatePortalRequest.Builder} to create a request.
     * @return Result of the CreatePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePortalResponse createPortal(Consumer<CreatePortalRequest.Builder> createPortalRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return createPortal(CreatePortalRequest.builder().applyMutation(createPortalRequest).build());
    }

    /**
     * <p>
     * Creates a project in the specified portal.
     * </p>
     * <note>
     * <p>
     * Make sure that the project name and description don't contain confidential information.
     * </p>
     * </note>
     *
     * @param createProjectRequest
     * @return Result of the CreateProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a project in the specified portal.
     * </p>
     * <note>
     * <p>
     * Make sure that the project name and description don't contain confidential information.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on {@link CreateProjectRequest.Builder} to create a request.
     * @return Result of the CreateProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Deletes an access policy that grants the specified identity access to the specified IoT SiteWise Monitor
     * resource. You can use this operation to revoke access to an IoT SiteWise Monitor resource.
     * </p>
     *
     * @param deleteAccessPolicyRequest
     * @return Result of the DeleteAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessPolicyResponse deleteAccessPolicy(DeleteAccessPolicyRequest deleteAccessPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an access policy that grants the specified identity access to the specified IoT SiteWise Monitor
     * resource. You can use this operation to revoke access to an IoT SiteWise Monitor resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAccessPolicyRequest#builder()}
     * </p>
     *
     * @param deleteAccessPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccessPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessPolicyResponse deleteAccessPolicy(Consumer<DeleteAccessPolicyRequest.Builder> deleteAccessPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return deleteAccessPolicy(DeleteAccessPolicyRequest.builder().applyMutation(deleteAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an asset. This action can't be undone. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't delete an asset that's associated to another asset. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html"
     * >DisassociateAssets</a>.
     * </p>
     * </note>
     *
     * @param deleteAssetRequest
     * @return Result of the DeleteAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAssetResponse deleteAsset(DeleteAssetRequest deleteAssetRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ConflictingOperationException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an asset. This action can't be undone. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't delete an asset that's associated to another asset. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html"
     * >DisassociateAssets</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAssetRequest#builder()}
     * </p>
     *
     * @param deleteAssetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssetRequest.Builder} to create a request.
     * @return Result of the DeleteAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAssetResponse deleteAsset(Consumer<DeleteAssetRequest.Builder> deleteAssetRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return deleteAsset(DeleteAssetRequest.builder().applyMutation(deleteAssetRequest).build());
    }

    /**
     * <p>
     * Deletes an asset model. This action can't be undone. You must delete all assets created from an asset model
     * before you can delete the model. Also, you can't delete an asset model if a parent asset model exists that
     * contains a property formula expression that depends on the asset model that you want to delete. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param deleteAssetModelRequest
     * @return Result of the DeleteAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAssetModelResponse deleteAssetModel(DeleteAssetModelRequest deleteAssetModelRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an asset model. This action can't be undone. You must delete all assets created from an asset model
     * before you can delete the model. Also, you can't delete an asset model if a parent asset model exists that
     * contains a property formula expression that depends on the asset model that you want to delete. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetModelRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssetModelRequest#builder()}
     * </p>
     *
     * @param deleteAssetModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssetModelRequest.Builder} to create a request.
     * @return Result of the DeleteAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAssetModelResponse deleteAssetModel(Consumer<DeleteAssetModelRequest.Builder> deleteAssetModelRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return deleteAssetModel(DeleteAssetModelRequest.builder().applyMutation(deleteAssetModelRequest).build());
    }

    /**
     * <p>
     * Deletes a dashboard from IoT SiteWise Monitor.
     * </p>
     *
     * @param deleteDashboardRequest
     * @return Result of the DeleteDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDashboardResponse deleteDashboard(DeleteDashboardRequest deleteDashboardRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dashboard from IoT SiteWise Monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDashboardRequest#builder()}
     * </p>
     *
     * @param deleteDashboardRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDashboardRequest.Builder} to create a request.
     * @return Result of the DeleteDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDashboardResponse deleteDashboard(Consumer<DeleteDashboardRequest.Builder> deleteDashboardRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return deleteDashboard(DeleteDashboardRequest.builder().applyMutation(deleteDashboardRequest).build());
    }

    /**
     * <p>
     * Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain in your
     * gateway's file system.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGatewayResponse deleteGateway(DeleteGatewayRequest deleteGatewayRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain in your
     * gateway's file system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGatewayRequest#builder()}
     * </p>
     *
     * @param deleteGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGatewayRequest.Builder} to create a request.
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGatewayResponse deleteGateway(Consumer<DeleteGatewayRequest.Builder> deleteGatewayRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return deleteGateway(DeleteGatewayRequest.builder().applyMutation(deleteGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a portal from IoT SiteWise Monitor.
     * </p>
     *
     * @param deletePortalRequest
     * @return Result of the DeletePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeletePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeletePortal" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePortalResponse deletePortal(DeletePortalRequest deletePortalRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ConflictingOperationException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a portal from IoT SiteWise Monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePortalRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePortalRequest#builder()}
     * </p>
     *
     * @param deletePortalRequest
     *        A {@link Consumer} that will call methods on {@link DeletePortalRequest.Builder} to create a request.
     * @return Result of the DeletePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeletePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeletePortal" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePortalResponse deletePortal(Consumer<DeletePortalRequest.Builder> deletePortalRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return deletePortal(DeletePortalRequest.builder().applyMutation(deletePortalRequest).build());
    }

    /**
     * <p>
     * Deletes a project from IoT SiteWise Monitor.
     * </p>
     *
     * @param deleteProjectRequest
     * @return Result of the DeleteProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a project from IoT SiteWise Monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProjectRequest.Builder} to create a request.
     * @return Result of the DeleteProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Deletes a time series (data stream). If you delete a time series that's associated with an asset property, the
     * asset property still exists, but the time series will no longer be associated with this asset property.
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     *
     * @param deleteTimeSeriesRequest
     * @return Result of the DeleteTimeSeries operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTimeSeriesResponse deleteTimeSeries(DeleteTimeSeriesRequest deleteTimeSeriesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a time series (data stream). If you delete a time series that's associated with an asset property, the
     * asset property still exists, but the time series will no longer be associated with this asset property.
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTimeSeriesRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTimeSeriesRequest#builder()}
     * </p>
     *
     * @param deleteTimeSeriesRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTimeSeriesRequest.Builder} to create a request.
     * @return Result of the DeleteTimeSeries operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DeleteTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTimeSeriesResponse deleteTimeSeries(Consumer<DeleteTimeSeriesRequest.Builder> deleteTimeSeriesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return deleteTimeSeries(DeleteTimeSeriesRequest.builder().applyMutation(deleteTimeSeriesRequest).build());
    }

    /**
     * <p>
     * Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or project.
     * </p>
     *
     * @param describeAccessPolicyRequest
     * @return Result of the DescribeAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccessPolicyResponse describeAccessPolicy(DescribeAccessPolicyRequest describeAccessPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccessPolicyRequest#builder()}
     * </p>
     *
     * @param describeAccessPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccessPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccessPolicyResponse describeAccessPolicy(
            Consumer<DescribeAccessPolicyRequest.Builder> describeAccessPolicyRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return describeAccessPolicy(DescribeAccessPolicyRequest.builder().applyMutation(describeAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an asset.
     * </p>
     *
     * @param describeAssetRequest
     * @return Result of the DescribeAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAssetResponse describeAsset(DescribeAssetRequest describeAssetRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssetRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAssetRequest#builder()}
     * </p>
     *
     * @param describeAssetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssetRequest.Builder} to create a request.
     * @return Result of the DescribeAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAssetResponse describeAsset(Consumer<DescribeAssetRequest.Builder> describeAssetRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return describeAsset(DescribeAssetRequest.builder().applyMutation(describeAssetRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an asset model.
     * </p>
     *
     * @param describeAssetModelRequest
     * @return Result of the DescribeAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssetModelResponse describeAssetModel(DescribeAssetModelRequest describeAssetModelRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an asset model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssetModelRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAssetModelRequest#builder()}
     * </p>
     *
     * @param describeAssetModelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssetModelRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssetModelResponse describeAssetModel(Consumer<DescribeAssetModelRequest.Builder> describeAssetModelRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return describeAssetModel(DescribeAssetModelRequest.builder().applyMutation(describeAssetModelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an asset property.
     * </p>
     * <note>
     * <p>
     * When you call this operation for an attribute property, this response includes the default attribute value that
     * you define in the asset model. If you update the default value in the model, this operation's response includes
     * the new default value.
     * </p>
     * </note>
     * <p>
     * This operation doesn't return the value of the asset property. To get the value of an asset property, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html">
     * GetAssetPropertyValue</a>.
     * </p>
     *
     * @param describeAssetPropertyRequest
     * @return Result of the DescribeAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssetPropertyResponse describeAssetProperty(DescribeAssetPropertyRequest describeAssetPropertyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an asset property.
     * </p>
     * <note>
     * <p>
     * When you call this operation for an attribute property, this response includes the default attribute value that
     * you define in the asset model. If you update the default value in the model, this operation's response includes
     * the new default value.
     * </p>
     * </note>
     * <p>
     * This operation doesn't return the value of the asset property. To get the value of an asset property, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html">
     * GetAssetPropertyValue</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssetPropertyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAssetPropertyRequest#builder()}
     * </p>
     *
     * @param describeAssetPropertyRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssetPropertyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssetPropertyResponse describeAssetProperty(
            Consumer<DescribeAssetPropertyRequest.Builder> describeAssetPropertyRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return describeAssetProperty(DescribeAssetPropertyRequest.builder().applyMutation(describeAssetPropertyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a bulk import job request. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/DescribeBulkImportJob.html">Describe a bulk
     * import job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     *
     * @param describeBulkImportJobRequest
     * @return Result of the DescribeBulkImportJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeBulkImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBulkImportJobResponse describeBulkImportJob(DescribeBulkImportJobRequest describeBulkImportJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a bulk import job request. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/DescribeBulkImportJob.html">Describe a bulk
     * import job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBulkImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBulkImportJobRequest#builder()}
     * </p>
     *
     * @param describeBulkImportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBulkImportJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeBulkImportJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeBulkImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBulkImportJobResponse describeBulkImportJob(
            Consumer<DescribeBulkImportJobRequest.Builder> describeBulkImportJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return describeBulkImportJob(DescribeBulkImportJobRequest.builder().applyMutation(describeBulkImportJobRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a dashboard.
     * </p>
     *
     * @param describeDashboardRequest
     * @return Result of the DescribeDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDashboardResponse describeDashboard(DescribeDashboardRequest describeDashboardRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a dashboard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDashboardRequest#builder()}
     * </p>
     *
     * @param describeDashboardRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDashboardRequest.Builder} to create a request.
     * @return Result of the DescribeDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDashboardResponse describeDashboard(Consumer<DescribeDashboardRequest.Builder> describeDashboardRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return describeDashboard(DescribeDashboardRequest.builder().applyMutation(describeDashboardRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in the
     * default or specified Region. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param describeDefaultEncryptionConfigurationRequest
     * @return Result of the DescribeDefaultEncryptionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDefaultEncryptionConfigurationResponse describeDefaultEncryptionConfiguration(
            DescribeDefaultEncryptionConfigurationRequest describeDefaultEncryptionConfigurationRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in the
     * default or specified Region. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeDefaultEncryptionConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeDefaultEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param describeDefaultEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDefaultEncryptionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeDefaultEncryptionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDefaultEncryptionConfigurationResponse describeDefaultEncryptionConfiguration(
            Consumer<DescribeDefaultEncryptionConfigurationRequest.Builder> describeDefaultEncryptionConfigurationRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return describeDefaultEncryptionConfiguration(DescribeDefaultEncryptionConfigurationRequest.builder()
                .applyMutation(describeDefaultEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a gateway.
     * </p>
     *
     * @param describeGatewayRequest
     * @return Result of the DescribeGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGatewayResponse describeGateway(DescribeGatewayRequest describeGatewayRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeGatewayRequest#builder()}
     * </p>
     *
     * @param describeGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGatewayRequest.Builder} to create a request.
     * @return Result of the DescribeGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGatewayResponse describeGateway(Consumer<DescribeGatewayRequest.Builder> describeGatewayRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return describeGateway(DescribeGatewayRequest.builder().applyMutation(describeGatewayRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a gateway capability configuration. Each gateway capability defines data sources for
     * a gateway. A capability configuration can contain multiple data source configurations. If you define OPC-UA
     * sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in one capability
     * configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     *
     * @param describeGatewayCapabilityConfigurationRequest
     * @return Result of the DescribeGatewayCapabilityConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeGatewayCapabilityConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGatewayCapabilityConfigurationResponse describeGatewayCapabilityConfiguration(
            DescribeGatewayCapabilityConfigurationRequest describeGatewayCapabilityConfigurationRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a gateway capability configuration. Each gateway capability defines data sources for
     * a gateway. A capability configuration can contain multiple data source configurations. If you define OPC-UA
     * sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in one capability
     * configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeGatewayCapabilityConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeGatewayCapabilityConfigurationRequest#builder()}
     * </p>
     *
     * @param describeGatewayCapabilityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGatewayCapabilityConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeGatewayCapabilityConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeGatewayCapabilityConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGatewayCapabilityConfigurationResponse describeGatewayCapabilityConfiguration(
            Consumer<DescribeGatewayCapabilityConfigurationRequest.Builder> describeGatewayCapabilityConfigurationRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return describeGatewayCapabilityConfiguration(DescribeGatewayCapabilityConfigurationRequest.builder()
                .applyMutation(describeGatewayCapabilityConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the current IoT SiteWise logging options.
     * </p>
     *
     * @param describeLoggingOptionsRequest
     * @return Result of the DescribeLoggingOptions operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoggingOptionsResponse describeLoggingOptions(DescribeLoggingOptionsRequest describeLoggingOptionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current IoT SiteWise logging options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoggingOptionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param describeLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLoggingOptionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLoggingOptions operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoggingOptionsResponse describeLoggingOptions(
            Consumer<DescribeLoggingOptionsRequest.Builder> describeLoggingOptionsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return describeLoggingOptions(DescribeLoggingOptionsRequest.builder().applyMutation(describeLoggingOptionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a portal.
     * </p>
     *
     * @param describePortalRequest
     * @return Result of the DescribePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePortalResponse describePortal(DescribePortalRequest describePortalRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePortalRequest.Builder} avoiding the need to
     * create one manually via {@link DescribePortalRequest#builder()}
     * </p>
     *
     * @param describePortalRequest
     *        A {@link Consumer} that will call methods on {@link DescribePortalRequest.Builder} to create a request.
     * @return Result of the DescribePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePortalResponse describePortal(Consumer<DescribePortalRequest.Builder> describePortalRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return describePortal(DescribePortalRequest.builder().applyMutation(describePortalRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a project.
     * </p>
     *
     * @param describeProjectRequest
     * @return Result of the DescribeProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeProject" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProjectResponse describeProject(DescribeProjectRequest describeProjectRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProjectRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProjectRequest#builder()}
     * </p>
     *
     * @param describeProjectRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProjectRequest.Builder} to create a request.
     * @return Result of the DescribeProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeProject" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProjectResponse describeProject(Consumer<DescribeProjectRequest.Builder> describeProjectRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return describeProject(DescribeProjectRequest.builder().applyMutation(describeProjectRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the storage configuration for IoT SiteWise.
     * </p>
     *
     * @param describeStorageConfigurationRequest
     * @return Result of the DescribeStorageConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStorageConfigurationResponse describeStorageConfiguration(
            DescribeStorageConfigurationRequest describeStorageConfigurationRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, LimitExceededException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the storage configuration for IoT SiteWise.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStorageConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStorageConfigurationRequest#builder()}
     * </p>
     *
     * @param describeStorageConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStorageConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeStorageConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStorageConfigurationResponse describeStorageConfiguration(
            Consumer<DescribeStorageConfigurationRequest.Builder> describeStorageConfigurationRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return describeStorageConfiguration(DescribeStorageConfigurationRequest.builder()
                .applyMutation(describeStorageConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a time series (data stream).
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     *
     * @param describeTimeSeriesRequest
     * @return Result of the DescribeTimeSeries operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTimeSeriesResponse describeTimeSeries(DescribeTimeSeriesRequest describeTimeSeriesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a time series (data stream).
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTimeSeriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTimeSeriesRequest#builder()}
     * </p>
     *
     * @param describeTimeSeriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTimeSeriesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTimeSeries operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DescribeTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTimeSeriesResponse describeTimeSeries(Consumer<DescribeTimeSeriesRequest.Builder> describeTimeSeriesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return describeTimeSeries(DescribeTimeSeriesRequest.builder().applyMutation(describeTimeSeriesRequest).build());
    }

    /**
     * <p>
     * Disassociates a child asset from the given parent asset through a hierarchy defined in the parent asset's model.
     * </p>
     *
     * @param disassociateAssetsRequest
     * @return Result of the DisassociateAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DisassociateAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAssetsResponse disassociateAssets(DisassociateAssetsRequest disassociateAssetsRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a child asset from the given parent asset through a hierarchy defined in the parent asset's model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateAssetsRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateAssetsRequest#builder()}
     * </p>
     *
     * @param disassociateAssetsRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateAssetsRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DisassociateAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAssetsResponse disassociateAssets(Consumer<DisassociateAssetsRequest.Builder> disassociateAssetsRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return disassociateAssets(DisassociateAssetsRequest.builder().applyMutation(disassociateAssetsRequest).build());
    }

    /**
     * <p>
     * Disassociates a time series (data stream) from an asset property.
     * </p>
     *
     * @param disassociateTimeSeriesFromAssetPropertyRequest
     * @return Result of the DisassociateTimeSeriesFromAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DisassociateTimeSeriesFromAssetProperty
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateTimeSeriesFromAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTimeSeriesFromAssetPropertyResponse disassociateTimeSeriesFromAssetProperty(
            DisassociateTimeSeriesFromAssetPropertyRequest disassociateTimeSeriesFromAssetPropertyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a time series (data stream) from an asset property.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateTimeSeriesFromAssetPropertyRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateTimeSeriesFromAssetPropertyRequest#builder()}
     * </p>
     *
     * @param disassociateTimeSeriesFromAssetPropertyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateTimeSeriesFromAssetPropertyRequest.Builder} to create a request.
     * @return Result of the DisassociateTimeSeriesFromAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.DisassociateTimeSeriesFromAssetProperty
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateTimeSeriesFromAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTimeSeriesFromAssetPropertyResponse disassociateTimeSeriesFromAssetProperty(
            Consumer<DisassociateTimeSeriesFromAssetPropertyRequest.Builder> disassociateTimeSeriesFromAssetPropertyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return disassociateTimeSeriesFromAssetProperty(DisassociateTimeSeriesFromAssetPropertyRequest.builder()
                .applyMutation(disassociateTimeSeriesFromAssetPropertyRequest).build());
    }

    /**
     * <p>
     * Gets aggregated values for an asset property. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetPropertyAggregatesRequest
     * @return Result of the GetAssetPropertyAggregates operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyAggregatesResponse getAssetPropertyAggregates(
            GetAssetPropertyAggregatesRequest getAssetPropertyAggregatesRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets aggregated values for an asset property. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetPropertyAggregatesRequest.Builder} avoiding
     * the need to create one manually via {@link GetAssetPropertyAggregatesRequest#builder()}
     * </p>
     *
     * @param getAssetPropertyAggregatesRequest
     *        A {@link Consumer} that will call methods on {@link GetAssetPropertyAggregatesRequest.Builder} to create a
     *        request.
     * @return Result of the GetAssetPropertyAggregates operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyAggregatesResponse getAssetPropertyAggregates(
            Consumer<GetAssetPropertyAggregatesRequest.Builder> getAssetPropertyAggregatesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return getAssetPropertyAggregates(GetAssetPropertyAggregatesRequest.builder()
                .applyMutation(getAssetPropertyAggregatesRequest).build());
    }

    /**
     * <p>
     * Gets aggregated values for an asset property. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyAggregatesIterable responses = client.getAssetPropertyAggregatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyAggregatesIterable responses = client
     *             .getAssetPropertyAggregatesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyAggregatesIterable responses = client.getAssetPropertyAggregatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAssetPropertyAggregatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyAggregatesIterable getAssetPropertyAggregatesPaginator(
            GetAssetPropertyAggregatesRequest getAssetPropertyAggregatesRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets aggregated values for an asset property. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyAggregatesIterable responses = client.getAssetPropertyAggregatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyAggregatesIterable responses = client
     *             .getAssetPropertyAggregatesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyAggregatesIterable responses = client.getAssetPropertyAggregatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetPropertyAggregatesRequest.Builder} avoiding
     * the need to create one manually via {@link GetAssetPropertyAggregatesRequest#builder()}
     * </p>
     *
     * @param getAssetPropertyAggregatesRequest
     *        A {@link Consumer} that will call methods on {@link GetAssetPropertyAggregatesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyAggregatesIterable getAssetPropertyAggregatesPaginator(
            Consumer<GetAssetPropertyAggregatesRequest.Builder> getAssetPropertyAggregatesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return getAssetPropertyAggregatesPaginator(GetAssetPropertyAggregatesRequest.builder()
                .applyMutation(getAssetPropertyAggregatesRequest).build());
    }

    /**
     * <p>
     * Gets an asset property's current value. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetPropertyValueRequest
     * @return Result of the GetAssetPropertyValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyValueResponse getAssetPropertyValue(GetAssetPropertyValueRequest getAssetPropertyValueRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an asset property's current value. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetPropertyValueRequest.Builder} avoiding the
     * need to create one manually via {@link GetAssetPropertyValueRequest#builder()}
     * </p>
     *
     * @param getAssetPropertyValueRequest
     *        A {@link Consumer} that will call methods on {@link GetAssetPropertyValueRequest.Builder} to create a
     *        request.
     * @return Result of the GetAssetPropertyValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyValueResponse getAssetPropertyValue(
            Consumer<GetAssetPropertyValueRequest.Builder> getAssetPropertyValueRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return getAssetPropertyValue(GetAssetPropertyValueRequest.builder().applyMutation(getAssetPropertyValueRequest).build());
    }

    /**
     * <p>
     * Gets the history of an asset property's values. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetPropertyValueHistoryRequest
     * @return Result of the GetAssetPropertyValueHistory operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyValueHistoryResponse getAssetPropertyValueHistory(
            GetAssetPropertyValueHistoryRequest getAssetPropertyValueHistoryRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the history of an asset property's values. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetPropertyValueHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link GetAssetPropertyValueHistoryRequest#builder()}
     * </p>
     *
     * @param getAssetPropertyValueHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetAssetPropertyValueHistoryRequest.Builder} to create
     *        a request.
     * @return Result of the GetAssetPropertyValueHistory operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyValueHistoryResponse getAssetPropertyValueHistory(
            Consumer<GetAssetPropertyValueHistoryRequest.Builder> getAssetPropertyValueHistoryRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return getAssetPropertyValueHistory(GetAssetPropertyValueHistoryRequest.builder()
                .applyMutation(getAssetPropertyValueHistoryRequest).build());
    }

    /**
     * <p>
     * Gets the history of an asset property's values. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyValueHistoryIterable responses = client.getAssetPropertyValueHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyValueHistoryIterable responses = client
     *             .getAssetPropertyValueHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyValueHistoryIterable responses = client.getAssetPropertyValueHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAssetPropertyValueHistoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyValueHistoryIterable getAssetPropertyValueHistoryPaginator(
            GetAssetPropertyValueHistoryRequest getAssetPropertyValueHistoryRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the history of an asset property's values. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyValueHistoryIterable responses = client.getAssetPropertyValueHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyValueHistoryIterable responses = client
     *             .getAssetPropertyValueHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyValueHistoryIterable responses = client.getAssetPropertyValueHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetPropertyValueHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link GetAssetPropertyValueHistoryRequest#builder()}
     * </p>
     *
     * @param getAssetPropertyValueHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetAssetPropertyValueHistoryRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyValueHistoryIterable getAssetPropertyValueHistoryPaginator(
            Consumer<GetAssetPropertyValueHistoryRequest.Builder> getAssetPropertyValueHistoryRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return getAssetPropertyValueHistoryPaginator(GetAssetPropertyValueHistoryRequest.builder()
                .applyMutation(getAssetPropertyValueHistoryRequest).build());
    }

    /**
     * <p>
     * Get interpolated values for an asset property for a specified time interval, during a period of time. If your
     * time series is missing data points during the specified time interval, you can use interpolation to estimate the
     * missing data.
     * </p>
     * <p>
     * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24
     * hours over a duration of 7 days.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getInterpolatedAssetPropertyValuesRequest
     * @return Result of the GetInterpolatedAssetPropertyValues operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetInterpolatedAssetPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetInterpolatedAssetPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInterpolatedAssetPropertyValuesResponse getInterpolatedAssetPropertyValues(
            GetInterpolatedAssetPropertyValuesRequest getInterpolatedAssetPropertyValuesRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get interpolated values for an asset property for a specified time interval, during a period of time. If your
     * time series is missing data points during the specified time interval, you can use interpolation to estimate the
     * missing data.
     * </p>
     * <p>
     * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24
     * hours over a duration of 7 days.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInterpolatedAssetPropertyValuesRequest.Builder}
     * avoiding the need to create one manually via {@link GetInterpolatedAssetPropertyValuesRequest#builder()}
     * </p>
     *
     * @param getInterpolatedAssetPropertyValuesRequest
     *        A {@link Consumer} that will call methods on {@link GetInterpolatedAssetPropertyValuesRequest.Builder} to
     *        create a request.
     * @return Result of the GetInterpolatedAssetPropertyValues operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetInterpolatedAssetPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetInterpolatedAssetPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInterpolatedAssetPropertyValuesResponse getInterpolatedAssetPropertyValues(
            Consumer<GetInterpolatedAssetPropertyValuesRequest.Builder> getInterpolatedAssetPropertyValuesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return getInterpolatedAssetPropertyValues(GetInterpolatedAssetPropertyValuesRequest.builder()
                .applyMutation(getInterpolatedAssetPropertyValuesRequest).build());
    }

    /**
     * <p>
     * Get interpolated values for an asset property for a specified time interval, during a period of time. If your
     * time series is missing data points during the specified time interval, you can use interpolation to estimate the
     * missing data.
     * </p>
     * <p>
     * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24
     * hours over a duration of 7 days.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInterpolatedAssetPropertyValues(software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetInterpolatedAssetPropertyValuesIterable responses = client.getInterpolatedAssetPropertyValuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.GetInterpolatedAssetPropertyValuesIterable responses = client
     *             .getInterpolatedAssetPropertyValuesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetInterpolatedAssetPropertyValuesIterable responses = client.getInterpolatedAssetPropertyValuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInterpolatedAssetPropertyValues(software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getInterpolatedAssetPropertyValuesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetInterpolatedAssetPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetInterpolatedAssetPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInterpolatedAssetPropertyValuesIterable getInterpolatedAssetPropertyValuesPaginator(
            GetInterpolatedAssetPropertyValuesRequest getInterpolatedAssetPropertyValuesRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get interpolated values for an asset property for a specified time interval, during a period of time. If your
     * time series is missing data points during the specified time interval, you can use interpolation to estimate the
     * missing data.
     * </p>
     * <p>
     * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24
     * hours over a duration of 7 days.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInterpolatedAssetPropertyValues(software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetInterpolatedAssetPropertyValuesIterable responses = client.getInterpolatedAssetPropertyValuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.GetInterpolatedAssetPropertyValuesIterable responses = client
     *             .getInterpolatedAssetPropertyValuesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetInterpolatedAssetPropertyValuesIterable responses = client.getInterpolatedAssetPropertyValuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInterpolatedAssetPropertyValues(software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInterpolatedAssetPropertyValuesRequest.Builder}
     * avoiding the need to create one manually via {@link GetInterpolatedAssetPropertyValuesRequest#builder()}
     * </p>
     *
     * @param getInterpolatedAssetPropertyValuesRequest
     *        A {@link Consumer} that will call methods on {@link GetInterpolatedAssetPropertyValuesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.GetInterpolatedAssetPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetInterpolatedAssetPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInterpolatedAssetPropertyValuesIterable getInterpolatedAssetPropertyValuesPaginator(
            Consumer<GetInterpolatedAssetPropertyValuesRequest.Builder> getInterpolatedAssetPropertyValuesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return getInterpolatedAssetPropertyValuesPaginator(GetInterpolatedAssetPropertyValuesRequest.builder()
                .applyMutation(getInterpolatedAssetPropertyValuesRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of access policies for an identity (an IAM Identity Center user, an IAM Identity
     * Center group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
     * </p>
     *
     * @param listAccessPoliciesRequest
     * @return Result of the ListAccessPolicies operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPoliciesResponse listAccessPolicies(ListAccessPoliciesRequest listAccessPoliciesRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of access policies for an identity (an IAM Identity Center user, an IAM Identity
     * Center group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccessPoliciesRequest#builder()}
     * </p>
     *
     * @param listAccessPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListAccessPoliciesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAccessPolicies operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPoliciesResponse listAccessPolicies(Consumer<ListAccessPoliciesRequest.Builder> listAccessPoliciesRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return listAccessPolicies(ListAccessPoliciesRequest.builder().applyMutation(listAccessPoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of access policies for an identity (an IAM Identity Center user, an IAM Identity
     * Center group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccessPolicies(software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAccessPoliciesIterable responses = client.listAccessPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAccessPoliciesIterable responses = client
     *             .listAccessPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAccessPoliciesIterable responses = client.listAccessPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessPolicies(software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPoliciesIterable listAccessPoliciesPaginator(ListAccessPoliciesRequest listAccessPoliciesRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of access policies for an identity (an IAM Identity Center user, an IAM Identity
     * Center group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccessPolicies(software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAccessPoliciesIterable responses = client.listAccessPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAccessPoliciesIterable responses = client
     *             .listAccessPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAccessPoliciesIterable responses = client.listAccessPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessPolicies(software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccessPoliciesRequest#builder()}
     * </p>
     *
     * @param listAccessPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListAccessPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPoliciesIterable listAccessPoliciesPaginator(
            Consumer<ListAccessPoliciesRequest.Builder> listAccessPoliciesRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return listAccessPoliciesPaginator(ListAccessPoliciesRequest.builder().applyMutation(listAccessPoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset model. If you update properties associated with
     * the model before you finish listing all the properties, you need to start all over again.
     * </p>
     *
     * @param listAssetModelPropertiesRequest
     * @return Result of the ListAssetModelProperties operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetModelProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetModelPropertiesResponse listAssetModelProperties(
            ListAssetModelPropertiesRequest listAssetModelPropertiesRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset model. If you update properties associated with
     * the model before you finish listing all the properties, you need to start all over again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetModelPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssetModelPropertiesRequest#builder()}
     * </p>
     *
     * @param listAssetModelPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link ListAssetModelPropertiesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssetModelProperties operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetModelProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetModelPropertiesResponse listAssetModelProperties(
            Consumer<ListAssetModelPropertiesRequest.Builder> listAssetModelPropertiesRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return listAssetModelProperties(ListAssetModelPropertiesRequest.builder().applyMutation(listAssetModelPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset model. If you update properties associated with
     * the model before you finish listing all the properties, you need to start all over again.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssetModelProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelPropertiesIterable responses = client.listAssetModelPropertiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelPropertiesIterable responses = client
     *             .listAssetModelPropertiesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelPropertiesIterable responses = client.listAssetModelPropertiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetModelProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssetModelPropertiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetModelProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetModelPropertiesIterable listAssetModelPropertiesPaginator(
            ListAssetModelPropertiesRequest listAssetModelPropertiesRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset model. If you update properties associated with
     * the model before you finish listing all the properties, you need to start all over again.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssetModelProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelPropertiesIterable responses = client.listAssetModelPropertiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelPropertiesIterable responses = client
     *             .listAssetModelPropertiesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelPropertiesIterable responses = client.listAssetModelPropertiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetModelProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetModelPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssetModelPropertiesRequest#builder()}
     * </p>
     *
     * @param listAssetModelPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link ListAssetModelPropertiesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetModelProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetModelPropertiesIterable listAssetModelPropertiesPaginator(
            Consumer<ListAssetModelPropertiesRequest.Builder> listAssetModelPropertiesRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return listAssetModelPropertiesPaginator(ListAssetModelPropertiesRequest.builder()
                .applyMutation(listAssetModelPropertiesRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of summaries of all asset models.
     * </p>
     *
     * @param listAssetModelsRequest
     * @return Result of the ListAssetModels operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetModelsResponse listAssetModels(ListAssetModelsRequest listAssetModelsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of summaries of all asset models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetModelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssetModelsRequest#builder()}
     * </p>
     *
     * @param listAssetModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssetModelsRequest.Builder} to create a request.
     * @return Result of the ListAssetModels operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetModelsResponse listAssetModels(Consumer<ListAssetModelsRequest.Builder> listAssetModelsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return listAssetModels(ListAssetModelsRequest.builder().applyMutation(listAssetModelsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of summaries of all asset models.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssetModels(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelsIterable responses = client.listAssetModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelsIterable responses = client
     *             .listAssetModelsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelsIterable responses = client.listAssetModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetModels(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest)} operation.</b>
     * </p>
     *
     * @param listAssetModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetModelsIterable listAssetModelsPaginator(ListAssetModelsRequest listAssetModelsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of summaries of all asset models.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssetModels(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelsIterable responses = client.listAssetModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelsIterable responses = client
     *             .listAssetModelsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelsIterable responses = client.listAssetModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetModels(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetModelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssetModelsRequest#builder()}
     * </p>
     *
     * @param listAssetModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssetModelsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetModelsIterable listAssetModelsPaginator(Consumer<ListAssetModelsRequest.Builder> listAssetModelsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return listAssetModelsPaginator(ListAssetModelsRequest.builder().applyMutation(listAssetModelsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset. If you update properties associated with the
     * model before you finish listing all the properties, you need to start all over again.
     * </p>
     *
     * @param listAssetPropertiesRequest
     * @return Result of the ListAssetProperties operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetPropertiesResponse listAssetProperties(ListAssetPropertiesRequest listAssetPropertiesRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset. If you update properties associated with the
     * model before you finish listing all the properties, you need to start all over again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetPropertiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetPropertiesRequest#builder()}
     * </p>
     *
     * @param listAssetPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link ListAssetPropertiesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssetProperties operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetPropertiesResponse listAssetProperties(
            Consumer<ListAssetPropertiesRequest.Builder> listAssetPropertiesRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return listAssetProperties(ListAssetPropertiesRequest.builder().applyMutation(listAssetPropertiesRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset. If you update properties associated with the
     * model before you finish listing all the properties, you need to start all over again.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssetProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetPropertiesIterable responses = client.listAssetPropertiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAssetPropertiesIterable responses = client
     *             .listAssetPropertiesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetPropertiesIterable responses = client.listAssetPropertiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssetPropertiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetPropertiesIterable listAssetPropertiesPaginator(ListAssetPropertiesRequest listAssetPropertiesRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset. If you update properties associated with the
     * model before you finish listing all the properties, you need to start all over again.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssetProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetPropertiesIterable responses = client.listAssetPropertiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAssetPropertiesIterable responses = client
     *             .listAssetPropertiesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetPropertiesIterable responses = client.listAssetPropertiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetPropertiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetPropertiesRequest#builder()}
     * </p>
     *
     * @param listAssetPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link ListAssetPropertiesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetPropertiesIterable listAssetPropertiesPaginator(
            Consumer<ListAssetPropertiesRequest.Builder> listAssetPropertiesRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return listAssetPropertiesPaginator(ListAssetPropertiesRequest.builder().applyMutation(listAssetPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a paginated list of asset relationships for an asset. You can use this operation to identify an asset's
     * root asset and all associated assets between that asset and its root.
     * </p>
     *
     * @param listAssetRelationshipsRequest
     * @return Result of the ListAssetRelationships operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetRelationshipsResponse listAssetRelationships(ListAssetRelationshipsRequest listAssetRelationshipsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of asset relationships for an asset. You can use this operation to identify an asset's
     * root asset and all associated assets between that asset and its root.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetRelationshipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetRelationshipsRequest#builder()}
     * </p>
     *
     * @param listAssetRelationshipsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssetRelationshipsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssetRelationships operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetRelationshipsResponse listAssetRelationships(
            Consumer<ListAssetRelationshipsRequest.Builder> listAssetRelationshipsRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return listAssetRelationships(ListAssetRelationshipsRequest.builder().applyMutation(listAssetRelationshipsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a paginated list of asset relationships for an asset. You can use this operation to identify an asset's
     * root asset and all associated assets between that asset and its root.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssetRelationships(software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetRelationshipsIterable responses = client.listAssetRelationshipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAssetRelationshipsIterable responses = client
     *             .listAssetRelationshipsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetRelationshipsIterable responses = client.listAssetRelationshipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetRelationships(software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssetRelationshipsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetRelationshipsIterable listAssetRelationshipsPaginator(
            ListAssetRelationshipsRequest listAssetRelationshipsRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of asset relationships for an asset. You can use this operation to identify an asset's
     * root asset and all associated assets between that asset and its root.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssetRelationships(software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetRelationshipsIterable responses = client.listAssetRelationshipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAssetRelationshipsIterable responses = client
     *             .listAssetRelationshipsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetRelationshipsIterable responses = client.listAssetRelationshipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetRelationships(software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetRelationshipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetRelationshipsRequest#builder()}
     * </p>
     *
     * @param listAssetRelationshipsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssetRelationshipsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssetRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetRelationshipsIterable listAssetRelationshipsPaginator(
            Consumer<ListAssetRelationshipsRequest.Builder> listAssetRelationshipsRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return listAssetRelationshipsPaginator(ListAssetRelationshipsRequest.builder()
                .applyMutation(listAssetRelationshipsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of asset summaries.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List assets based on a specific asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * List top-level assets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't use this operation to list all assets. To retrieve summaries for all of your assets, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels</a>
     * to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.
     * </p>
     *
     * @param listAssetsRequest
     * @return Result of the ListAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetsResponse listAssets(ListAssetsRequest listAssetsRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of asset summaries.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List assets based on a specific asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * List top-level assets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't use this operation to list all assets. To retrieve summaries for all of your assets, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels</a>
     * to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssetsRequest#builder()}
     * </p>
     *
     * @param listAssetsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssetsRequest.Builder} to create a request.
     * @return Result of the ListAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetsResponse listAssets(Consumer<ListAssetsRequest.Builder> listAssetsRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return listAssets(ListAssetsRequest.builder().applyMutation(listAssetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of asset summaries.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List assets based on a specific asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * List top-level assets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't use this operation to list all assets. To retrieve summaries for all of your assets, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels</a>
     * to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetsIterable responses = client.listAssetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAssetsIterable responses = client.listAssetsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetsIterable responses = client.listAssetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest)} operation.</b>
     * </p>
     *
     * @param listAssetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetsIterable listAssetsPaginator(ListAssetsRequest listAssetsRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of asset summaries.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List assets based on a specific asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * List top-level assets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't use this operation to list all assets. To retrieve summaries for all of your assets, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels</a>
     * to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetsIterable responses = client.listAssetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAssetsIterable responses = client.listAssetsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetsIterable responses = client.listAssetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssetsRequest#builder()}
     * </p>
     *
     * @param listAssetsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetsIterable listAssetsPaginator(Consumer<ListAssetsRequest.Builder> listAssetsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return listAssetsPaginator(ListAssetsRequest.builder().applyMutation(listAssetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of associated assets.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List child assets associated to a parent asset by a hierarchy that you specify.
     * </p>
     * </li>
     * <li>
     * <p>
     * List an asset's parent asset.
     * </p>
     * </li>
     * </ul>
     *
     * @param listAssociatedAssetsRequest
     * @return Result of the ListAssociatedAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssociatedAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedAssetsResponse listAssociatedAssets(ListAssociatedAssetsRequest listAssociatedAssetsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of associated assets.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List child assets associated to a parent asset by a hierarchy that you specify.
     * </p>
     * </li>
     * <li>
     * <p>
     * List an asset's parent asset.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedAssetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssociatedAssetsRequest#builder()}
     * </p>
     *
     * @param listAssociatedAssetsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedAssetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssociatedAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssociatedAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedAssetsResponse listAssociatedAssets(
            Consumer<ListAssociatedAssetsRequest.Builder> listAssociatedAssetsRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return listAssociatedAssets(ListAssociatedAssetsRequest.builder().applyMutation(listAssociatedAssetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of associated assets.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List child assets associated to a parent asset by a hierarchy that you specify.
     * </p>
     * </li>
     * <li>
     * <p>
     * List an asset's parent asset.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssociatedAssetsIterable responses = client.listAssociatedAssetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAssociatedAssetsIterable responses = client
     *             .listAssociatedAssetsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssociatedAssetsIterable responses = client.listAssociatedAssetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssociatedAssetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssociatedAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedAssetsIterable listAssociatedAssetsPaginator(ListAssociatedAssetsRequest listAssociatedAssetsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of associated assets.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List child assets associated to a parent asset by a hierarchy that you specify.
     * </p>
     * </li>
     * <li>
     * <p>
     * List an asset's parent asset.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssociatedAssetsIterable responses = client.listAssociatedAssetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListAssociatedAssetsIterable responses = client
     *             .listAssociatedAssetsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssociatedAssetsIterable responses = client.listAssociatedAssetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedAssetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssociatedAssetsRequest#builder()}
     * </p>
     *
     * @param listAssociatedAssetsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedAssetsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListAssociatedAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedAssetsIterable listAssociatedAssetsPaginator(
            Consumer<ListAssociatedAssetsRequest.Builder> listAssociatedAssetsRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return listAssociatedAssetsPaginator(ListAssociatedAssetsRequest.builder().applyMutation(listAssociatedAssetsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a paginated list of bulk import job requests. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ListBulkImportJobs.html">List bulk import jobs
     * (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param listBulkImportJobsRequest
     * @return Result of the ListBulkImportJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListBulkImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListBulkImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBulkImportJobsResponse listBulkImportJobs(ListBulkImportJobsRequest listBulkImportJobsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of bulk import job requests. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ListBulkImportJobs.html">List bulk import jobs
     * (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBulkImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBulkImportJobsRequest#builder()}
     * </p>
     *
     * @param listBulkImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListBulkImportJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListBulkImportJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListBulkImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListBulkImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBulkImportJobsResponse listBulkImportJobs(Consumer<ListBulkImportJobsRequest.Builder> listBulkImportJobsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return listBulkImportJobs(ListBulkImportJobsRequest.builder().applyMutation(listBulkImportJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of bulk import job requests. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ListBulkImportJobs.html">List bulk import jobs
     * (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBulkImportJobs(software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListBulkImportJobsIterable responses = client.listBulkImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListBulkImportJobsIterable responses = client
     *             .listBulkImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListBulkImportJobsIterable responses = client.listBulkImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBulkImportJobs(software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBulkImportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListBulkImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListBulkImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBulkImportJobsIterable listBulkImportJobsPaginator(ListBulkImportJobsRequest listBulkImportJobsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of bulk import job requests. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ListBulkImportJobs.html">List bulk import jobs
     * (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBulkImportJobs(software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListBulkImportJobsIterable responses = client.listBulkImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListBulkImportJobsIterable responses = client
     *             .listBulkImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListBulkImportJobsIterable responses = client.listBulkImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBulkImportJobs(software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBulkImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBulkImportJobsRequest#builder()}
     * </p>
     *
     * @param listBulkImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListBulkImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListBulkImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListBulkImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBulkImportJobsIterable listBulkImportJobsPaginator(
            Consumer<ListBulkImportJobsRequest.Builder> listBulkImportJobsRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return listBulkImportJobsPaginator(ListBulkImportJobsRequest.builder().applyMutation(listBulkImportJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
     * </p>
     *
     * @param listDashboardsRequest
     * @return Result of the ListDashboards operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDashboardsResponse listDashboards(ListDashboardsRequest listDashboardsRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDashboardsRequest#builder()}
     * </p>
     *
     * @param listDashboardsRequest
     *        A {@link Consumer} that will call methods on {@link ListDashboardsRequest.Builder} to create a request.
     * @return Result of the ListDashboards operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDashboardsResponse listDashboards(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return listDashboards(ListDashboardsRequest.builder().applyMutation(listDashboardsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboards(software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListDashboardsIterable responses = client.listDashboardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListDashboardsIterable responses = client
     *             .listDashboardsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListDashboardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListDashboardsIterable responses = client.listDashboardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboards(software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest)} operation.</b>
     * </p>
     *
     * @param listDashboardsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDashboardsIterable listDashboardsPaginator(ListDashboardsRequest listDashboardsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboards(software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListDashboardsIterable responses = client.listDashboardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListDashboardsIterable responses = client
     *             .listDashboardsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListDashboardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListDashboardsIterable responses = client.listDashboardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboards(software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDashboardsRequest#builder()}
     * </p>
     *
     * @param listDashboardsRequest
     *        A {@link Consumer} that will call methods on {@link ListDashboardsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDashboardsIterable listDashboardsPaginator(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return listDashboardsPaginator(ListDashboardsRequest.builder().applyMutation(listDashboardsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of gateways.
     * </p>
     *
     * @param listGatewaysRequest
     * @return Result of the ListGateways operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewaysResponse listGateways(ListGatewaysRequest listGatewaysRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewaysRequest.Builder} to create a request.
     * @return Result of the ListGateways operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewaysResponse listGateways(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return listGateways(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGateways(software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest)} operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewaysIterable listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGateways(software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewaysRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewaysIterable listGatewaysPaginator(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return listGatewaysPaginator(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of IoT SiteWise Monitor portals.
     * </p>
     *
     * @param listPortalsRequest
     * @return Result of the ListPortals operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPortalsResponse listPortals(ListPortalsRequest listPortalsRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of IoT SiteWise Monitor portals.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPortalsRequest#builder()}
     * </p>
     *
     * @param listPortalsRequest
     *        A {@link Consumer} that will call methods on {@link ListPortalsRequest.Builder} to create a request.
     * @return Result of the ListPortals operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPortalsResponse listPortals(Consumer<ListPortalsRequest.Builder> listPortalsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return listPortals(ListPortalsRequest.builder().applyMutation(listPortalsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of IoT SiteWise Monitor portals.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPortals(software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortals(software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest)} operation.</b>
     * </p>
     *
     * @param listPortalsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPortalsIterable listPortalsPaginator(ListPortalsRequest listPortalsRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of IoT SiteWise Monitor portals.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPortals(software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortals(software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPortalsRequest#builder()}
     * </p>
     *
     * @param listPortalsRequest
     *        A {@link Consumer} that will call methods on {@link ListPortalsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPortalsIterable listPortalsPaginator(Consumer<ListPortalsRequest.Builder> listPortalsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return listPortalsPaginator(ListPortalsRequest.builder().applyMutation(listPortalsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
     * </p>
     *
     * @param listProjectAssetsRequest
     * @return Result of the ListProjectAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectAssetsResponse listProjectAssets(ListProjectAssetsRequest listProjectAssetsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectAssetsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProjectAssetsRequest#builder()}
     * </p>
     *
     * @param listProjectAssetsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectAssetsRequest.Builder} to create a request.
     * @return Result of the ListProjectAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectAssetsResponse listProjectAssets(Consumer<ListProjectAssetsRequest.Builder> listProjectAssetsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return listProjectAssets(ListProjectAssetsRequest.builder().applyMutation(listProjectAssetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProjectAssets(software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectAssetsIterable responses = client.listProjectAssetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListProjectAssetsIterable responses = client
     *             .listProjectAssetsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectAssetsIterable responses = client.listProjectAssetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectAssets(software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProjectAssetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectAssetsIterable listProjectAssetsPaginator(ListProjectAssetsRequest listProjectAssetsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProjectAssets(software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectAssetsIterable responses = client.listProjectAssetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListProjectAssetsIterable responses = client
     *             .listProjectAssetsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectAssetsIterable responses = client.listProjectAssetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectAssets(software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectAssetsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProjectAssetsRequest#builder()}
     * </p>
     *
     * @param listProjectAssetsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectAssetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectAssetsIterable listProjectAssetsPaginator(
            Consumer<ListProjectAssetsRequest.Builder> listProjectAssetsRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return listProjectAssetsPaginator(ListProjectAssetsRequest.builder().applyMutation(listProjectAssetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
     * </p>
     *
     * @param listProjectsRequest
     * @return Result of the ListProjects operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     * @return Result of the ListProjects operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of tags for an IoT SiteWise resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws UnauthorizedException
     *         You are not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, ResourceNotFoundException,
            ConflictingOperationException, LimitExceededException, UnauthorizedException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of tags for an IoT SiteWise resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws UnauthorizedException
     *         You are not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ResourceNotFoundException, ConflictingOperationException,
            LimitExceededException, UnauthorizedException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of time series (data streams).
     * </p>
     *
     * @param listTimeSeriesRequest
     * @return Result of the ListTimeSeries operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTimeSeriesResponse listTimeSeries(ListTimeSeriesRequest listTimeSeriesRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of time series (data streams).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTimeSeriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTimeSeriesRequest#builder()}
     * </p>
     *
     * @param listTimeSeriesRequest
     *        A {@link Consumer} that will call methods on {@link ListTimeSeriesRequest.Builder} to create a request.
     * @return Result of the ListTimeSeries operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTimeSeriesResponse listTimeSeries(Consumer<ListTimeSeriesRequest.Builder> listTimeSeriesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return listTimeSeries(ListTimeSeriesRequest.builder().applyMutation(listTimeSeriesRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of time series (data streams).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTimeSeries(software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListTimeSeriesIterable responses = client.listTimeSeriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListTimeSeriesIterable responses = client
     *             .listTimeSeriesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListTimeSeriesIterable responses = client.listTimeSeriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTimeSeries(software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest)} operation.</b>
     * </p>
     *
     * @param listTimeSeriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTimeSeriesIterable listTimeSeriesPaginator(ListTimeSeriesRequest listTimeSeriesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of time series (data streams).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTimeSeries(software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListTimeSeriesIterable responses = client.listTimeSeriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsitewise.paginators.ListTimeSeriesIterable responses = client
     *             .listTimeSeriesPaginator(request);
     *     for (software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListTimeSeriesIterable responses = client.listTimeSeriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTimeSeries(software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTimeSeriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTimeSeriesRequest#builder()}
     * </p>
     *
     * @param listTimeSeriesRequest
     *        A {@link Consumer} that will call methods on {@link ListTimeSeriesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.ListTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTimeSeriesIterable listTimeSeriesPaginator(Consumer<ListTimeSeriesRequest.Builder> listTimeSeriesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return listTimeSeriesPaginator(ListTimeSeriesRequest.builder().applyMutation(listTimeSeriesRequest).build());
    }

    /**
     * <p>
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param putDefaultEncryptionConfigurationRequest
     * @return Result of the PutDefaultEncryptionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.PutDefaultEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDefaultEncryptionConfigurationResponse putDefaultEncryptionConfiguration(
            PutDefaultEncryptionConfigurationRequest putDefaultEncryptionConfigurationRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, LimitExceededException, ConflictingOperationException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDefaultEncryptionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutDefaultEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param putDefaultEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutDefaultEncryptionConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the PutDefaultEncryptionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.PutDefaultEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDefaultEncryptionConfigurationResponse putDefaultEncryptionConfiguration(
            Consumer<PutDefaultEncryptionConfigurationRequest.Builder> putDefaultEncryptionConfigurationRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, LimitExceededException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return putDefaultEncryptionConfiguration(PutDefaultEncryptionConfigurationRequest.builder()
                .applyMutation(putDefaultEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Sets logging options for IoT SiteWise.
     * </p>
     *
     * @param putLoggingOptionsRequest
     * @return Result of the PutLoggingOptions operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutLoggingOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default PutLoggingOptionsResponse putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ConflictingOperationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets logging options for IoT SiteWise.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLoggingOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link PutLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param putLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link PutLoggingOptionsRequest.Builder} to create a request.
     * @return Result of the PutLoggingOptions operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutLoggingOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default PutLoggingOptionsResponse putLoggingOptions(Consumer<PutLoggingOptionsRequest.Builder> putLoggingOptionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ConflictingOperationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return putLoggingOptions(PutLoggingOptionsRequest.builder().applyMutation(putLoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Configures storage settings for IoT SiteWise.
     * </p>
     *
     * @param putStorageConfigurationRequest
     * @return Result of the PutStorageConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.PutStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutStorageConfigurationResponse putStorageConfiguration(PutStorageConfigurationRequest putStorageConfigurationRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            ThrottlingException, LimitExceededException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures storage settings for IoT SiteWise.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutStorageConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutStorageConfigurationRequest#builder()}
     * </p>
     *
     * @param putStorageConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutStorageConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the PutStorageConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.PutStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutStorageConfigurationResponse putStorageConfiguration(
            Consumer<PutStorageConfigurationRequest.Builder> putStorageConfigurationRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            LimitExceededException, ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return putStorageConfiguration(PutStorageConfigurationRequest.builder().applyMutation(putStorageConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation updates the tag's
     * value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws UnauthorizedException
     *         You are not authorized.
     * @throws TooManyTagsException
     *         You've reached the limit for the number of tags allowed for a resource. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag naming limits
     *         and requirements</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ResourceNotFoundException, ConflictingOperationException,
            LimitExceededException, UnauthorizedException, TooManyTagsException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation updates the tag's
     * value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws UnauthorizedException
     *         You are not authorized.
     * @throws TooManyTagsException
     *         You've reached the limit for the number of tags allowed for a resource. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag naming limits
     *         and requirements</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, ResourceNotFoundException,
            ConflictingOperationException, LimitExceededException, UnauthorizedException, TooManyTagsException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from an IoT SiteWise resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws UnauthorizedException
     *         You are not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, ResourceNotFoundException, ConflictingOperationException,
            LimitExceededException, UnauthorizedException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from an IoT SiteWise resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws UnauthorizedException
     *         You are not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, ResourceNotFoundException,
            ConflictingOperationException, LimitExceededException, UnauthorizedException, AwsServiceException,
            SdkClientException, IoTSiteWiseException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor portal or
     * project resource.
     * </p>
     *
     * @param updateAccessPolicyRequest
     * @return Result of the UpdateAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccessPolicyResponse updateAccessPolicy(UpdateAccessPolicyRequest updateAccessPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor portal or
     * project resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAccessPolicyRequest#builder()}
     * </p>
     *
     * @param updateAccessPolicyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAccessPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccessPolicyResponse updateAccessPolicy(Consumer<UpdateAccessPolicyRequest.Builder> updateAccessPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return updateAccessPolicy(UpdateAccessPolicyRequest.builder().applyMutation(updateAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Updates an asset's name. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param updateAssetRequest
     * @return Result of the UpdateAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAssetResponse updateAsset(UpdateAssetRequest updateAssetRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an asset's name. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAssetRequest#builder()}
     * </p>
     *
     * @param updateAssetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAssetRequest.Builder} to create a request.
     * @return Result of the UpdateAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAssetResponse updateAsset(Consumer<UpdateAssetRequest.Builder> updateAssetRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            ThrottlingException, ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return updateAsset(UpdateAssetRequest.builder().applyMutation(updateAssetRequest).build());
    }

    /**
     * <p>
     * Updates an asset model and all of the assets that were created from the model. Each asset created from the model
     * inherits the updated asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <important>
     * <p>
     * This operation overwrites the existing model with the provided model. To avoid deleting your asset model's
     * properties or hierarchies, you must include their IDs and definitions in the updated asset model payload. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html"
     * >DescribeAssetModel</a>.
     * </p>
     * <p>
     * If you remove a property from an asset model, IoT SiteWise deletes all previous data for that property. If you
     * remove a hierarchy definition from an asset model, IoT SiteWise disassociates every asset associated with that
     * hierarchy. You can't change the type or data type of an existing property.
     * </p>
     * </important>
     *
     * @param updateAssetModelRequest
     * @return Result of the UpdateAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateAssetModelResponse updateAssetModel(UpdateAssetModelRequest updateAssetModelRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            LimitExceededException, ThrottlingException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an asset model and all of the assets that were created from the model. Each asset created from the model
     * inherits the updated asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <important>
     * <p>
     * This operation overwrites the existing model with the provided model. To avoid deleting your asset model's
     * properties or hierarchies, you must include their IDs and definitions in the updated asset model payload. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html"
     * >DescribeAssetModel</a>.
     * </p>
     * <p>
     * If you remove a property from an asset model, IoT SiteWise deletes all previous data for that property. If you
     * remove a hierarchy definition from an asset model, IoT SiteWise disassociates every asset associated with that
     * hierarchy. You can't change the type or data type of an existing property.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssetModelRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAssetModelRequest#builder()}
     * </p>
     *
     * @param updateAssetModelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAssetModelRequest.Builder} to create a request.
     * @return Result of the UpdateAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateAssetModelResponse updateAssetModel(Consumer<UpdateAssetModelRequest.Builder> updateAssetModelRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalFailureException,
            LimitExceededException, ThrottlingException, ConflictingOperationException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        return updateAssetModel(UpdateAssetModelRequest.builder().applyMutation(updateAssetModelRequest).build());
    }

    /**
     * <p>
     * Updates an asset property's alias and notification state.
     * </p>
     * <important>
     * <p>
     * This operation overwrites the property's existing alias and notification state. To keep your existing property's
     * alias or notification state, you must include the existing values in the UpdateAssetProperty request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html"
     * >DescribeAssetProperty</a>.
     * </p>
     * </important>
     *
     * @param updateAssetPropertyRequest
     * @return Result of the UpdateAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssetPropertyResponse updateAssetProperty(UpdateAssetPropertyRequest updateAssetPropertyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an asset property's alias and notification state.
     * </p>
     * <important>
     * <p>
     * This operation overwrites the property's existing alias and notification state. To keep your existing property's
     * alias or notification state, you must include the existing values in the UpdateAssetProperty request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html"
     * >DescribeAssetProperty</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssetPropertyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAssetPropertyRequest#builder()}
     * </p>
     *
     * @param updateAssetPropertyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAssetPropertyRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssetPropertyResponse updateAssetProperty(
            Consumer<UpdateAssetPropertyRequest.Builder> updateAssetPropertyRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ConflictingOperationException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return updateAssetProperty(UpdateAssetPropertyRequest.builder().applyMutation(updateAssetPropertyRequest).build());
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor dashboard.
     * </p>
     *
     * @param updateDashboardRequest
     * @return Result of the UpdateDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDashboardResponse updateDashboard(UpdateDashboardRequest updateDashboardRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor dashboard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDashboardRequest#builder()}
     * </p>
     *
     * @param updateDashboardRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDashboardRequest.Builder} to create a request.
     * @return Result of the UpdateDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDashboardResponse updateDashboard(Consumer<UpdateDashboardRequest.Builder> updateDashboardRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return updateDashboard(UpdateDashboardRequest.builder().applyMutation(updateDashboardRequest).build());
    }

    /**
     * <p>
     * Updates a gateway's name.
     * </p>
     *
     * @param updateGatewayRequest
     * @return Result of the UpdateGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGatewayResponse updateGateway(UpdateGatewayRequest updateGatewayRequest) throws InvalidRequestException,
            ResourceNotFoundException, ConflictingOperationException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a gateway's name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGatewayRequest#builder()}
     * </p>
     *
     * @param updateGatewayRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGatewayRequest.Builder} to create a request.
     * @return Result of the UpdateGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGatewayResponse updateGateway(Consumer<UpdateGatewayRequest.Builder> updateGatewayRequest)
            throws InvalidRequestException, ResourceNotFoundException, ConflictingOperationException, InternalFailureException,
            ThrottlingException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return updateGateway(UpdateGatewayRequest.builder().applyMutation(updateGatewayRequest).build());
    }

    /**
     * <p>
     * Updates a gateway capability configuration or defines a new capability configuration. Each gateway capability
     * defines data sources for a gateway. A capability configuration can contain multiple data source configurations.
     * If you define OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in
     * one capability configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     *
     * @param updateGatewayCapabilityConfigurationRequest
     * @return Result of the UpdateGatewayCapabilityConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateGatewayCapabilityConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayCapabilityConfigurationResponse updateGatewayCapabilityConfiguration(
            UpdateGatewayCapabilityConfigurationRequest updateGatewayCapabilityConfigurationRequest)
            throws InvalidRequestException, ResourceNotFoundException, ConflictingOperationException, InternalFailureException,
            ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a gateway capability configuration or defines a new capability configuration. Each gateway capability
     * defines data sources for a gateway. A capability configuration can contain multiple data source configurations.
     * If you define OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in
     * one capability configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateGatewayCapabilityConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateGatewayCapabilityConfigurationRequest#builder()}
     * </p>
     *
     * @param updateGatewayCapabilityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGatewayCapabilityConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateGatewayCapabilityConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateGatewayCapabilityConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayCapabilityConfigurationResponse updateGatewayCapabilityConfiguration(
            Consumer<UpdateGatewayCapabilityConfigurationRequest.Builder> updateGatewayCapabilityConfigurationRequest)
            throws InvalidRequestException, ResourceNotFoundException, ConflictingOperationException, InternalFailureException,
            ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return updateGatewayCapabilityConfiguration(UpdateGatewayCapabilityConfigurationRequest.builder()
                .applyMutation(updateGatewayCapabilityConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor portal.
     * </p>
     *
     * @param updatePortalRequest
     * @return Result of the UpdatePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePortalResponse updatePortal(UpdatePortalRequest updatePortalRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, ConflictingOperationException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePortalRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePortalRequest#builder()}
     * </p>
     *
     * @param updatePortalRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePortalRequest.Builder} to create a request.
     * @return Result of the UpdatePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePortalResponse updatePortal(Consumer<UpdatePortalRequest.Builder> updatePortalRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            ConflictingOperationException, AwsServiceException, SdkClientException, IoTSiteWiseException {
        return updatePortal(UpdatePortalRequest.builder().applyMutation(updatePortalRequest).build());
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor project.
     * </p>
     *
     * @param updateProjectRequest
     * @return Result of the UpdateProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTSiteWiseException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProjectRequest#builder()}
     * </p>
     *
     * @param updateProjectRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProjectRequest.Builder} to create a request.
     * @return Result of the UpdateProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSiteWiseException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSiteWiseClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProjectResponse updateProject(Consumer<UpdateProjectRequest.Builder> updateProjectRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTSiteWiseException {
        return updateProject(UpdateProjectRequest.builder().applyMutation(updateProjectRequest).build());
    }

    /**
     * Create an instance of {@link IoTSiteWiseWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link IoTSiteWiseWaiter}
     */
    default IoTSiteWiseWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IoTSiteWiseClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IoTSiteWiseClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IoTSiteWiseClient}.
     */
    static IoTSiteWiseClientBuilder builder() {
        return new DefaultIoTSiteWiseClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default IoTSiteWiseServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
