/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.TimeSeriesSummary;

public class ListTimeSeriesPublisher
implements SdkPublisher<ListTimeSeriesResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListTimeSeriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTimeSeriesPublisher(IoTSiteWiseAsyncClient client, ListTimeSeriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTimeSeriesPublisher(IoTSiteWiseAsyncClient client, ListTimeSeriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTimeSeriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTimeSeriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TimeSeriesSummary> timeSeriesSummaries() {
        Function<ListTimeSeriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.timeSeriesSummaries() != null) {
                return response.timeSeriesSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTimeSeriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTimeSeriesResponseFetcher
    implements AsyncPageFetcher<ListTimeSeriesResponse> {
        private ListTimeSeriesResponseFetcher() {
        }

        public boolean hasNextPage(ListTimeSeriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTimeSeriesResponse> nextPage(ListTimeSeriesResponse previousPage) {
            if (previousPage == null) {
                return ListTimeSeriesPublisher.this.client.listTimeSeries(ListTimeSeriesPublisher.this.firstRequest);
            }
            return ListTimeSeriesPublisher.this.client.listTimeSeries((ListTimeSeriesRequest)((Object)ListTimeSeriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

