/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotsitewise.internal.IoTSiteWiseServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.iotsitewise.model.AssociateAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.AssociateAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.AssociateTimeSeriesToAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.AssociateTimeSeriesToAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueResponse;
import software.amazon.awssdk.services.iotsitewise.model.ConflictingOperationException;
import software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreatePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreatePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateProjectResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeletePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeletePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteProjectResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeLoggingOptionsRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeLoggingOptionsResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeProjectResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse;
import software.amazon.awssdk.services.iotsitewise.model.InternalFailureException;
import software.amazon.awssdk.services.iotsitewise.model.InvalidRequestException;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseException;
import software.amazon.awssdk.services.iotsitewise.model.LimitExceededException;
import software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListDashboardsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iotsitewise.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotsitewise.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iotsitewise.model.TagResourceRequest;
import software.amazon.awssdk.services.iotsitewise.model.TagResourceResponse;
import software.amazon.awssdk.services.iotsitewise.model.ThrottlingException;
import software.amazon.awssdk.services.iotsitewise.model.TooManyTagsException;
import software.amazon.awssdk.services.iotsitewise.model.UnauthorizedException;
import software.amazon.awssdk.services.iotsitewise.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotsitewise.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdatePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateProjectResponse;
import software.amazon.awssdk.services.iotsitewise.transform.AssociateAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.AssociateTimeSeriesToAssetPropertyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.BatchAssociateProjectAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.BatchDisassociateProjectAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.BatchGetAssetPropertyAggregatesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.BatchGetAssetPropertyValueHistoryRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.BatchGetAssetPropertyValueRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.BatchPutAssetPropertyValueRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateAssetModelRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateAssetRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateBulkImportJobRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateDashboardRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreatePortalRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteAssetModelRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteAssetRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteDashboardRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeletePortalRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DeleteTimeSeriesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeAssetModelRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeAssetPropertyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeAssetRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeBulkImportJobRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeDashboardRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeDefaultEncryptionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeGatewayCapabilityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribePortalRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeProjectRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeStorageConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DescribeTimeSeriesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DisassociateAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.DisassociateTimeSeriesFromAssetPropertyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.GetAssetPropertyAggregatesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.GetAssetPropertyValueHistoryRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.GetAssetPropertyValueRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.GetInterpolatedAssetPropertyValuesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAccessPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAssetModelPropertiesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAssetModelsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAssetPropertiesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAssetRelationshipsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListAssociatedAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListBulkImportJobsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListDashboardsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListGatewaysRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListPortalsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListProjectAssetsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.ListTimeSeriesRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.PutDefaultEncryptionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.PutLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.PutStorageConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateAssetModelRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateAssetPropertyRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateAssetRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateDashboardRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateGatewayCapabilityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateGatewayRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdatePortalRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.transform.UpdateProjectRequestMarshaller;
import software.amazon.awssdk.services.iotsitewise.waiters.IoTSiteWiseAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link IoTSiteWiseAsyncClient}.
 *
 * @see IoTSiteWiseAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIoTSiteWiseAsyncClient implements IoTSiteWiseAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultIoTSiteWiseAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final IoTSiteWiseServiceClientConfiguration serviceClientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultIoTSiteWiseAsyncClient(IoTSiteWiseServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Associates a child asset with the given parent asset through a hierarchy defined in the parent asset's model. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html">Associating
     * assets</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param associateAssetsRequest
     * @return A Java Future containing the result of the AssociateAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.AssociateAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateAssets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateAssetsResponse> associateAssets(AssociateAssetsRequest associateAssetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateAssetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateAssetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAssets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateAssetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateAssetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<AssociateAssetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateAssetsRequest, AssociateAssetsResponse>()
                            .withOperationName("AssociateAssets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateAssetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(associateAssetsRequest));
            CompletableFuture<AssociateAssetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a time series (data stream) with an asset property.
     * </p>
     *
     * @param associateTimeSeriesToAssetPropertyRequest
     * @return A Java Future containing the result of the AssociateTimeSeriesToAssetProperty operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.AssociateTimeSeriesToAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateTimeSeriesToAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateTimeSeriesToAssetPropertyResponse> associateTimeSeriesToAssetProperty(
            AssociateTimeSeriesToAssetPropertyRequest associateTimeSeriesToAssetPropertyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTimeSeriesToAssetPropertyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateTimeSeriesToAssetPropertyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTimeSeriesToAssetProperty");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateTimeSeriesToAssetPropertyResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateTimeSeriesToAssetPropertyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<AssociateTimeSeriesToAssetPropertyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateTimeSeriesToAssetPropertyRequest, AssociateTimeSeriesToAssetPropertyResponse>()
                            .withOperationName("AssociateTimeSeriesToAssetProperty").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateTimeSeriesToAssetPropertyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(associateTimeSeriesToAssetPropertyRequest));
            CompletableFuture<AssociateTimeSeriesToAssetPropertyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a group (batch) of assets with an IoT SiteWise Monitor project.
     * </p>
     *
     * @param batchAssociateProjectAssetsRequest
     * @return A Java Future containing the result of the BatchAssociateProjectAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchAssociateProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchAssociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchAssociateProjectAssetsResponse> batchAssociateProjectAssets(
            BatchAssociateProjectAssetsRequest batchAssociateProjectAssetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchAssociateProjectAssetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchAssociateProjectAssetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchAssociateProjectAssets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchAssociateProjectAssetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchAssociateProjectAssetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<BatchAssociateProjectAssetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchAssociateProjectAssetsRequest, BatchAssociateProjectAssetsResponse>()
                            .withOperationName("BatchAssociateProjectAssets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchAssociateProjectAssetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(batchAssociateProjectAssetsRequest));
            CompletableFuture<BatchAssociateProjectAssetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.
     * </p>
     *
     * @param batchDisassociateProjectAssetsRequest
     * @return A Java Future containing the result of the BatchDisassociateProjectAssets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchDisassociateProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchDisassociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDisassociateProjectAssetsResponse> batchDisassociateProjectAssets(
            BatchDisassociateProjectAssetsRequest batchDisassociateProjectAssetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDisassociateProjectAssetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDisassociateProjectAssetsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDisassociateProjectAssets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDisassociateProjectAssetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDisassociateProjectAssetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<BatchDisassociateProjectAssetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDisassociateProjectAssetsRequest, BatchDisassociateProjectAssetsResponse>()
                            .withOperationName("BatchDisassociateProjectAssets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDisassociateProjectAssetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(batchDisassociateProjectAssetsRequest));
            CompletableFuture<BatchDisassociateProjectAssetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets aggregated values (for example, average, minimum, and maximum) for one or more asset properties. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchGetAssetPropertyAggregatesRequest
     * @return A Java Future containing the result of the BatchGetAssetPropertyAggregates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetAssetPropertyAggregatesResponse> batchGetAssetPropertyAggregates(
            BatchGetAssetPropertyAggregatesRequest batchGetAssetPropertyAggregatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetAssetPropertyAggregatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchGetAssetPropertyAggregatesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetAssetPropertyAggregates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetAssetPropertyAggregatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetAssetPropertyAggregatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<BatchGetAssetPropertyAggregatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetAssetPropertyAggregatesRequest, BatchGetAssetPropertyAggregatesResponse>()
                            .withOperationName("BatchGetAssetPropertyAggregates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetAssetPropertyAggregatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(batchGetAssetPropertyAggregatesRequest));
            CompletableFuture<BatchGetAssetPropertyAggregatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the current value for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchGetAssetPropertyValueRequest
     * @return A Java Future containing the result of the BatchGetAssetPropertyValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetAssetPropertyValueResponse> batchGetAssetPropertyValue(
            BatchGetAssetPropertyValueRequest batchGetAssetPropertyValueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetAssetPropertyValueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetAssetPropertyValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetAssetPropertyValue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetAssetPropertyValueResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetAssetPropertyValueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<BatchGetAssetPropertyValueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetAssetPropertyValueRequest, BatchGetAssetPropertyValueResponse>()
                            .withOperationName("BatchGetAssetPropertyValue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetAssetPropertyValueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(batchGetAssetPropertyValueRequest));
            CompletableFuture<BatchGetAssetPropertyValueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the historical values for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchGetAssetPropertyValueHistoryRequest
     * @return A Java Future containing the result of the BatchGetAssetPropertyValueHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetAssetPropertyValueHistoryResponse> batchGetAssetPropertyValueHistory(
            BatchGetAssetPropertyValueHistoryRequest batchGetAssetPropertyValueHistoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetAssetPropertyValueHistoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchGetAssetPropertyValueHistoryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetAssetPropertyValueHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetAssetPropertyValueHistoryResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchGetAssetPropertyValueHistoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<BatchGetAssetPropertyValueHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetAssetPropertyValueHistoryRequest, BatchGetAssetPropertyValueHistoryResponse>()
                            .withOperationName("BatchGetAssetPropertyValueHistory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetAssetPropertyValueHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(batchGetAssetPropertyValueHistoryRequest));
            CompletableFuture<BatchGetAssetPropertyValueHistoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value (TQV) data point.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html">Ingesting data using the API</a>
     * in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more than 7 days in
     * the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps outside of the inclusive
     * range of [-7 days, +10 minutes] and returns a <code>TimestampOutOfRangeException</code> error.
     * </p>
     * <p>
     * For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer TQV has a
     * different quality. For example, if you store a TQV <code>{T1, GOOD, V1}</code>, then storing
     * <code>{T1, GOOD, V2}</code> replaces the existing TQV.
     * </p>
     * </important>
     * <p>
     * IoT SiteWise authorizes access to each <code>BatchPutAssetPropertyValue</code> entry individually. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action"
     * >BatchPutAssetPropertyValue authorization</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchPutAssetPropertyValueRequest
     * @return A Java Future containing the result of the BatchPutAssetPropertyValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchPutAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchPutAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchPutAssetPropertyValueResponse> batchPutAssetPropertyValue(
            BatchPutAssetPropertyValueRequest batchPutAssetPropertyValueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchPutAssetPropertyValueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchPutAssetPropertyValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchPutAssetPropertyValue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchPutAssetPropertyValueResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchPutAssetPropertyValueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<BatchPutAssetPropertyValueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchPutAssetPropertyValueRequest, BatchPutAssetPropertyValueResponse>()
                            .withOperationName("BatchPutAssetPropertyValue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchPutAssetPropertyValueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(batchPutAssetPropertyValueRequest));
            CompletableFuture<BatchPutAssetPropertyValueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an access policy that grants the specified identity (IAM Identity Center user, IAM Identity Center group,
     * or IAM user) access to the specified IoT SiteWise Monitor portal or project resource.
     * </p>
     *
     * @param createAccessPolicyRequest
     * @return A Java Future containing the result of the CreateAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccessPolicyResponse> createAccessPolicy(CreateAccessPolicyRequest createAccessPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccessPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAccessPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<CreateAccessPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccessPolicyRequest, CreateAccessPolicyResponse>()
                            .withOperationName("CreateAccessPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAccessPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createAccessPolicyRequest));
            CompletableFuture<CreateAccessPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an asset from an existing asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param createAssetRequest
     * @return A Java Future containing the result of the CreateAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAssetResponse> createAsset(CreateAssetRequest createAssetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAssetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAsset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAssetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAssetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<CreateAssetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAssetRequest, CreateAssetResponse>()
                            .withOperationName("CreateAsset").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAssetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createAssetRequest));
            CompletableFuture<CreateAssetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an asset model from specified property and hierarchy definitions. You create assets from asset models.
     * With asset models, you can easily create assets of the same type that have standardized definitions. Each asset
     * created from a model inherits the asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param createAssetModelRequest
     * @return A Java Future containing the result of the CreateAssetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAssetModelResponse> createAssetModel(CreateAssetModelRequest createAssetModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAssetModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssetModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssetModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAssetModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAssetModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<CreateAssetModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAssetModelRequest, CreateAssetModelResponse>()
                            .withOperationName("CreateAssetModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAssetModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createAssetModelRequest));
            CompletableFuture<CreateAssetModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Defines a job to ingest data to IoT SiteWise from Amazon S3. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/CreateBulkImportJob.html">Create a bulk import
     * job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <important>
     * <p>
     * You must enable IoT SiteWise to export data to Amazon S3 before you create a bulk import job. For more
     * information about how to configure storage settings, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_PutStorageConfiguration.html"
     * >PutStorageConfiguration</a>.
     * </p>
     * </important>
     *
     * @param createBulkImportJobRequest
     * @return A Java Future containing the result of the CreateBulkImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateBulkImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBulkImportJobResponse> createBulkImportJob(
            CreateBulkImportJobRequest createBulkImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBulkImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBulkImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBulkImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBulkImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBulkImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<CreateBulkImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBulkImportJobRequest, CreateBulkImportJobResponse>()
                            .withOperationName("CreateBulkImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBulkImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createBulkImportJobRequest));
            CompletableFuture<CreateBulkImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a dashboard in an IoT SiteWise Monitor project.
     * </p>
     *
     * @param createDashboardRequest
     * @return A Java Future containing the result of the CreateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDashboardResponse> createDashboard(CreateDashboardRequest createDashboardRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDashboardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDashboardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDashboardResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<CreateDashboardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDashboardRequest, CreateDashboardResponse>()
                            .withOperationName("CreateDashboard").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDashboardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createDashboardRequest));
            CompletableFuture<CreateDashboardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a gateway, which is a virtual or edge device that delivers industrial data streams from local servers to
     * IoT SiteWise. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a
     * gateway</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param createGatewayRequest
     * @return A Java Future containing the result of the CreateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGatewayResponse> createGateway(CreateGatewayRequest createGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<CreateGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGatewayRequest, CreateGatewayResponse>()
                            .withOperationName("CreateGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createGatewayRequest));
            CompletableFuture<CreateGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses IAM Identity Center or IAM
     * to authenticate portal users and manage user permissions.
     * </p>
     * <note>
     * <p>
     * Before you can sign in to a new portal, you must add at least one identity to that portal. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins"
     * >Adding or removing portal administrators</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * </note>
     *
     * @param createPortalRequest
     * @return A Java Future containing the result of the CreatePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePortalResponse> createPortal(CreatePortalRequest createPortalRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPortalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePortal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreatePortalResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<CreatePortalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePortalRequest, CreatePortalResponse>()
                            .withOperationName("CreatePortal").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePortalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createPortalRequest));
            CompletableFuture<CreatePortalResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a project in the specified portal.
     * </p>
     * <note>
     * <p>
     * Make sure that the project name and description don't contain confidential information.
     * </p>
     * </note>
     *
     * @param createProjectRequest
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateProjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<CreateProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProjectRequest, CreateProjectResponse>()
                            .withOperationName("CreateProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createProjectRequest));
            CompletableFuture<CreateProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an access policy that grants the specified identity access to the specified IoT SiteWise Monitor
     * resource. You can use this operation to revoke access to an IoT SiteWise Monitor resource.
     * </p>
     *
     * @param deleteAccessPolicyRequest
     * @return A Java Future containing the result of the DeleteAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccessPolicyResponse> deleteAccessPolicy(DeleteAccessPolicyRequest deleteAccessPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAccessPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<DeleteAccessPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessPolicyRequest, DeleteAccessPolicyResponse>()
                            .withOperationName("DeleteAccessPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccessPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteAccessPolicyRequest));
            CompletableFuture<DeleteAccessPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an asset. This action can't be undone. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't delete an asset that's associated to another asset. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html"
     * >DisassociateAssets</a>.
     * </p>
     * </note>
     *
     * @param deleteAssetRequest
     * @return A Java Future containing the result of the DeleteAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAssetResponse> deleteAsset(DeleteAssetRequest deleteAssetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAssetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAsset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAssetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteAssetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DeleteAssetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAssetRequest, DeleteAssetResponse>()
                            .withOperationName("DeleteAsset").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAssetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteAssetRequest));
            CompletableFuture<DeleteAssetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an asset model. This action can't be undone. You must delete all assets created from an asset model
     * before you can delete the model. Also, you can't delete an asset model if a parent asset model exists that
     * contains a property formula expression that depends on the asset model that you want to delete. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param deleteAssetModelRequest
     * @return A Java Future containing the result of the DeleteAssetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAssetModelResponse> deleteAssetModel(DeleteAssetModelRequest deleteAssetModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAssetModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssetModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssetModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAssetModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAssetModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DeleteAssetModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAssetModelRequest, DeleteAssetModelResponse>()
                            .withOperationName("DeleteAssetModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAssetModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteAssetModelRequest));
            CompletableFuture<DeleteAssetModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a dashboard from IoT SiteWise Monitor.
     * </p>
     *
     * @param deleteDashboardRequest
     * @return A Java Future containing the result of the DeleteDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDashboardResponse> deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDashboardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDashboardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDashboardResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<DeleteDashboardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDashboardRequest, DeleteDashboardResponse>()
                            .withOperationName("DeleteDashboard").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDashboardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteDashboardRequest));
            CompletableFuture<DeleteDashboardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain in your
     * gateway's file system.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return A Java Future containing the result of the DeleteGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGatewayResponse> deleteGateway(DeleteGatewayRequest deleteGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DeleteGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGatewayRequest, DeleteGatewayResponse>()
                            .withOperationName("DeleteGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteGatewayRequest));
            CompletableFuture<DeleteGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a portal from IoT SiteWise Monitor.
     * </p>
     *
     * @param deletePortalRequest
     * @return A Java Future containing the result of the DeletePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeletePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeletePortal" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePortalResponse> deletePortal(DeletePortalRequest deletePortalRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePortalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePortal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeletePortalResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<DeletePortalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePortalRequest, DeletePortalResponse>()
                            .withOperationName("DeletePortal").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePortalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deletePortalRequest));
            CompletableFuture<DeletePortalResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a project from IoT SiteWise Monitor.
     * </p>
     *
     * @param deleteProjectRequest
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteProjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<DeleteProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProjectRequest, DeleteProjectResponse>()
                            .withOperationName("DeleteProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteProjectRequest));
            CompletableFuture<DeleteProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a time series (data stream). If you delete a time series that's associated with an asset property, the
     * asset property still exists, but the time series will no longer be associated with this asset property.
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     *
     * @param deleteTimeSeriesRequest
     * @return A Java Future containing the result of the DeleteTimeSeries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTimeSeriesResponse> deleteTimeSeries(DeleteTimeSeriesRequest deleteTimeSeriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTimeSeriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTimeSeriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTimeSeries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTimeSeriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTimeSeriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DeleteTimeSeriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTimeSeriesRequest, DeleteTimeSeriesResponse>()
                            .withOperationName("DeleteTimeSeries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTimeSeriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteTimeSeriesRequest));
            CompletableFuture<DeleteTimeSeriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or project.
     * </p>
     *
     * @param describeAccessPolicyRequest
     * @return A Java Future containing the result of the DescribeAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccessPolicyResponse> describeAccessPolicy(
            DescribeAccessPolicyRequest describeAccessPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccessPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAccessPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<DescribeAccessPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccessPolicyRequest, DescribeAccessPolicyResponse>()
                            .withOperationName("DescribeAccessPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAccessPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(describeAccessPolicyRequest));
            CompletableFuture<DescribeAccessPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an asset.
     * </p>
     *
     * @param describeAssetRequest
     * @return A Java Future containing the result of the DescribeAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAsset" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAssetResponse> describeAsset(DescribeAssetRequest describeAssetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAssetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAssetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAsset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAssetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeAssetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DescribeAssetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAssetRequest, DescribeAssetResponse>()
                            .withOperationName("DescribeAsset").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAssetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(describeAssetRequest));
            CompletableFuture<DescribeAssetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an asset model.
     * </p>
     *
     * @param describeAssetModelRequest
     * @return A Java Future containing the result of the DescribeAssetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAssetModelResponse> describeAssetModel(DescribeAssetModelRequest describeAssetModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAssetModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAssetModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssetModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAssetModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAssetModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DescribeAssetModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAssetModelRequest, DescribeAssetModelResponse>()
                            .withOperationName("DescribeAssetModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAssetModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(describeAssetModelRequest));
            CompletableFuture<DescribeAssetModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an asset property.
     * </p>
     * <note>
     * <p>
     * When you call this operation for an attribute property, this response includes the default attribute value that
     * you define in the asset model. If you update the default value in the model, this operation's response includes
     * the new default value.
     * </p>
     * </note>
     * <p>
     * This operation doesn't return the value of the asset property. To get the value of an asset property, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html">
     * GetAssetPropertyValue</a>.
     * </p>
     *
     * @param describeAssetPropertyRequest
     * @return A Java Future containing the result of the DescribeAssetProperty operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAssetPropertyResponse> describeAssetProperty(
            DescribeAssetPropertyRequest describeAssetPropertyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAssetPropertyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAssetPropertyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssetProperty");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAssetPropertyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAssetPropertyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DescribeAssetPropertyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAssetPropertyRequest, DescribeAssetPropertyResponse>()
                            .withOperationName("DescribeAssetProperty").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAssetPropertyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(describeAssetPropertyRequest));
            CompletableFuture<DescribeAssetPropertyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a bulk import job request. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/DescribeBulkImportJob.html">Describe a bulk
     * import job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     *
     * @param describeBulkImportJobRequest
     * @return A Java Future containing the result of the DescribeBulkImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeBulkImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBulkImportJobResponse> describeBulkImportJob(
            DescribeBulkImportJobRequest describeBulkImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBulkImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBulkImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBulkImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBulkImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBulkImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<DescribeBulkImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBulkImportJobRequest, DescribeBulkImportJobResponse>()
                            .withOperationName("DescribeBulkImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeBulkImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(describeBulkImportJobRequest));
            CompletableFuture<DescribeBulkImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a dashboard.
     * </p>
     *
     * @param describeDashboardRequest
     * @return A Java Future containing the result of the DescribeDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDashboardResponse> describeDashboard(DescribeDashboardRequest describeDashboardRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDashboardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDashboardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDashboardResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<DescribeDashboardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardRequest, DescribeDashboardResponse>()
                            .withOperationName("DescribeDashboard").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDashboardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(describeDashboardRequest));
            CompletableFuture<DescribeDashboardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in the
     * default or specified Region. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param describeDefaultEncryptionConfigurationRequest
     * @return A Java Future containing the result of the DescribeDefaultEncryptionConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDefaultEncryptionConfigurationResponse> describeDefaultEncryptionConfiguration(
            DescribeDefaultEncryptionConfigurationRequest describeDefaultEncryptionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDefaultEncryptionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDefaultEncryptionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDefaultEncryptionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDefaultEncryptionConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDefaultEncryptionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DescribeDefaultEncryptionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDefaultEncryptionConfigurationRequest, DescribeDefaultEncryptionConfigurationResponse>()
                            .withOperationName("DescribeDefaultEncryptionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDefaultEncryptionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression)
                            .withInput(describeDefaultEncryptionConfigurationRequest));
            CompletableFuture<DescribeDefaultEncryptionConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a gateway.
     * </p>
     *
     * @param describeGatewayRequest
     * @return A Java Future containing the result of the DescribeGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGatewayResponse> describeGateway(DescribeGatewayRequest describeGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DescribeGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGatewayRequest, DescribeGatewayResponse>()
                            .withOperationName("DescribeGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(describeGatewayRequest));
            CompletableFuture<DescribeGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a gateway capability configuration. Each gateway capability defines data sources for
     * a gateway. A capability configuration can contain multiple data source configurations. If you define OPC-UA
     * sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in one capability
     * configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     *
     * @param describeGatewayCapabilityConfigurationRequest
     * @return A Java Future containing the result of the DescribeGatewayCapabilityConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeGatewayCapabilityConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGatewayCapabilityConfigurationResponse> describeGatewayCapabilityConfiguration(
            DescribeGatewayCapabilityConfigurationRequest describeGatewayCapabilityConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGatewayCapabilityConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeGatewayCapabilityConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGatewayCapabilityConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGatewayCapabilityConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeGatewayCapabilityConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DescribeGatewayCapabilityConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGatewayCapabilityConfigurationRequest, DescribeGatewayCapabilityConfigurationResponse>()
                            .withOperationName("DescribeGatewayCapabilityConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeGatewayCapabilityConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression)
                            .withInput(describeGatewayCapabilityConfigurationRequest));
            CompletableFuture<DescribeGatewayCapabilityConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the current IoT SiteWise logging options.
     * </p>
     *
     * @param describeLoggingOptionsRequest
     * @return A Java Future containing the result of the DescribeLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLoggingOptionsResponse> describeLoggingOptions(
            DescribeLoggingOptionsRequest describeLoggingOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLoggingOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLoggingOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLoggingOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeLoggingOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DescribeLoggingOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLoggingOptionsRequest, DescribeLoggingOptionsResponse>()
                            .withOperationName("DescribeLoggingOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeLoggingOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(describeLoggingOptionsRequest));
            CompletableFuture<DescribeLoggingOptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a portal.
     * </p>
     *
     * @param describePortalRequest
     * @return A Java Future containing the result of the DescribePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribePortal" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePortalResponse> describePortal(DescribePortalRequest describePortalRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePortalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePortal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePortalResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePortalResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<DescribePortalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePortalRequest, DescribePortalResponse>()
                            .withOperationName("DescribePortal").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribePortalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(describePortalRequest));
            CompletableFuture<DescribePortalResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a project.
     * </p>
     *
     * @param describeProjectRequest
     * @return A Java Future containing the result of the DescribeProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeProject" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProjectResponse> describeProject(DescribeProjectRequest describeProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProjectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<DescribeProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProjectRequest, DescribeProjectResponse>()
                            .withOperationName("DescribeProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(describeProjectRequest));
            CompletableFuture<DescribeProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the storage configuration for IoT SiteWise.
     * </p>
     *
     * @param describeStorageConfigurationRequest
     * @return A Java Future containing the result of the DescribeStorageConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStorageConfigurationResponse> describeStorageConfiguration(
            DescribeStorageConfigurationRequest describeStorageConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStorageConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStorageConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStorageConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeStorageConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeStorageConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DescribeStorageConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStorageConfigurationRequest, DescribeStorageConfigurationResponse>()
                            .withOperationName("DescribeStorageConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeStorageConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(describeStorageConfigurationRequest));
            CompletableFuture<DescribeStorageConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a time series (data stream).
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     *
     * @param describeTimeSeriesRequest
     * @return A Java Future containing the result of the DescribeTimeSeries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTimeSeriesResponse> describeTimeSeries(DescribeTimeSeriesRequest describeTimeSeriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTimeSeriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTimeSeriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTimeSeries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTimeSeriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTimeSeriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DescribeTimeSeriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTimeSeriesRequest, DescribeTimeSeriesResponse>()
                            .withOperationName("DescribeTimeSeries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTimeSeriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(describeTimeSeriesRequest));
            CompletableFuture<DescribeTimeSeriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a child asset from the given parent asset through a hierarchy defined in the parent asset's model.
     * </p>
     *
     * @param disassociateAssetsRequest
     * @return A Java Future containing the result of the DisassociateAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DisassociateAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateAssets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateAssetsResponse> disassociateAssets(DisassociateAssetsRequest disassociateAssetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateAssetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateAssetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateAssets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateAssetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateAssetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DisassociateAssetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateAssetsRequest, DisassociateAssetsResponse>()
                            .withOperationName("DisassociateAssets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateAssetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(disassociateAssetsRequest));
            CompletableFuture<DisassociateAssetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a time series (data stream) from an asset property.
     * </p>
     *
     * @param disassociateTimeSeriesFromAssetPropertyRequest
     * @return A Java Future containing the result of the DisassociateTimeSeriesFromAssetProperty operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DisassociateTimeSeriesFromAssetProperty
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateTimeSeriesFromAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateTimeSeriesFromAssetPropertyResponse> disassociateTimeSeriesFromAssetProperty(
            DisassociateTimeSeriesFromAssetPropertyRequest disassociateTimeSeriesFromAssetPropertyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateTimeSeriesFromAssetPropertyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateTimeSeriesFromAssetPropertyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateTimeSeriesFromAssetProperty");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateTimeSeriesFromAssetPropertyResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateTimeSeriesFromAssetPropertyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<DisassociateTimeSeriesFromAssetPropertyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateTimeSeriesFromAssetPropertyRequest, DisassociateTimeSeriesFromAssetPropertyResponse>()
                            .withOperationName("DisassociateTimeSeriesFromAssetProperty").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateTimeSeriesFromAssetPropertyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression)
                            .withInput(disassociateTimeSeriesFromAssetPropertyRequest));
            CompletableFuture<DisassociateTimeSeriesFromAssetPropertyResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets aggregated values for an asset property. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetPropertyAggregatesRequest
     * @return A Java Future containing the result of the GetAssetPropertyAggregates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAssetPropertyAggregatesResponse> getAssetPropertyAggregates(
            GetAssetPropertyAggregatesRequest getAssetPropertyAggregatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAssetPropertyAggregatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssetPropertyAggregatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssetPropertyAggregates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAssetPropertyAggregatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAssetPropertyAggregatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<GetAssetPropertyAggregatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAssetPropertyAggregatesRequest, GetAssetPropertyAggregatesResponse>()
                            .withOperationName("GetAssetPropertyAggregates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAssetPropertyAggregatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getAssetPropertyAggregatesRequest));
            CompletableFuture<GetAssetPropertyAggregatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an asset property's current value. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetPropertyValueRequest
     * @return A Java Future containing the result of the GetAssetPropertyValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAssetPropertyValueResponse> getAssetPropertyValue(
            GetAssetPropertyValueRequest getAssetPropertyValueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAssetPropertyValueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssetPropertyValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssetPropertyValue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAssetPropertyValueResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAssetPropertyValueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<GetAssetPropertyValueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAssetPropertyValueRequest, GetAssetPropertyValueResponse>()
                            .withOperationName("GetAssetPropertyValue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAssetPropertyValueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getAssetPropertyValueRequest));
            CompletableFuture<GetAssetPropertyValueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the history of an asset property's values. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetPropertyValueHistoryRequest
     * @return A Java Future containing the result of the GetAssetPropertyValueHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAssetPropertyValueHistoryResponse> getAssetPropertyValueHistory(
            GetAssetPropertyValueHistoryRequest getAssetPropertyValueHistoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAssetPropertyValueHistoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssetPropertyValueHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssetPropertyValueHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAssetPropertyValueHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAssetPropertyValueHistoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<GetAssetPropertyValueHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAssetPropertyValueHistoryRequest, GetAssetPropertyValueHistoryResponse>()
                            .withOperationName("GetAssetPropertyValueHistory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAssetPropertyValueHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getAssetPropertyValueHistoryRequest));
            CompletableFuture<GetAssetPropertyValueHistoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get interpolated values for an asset property for a specified time interval, during a period of time. If your
     * time series is missing data points during the specified time interval, you can use interpolation to estimate the
     * missing data.
     * </p>
     * <p>
     * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24
     * hours over a duration of 7 days.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getInterpolatedAssetPropertyValuesRequest
     * @return A Java Future containing the result of the GetInterpolatedAssetPropertyValues operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetInterpolatedAssetPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetInterpolatedAssetPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInterpolatedAssetPropertyValuesResponse> getInterpolatedAssetPropertyValues(
            GetInterpolatedAssetPropertyValuesRequest getInterpolatedAssetPropertyValuesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInterpolatedAssetPropertyValuesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getInterpolatedAssetPropertyValuesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInterpolatedAssetPropertyValues");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInterpolatedAssetPropertyValuesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetInterpolatedAssetPropertyValuesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<GetInterpolatedAssetPropertyValuesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInterpolatedAssetPropertyValuesRequest, GetInterpolatedAssetPropertyValuesResponse>()
                            .withOperationName("GetInterpolatedAssetPropertyValues").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetInterpolatedAssetPropertyValuesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getInterpolatedAssetPropertyValuesRequest));
            CompletableFuture<GetInterpolatedAssetPropertyValuesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of access policies for an identity (an IAM Identity Center user, an IAM Identity
     * Center group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
     * </p>
     *
     * @param listAccessPoliciesRequest
     * @return A Java Future containing the result of the ListAccessPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccessPoliciesResponse> listAccessPolicies(ListAccessPoliciesRequest listAccessPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccessPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccessPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAccessPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAccessPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<ListAccessPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccessPoliciesRequest, ListAccessPoliciesResponse>()
                            .withOperationName("ListAccessPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAccessPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listAccessPoliciesRequest));
            CompletableFuture<ListAccessPoliciesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset model. If you update properties associated with
     * the model before you finish listing all the properties, you need to start all over again.
     * </p>
     *
     * @param listAssetModelPropertiesRequest
     * @return A Java Future containing the result of the ListAssetModelProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModelProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssetModelPropertiesResponse> listAssetModelProperties(
            ListAssetModelPropertiesRequest listAssetModelPropertiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssetModelPropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssetModelPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssetModelProperties");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssetModelPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAssetModelPropertiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListAssetModelPropertiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssetModelPropertiesRequest, ListAssetModelPropertiesResponse>()
                            .withOperationName("ListAssetModelProperties").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAssetModelPropertiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listAssetModelPropertiesRequest));
            CompletableFuture<ListAssetModelPropertiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of summaries of all asset models.
     * </p>
     *
     * @param listAssetModelsRequest
     * @return A Java Future containing the result of the ListAssetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssetModelsResponse> listAssetModels(ListAssetModelsRequest listAssetModelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssetModelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssetModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssetModels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssetModelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAssetModelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListAssetModelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssetModelsRequest, ListAssetModelsResponse>()
                            .withOperationName("ListAssetModels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAssetModelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listAssetModelsRequest));
            CompletableFuture<ListAssetModelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset. If you update properties associated with the
     * model before you finish listing all the properties, you need to start all over again.
     * </p>
     *
     * @param listAssetPropertiesRequest
     * @return A Java Future containing the result of the ListAssetProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssetPropertiesResponse> listAssetProperties(
            ListAssetPropertiesRequest listAssetPropertiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssetPropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssetPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssetProperties");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssetPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAssetPropertiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListAssetPropertiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssetPropertiesRequest, ListAssetPropertiesResponse>()
                            .withOperationName("ListAssetProperties").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAssetPropertiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listAssetPropertiesRequest));
            CompletableFuture<ListAssetPropertiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of asset relationships for an asset. You can use this operation to identify an asset's
     * root asset and all associated assets between that asset and its root.
     * </p>
     *
     * @param listAssetRelationshipsRequest
     * @return A Java Future containing the result of the ListAssetRelationships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssetRelationshipsResponse> listAssetRelationships(
            ListAssetRelationshipsRequest listAssetRelationshipsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssetRelationshipsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssetRelationshipsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssetRelationships");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssetRelationshipsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAssetRelationshipsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListAssetRelationshipsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssetRelationshipsRequest, ListAssetRelationshipsResponse>()
                            .withOperationName("ListAssetRelationships").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAssetRelationshipsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listAssetRelationshipsRequest));
            CompletableFuture<ListAssetRelationshipsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of asset summaries.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List assets based on a specific asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * List top-level assets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't use this operation to list all assets. To retrieve summaries for all of your assets, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels</a>
     * to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.
     * </p>
     *
     * @param listAssetsRequest
     * @return A Java Future containing the result of the ListAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssetsResponse> listAssets(ListAssetsRequest listAssetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListAssetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListAssetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssetsRequest, ListAssetsResponse>().withOperationName("ListAssets")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAssetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listAssetsRequest));
            CompletableFuture<ListAssetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of associated assets.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List child assets associated to a parent asset by a hierarchy that you specify.
     * </p>
     * </li>
     * <li>
     * <p>
     * List an asset's parent asset.
     * </p>
     * </li>
     * </ul>
     *
     * @param listAssociatedAssetsRequest
     * @return A Java Future containing the result of the ListAssociatedAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssociatedAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAssociatedAssetsResponse> listAssociatedAssets(
            ListAssociatedAssetsRequest listAssociatedAssetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssociatedAssetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssociatedAssetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssociatedAssets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAssociatedAssetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAssociatedAssetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListAssociatedAssetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAssociatedAssetsRequest, ListAssociatedAssetsResponse>()
                            .withOperationName("ListAssociatedAssets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAssociatedAssetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listAssociatedAssetsRequest));
            CompletableFuture<ListAssociatedAssetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of bulk import job requests. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ListBulkImportJobs.html">List bulk import jobs
     * (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param listBulkImportJobsRequest
     * @return A Java Future containing the result of the ListBulkImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListBulkImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListBulkImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBulkImportJobsResponse> listBulkImportJobs(ListBulkImportJobsRequest listBulkImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBulkImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBulkImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBulkImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBulkImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBulkImportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            CompletableFuture<ListBulkImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBulkImportJobsRequest, ListBulkImportJobsResponse>()
                            .withOperationName("ListBulkImportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBulkImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listBulkImportJobsRequest));
            CompletableFuture<ListBulkImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
     * </p>
     *
     * @param listDashboardsRequest
     * @return A Java Future containing the result of the ListDashboards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDashboardsResponse> listDashboards(ListDashboardsRequest listDashboardsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDashboardsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDashboardsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDashboards");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDashboardsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDashboardsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<ListDashboardsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDashboardsRequest, ListDashboardsResponse>()
                            .withOperationName("ListDashboards").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDashboardsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listDashboardsRequest));
            CompletableFuture<ListDashboardsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of gateways.
     * </p>
     *
     * @param listGatewaysRequest
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGatewaysResponse> listGateways(ListGatewaysRequest listGatewaysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGatewaysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGatewaysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGateways");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGatewaysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGatewaysRequest, ListGatewaysResponse>()
                            .withOperationName("ListGateways").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listGatewaysRequest));
            CompletableFuture<ListGatewaysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of IoT SiteWise Monitor portals.
     * </p>
     *
     * @param listPortalsRequest
     * @return A Java Future containing the result of the ListPortals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListPortalsResponse> listPortals(ListPortalsRequest listPortalsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPortalsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPortalsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPortals");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPortalsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListPortalsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<ListPortalsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPortalsRequest, ListPortalsResponse>()
                            .withOperationName("ListPortals").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPortalsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listPortalsRequest));
            CompletableFuture<ListPortalsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
     * </p>
     *
     * @param listProjectAssetsRequest
     * @return A Java Future containing the result of the ListProjectAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListProjectAssetsResponse> listProjectAssets(ListProjectAssetsRequest listProjectAssetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProjectAssetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProjectAssetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProjectAssets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProjectAssetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListProjectAssetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<ListProjectAssetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProjectAssetsRequest, ListProjectAssetsResponse>()
                            .withOperationName("ListProjectAssets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListProjectAssetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listProjectAssetsRequest));
            CompletableFuture<ListProjectAssetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
     * </p>
     *
     * @param listProjectsRequest
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListProjectsResponse> listProjects(ListProjectsRequest listProjectsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProjectsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProjects");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProjectsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListProjectsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<ListProjectsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProjectsRequest, ListProjectsResponse>()
                            .withOperationName("ListProjects").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListProjectsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listProjectsRequest));
            CompletableFuture<ListProjectsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the list of tags for an IoT SiteWise resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>UnauthorizedException You are not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of time series (data streams).
     * </p>
     *
     * @param listTimeSeriesRequest
     * @return A Java Future containing the result of the ListTimeSeries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTimeSeriesResponse> listTimeSeries(ListTimeSeriesRequest listTimeSeriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTimeSeriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTimeSeriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTimeSeries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTimeSeriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTimeSeriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<ListTimeSeriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTimeSeriesRequest, ListTimeSeriesResponse>()
                            .withOperationName("ListTimeSeries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTimeSeriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listTimeSeriesRequest));
            CompletableFuture<ListTimeSeriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param putDefaultEncryptionConfigurationRequest
     * @return A Java Future containing the result of the PutDefaultEncryptionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.PutDefaultEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutDefaultEncryptionConfigurationResponse> putDefaultEncryptionConfiguration(
            PutDefaultEncryptionConfigurationRequest putDefaultEncryptionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDefaultEncryptionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putDefaultEncryptionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDefaultEncryptionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutDefaultEncryptionConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutDefaultEncryptionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<PutDefaultEncryptionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutDefaultEncryptionConfigurationRequest, PutDefaultEncryptionConfigurationResponse>()
                            .withOperationName("PutDefaultEncryptionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutDefaultEncryptionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(putDefaultEncryptionConfigurationRequest));
            CompletableFuture<PutDefaultEncryptionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets logging options for IoT SiteWise.
     * </p>
     *
     * @param putLoggingOptionsRequest
     * @return A Java Future containing the result of the PutLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutLoggingOptions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutLoggingOptionsResponse> putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putLoggingOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putLoggingOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutLoggingOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutLoggingOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<PutLoggingOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutLoggingOptionsRequest, PutLoggingOptionsResponse>()
                            .withOperationName("PutLoggingOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutLoggingOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(putLoggingOptionsRequest));
            CompletableFuture<PutLoggingOptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Configures storage settings for IoT SiteWise.
     * </p>
     *
     * @param putStorageConfigurationRequest
     * @return A Java Future containing the result of the PutStorageConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.PutStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutStorageConfigurationResponse> putStorageConfiguration(
            PutStorageConfigurationRequest putStorageConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putStorageConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putStorageConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutStorageConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutStorageConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutStorageConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<PutStorageConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutStorageConfigurationRequest, PutStorageConfigurationResponse>()
                            .withOperationName("PutStorageConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutStorageConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(putStorageConfigurationRequest));
            CompletableFuture<PutStorageConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation updates the tag's
     * value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>UnauthorizedException You are not authorized.</li>
     *         <li>TooManyTagsException You've reached the limit for the number of tags allowed for a resource. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag naming limits
     *         and requirements</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag from an IoT SiteWise resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>UnauthorizedException You are not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor portal or
     * project resource.
     * </p>
     *
     * @param updateAccessPolicyRequest
     * @return A Java Future containing the result of the UpdateAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAccessPolicyResponse> updateAccessPolicy(UpdateAccessPolicyRequest updateAccessPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccessPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAccessPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<UpdateAccessPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAccessPolicyRequest, UpdateAccessPolicyResponse>()
                            .withOperationName("UpdateAccessPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAccessPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateAccessPolicyRequest));
            CompletableFuture<UpdateAccessPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an asset's name. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param updateAssetRequest
     * @return A Java Future containing the result of the UpdateAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAssetResponse> updateAsset(UpdateAssetRequest updateAssetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAssetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAsset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAssetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateAssetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<UpdateAssetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAssetRequest, UpdateAssetResponse>()
                            .withOperationName("UpdateAsset").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAssetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateAssetRequest));
            CompletableFuture<UpdateAssetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an asset model and all of the assets that were created from the model. Each asset created from the model
     * inherits the updated asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <important>
     * <p>
     * This operation overwrites the existing model with the provided model. To avoid deleting your asset model's
     * properties or hierarchies, you must include their IDs and definitions in the updated asset model payload. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html"
     * >DescribeAssetModel</a>.
     * </p>
     * <p>
     * If you remove a property from an asset model, IoT SiteWise deletes all previous data for that property. If you
     * remove a hierarchy definition from an asset model, IoT SiteWise disassociates every asset associated with that
     * hierarchy. You can't change the type or data type of an existing property.
     * </p>
     * </important>
     *
     * @param updateAssetModelRequest
     * @return A Java Future containing the result of the UpdateAssetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAssetModelResponse> updateAssetModel(UpdateAssetModelRequest updateAssetModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAssetModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssetModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssetModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAssetModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAssetModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<UpdateAssetModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAssetModelRequest, UpdateAssetModelResponse>()
                            .withOperationName("UpdateAssetModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAssetModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateAssetModelRequest));
            CompletableFuture<UpdateAssetModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an asset property's alias and notification state.
     * </p>
     * <important>
     * <p>
     * This operation overwrites the property's existing alias and notification state. To keep your existing property's
     * alias or notification state, you must include the existing values in the UpdateAssetProperty request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html"
     * >DescribeAssetProperty</a>.
     * </p>
     * </important>
     *
     * @param updateAssetPropertyRequest
     * @return A Java Future containing the result of the UpdateAssetProperty operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAssetPropertyResponse> updateAssetProperty(
            UpdateAssetPropertyRequest updateAssetPropertyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAssetPropertyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssetPropertyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssetProperty");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAssetPropertyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAssetPropertyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<UpdateAssetPropertyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAssetPropertyRequest, UpdateAssetPropertyResponse>()
                            .withOperationName("UpdateAssetProperty").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAssetPropertyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateAssetPropertyRequest));
            CompletableFuture<UpdateAssetPropertyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor dashboard.
     * </p>
     *
     * @param updateDashboardRequest
     * @return A Java Future containing the result of the UpdateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDashboardResponse> updateDashboard(UpdateDashboardRequest updateDashboardRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDashboardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDashboardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDashboardResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<UpdateDashboardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDashboardRequest, UpdateDashboardResponse>()
                            .withOperationName("UpdateDashboard").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDashboardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateDashboardRequest));
            CompletableFuture<UpdateDashboardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a gateway's name.
     * </p>
     *
     * @param updateGatewayRequest
     * @return A Java Future containing the result of the UpdateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGatewayResponse> updateGateway(UpdateGatewayRequest updateGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<UpdateGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGatewayRequest, UpdateGatewayResponse>()
                            .withOperationName("UpdateGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateGatewayRequest));
            CompletableFuture<UpdateGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a gateway capability configuration or defines a new capability configuration. Each gateway capability
     * defines data sources for a gateway. A capability configuration can contain multiple data source configurations.
     * If you define OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in
     * one capability configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     *
     * @param updateGatewayCapabilityConfigurationRequest
     * @return A Java Future containing the result of the UpdateGatewayCapabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateGatewayCapabilityConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGatewayCapabilityConfigurationResponse> updateGatewayCapabilityConfiguration(
            UpdateGatewayCapabilityConfigurationRequest updateGatewayCapabilityConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGatewayCapabilityConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateGatewayCapabilityConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGatewayCapabilityConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGatewayCapabilityConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateGatewayCapabilityConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            CompletableFuture<UpdateGatewayCapabilityConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGatewayCapabilityConfigurationRequest, UpdateGatewayCapabilityConfigurationResponse>()
                            .withOperationName("UpdateGatewayCapabilityConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateGatewayCapabilityConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateGatewayCapabilityConfigurationRequest));
            CompletableFuture<UpdateGatewayCapabilityConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor portal.
     * </p>
     *
     * @param updatePortalRequest
     * @return A Java Future containing the result of the UpdatePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePortalResponse> updatePortal(UpdatePortalRequest updatePortalRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePortalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePortal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdatePortalResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<UpdatePortalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePortalRequest, UpdatePortalResponse>()
                            .withOperationName("UpdatePortal").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdatePortalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updatePortalRequest));
            CompletableFuture<UpdatePortalResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor project.
     * </p>
     *
     * @param updateProjectRequest
     * @return A Java Future containing the result of the UpdateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProjectResponse> updateProject(UpdateProjectRequest updateProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTSiteWise");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateProjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);
            String hostPrefix = "monitor.";
            String resolvedHostExpression = "monitor.";

            CompletableFuture<UpdateProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProjectRequest, UpdateProjectResponse>()
                            .withOperationName("UpdateProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateProjectRequest));
            CompletableFuture<UpdateProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public IoTSiteWiseAsyncWaiter waiter() {
        return IoTSiteWiseAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }

    @Override
    public final IoTSiteWiseServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IoTSiteWiseException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalFailureException")
                                .exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(410).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictingOperationException")
                                .exceptionBuilderSupplier(ConflictingOperationException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        IoTSiteWiseServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = IoTSiteWiseServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
