/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A .CSV file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Csv implements SdkPojo, Serializable, ToCopyableBuilder<Csv.Builder, Csv> {
    private static final SdkField<List<String>> COLUMN_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("columnNames")
            .getter(getter(Csv::columnNamesAsStrings))
            .setter(setter(Builder::columnNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> columnNames;

    private Csv(BuilderImpl builder) {
        this.columnNames = builder.columnNames;
    }

    /**
     * <p>
     * The column names specified in the .csv file.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnNames} method.
     * </p>
     * 
     * @return The column names specified in the .csv file.
     */
    public final List<ColumnName> columnNames() {
        return ColumnNamesCopier.copyStringToEnum(columnNames);
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnNames() {
        return columnNames != null && !(columnNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The column names specified in the .csv file.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnNames} method.
     * </p>
     * 
     * @return The column names specified in the .csv file.
     */
    public final List<String> columnNamesAsStrings() {
        return columnNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnNames() ? columnNamesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Csv)) {
            return false;
        }
        Csv other = (Csv) obj;
        return hasColumnNames() == other.hasColumnNames() && Objects.equals(columnNamesAsStrings(), other.columnNamesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Csv").add("ColumnNames", hasColumnNames() ? columnNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnNames":
            return Optional.ofNullable(clazz.cast(columnNamesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Csv, T> g) {
        return obj -> g.apply((Csv) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Csv> {
        /**
         * <p>
         * The column names specified in the .csv file.
         * </p>
         * 
         * @param columnNames
         *        The column names specified in the .csv file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNamesWithStrings(Collection<String> columnNames);

        /**
         * <p>
         * The column names specified in the .csv file.
         * </p>
         * 
         * @param columnNames
         *        The column names specified in the .csv file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNamesWithStrings(String... columnNames);

        /**
         * <p>
         * The column names specified in the .csv file.
         * </p>
         * 
         * @param columnNames
         *        The column names specified in the .csv file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNames(Collection<ColumnName> columnNames);

        /**
         * <p>
         * The column names specified in the .csv file.
         * </p>
         * 
         * @param columnNames
         *        The column names specified in the .csv file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNames(ColumnName... columnNames);
    }

    static final class BuilderImpl implements Builder {
        private List<String> columnNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Csv model) {
            columnNamesWithStrings(model.columnNames);
        }

        public final Collection<String> getColumnNames() {
            if (columnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return columnNames;
        }

        public final void setColumnNames(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
        }

        @Override
        public final Builder columnNamesWithStrings(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNamesWithStrings(String... columnNames) {
            columnNamesWithStrings(Arrays.asList(columnNames));
            return this;
        }

        @Override
        public final Builder columnNames(Collection<ColumnName> columnNames) {
            this.columnNames = ColumnNamesCopier.copyEnumToString(columnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNames(ColumnName... columnNames) {
            columnNames(Arrays.asList(columnNames));
            return this;
        }

        @Override
        public Csv build() {
            return new Csv(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
