/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssetRelationshipsRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<ListAssetRelationshipsRequest.Builder, ListAssetRelationshipsRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(ListAssetRelationshipsRequest::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetId").build()).build();

    private static final SdkField<String> TRAVERSAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traversalType").getter(getter(ListAssetRelationshipsRequest::traversalTypeAsString))
            .setter(setter(Builder::traversalType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("traversalType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssetRelationshipsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAssetRelationshipsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            TRAVERSAL_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String assetId;

    private final String traversalType;

    private final String nextToken;

    private final Integer maxResults;

    private ListAssetRelationshipsRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.traversalType = builder.traversalType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed
     * by the external ID, if it has one. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code>
     *         followed by the external ID, if it has one. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     *         >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The type of traversal to use to identify asset relationships. Choose the following option:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root asset. The asset that you specify
     * in <code>assetId</code> is the first result in the list of <code>assetRelationshipSummaries</code>, and the root
     * asset is the last result.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #traversalType}
     * will return {@link TraversalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traversalTypeAsString}.
     * </p>
     * 
     * @return The type of traversal to use to identify asset relationships. Choose the following option:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root asset. The asset that you
     *         specify in <code>assetId</code> is the first result in the list of
     *         <code>assetRelationshipSummaries</code>, and the root asset is the last result.
     *         </p>
     *         </li>
     * @see TraversalType
     */
    public final TraversalType traversalType() {
        return TraversalType.fromValue(traversalType);
    }

    /**
     * <p>
     * The type of traversal to use to identify asset relationships. Choose the following option:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root asset. The asset that you specify
     * in <code>assetId</code> is the first result in the list of <code>assetRelationshipSummaries</code>, and the root
     * asset is the last result.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #traversalType}
     * will return {@link TraversalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traversalTypeAsString}.
     * </p>
     * 
     * @return The type of traversal to use to identify asset relationships. Choose the following option:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root asset. The asset that you
     *         specify in <code>assetId</code> is the first result in the list of
     *         <code>assetRelationshipSummaries</code>, and the root asset is the last result.
     *         </p>
     *         </li>
     * @see TraversalType
     */
    public final String traversalTypeAsString() {
        return traversalType;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return for each paginated request.
     * </p>
     * 
     * @return The maximum number of results to return for each paginated request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(traversalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetRelationshipsRequest)) {
            return false;
        }
        ListAssetRelationshipsRequest other = (ListAssetRelationshipsRequest) obj;
        return Objects.equals(assetId(), other.assetId())
                && Objects.equals(traversalTypeAsString(), other.traversalTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssetRelationshipsRequest").add("AssetId", assetId())
                .add("TraversalType", traversalTypeAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "traversalType":
            return Optional.ofNullable(clazz.cast(traversalTypeAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssetRelationshipsRequest, T> g) {
        return obj -> g.apply((ListAssetRelationshipsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAssetRelationshipsRequest> {
        /**
         * <p>
         * The ID of the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code>
         * followed by the external ID, if it has one. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code>
         *        followed by the external ID, if it has one. For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The type of traversal to use to identify asset relationships. Choose the following option:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root asset. The asset that you
         * specify in <code>assetId</code> is the first result in the list of <code>assetRelationshipSummaries</code>,
         * and the root asset is the last result.
         * </p>
         * </li>
         * </ul>
         * 
         * @param traversalType
         *        The type of traversal to use to identify asset relationships. Choose the following option:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root asset. The asset that
         *        you specify in <code>assetId</code> is the first result in the list of
         *        <code>assetRelationshipSummaries</code>, and the root asset is the last result.
         *        </p>
         *        </li>
         * @see TraversalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TraversalType
         */
        Builder traversalType(String traversalType);

        /**
         * <p>
         * The type of traversal to use to identify asset relationships. Choose the following option:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root asset. The asset that you
         * specify in <code>assetId</code> is the first result in the list of <code>assetRelationshipSummaries</code>,
         * and the root asset is the last result.
         * </p>
         * </li>
         * </ul>
         * 
         * @param traversalType
         *        The type of traversal to use to identify asset relationships. Choose the following option:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root asset. The asset that
         *        you specify in <code>assetId</code> is the first result in the list of
         *        <code>assetRelationshipSummaries</code>, and the root asset is the last result.
         *        </p>
         *        </li>
         * @see TraversalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TraversalType
         */
        Builder traversalType(TraversalType traversalType);

        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return for each paginated request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for each paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetId;

        private String traversalType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetRelationshipsRequest model) {
            super(model);
            assetId(model.assetId);
            traversalType(model.traversalType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getTraversalType() {
            return traversalType;
        }

        public final void setTraversalType(String traversalType) {
            this.traversalType = traversalType;
        }

        @Override
        public final Builder traversalType(String traversalType) {
            this.traversalType = traversalType;
            return this;
        }

        @Override
        public final Builder traversalType(TraversalType traversalType) {
            this.traversalType(traversalType == null ? null : traversalType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssetRelationshipsRequest build() {
            return new ListAssetRelationshipsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
