/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The file format of the data in S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileFormat implements SdkPojo, Serializable, ToCopyableBuilder<FileFormat.Builder, FileFormat> {
    private static final SdkField<Csv> CSV_FIELD = SdkField.<Csv> builder(MarshallingType.SDK_POJO).memberName("csv")
            .getter(getter(FileFormat::csv)).setter(setter(Builder::csv)).constructor(Csv::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("csv").build()).build();

    private static final SdkField<Parquet> PARQUET_FIELD = SdkField.<Parquet> builder(MarshallingType.SDK_POJO)
            .memberName("parquet").getter(getter(FileFormat::parquet)).setter(setter(Builder::parquet))
            .constructor(Parquet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_FIELD, PARQUET_FIELD));

    private static final long serialVersionUID = 1L;

    private final Csv csv;

    private final Parquet parquet;

    private FileFormat(BuilderImpl builder) {
        this.csv = builder.csv;
        this.parquet = builder.parquet;
    }

    /**
     * <p>
     * The file is in .CSV format.
     * </p>
     * 
     * @return The file is in .CSV format.
     */
    public final Csv csv() {
        return csv;
    }

    /**
     * <p>
     * The file is in parquet format.
     * </p>
     * 
     * @return The file is in parquet format.
     */
    public final Parquet parquet() {
        return parquet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(csv());
        hashCode = 31 * hashCode + Objects.hashCode(parquet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileFormat)) {
            return false;
        }
        FileFormat other = (FileFormat) obj;
        return Objects.equals(csv(), other.csv()) && Objects.equals(parquet(), other.parquet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileFormat").add("Csv", csv()).add("Parquet", parquet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "csv":
            return Optional.ofNullable(clazz.cast(csv()));
        case "parquet":
            return Optional.ofNullable(clazz.cast(parquet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileFormat, T> g) {
        return obj -> g.apply((FileFormat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileFormat> {
        /**
         * <p>
         * The file is in .CSV format.
         * </p>
         * 
         * @param csv
         *        The file is in .CSV format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csv(Csv csv);

        /**
         * <p>
         * The file is in .CSV format.
         * </p>
         * This is a convenience method that creates an instance of the {@link Csv.Builder} avoiding the need to create
         * one manually via {@link Csv#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Csv.Builder#build()} is called immediately and its result is
         * passed to {@link #csv(Csv)}.
         * 
         * @param csv
         *        a consumer that will call methods on {@link Csv.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csv(Csv)
         */
        default Builder csv(Consumer<Csv.Builder> csv) {
            return csv(Csv.builder().applyMutation(csv).build());
        }

        /**
         * <p>
         * The file is in parquet format.
         * </p>
         * 
         * @param parquet
         *        The file is in parquet format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parquet(Parquet parquet);

        /**
         * <p>
         * The file is in parquet format.
         * </p>
         * This is a convenience method that creates an instance of the {@link Parquet.Builder} avoiding the need to
         * create one manually via {@link Parquet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Parquet.Builder#build()} is called immediately and its result is
         * passed to {@link #parquet(Parquet)}.
         * 
         * @param parquet
         *        a consumer that will call methods on {@link Parquet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parquet(Parquet)
         */
        default Builder parquet(Consumer<Parquet.Builder> parquet) {
            return parquet(Parquet.builder().applyMutation(parquet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Csv csv;

        private Parquet parquet;

        private BuilderImpl() {
        }

        private BuilderImpl(FileFormat model) {
            csv(model.csv);
            parquet(model.parquet);
        }

        public final Csv.Builder getCsv() {
            return csv != null ? csv.toBuilder() : null;
        }

        public final void setCsv(Csv.BuilderImpl csv) {
            this.csv = csv != null ? csv.build() : null;
        }

        @Override
        public final Builder csv(Csv csv) {
            this.csv = csv;
            return this;
        }

        public final Parquet.Builder getParquet() {
            return parquet != null ? parquet.toBuilder() : null;
        }

        public final void setParquet(Parquet.BuilderImpl parquet) {
            this.parquet = parquet != null ? parquet.build() : null;
        }

        @Override
        public final Builder parquet(Parquet parquet) {
            this.parquet = parquet;
            return this;
        }

        @Override
        public FileFormat build() {
            return new FileFormat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
