/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAssetPropertyValueResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<BatchGetAssetPropertyValueResponse.Builder, BatchGetAssetPropertyValueResponse> {
    private static final SdkField<List<BatchGetAssetPropertyValueErrorEntry>> ERROR_ENTRIES_FIELD = SdkField
            .<List<BatchGetAssetPropertyValueErrorEntry>> builder(MarshallingType.LIST)
            .memberName("errorEntries")
            .getter(getter(BatchGetAssetPropertyValueResponse::errorEntries))
            .setter(setter(Builder::errorEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetAssetPropertyValueErrorEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetAssetPropertyValueErrorEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetAssetPropertyValueSuccessEntry>> SUCCESS_ENTRIES_FIELD = SdkField
            .<List<BatchGetAssetPropertyValueSuccessEntry>> builder(MarshallingType.LIST)
            .memberName("successEntries")
            .getter(getter(BatchGetAssetPropertyValueResponse::successEntries))
            .setter(setter(Builder::successEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetAssetPropertyValueSuccessEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetAssetPropertyValueSuccessEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetAssetPropertyValueSkippedEntry>> SKIPPED_ENTRIES_FIELD = SdkField
            .<List<BatchGetAssetPropertyValueSkippedEntry>> builder(MarshallingType.LIST)
            .memberName("skippedEntries")
            .getter(getter(BatchGetAssetPropertyValueResponse::skippedEntries))
            .setter(setter(Builder::skippedEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skippedEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetAssetPropertyValueSkippedEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetAssetPropertyValueSkippedEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(BatchGetAssetPropertyValueResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_ENTRIES_FIELD,
            SUCCESS_ENTRIES_FIELD, SKIPPED_ENTRIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<BatchGetAssetPropertyValueErrorEntry> errorEntries;

    private final List<BatchGetAssetPropertyValueSuccessEntry> successEntries;

    private final List<BatchGetAssetPropertyValueSkippedEntry> skippedEntries;

    private final String nextToken;

    private BatchGetAssetPropertyValueResponse(BuilderImpl builder) {
        super(builder);
        this.errorEntries = builder.errorEntries;
        this.successEntries = builder.successEntries;
        this.skippedEntries = builder.skippedEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasErrorEntries() {
        return errorEntries != null && !(errorEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the errors (if any) associated with the batch request. Each error entry contains the
     * <code>entryId</code> of the entry that failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorEntries} method.
     * </p>
     * 
     * @return A list of the errors (if any) associated with the batch request. Each error entry contains the
     *         <code>entryId</code> of the entry that failed.
     */
    public final List<BatchGetAssetPropertyValueErrorEntry> errorEntries() {
        return errorEntries;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuccessEntries() {
        return successEntries != null && !(successEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entries that were processed successfully by this batch request. Each success entry contains the
     * <code>entryId</code> of the entry that succeeded and the latest query result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessEntries} method.
     * </p>
     * 
     * @return A list of entries that were processed successfully by this batch request. Each success entry contains the
     *         <code>entryId</code> of the entry that succeeded and the latest query result.
     */
    public final List<BatchGetAssetPropertyValueSuccessEntry> successEntries() {
        return successEntries;
    }

    /**
     * For responses, this returns true if the service returned a value for the SkippedEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSkippedEntries() {
        return skippedEntries != null && !(skippedEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entries that were not processed by this batch request. because these entries had been completely
     * processed by previous paginated requests. Each skipped entry contains the <code>entryId</code> of the entry that
     * skipped.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSkippedEntries} method.
     * </p>
     * 
     * @return A list of entries that were not processed by this batch request. because these entries had been
     *         completely processed by previous paginated requests. Each skipped entry contains the <code>entryId</code>
     *         of the entry that skipped.
     */
    public final List<BatchGetAssetPropertyValueSkippedEntry> skippedEntries() {
        return skippedEntries;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorEntries() ? errorEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessEntries() ? successEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSkippedEntries() ? skippedEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyValueResponse)) {
            return false;
        }
        BatchGetAssetPropertyValueResponse other = (BatchGetAssetPropertyValueResponse) obj;
        return hasErrorEntries() == other.hasErrorEntries() && Objects.equals(errorEntries(), other.errorEntries())
                && hasSuccessEntries() == other.hasSuccessEntries() && Objects.equals(successEntries(), other.successEntries())
                && hasSkippedEntries() == other.hasSkippedEntries() && Objects.equals(skippedEntries(), other.skippedEntries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAssetPropertyValueResponse")
                .add("ErrorEntries", hasErrorEntries() ? errorEntries() : null)
                .add("SuccessEntries", hasSuccessEntries() ? successEntries() : null)
                .add("SkippedEntries", hasSkippedEntries() ? skippedEntries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorEntries":
            return Optional.ofNullable(clazz.cast(errorEntries()));
        case "successEntries":
            return Optional.ofNullable(clazz.cast(successEntries()));
        case "skippedEntries":
            return Optional.ofNullable(clazz.cast(skippedEntries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyValueResponse, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyValueResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetAssetPropertyValueResponse> {
        /**
         * <p>
         * A list of the errors (if any) associated with the batch request. Each error entry contains the
         * <code>entryId</code> of the entry that failed.
         * </p>
         * 
         * @param errorEntries
         *        A list of the errors (if any) associated with the batch request. Each error entry contains the
         *        <code>entryId</code> of the entry that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorEntries(Collection<BatchGetAssetPropertyValueErrorEntry> errorEntries);

        /**
         * <p>
         * A list of the errors (if any) associated with the batch request. Each error entry contains the
         * <code>entryId</code> of the entry that failed.
         * </p>
         * 
         * @param errorEntries
         *        A list of the errors (if any) associated with the batch request. Each error entry contains the
         *        <code>entryId</code> of the entry that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorEntries(BatchGetAssetPropertyValueErrorEntry... errorEntries);

        /**
         * <p>
         * A list of the errors (if any) associated with the batch request. Each error entry contains the
         * <code>entryId</code> of the entry that failed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #errorEntries(List<BatchGetAssetPropertyValueErrorEntry>)}.
         * 
         * @param errorEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorEntries(java.util.Collection<BatchGetAssetPropertyValueErrorEntry>)
         */
        Builder errorEntries(Consumer<BatchGetAssetPropertyValueErrorEntry.Builder>... errorEntries);

        /**
         * <p>
         * A list of entries that were processed successfully by this batch request. Each success entry contains the
         * <code>entryId</code> of the entry that succeeded and the latest query result.
         * </p>
         * 
         * @param successEntries
         *        A list of entries that were processed successfully by this batch request. Each success entry contains
         *        the <code>entryId</code> of the entry that succeeded and the latest query result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successEntries(Collection<BatchGetAssetPropertyValueSuccessEntry> successEntries);

        /**
         * <p>
         * A list of entries that were processed successfully by this batch request. Each success entry contains the
         * <code>entryId</code> of the entry that succeeded and the latest query result.
         * </p>
         * 
         * @param successEntries
         *        A list of entries that were processed successfully by this batch request. Each success entry contains
         *        the <code>entryId</code> of the entry that succeeded and the latest query result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successEntries(BatchGetAssetPropertyValueSuccessEntry... successEntries);

        /**
         * <p>
         * A list of entries that were processed successfully by this batch request. Each success entry contains the
         * <code>entryId</code> of the entry that succeeded and the latest query result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #successEntries(List<BatchGetAssetPropertyValueSuccessEntry>)}.
         * 
         * @param successEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSuccessEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successEntries(java.util.Collection<BatchGetAssetPropertyValueSuccessEntry>)
         */
        Builder successEntries(Consumer<BatchGetAssetPropertyValueSuccessEntry.Builder>... successEntries);

        /**
         * <p>
         * A list of entries that were not processed by this batch request. because these entries had been completely
         * processed by previous paginated requests. Each skipped entry contains the <code>entryId</code> of the entry
         * that skipped.
         * </p>
         * 
         * @param skippedEntries
         *        A list of entries that were not processed by this batch request. because these entries had been
         *        completely processed by previous paginated requests. Each skipped entry contains the
         *        <code>entryId</code> of the entry that skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skippedEntries(Collection<BatchGetAssetPropertyValueSkippedEntry> skippedEntries);

        /**
         * <p>
         * A list of entries that were not processed by this batch request. because these entries had been completely
         * processed by previous paginated requests. Each skipped entry contains the <code>entryId</code> of the entry
         * that skipped.
         * </p>
         * 
         * @param skippedEntries
         *        A list of entries that were not processed by this batch request. because these entries had been
         *        completely processed by previous paginated requests. Each skipped entry contains the
         *        <code>entryId</code> of the entry that skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skippedEntries(BatchGetAssetPropertyValueSkippedEntry... skippedEntries);

        /**
         * <p>
         * A list of entries that were not processed by this batch request. because these entries had been completely
         * processed by previous paginated requests. Each skipped entry contains the <code>entryId</code> of the entry
         * that skipped.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSkippedEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSkippedEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSkippedEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #skippedEntries(List<BatchGetAssetPropertyValueSkippedEntry>)}.
         * 
         * @param skippedEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueSkippedEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #skippedEntries(java.util.Collection<BatchGetAssetPropertyValueSkippedEntry>)
         */
        Builder skippedEntries(Consumer<BatchGetAssetPropertyValueSkippedEntry.Builder>... skippedEntries);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private List<BatchGetAssetPropertyValueErrorEntry> errorEntries = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetAssetPropertyValueSuccessEntry> successEntries = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetAssetPropertyValueSkippedEntry> skippedEntries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyValueResponse model) {
            super(model);
            errorEntries(model.errorEntries);
            successEntries(model.successEntries);
            skippedEntries(model.skippedEntries);
            nextToken(model.nextToken);
        }

        public final List<BatchGetAssetPropertyValueErrorEntry.Builder> getErrorEntries() {
            List<BatchGetAssetPropertyValueErrorEntry.Builder> result = BatchGetAssetPropertyValueErrorEntriesCopier
                    .copyToBuilder(this.errorEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorEntries(Collection<BatchGetAssetPropertyValueErrorEntry.BuilderImpl> errorEntries) {
            this.errorEntries = BatchGetAssetPropertyValueErrorEntriesCopier.copyFromBuilder(errorEntries);
        }

        @Override
        public final Builder errorEntries(Collection<BatchGetAssetPropertyValueErrorEntry> errorEntries) {
            this.errorEntries = BatchGetAssetPropertyValueErrorEntriesCopier.copy(errorEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(BatchGetAssetPropertyValueErrorEntry... errorEntries) {
            errorEntries(Arrays.asList(errorEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(Consumer<BatchGetAssetPropertyValueErrorEntry.Builder>... errorEntries) {
            errorEntries(Stream.of(errorEntries)
                    .map(c -> BatchGetAssetPropertyValueErrorEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetAssetPropertyValueSuccessEntry.Builder> getSuccessEntries() {
            List<BatchGetAssetPropertyValueSuccessEntry.Builder> result = BatchGetAssetPropertyValueSuccessEntriesCopier
                    .copyToBuilder(this.successEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessEntries(Collection<BatchGetAssetPropertyValueSuccessEntry.BuilderImpl> successEntries) {
            this.successEntries = BatchGetAssetPropertyValueSuccessEntriesCopier.copyFromBuilder(successEntries);
        }

        @Override
        public final Builder successEntries(Collection<BatchGetAssetPropertyValueSuccessEntry> successEntries) {
            this.successEntries = BatchGetAssetPropertyValueSuccessEntriesCopier.copy(successEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successEntries(BatchGetAssetPropertyValueSuccessEntry... successEntries) {
            successEntries(Arrays.asList(successEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successEntries(Consumer<BatchGetAssetPropertyValueSuccessEntry.Builder>... successEntries) {
            successEntries(Stream.of(successEntries)
                    .map(c -> BatchGetAssetPropertyValueSuccessEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetAssetPropertyValueSkippedEntry.Builder> getSkippedEntries() {
            List<BatchGetAssetPropertyValueSkippedEntry.Builder> result = BatchGetAssetPropertyValueSkippedEntriesCopier
                    .copyToBuilder(this.skippedEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSkippedEntries(Collection<BatchGetAssetPropertyValueSkippedEntry.BuilderImpl> skippedEntries) {
            this.skippedEntries = BatchGetAssetPropertyValueSkippedEntriesCopier.copyFromBuilder(skippedEntries);
        }

        @Override
        public final Builder skippedEntries(Collection<BatchGetAssetPropertyValueSkippedEntry> skippedEntries) {
            this.skippedEntries = BatchGetAssetPropertyValueSkippedEntriesCopier.copy(skippedEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedEntries(BatchGetAssetPropertyValueSkippedEntry... skippedEntries) {
            skippedEntries(Arrays.asList(skippedEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedEntries(Consumer<BatchGetAssetPropertyValueSkippedEntry.Builder>... skippedEntries) {
            skippedEntries(Stream.of(skippedEntries)
                    .map(c -> BatchGetAssetPropertyValueSkippedEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public BatchGetAssetPropertyValueResponse build() {
            return new BatchGetAssetPropertyValueResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
