/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.ErrorReportLocation;
import software.amazon.awssdk.services.iotsitewise.model.File;
import software.amazon.awssdk.services.iotsitewise.model.FilesCopier;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.JobConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBulkImportJobRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, CreateBulkImportJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(CreateBulkImportJobRequest.getter(CreateBulkImportJobRequest::jobName)).setter(CreateBulkImportJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> JOB_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobRoleArn").getter(CreateBulkImportJobRequest.getter(CreateBulkImportJobRequest::jobRoleArn)).setter(CreateBulkImportJobRequest.setter(Builder::jobRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRoleArn").build()}).build();
    private static final SdkField<List<File>> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("files").getter(CreateBulkImportJobRequest.getter(CreateBulkImportJobRequest::files)).setter(CreateBulkImportJobRequest.setter(Builder::files)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(File::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ErrorReportLocation> ERROR_REPORT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorReportLocation").getter(CreateBulkImportJobRequest.getter(CreateBulkImportJobRequest::errorReportLocation)).setter(CreateBulkImportJobRequest.setter(Builder::errorReportLocation)).constructor(ErrorReportLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorReportLocation").build()}).build();
    private static final SdkField<JobConfiguration> JOB_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobConfiguration").getter(CreateBulkImportJobRequest.getter(CreateBulkImportJobRequest::jobConfiguration)).setter(CreateBulkImportJobRequest.setter(Builder::jobConfiguration)).constructor(JobConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobConfiguration").build()}).build();
    private static final SdkField<Boolean> ADAPTIVE_INGESTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("adaptiveIngestion").getter(CreateBulkImportJobRequest.getter(CreateBulkImportJobRequest::adaptiveIngestion)).setter(CreateBulkImportJobRequest.setter(Builder::adaptiveIngestion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveIngestion").build()}).build();
    private static final SdkField<Boolean> DELETE_FILES_AFTER_IMPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deleteFilesAfterImport").getter(CreateBulkImportJobRequest.getter(CreateBulkImportJobRequest::deleteFilesAfterImport)).setter(CreateBulkImportJobRequest.setter(Builder::deleteFilesAfterImport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteFilesAfterImport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, JOB_ROLE_ARN_FIELD, FILES_FIELD, ERROR_REPORT_LOCATION_FIELD, JOB_CONFIGURATION_FIELD, ADAPTIVE_INGESTION_FIELD, DELETE_FILES_AFTER_IMPORT_FIELD));
    private final String jobName;
    private final String jobRoleArn;
    private final List<File> files;
    private final ErrorReportLocation errorReportLocation;
    private final JobConfiguration jobConfiguration;
    private final Boolean adaptiveIngestion;
    private final Boolean deleteFilesAfterImport;

    private CreateBulkImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobRoleArn = builder.jobRoleArn;
        this.files = builder.files;
        this.errorReportLocation = builder.errorReportLocation;
        this.jobConfiguration = builder.jobConfiguration;
        this.adaptiveIngestion = builder.adaptiveIngestion;
        this.deleteFilesAfterImport = builder.deleteFilesAfterImport;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobRoleArn() {
        return this.jobRoleArn;
    }

    public final boolean hasFiles() {
        return this.files != null && !(this.files instanceof SdkAutoConstructList);
    }

    public final List<File> files() {
        return this.files;
    }

    public final ErrorReportLocation errorReportLocation() {
        return this.errorReportLocation;
    }

    public final JobConfiguration jobConfiguration() {
        return this.jobConfiguration;
    }

    public final Boolean adaptiveIngestion() {
        return this.adaptiveIngestion;
    }

    public final Boolean deleteFilesAfterImport() {
        return this.deleteFilesAfterImport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiles() ? this.files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorReportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveIngestion());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteFilesAfterImport());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBulkImportJobRequest)) {
            return false;
        }
        CreateBulkImportJobRequest other = (CreateBulkImportJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobRoleArn(), other.jobRoleArn()) && this.hasFiles() == other.hasFiles() && Objects.equals(this.files(), other.files()) && Objects.equals(this.errorReportLocation(), other.errorReportLocation()) && Objects.equals(this.jobConfiguration(), other.jobConfiguration()) && Objects.equals(this.adaptiveIngestion(), other.adaptiveIngestion()) && Objects.equals(this.deleteFilesAfterImport(), other.deleteFilesAfterImport());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBulkImportJobRequest").add("JobName", (Object)this.jobName()).add("JobRoleArn", (Object)this.jobRoleArn()).add("Files", this.hasFiles() ? this.files() : null).add("ErrorReportLocation", (Object)this.errorReportLocation()).add("JobConfiguration", (Object)this.jobConfiguration()).add("AdaptiveIngestion", (Object)this.adaptiveIngestion()).add("DeleteFilesAfterImport", (Object)this.deleteFilesAfterImport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "jobRoleArn": {
                return Optional.ofNullable(clazz.cast(this.jobRoleArn()));
            }
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "errorReportLocation": {
                return Optional.ofNullable(clazz.cast(this.errorReportLocation()));
            }
            case "jobConfiguration": {
                return Optional.ofNullable(clazz.cast(this.jobConfiguration()));
            }
            case "adaptiveIngestion": {
                return Optional.ofNullable(clazz.cast(this.adaptiveIngestion()));
            }
            case "deleteFilesAfterImport": {
                return Optional.ofNullable(clazz.cast(this.deleteFilesAfterImport()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBulkImportJobRequest, T> g) {
        return obj -> g.apply((CreateBulkImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String jobRoleArn;
        private List<File> files = DefaultSdkAutoConstructList.getInstance();
        private ErrorReportLocation errorReportLocation;
        private JobConfiguration jobConfiguration;
        private Boolean adaptiveIngestion;
        private Boolean deleteFilesAfterImport;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBulkImportJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.jobRoleArn(model.jobRoleArn);
            this.files(model.files);
            this.errorReportLocation(model.errorReportLocation);
            this.jobConfiguration(model.jobConfiguration);
            this.adaptiveIngestion(model.adaptiveIngestion);
            this.deleteFilesAfterImport(model.deleteFilesAfterImport);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobRoleArn() {
            return this.jobRoleArn;
        }

        public final void setJobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
        }

        @Override
        public final Builder jobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
            return this;
        }

        public final List<File.Builder> getFiles() {
            List<File.Builder> result = FilesCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<File.BuilderImpl> files) {
            this.files = FilesCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<File> files) {
            this.files = FilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(File ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<File.Builder> ... files) {
            this.files(Stream.of(files).map(c -> (File)((File.Builder)File.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ErrorReportLocation.Builder getErrorReportLocation() {
            return this.errorReportLocation != null ? this.errorReportLocation.toBuilder() : null;
        }

        public final void setErrorReportLocation(ErrorReportLocation.BuilderImpl errorReportLocation) {
            this.errorReportLocation = errorReportLocation != null ? errorReportLocation.build() : null;
        }

        @Override
        public final Builder errorReportLocation(ErrorReportLocation errorReportLocation) {
            this.errorReportLocation = errorReportLocation;
            return this;
        }

        public final JobConfiguration.Builder getJobConfiguration() {
            return this.jobConfiguration != null ? this.jobConfiguration.toBuilder() : null;
        }

        public final void setJobConfiguration(JobConfiguration.BuilderImpl jobConfiguration) {
            this.jobConfiguration = jobConfiguration != null ? jobConfiguration.build() : null;
        }

        @Override
        public final Builder jobConfiguration(JobConfiguration jobConfiguration) {
            this.jobConfiguration = jobConfiguration;
            return this;
        }

        public final Boolean getAdaptiveIngestion() {
            return this.adaptiveIngestion;
        }

        public final void setAdaptiveIngestion(Boolean adaptiveIngestion) {
            this.adaptiveIngestion = adaptiveIngestion;
        }

        @Override
        public final Builder adaptiveIngestion(Boolean adaptiveIngestion) {
            this.adaptiveIngestion = adaptiveIngestion;
            return this;
        }

        public final Boolean getDeleteFilesAfterImport() {
            return this.deleteFilesAfterImport;
        }

        public final void setDeleteFilesAfterImport(Boolean deleteFilesAfterImport) {
            this.deleteFilesAfterImport = deleteFilesAfterImport;
        }

        @Override
        public final Builder deleteFilesAfterImport(Boolean deleteFilesAfterImport) {
            this.deleteFilesAfterImport = deleteFilesAfterImport;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBulkImportJobRequest build() {
            return new CreateBulkImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBulkImportJobRequest> {
        public Builder jobName(String var1);

        public Builder jobRoleArn(String var1);

        public Builder files(Collection<File> var1);

        public Builder files(File ... var1);

        public Builder files(Consumer<File.Builder> ... var1);

        public Builder errorReportLocation(ErrorReportLocation var1);

        default public Builder errorReportLocation(Consumer<ErrorReportLocation.Builder> errorReportLocation) {
            return this.errorReportLocation((ErrorReportLocation)((ErrorReportLocation.Builder)ErrorReportLocation.builder().applyMutation(errorReportLocation)).build());
        }

        public Builder jobConfiguration(JobConfiguration var1);

        default public Builder jobConfiguration(Consumer<JobConfiguration.Builder> jobConfiguration) {
            return this.jobConfiguration((JobConfiguration)((JobConfiguration.Builder)JobConfiguration.builder().applyMutation(jobConfiguration)).build());
        }

        public Builder adaptiveIngestion(Boolean var1);

        public Builder deleteFilesAfterImport(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

