/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateAssetsRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<DisassociateAssetsRequest.Builder, DisassociateAssetsRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(DisassociateAssetsRequest::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetId").build()).build();

    private static final SdkField<String> HIERARCHY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hierarchyId").getter(getter(DisassociateAssetsRequest::hierarchyId))
            .setter(setter(Builder::hierarchyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hierarchyId").build()).build();

    private static final SdkField<String> CHILD_ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("childAssetId").getter(getter(DisassociateAssetsRequest::childAssetId))
            .setter(setter(Builder::childAssetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childAssetId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(DisassociateAssetsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            HIERARCHY_ID_FIELD, CHILD_ASSET_ID_FIELD, CLIENT_TOKEN_FIELD));

    private final String assetId;

    private final String hierarchyId;

    private final String childAssetId;

    private final String clientToken;

    private DisassociateAssetsRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.hierarchyId = builder.hierarchyId;
        this.childAssetId = builder.childAssetId;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the parent asset from which to disassociate the child asset. This can be either the actual ID in UUID
     * format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     * href
     * ="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing
     * objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the parent asset from which to disassociate the child asset. This can be either the actual ID
     *         in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     *         >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The ID of a hierarchy in the parent asset's model. (This can be either the actual ID in UUID format, or else
     * <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.) Hierarchies allow different
     * groupings of assets to be formed that all come from the same asset model. You can use the hierarchy ID to
     * identify the correct asset to disassociate. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of a hierarchy in the parent asset's model. (This can be either the actual ID in UUID format, or
     *         else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">
     *         Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.) Hierarchies allow
     *         different groupings of assets to be formed that all come from the same asset model. You can use the
     *         hierarchy ID to identify the correct asset to disassociate. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
     *         hierarchies</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String hierarchyId() {
        return hierarchyId;
    }

    /**
     * <p>
     * The ID of the child asset to disassociate. This can be either the actual ID in UUID format, or else
     * <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the child asset to disassociate. This can be either the actual ID in UUID format, or else
     *         <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     *         >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String childAssetId() {
        return childAssetId;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyId());
        hashCode = 31 * hashCode + Objects.hashCode(childAssetId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateAssetsRequest)) {
            return false;
        }
        DisassociateAssetsRequest other = (DisassociateAssetsRequest) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(hierarchyId(), other.hierarchyId())
                && Objects.equals(childAssetId(), other.childAssetId()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateAssetsRequest").add("AssetId", assetId()).add("HierarchyId", hierarchyId())
                .add("ChildAssetId", childAssetId()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "hierarchyId":
            return Optional.ofNullable(clazz.cast(hierarchyId()));
        case "childAssetId":
            return Optional.ofNullable(clazz.cast(childAssetId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateAssetsRequest, T> g) {
        return obj -> g.apply((DisassociateAssetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateAssetsRequest> {
        /**
         * <p>
         * The ID of the parent asset from which to disassociate the child asset. This can be either the actual ID in
         * UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetId
         *        The ID of the parent asset from which to disassociate the child asset. This can be either the actual
         *        ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The ID of a hierarchy in the parent asset's model. (This can be either the actual ID in UUID format, or else
         * <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.) Hierarchies allow
         * different groupings of assets to be formed that all come from the same asset model. You can use the hierarchy
         * ID to identify the correct asset to disassociate. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param hierarchyId
         *        The ID of a hierarchy in the parent asset's model. (This can be either the actual ID in UUID format,
         *        or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.) Hierarchies allow
         *        different groupings of assets to be formed that all come from the same asset model. You can use the
         *        hierarchy ID to identify the correct asset to disassociate. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
         *        hierarchies</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyId(String hierarchyId);

        /**
         * <p>
         * The ID of the child asset to disassociate. This can be either the actual ID in UUID format, or else
         * <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param childAssetId
         *        The ID of the child asset to disassociate. This can be either the actual ID in UUID format, or else
         *        <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childAssetId(String childAssetId);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetId;

        private String hierarchyId;

        private String childAssetId;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateAssetsRequest model) {
            super(model);
            assetId(model.assetId);
            hierarchyId(model.hierarchyId);
            childAssetId(model.childAssetId);
            clientToken(model.clientToken);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getHierarchyId() {
            return hierarchyId;
        }

        public final void setHierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
        }

        @Override
        public final Builder hierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
            return this;
        }

        public final String getChildAssetId() {
            return childAssetId;
        }

        public final void setChildAssetId(String childAssetId) {
            this.childAssetId = childAssetId;
        }

        @Override
        public final Builder childAssetId(String childAssetId) {
            this.childAssetId = childAssetId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateAssetsRequest build() {
            return new DisassociateAssetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
