/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBulkImportJobResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeBulkImportJobResponse.Builder, DescribeBulkImportJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(DescribeBulkImportJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(DescribeBulkImportJobResponse::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobStatus").getter(getter(DescribeBulkImportJobResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final SdkField<String> JOB_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobRoleArn").getter(getter(DescribeBulkImportJobResponse::jobRoleArn))
            .setter(setter(Builder::jobRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRoleArn").build()).build();

    private static final SdkField<List<File>> FILES_FIELD = SdkField
            .<List<File>> builder(MarshallingType.LIST)
            .memberName("files")
            .getter(getter(DescribeBulkImportJobResponse::files))
            .setter(setter(Builder::files))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<File> builder(MarshallingType.SDK_POJO)
                                            .constructor(File::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ErrorReportLocation> ERROR_REPORT_LOCATION_FIELD = SdkField
            .<ErrorReportLocation> builder(MarshallingType.SDK_POJO).memberName("errorReportLocation")
            .getter(getter(DescribeBulkImportJobResponse::errorReportLocation)).setter(setter(Builder::errorReportLocation))
            .constructor(ErrorReportLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorReportLocation").build())
            .build();

    private static final SdkField<JobConfiguration> JOB_CONFIGURATION_FIELD = SdkField
            .<JobConfiguration> builder(MarshallingType.SDK_POJO).memberName("jobConfiguration")
            .getter(getter(DescribeBulkImportJobResponse::jobConfiguration)).setter(setter(Builder::jobConfiguration))
            .constructor(JobConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobConfiguration").build()).build();

    private static final SdkField<Instant> JOB_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("jobCreationDate").getter(getter(DescribeBulkImportJobResponse::jobCreationDate))
            .setter(setter(Builder::jobCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobCreationDate").build()).build();

    private static final SdkField<Instant> JOB_LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("jobLastUpdateDate").getter(getter(DescribeBulkImportJobResponse::jobLastUpdateDate))
            .setter(setter(Builder::jobLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobLastUpdateDate").build()).build();

    private static final SdkField<Boolean> ADAPTIVE_INGESTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("adaptiveIngestion").getter(getter(DescribeBulkImportJobResponse::adaptiveIngestion))
            .setter(setter(Builder::adaptiveIngestion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveIngestion").build()).build();

    private static final SdkField<Boolean> DELETE_FILES_AFTER_IMPORT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteFilesAfterImport").getter(getter(DescribeBulkImportJobResponse::deleteFilesAfterImport))
            .setter(setter(Builder::deleteFilesAfterImport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteFilesAfterImport").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_NAME_FIELD,
            JOB_STATUS_FIELD, JOB_ROLE_ARN_FIELD, FILES_FIELD, ERROR_REPORT_LOCATION_FIELD, JOB_CONFIGURATION_FIELD,
            JOB_CREATION_DATE_FIELD, JOB_LAST_UPDATE_DATE_FIELD, ADAPTIVE_INGESTION_FIELD, DELETE_FILES_AFTER_IMPORT_FIELD));

    private final String jobId;

    private final String jobName;

    private final String jobStatus;

    private final String jobRoleArn;

    private final List<File> files;

    private final ErrorReportLocation errorReportLocation;

    private final JobConfiguration jobConfiguration;

    private final Instant jobCreationDate;

    private final Instant jobLastUpdateDate;

    private final Boolean adaptiveIngestion;

    private final Boolean deleteFilesAfterImport;

    private DescribeBulkImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.jobRoleArn = builder.jobRoleArn;
        this.files = builder.files;
        this.errorReportLocation = builder.errorReportLocation;
        this.jobConfiguration = builder.jobConfiguration;
        this.jobCreationDate = builder.jobCreationDate;
        this.jobLastUpdateDate = builder.jobLastUpdateDate;
        this.adaptiveIngestion = builder.adaptiveIngestion;
        this.deleteFilesAfterImport = builder.deleteFilesAfterImport;
    }

    /**
     * <p>
     * The ID of the job.
     * </p>
     * 
     * @return The ID of the job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The unique name that helps identify the job request.
     * </p>
     * 
     * @return The unique name that helps identify the job request.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The status of the bulk import job can be one of following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> – The bulk import job has been canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use logs
     * saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with
     * errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the bulk import job can be one of following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> – The bulk import job has been canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can
     *         use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3
     *         with errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot
     *         issues.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The status of the bulk import job can be one of following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> – The bulk import job has been canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use logs
     * saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with
     * errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the bulk import job can be one of following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> – The bulk import job has been canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can
     *         use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3
     *         with errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot
     *         issues.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IAM role
     * that allows IoT SiteWise to read Amazon S3 data.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         IAM role that allows IoT SiteWise to read Amazon S3 data.
     */
    public final String jobRoleArn() {
        return jobRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Files property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFiles() {
        return files != null && !(files instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The files in the specified Amazon S3 bucket that contain your data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFiles} method.
     * </p>
     * 
     * @return The files in the specified Amazon S3 bucket that contain your data.
     */
    public final List<File> files() {
        return files;
    }

    /**
     * <p>
     * The Amazon S3 destination where errors associated with the job creation request are saved.
     * </p>
     * 
     * @return The Amazon S3 destination where errors associated with the job creation request are saved.
     */
    public final ErrorReportLocation errorReportLocation() {
        return errorReportLocation;
    }

    /**
     * <p>
     * Contains the configuration information of a job, such as the file format used to save data in Amazon S3.
     * </p>
     * 
     * @return Contains the configuration information of a job, such as the file format used to save data in Amazon S3.
     */
    public final JobConfiguration jobConfiguration() {
        return jobConfiguration;
    }

    /**
     * <p>
     * The date the job was created, in Unix epoch TIME.
     * </p>
     * 
     * @return The date the job was created, in Unix epoch TIME.
     */
    public final Instant jobCreationDate() {
        return jobCreationDate;
    }

    /**
     * <p>
     * The date the job was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the job was last updated, in Unix epoch time.
     */
    public final Instant jobLastUpdateDate() {
        return jobLastUpdateDate;
    }

    /**
     * <p>
     * If set to true, ingest new data into IoT SiteWise storage. Measurements with notifications, metrics and
     * transforms are computed. If set to false, historical data is ingested into IoT SiteWise as is.
     * </p>
     * 
     * @return If set to true, ingest new data into IoT SiteWise storage. Measurements with notifications, metrics and
     *         transforms are computed. If set to false, historical data is ingested into IoT SiteWise as is.
     */
    public final Boolean adaptiveIngestion() {
        return adaptiveIngestion;
    }

    /**
     * <p>
     * If set to true, your data files is deleted from S3, after ingestion into IoT SiteWise storage.
     * </p>
     * 
     * @return If set to true, your data files is deleted from S3, after ingestion into IoT SiteWise storage.
     */
    public final Boolean deleteFilesAfterImport() {
        return deleteFilesAfterImport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasFiles() ? files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(errorReportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(jobConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(jobCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(jobLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(adaptiveIngestion());
        hashCode = 31 * hashCode + Objects.hashCode(deleteFilesAfterImport());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBulkImportJobResponse)) {
            return false;
        }
        DescribeBulkImportJobResponse other = (DescribeBulkImportJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(jobRoleArn(), other.jobRoleArn()) && hasFiles() == other.hasFiles()
                && Objects.equals(files(), other.files()) && Objects.equals(errorReportLocation(), other.errorReportLocation())
                && Objects.equals(jobConfiguration(), other.jobConfiguration())
                && Objects.equals(jobCreationDate(), other.jobCreationDate())
                && Objects.equals(jobLastUpdateDate(), other.jobLastUpdateDate())
                && Objects.equals(adaptiveIngestion(), other.adaptiveIngestion())
                && Objects.equals(deleteFilesAfterImport(), other.deleteFilesAfterImport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBulkImportJobResponse").add("JobId", jobId()).add("JobName", jobName())
                .add("JobStatus", jobStatusAsString()).add("JobRoleArn", jobRoleArn()).add("Files", hasFiles() ? files() : null)
                .add("ErrorReportLocation", errorReportLocation()).add("JobConfiguration", jobConfiguration())
                .add("JobCreationDate", jobCreationDate()).add("JobLastUpdateDate", jobLastUpdateDate())
                .add("AdaptiveIngestion", adaptiveIngestion()).add("DeleteFilesAfterImport", deleteFilesAfterImport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "jobRoleArn":
            return Optional.ofNullable(clazz.cast(jobRoleArn()));
        case "files":
            return Optional.ofNullable(clazz.cast(files()));
        case "errorReportLocation":
            return Optional.ofNullable(clazz.cast(errorReportLocation()));
        case "jobConfiguration":
            return Optional.ofNullable(clazz.cast(jobConfiguration()));
        case "jobCreationDate":
            return Optional.ofNullable(clazz.cast(jobCreationDate()));
        case "jobLastUpdateDate":
            return Optional.ofNullable(clazz.cast(jobLastUpdateDate()));
        case "adaptiveIngestion":
            return Optional.ofNullable(clazz.cast(adaptiveIngestion()));
        case "deleteFilesAfterImport":
            return Optional.ofNullable(clazz.cast(deleteFilesAfterImport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBulkImportJobResponse, T> g) {
        return obj -> g.apply((DescribeBulkImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeBulkImportJobResponse> {
        /**
         * <p>
         * The ID of the job.
         * </p>
         * 
         * @param jobId
         *        The ID of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The unique name that helps identify the job request.
         * </p>
         * 
         * @param jobName
         *        The unique name that helps identify the job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The status of the bulk import job can be one of following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> – The bulk import job has been canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use
         * logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with
         * errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The status of the bulk import job can be one of following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> – The bulk import job has been canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon
         *        S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You
         *        can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon
         *        S3 with errors. You can use logs saved in the specified error report location in Amazon S3 to
         *        troubleshoot issues.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The status of the bulk import job can be one of following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> – The bulk import job has been canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You can use
         * logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with
         * errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The status of the bulk import job can be one of following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> – The bulk import job has been canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon
         *        S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – IoT SiteWise couldn't process your request to import data from Amazon S3. You
         *        can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon
         *        S3 with errors. You can use logs saved in the specified error report location in Amazon S3 to
         *        troubleshoot issues.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IAM
         * role that allows IoT SiteWise to read Amazon S3 data.
         * </p>
         * 
         * @param jobRoleArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the IAM role that allows IoT SiteWise to read Amazon S3 data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRoleArn(String jobRoleArn);

        /**
         * <p>
         * The files in the specified Amazon S3 bucket that contain your data.
         * </p>
         * 
         * @param files
         *        The files in the specified Amazon S3 bucket that contain your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(Collection<File> files);

        /**
         * <p>
         * The files in the specified Amazon S3 bucket that contain your data.
         * </p>
         * 
         * @param files
         *        The files in the specified Amazon S3 bucket that contain your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(File... files);

        /**
         * <p>
         * The files in the specified Amazon S3 bucket that contain your data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.File.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotsitewise.model.File#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.File.Builder#build()} is called immediately and its
         * result is passed to {@link #files(List<File>)}.
         * 
         * @param files
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.File.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #files(java.util.Collection<File>)
         */
        Builder files(Consumer<File.Builder>... files);

        /**
         * <p>
         * The Amazon S3 destination where errors associated with the job creation request are saved.
         * </p>
         * 
         * @param errorReportLocation
         *        The Amazon S3 destination where errors associated with the job creation request are saved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorReportLocation(ErrorReportLocation errorReportLocation);

        /**
         * <p>
         * The Amazon S3 destination where errors associated with the job creation request are saved.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorReportLocation.Builder} avoiding the
         * need to create one manually via {@link ErrorReportLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorReportLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #errorReportLocation(ErrorReportLocation)}.
         * 
         * @param errorReportLocation
         *        a consumer that will call methods on {@link ErrorReportLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorReportLocation(ErrorReportLocation)
         */
        default Builder errorReportLocation(Consumer<ErrorReportLocation.Builder> errorReportLocation) {
            return errorReportLocation(ErrorReportLocation.builder().applyMutation(errorReportLocation).build());
        }

        /**
         * <p>
         * Contains the configuration information of a job, such as the file format used to save data in Amazon S3.
         * </p>
         * 
         * @param jobConfiguration
         *        Contains the configuration information of a job, such as the file format used to save data in Amazon
         *        S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobConfiguration(JobConfiguration jobConfiguration);

        /**
         * <p>
         * Contains the configuration information of a job, such as the file format used to save data in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobConfiguration.Builder} avoiding the
         * need to create one manually via {@link JobConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #jobConfiguration(JobConfiguration)}.
         * 
         * @param jobConfiguration
         *        a consumer that will call methods on {@link JobConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobConfiguration(JobConfiguration)
         */
        default Builder jobConfiguration(Consumer<JobConfiguration.Builder> jobConfiguration) {
            return jobConfiguration(JobConfiguration.builder().applyMutation(jobConfiguration).build());
        }

        /**
         * <p>
         * The date the job was created, in Unix epoch TIME.
         * </p>
         * 
         * @param jobCreationDate
         *        The date the job was created, in Unix epoch TIME.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobCreationDate(Instant jobCreationDate);

        /**
         * <p>
         * The date the job was last updated, in Unix epoch time.
         * </p>
         * 
         * @param jobLastUpdateDate
         *        The date the job was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobLastUpdateDate(Instant jobLastUpdateDate);

        /**
         * <p>
         * If set to true, ingest new data into IoT SiteWise storage. Measurements with notifications, metrics and
         * transforms are computed. If set to false, historical data is ingested into IoT SiteWise as is.
         * </p>
         * 
         * @param adaptiveIngestion
         *        If set to true, ingest new data into IoT SiteWise storage. Measurements with notifications, metrics
         *        and transforms are computed. If set to false, historical data is ingested into IoT SiteWise as is.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adaptiveIngestion(Boolean adaptiveIngestion);

        /**
         * <p>
         * If set to true, your data files is deleted from S3, after ingestion into IoT SiteWise storage.
         * </p>
         * 
         * @param deleteFilesAfterImport
         *        If set to true, your data files is deleted from S3, after ingestion into IoT SiteWise storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteFilesAfterImport(Boolean deleteFilesAfterImport);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String jobId;

        private String jobName;

        private String jobStatus;

        private String jobRoleArn;

        private List<File> files = DefaultSdkAutoConstructList.getInstance();

        private ErrorReportLocation errorReportLocation;

        private JobConfiguration jobConfiguration;

        private Instant jobCreationDate;

        private Instant jobLastUpdateDate;

        private Boolean adaptiveIngestion;

        private Boolean deleteFilesAfterImport;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBulkImportJobResponse model) {
            super(model);
            jobId(model.jobId);
            jobName(model.jobName);
            jobStatus(model.jobStatus);
            jobRoleArn(model.jobRoleArn);
            files(model.files);
            errorReportLocation(model.errorReportLocation);
            jobConfiguration(model.jobConfiguration);
            jobCreationDate(model.jobCreationDate);
            jobLastUpdateDate(model.jobLastUpdateDate);
            adaptiveIngestion(model.adaptiveIngestion);
            deleteFilesAfterImport(model.deleteFilesAfterImport);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getJobRoleArn() {
            return jobRoleArn;
        }

        public final void setJobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
        }

        @Override
        public final Builder jobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
            return this;
        }

        public final List<File.Builder> getFiles() {
            List<File.Builder> result = FilesCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<File.BuilderImpl> files) {
            this.files = FilesCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<File> files) {
            this.files = FilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(File... files) {
            files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<File.Builder>... files) {
            files(Stream.of(files).map(c -> File.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ErrorReportLocation.Builder getErrorReportLocation() {
            return errorReportLocation != null ? errorReportLocation.toBuilder() : null;
        }

        public final void setErrorReportLocation(ErrorReportLocation.BuilderImpl errorReportLocation) {
            this.errorReportLocation = errorReportLocation != null ? errorReportLocation.build() : null;
        }

        @Override
        public final Builder errorReportLocation(ErrorReportLocation errorReportLocation) {
            this.errorReportLocation = errorReportLocation;
            return this;
        }

        public final JobConfiguration.Builder getJobConfiguration() {
            return jobConfiguration != null ? jobConfiguration.toBuilder() : null;
        }

        public final void setJobConfiguration(JobConfiguration.BuilderImpl jobConfiguration) {
            this.jobConfiguration = jobConfiguration != null ? jobConfiguration.build() : null;
        }

        @Override
        public final Builder jobConfiguration(JobConfiguration jobConfiguration) {
            this.jobConfiguration = jobConfiguration;
            return this;
        }

        public final Instant getJobCreationDate() {
            return jobCreationDate;
        }

        public final void setJobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
        }

        @Override
        public final Builder jobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
            return this;
        }

        public final Instant getJobLastUpdateDate() {
            return jobLastUpdateDate;
        }

        public final void setJobLastUpdateDate(Instant jobLastUpdateDate) {
            this.jobLastUpdateDate = jobLastUpdateDate;
        }

        @Override
        public final Builder jobLastUpdateDate(Instant jobLastUpdateDate) {
            this.jobLastUpdateDate = jobLastUpdateDate;
            return this;
        }

        public final Boolean getAdaptiveIngestion() {
            return adaptiveIngestion;
        }

        public final void setAdaptiveIngestion(Boolean adaptiveIngestion) {
            this.adaptiveIngestion = adaptiveIngestion;
        }

        @Override
        public final Builder adaptiveIngestion(Boolean adaptiveIngestion) {
            this.adaptiveIngestion = adaptiveIngestion;
            return this;
        }

        public final Boolean getDeleteFilesAfterImport() {
            return deleteFilesAfterImport;
        }

        public final void setDeleteFilesAfterImport(Boolean deleteFilesAfterImport) {
            this.deleteFilesAfterImport = deleteFilesAfterImport;
        }

        @Override
        public final Builder deleteFilesAfterImport(Boolean deleteFilesAfterImport) {
            this.deleteFilesAfterImport = deleteFilesAfterImport;
            return this;
        }

        @Override
        public DescribeBulkImportJobResponse build() {
            return new DescribeBulkImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
