/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteActionRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<ExecuteActionRequest.Builder, ExecuteActionRequest> {
    private static final SdkField<TargetResource> TARGET_RESOURCE_FIELD = SdkField
            .<TargetResource> builder(MarshallingType.SDK_POJO).memberName("targetResource")
            .getter(getter(ExecuteActionRequest::targetResource)).setter(setter(Builder::targetResource))
            .constructor(TargetResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResource").build()).build();

    private static final SdkField<String> ACTION_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionDefinitionId").getter(getter(ExecuteActionRequest::actionDefinitionId))
            .setter(setter(Builder::actionDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionDefinitionId").build())
            .build();

    private static final SdkField<ActionPayload> ACTION_PAYLOAD_FIELD = SdkField
            .<ActionPayload> builder(MarshallingType.SDK_POJO).memberName("actionPayload")
            .getter(getter(ExecuteActionRequest::actionPayload)).setter(setter(Builder::actionPayload))
            .constructor(ActionPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPayload").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(ExecuteActionRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_RESOURCE_FIELD,
            ACTION_DEFINITION_ID_FIELD, ACTION_PAYLOAD_FIELD, CLIENT_TOKEN_FIELD));

    private final TargetResource targetResource;

    private final String actionDefinitionId;

    private final ActionPayload actionPayload;

    private final String clientToken;

    private ExecuteActionRequest(BuilderImpl builder) {
        super(builder);
        this.targetResource = builder.targetResource;
        this.actionDefinitionId = builder.actionDefinitionId;
        this.actionPayload = builder.actionPayload;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The resource the action will be taken on.
     * </p>
     * 
     * @return The resource the action will be taken on.
     */
    public final TargetResource targetResource() {
        return targetResource;
    }

    /**
     * <p>
     * The ID of the action definition.
     * </p>
     * 
     * @return The ID of the action definition.
     */
    public final String actionDefinitionId() {
        return actionDefinitionId;
    }

    /**
     * <p>
     * The JSON payload of the action.
     * </p>
     * 
     * @return The JSON payload of the action.
     */
    public final ActionPayload actionPayload() {
        return actionPayload;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetResource());
        hashCode = 31 * hashCode + Objects.hashCode(actionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(actionPayload());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteActionRequest)) {
            return false;
        }
        ExecuteActionRequest other = (ExecuteActionRequest) obj;
        return Objects.equals(targetResource(), other.targetResource())
                && Objects.equals(actionDefinitionId(), other.actionDefinitionId())
                && Objects.equals(actionPayload(), other.actionPayload()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteActionRequest").add("TargetResource", targetResource())
                .add("ActionDefinitionId", actionDefinitionId()).add("ActionPayload", actionPayload())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetResource":
            return Optional.ofNullable(clazz.cast(targetResource()));
        case "actionDefinitionId":
            return Optional.ofNullable(clazz.cast(actionDefinitionId()));
        case "actionPayload":
            return Optional.ofNullable(clazz.cast(actionPayload()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteActionRequest, T> g) {
        return obj -> g.apply((ExecuteActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteActionRequest> {
        /**
         * <p>
         * The resource the action will be taken on.
         * </p>
         * 
         * @param targetResource
         *        The resource the action will be taken on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResource(TargetResource targetResource);

        /**
         * <p>
         * The resource the action will be taken on.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetResource.Builder} avoiding the need
         * to create one manually via {@link TargetResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetResource.Builder#build()} is called immediately and its
         * result is passed to {@link #targetResource(TargetResource)}.
         * 
         * @param targetResource
         *        a consumer that will call methods on {@link TargetResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetResource(TargetResource)
         */
        default Builder targetResource(Consumer<TargetResource.Builder> targetResource) {
            return targetResource(TargetResource.builder().applyMutation(targetResource).build());
        }

        /**
         * <p>
         * The ID of the action definition.
         * </p>
         * 
         * @param actionDefinitionId
         *        The ID of the action definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDefinitionId(String actionDefinitionId);

        /**
         * <p>
         * The JSON payload of the action.
         * </p>
         * 
         * @param actionPayload
         *        The JSON payload of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionPayload(ActionPayload actionPayload);

        /**
         * <p>
         * The JSON payload of the action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionPayload.Builder} avoiding the need
         * to create one manually via {@link ActionPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionPayload.Builder#build()} is called immediately and its
         * result is passed to {@link #actionPayload(ActionPayload)}.
         * 
         * @param actionPayload
         *        a consumer that will call methods on {@link ActionPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionPayload(ActionPayload)
         */
        default Builder actionPayload(Consumer<ActionPayload.Builder> actionPayload) {
            return actionPayload(ActionPayload.builder().applyMutation(actionPayload).build());
        }

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private TargetResource targetResource;

        private String actionDefinitionId;

        private ActionPayload actionPayload;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteActionRequest model) {
            super(model);
            targetResource(model.targetResource);
            actionDefinitionId(model.actionDefinitionId);
            actionPayload(model.actionPayload);
            clientToken(model.clientToken);
        }

        public final TargetResource.Builder getTargetResource() {
            return targetResource != null ? targetResource.toBuilder() : null;
        }

        public final void setTargetResource(TargetResource.BuilderImpl targetResource) {
            this.targetResource = targetResource != null ? targetResource.build() : null;
        }

        @Override
        public final Builder targetResource(TargetResource targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public final String getActionDefinitionId() {
            return actionDefinitionId;
        }

        public final void setActionDefinitionId(String actionDefinitionId) {
            this.actionDefinitionId = actionDefinitionId;
        }

        @Override
        public final Builder actionDefinitionId(String actionDefinitionId) {
            this.actionDefinitionId = actionDefinitionId;
            return this;
        }

        public final ActionPayload.Builder getActionPayload() {
            return actionPayload != null ? actionPayload.toBuilder() : null;
        }

        public final void setActionPayload(ActionPayload.BuilderImpl actionPayload) {
            this.actionPayload = actionPayload != null ? actionPayload.build() : null;
        }

        @Override
        public final Builder actionPayload(ActionPayload actionPayload) {
            this.actionPayload = actionPayload;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteActionRequest build() {
            return new ExecuteActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
