/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTimeSeriesRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<ListTimeSeriesRequest.Builder, ListTimeSeriesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTimeSeriesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListTimeSeriesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(ListTimeSeriesRequest::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetId").build()).build();

    private static final SdkField<String> ALIAS_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aliasPrefix").getter(getter(ListTimeSeriesRequest::aliasPrefix)).setter(setter(Builder::aliasPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("aliasPrefix").build()).build();

    private static final SdkField<String> TIME_SERIES_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeSeriesType").getter(getter(ListTimeSeriesRequest::timeSeriesTypeAsString))
            .setter(setter(Builder::timeSeriesType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("timeSeriesType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, ASSET_ID_FIELD, ALIAS_PREFIX_FIELD, TIME_SERIES_TYPE_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String assetId;

    private final String aliasPrefix;

    private final String timeSeriesType;

    private ListTimeSeriesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.assetId = builder.assetId;
        this.aliasPrefix = builder.aliasPrefix;
        this.timeSeriesType = builder.timeSeriesType;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return for each paginated request.
     * </p>
     * 
     * @return The maximum number of results to return for each paginated request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The ID of the asset in which the asset property was created. This can be either the actual ID in UUID format, or
     * else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the asset in which the asset property was created. This can be either the actual ID in UUID
     *         format, or else <code>externalId:</code> followed by the external ID, if it has one. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     *         >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The alias prefix of the time series.
     * </p>
     * 
     * @return The alias prefix of the time series.
     */
    public final String aliasPrefix() {
        return aliasPrefix;
    }

    /**
     * <p>
     * The type of the time series. The time series type can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASSOCIATED</code> – The time series is associated with an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISASSOCIATED</code> – The time series isn't associated with any asset property.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeSeriesType}
     * will return {@link ListTimeSeriesType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeSeriesTypeAsString}.
     * </p>
     * 
     * @return The type of the time series. The time series type can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASSOCIATED</code> – The time series is associated with an asset property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISASSOCIATED</code> – The time series isn't associated with any asset property.
     *         </p>
     *         </li>
     * @see ListTimeSeriesType
     */
    public final ListTimeSeriesType timeSeriesType() {
        return ListTimeSeriesType.fromValue(timeSeriesType);
    }

    /**
     * <p>
     * The type of the time series. The time series type can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASSOCIATED</code> – The time series is associated with an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISASSOCIATED</code> – The time series isn't associated with any asset property.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeSeriesType}
     * will return {@link ListTimeSeriesType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeSeriesTypeAsString}.
     * </p>
     * 
     * @return The type of the time series. The time series type can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASSOCIATED</code> – The time series is associated with an asset property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISASSOCIATED</code> – The time series isn't associated with any asset property.
     *         </p>
     *         </li>
     * @see ListTimeSeriesType
     */
    public final String timeSeriesTypeAsString() {
        return timeSeriesType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(aliasPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTimeSeriesRequest)) {
            return false;
        }
        ListTimeSeriesRequest other = (ListTimeSeriesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(assetId(), other.assetId()) && Objects.equals(aliasPrefix(), other.aliasPrefix())
                && Objects.equals(timeSeriesTypeAsString(), other.timeSeriesTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTimeSeriesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("AssetId", assetId()).add("AliasPrefix", aliasPrefix()).add("TimeSeriesType", timeSeriesTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "aliasPrefix":
            return Optional.ofNullable(clazz.cast(aliasPrefix()));
        case "timeSeriesType":
            return Optional.ofNullable(clazz.cast(timeSeriesTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTimeSeriesRequest, T> g) {
        return obj -> g.apply((ListTimeSeriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTimeSeriesRequest> {
        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return for each paginated request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for each paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The ID of the asset in which the asset property was created. This can be either the actual ID in UUID format,
         * or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">
         * Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset in which the asset property was created. This can be either the actual ID in UUID
         *        format, or else <code>externalId:</code> followed by the external ID, if it has one. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The alias prefix of the time series.
         * </p>
         * 
         * @param aliasPrefix
         *        The alias prefix of the time series.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasPrefix(String aliasPrefix);

        /**
         * <p>
         * The type of the time series. The time series type can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASSOCIATED</code> – The time series is associated with an asset property.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISASSOCIATED</code> – The time series isn't associated with any asset property.
         * </p>
         * </li>
         * </ul>
         * 
         * @param timeSeriesType
         *        The type of the time series. The time series type can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASSOCIATED</code> – The time series is associated with an asset property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISASSOCIATED</code> – The time series isn't associated with any asset property.
         *        </p>
         *        </li>
         * @see ListTimeSeriesType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListTimeSeriesType
         */
        Builder timeSeriesType(String timeSeriesType);

        /**
         * <p>
         * The type of the time series. The time series type can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASSOCIATED</code> – The time series is associated with an asset property.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISASSOCIATED</code> – The time series isn't associated with any asset property.
         * </p>
         * </li>
         * </ul>
         * 
         * @param timeSeriesType
         *        The type of the time series. The time series type can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASSOCIATED</code> – The time series is associated with an asset property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISASSOCIATED</code> – The time series isn't associated with any asset property.
         *        </p>
         *        </li>
         * @see ListTimeSeriesType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListTimeSeriesType
         */
        Builder timeSeriesType(ListTimeSeriesType timeSeriesType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String assetId;

        private String aliasPrefix;

        private String timeSeriesType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTimeSeriesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            assetId(model.assetId);
            aliasPrefix(model.aliasPrefix);
            timeSeriesType(model.timeSeriesType);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAliasPrefix() {
            return aliasPrefix;
        }

        public final void setAliasPrefix(String aliasPrefix) {
            this.aliasPrefix = aliasPrefix;
        }

        @Override
        public final Builder aliasPrefix(String aliasPrefix) {
            this.aliasPrefix = aliasPrefix;
            return this;
        }

        public final String getTimeSeriesType() {
            return timeSeriesType;
        }

        public final void setTimeSeriesType(String timeSeriesType) {
            this.timeSeriesType = timeSeriesType;
        }

        @Override
        public final Builder timeSeriesType(String timeSeriesType) {
            this.timeSeriesType = timeSeriesType;
            return this;
        }

        @Override
        public final Builder timeSeriesType(ListTimeSeriesType timeSeriesType) {
            this.timeSeriesType(timeSeriesType == null ? null : timeSeriesType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTimeSeriesRequest build() {
            return new ListTimeSeriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
