/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The processing configuration for the given metric property. You can configure metrics to be computed at the edge or
 * in the Amazon Web Services Cloud. By default, metrics are forwarded to the cloud.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricProcessingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricProcessingConfig.Builder, MetricProcessingConfig> {
    private static final SdkField<String> COMPUTE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeLocation").getter(getter(MetricProcessingConfig::computeLocationAsString))
            .setter(setter(Builder::computeLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String computeLocation;

    private MetricProcessingConfig(BuilderImpl builder) {
        this.computeLocation = builder.computeLocation;
    }

    /**
     * <p>
     * The compute location for the given metric property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeLocation}
     * will return {@link ComputeLocation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computeLocationAsString}.
     * </p>
     * 
     * @return The compute location for the given metric property.
     * @see ComputeLocation
     */
    public final ComputeLocation computeLocation() {
        return ComputeLocation.fromValue(computeLocation);
    }

    /**
     * <p>
     * The compute location for the given metric property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeLocation}
     * will return {@link ComputeLocation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computeLocationAsString}.
     * </p>
     * 
     * @return The compute location for the given metric property.
     * @see ComputeLocation
     */
    public final String computeLocationAsString() {
        return computeLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computeLocationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricProcessingConfig)) {
            return false;
        }
        MetricProcessingConfig other = (MetricProcessingConfig) obj;
        return Objects.equals(computeLocationAsString(), other.computeLocationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricProcessingConfig").add("ComputeLocation", computeLocationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeLocation":
            return Optional.ofNullable(clazz.cast(computeLocationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricProcessingConfig, T> g) {
        return obj -> g.apply((MetricProcessingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricProcessingConfig> {
        /**
         * <p>
         * The compute location for the given metric property.
         * </p>
         * 
         * @param computeLocation
         *        The compute location for the given metric property.
         * @see ComputeLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeLocation
         */
        Builder computeLocation(String computeLocation);

        /**
         * <p>
         * The compute location for the given metric property.
         * </p>
         * 
         * @param computeLocation
         *        The compute location for the given metric property.
         * @see ComputeLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeLocation
         */
        Builder computeLocation(ComputeLocation computeLocation);
    }

    static final class BuilderImpl implements Builder {
        private String computeLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricProcessingConfig model) {
            computeLocation(model.computeLocation);
        }

        public final String getComputeLocation() {
            return computeLocation;
        }

        public final void setComputeLocation(String computeLocation) {
            this.computeLocation = computeLocation;
        }

        @Override
        public final Builder computeLocation(String computeLocation) {
            this.computeLocation = computeLocation;
            return this;
        }

        @Override
        public final Builder computeLocation(ComputeLocation computeLocation) {
            this.computeLocation(computeLocation == null ? null : computeLocation.toString());
            return this;
        }

        @Override
        public MetricProcessingConfig build() {
            return new MetricProcessingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
