/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for a SiteWise Edge gateway that runs on a Siemens Industrial Edge Device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SiemensIE implements SdkPojo, Serializable, ToCopyableBuilder<SiemensIE.Builder, SiemensIE> {
    private static final SdkField<String> IOT_CORE_THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iotCoreThingName").getter(getter(SiemensIE::iotCoreThingName)).setter(setter(Builder::iotCoreThingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotCoreThingName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOT_CORE_THING_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String iotCoreThingName;

    private SiemensIE(BuilderImpl builder) {
        this.iotCoreThingName = builder.iotCoreThingName;
    }

    /**
     * <p>
     * The name of the IoT Thing for your SiteWise Edge gateway.
     * </p>
     * 
     * @return The name of the IoT Thing for your SiteWise Edge gateway.
     */
    public final String iotCoreThingName() {
        return iotCoreThingName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iotCoreThingName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SiemensIE)) {
            return false;
        }
        SiemensIE other = (SiemensIE) obj;
        return Objects.equals(iotCoreThingName(), other.iotCoreThingName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SiemensIE").add("IotCoreThingName", iotCoreThingName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iotCoreThingName":
            return Optional.ofNullable(clazz.cast(iotCoreThingName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SiemensIE, T> g) {
        return obj -> g.apply((SiemensIE) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SiemensIE> {
        /**
         * <p>
         * The name of the IoT Thing for your SiteWise Edge gateway.
         * </p>
         * 
         * @param iotCoreThingName
         *        The name of the IoT Thing for your SiteWise Edge gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotCoreThingName(String iotCoreThingName);
    }

    static final class BuilderImpl implements Builder {
        private String iotCoreThingName;

        private BuilderImpl() {
        }

        private BuilderImpl(SiemensIE model) {
            iotCoreThingName(model.iotCoreThingName);
        }

        public final String getIotCoreThingName() {
            return iotCoreThingName;
        }

        public final void setIotCoreThingName(String iotCoreThingName) {
            this.iotCoreThingName = iotCoreThingName;
        }

        @Override
        public final Builder iotCoreThingName(String iotCoreThingName) {
            this.iotCoreThingName = iotCoreThingName;
            return this;
        }

        @Override
        public SiemensIE build() {
            return new SiemensIE(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
