/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssetModelCompositeModelRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<UpdateAssetModelCompositeModelRequest.Builder, UpdateAssetModelCompositeModelRequest> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(UpdateAssetModelCompositeModelRequest::assetModelId))
            .setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelId").build()).build();

    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("assetModelCompositeModelId")
            .getter(getter(UpdateAssetModelCompositeModelRequest::assetModelCompositeModelId))
            .setter(setter(Builder::assetModelCompositeModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelCompositeModelId").build())
            .build();

    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_EXTERNAL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("assetModelCompositeModelExternalId")
            .getter(getter(UpdateAssetModelCompositeModelRequest::assetModelCompositeModelExternalId))
            .setter(setter(Builder::assetModelCompositeModelExternalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelExternalId")
                    .build()).build();

    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("assetModelCompositeModelDescription")
            .getter(getter(UpdateAssetModelCompositeModelRequest::assetModelCompositeModelDescription))
            .setter(setter(Builder::assetModelCompositeModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("assetModelCompositeModelDescription").build()).build();

    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("assetModelCompositeModelName")
            .getter(getter(UpdateAssetModelCompositeModelRequest::assetModelCompositeModelName))
            .setter(setter(Builder::assetModelCompositeModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelName")
                    .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateAssetModelCompositeModelRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<AssetModelProperty>> ASSET_MODEL_COMPOSITE_MODEL_PROPERTIES_FIELD = SdkField
            .<List<AssetModelProperty>> builder(MarshallingType.LIST)
            .memberName("assetModelCompositeModelProperties")
            .getter(getter(UpdateAssetModelCompositeModelRequest::assetModelCompositeModelProperties))
            .setter(setter(Builder::assetModelCompositeModelProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelProperties")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD, ASSET_MODEL_COMPOSITE_MODEL_EXTERNAL_ID_FIELD,
            ASSET_MODEL_COMPOSITE_MODEL_DESCRIPTION_FIELD, ASSET_MODEL_COMPOSITE_MODEL_NAME_FIELD, CLIENT_TOKEN_FIELD,
            ASSET_MODEL_COMPOSITE_MODEL_PROPERTIES_FIELD));

    private final String assetModelId;

    private final String assetModelCompositeModelId;

    private final String assetModelCompositeModelExternalId;

    private final String assetModelCompositeModelDescription;

    private final String assetModelCompositeModelName;

    private final String clientToken;

    private final List<AssetModelProperty> assetModelCompositeModelProperties;

    private UpdateAssetModelCompositeModelRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.assetModelCompositeModelId = builder.assetModelCompositeModelId;
        this.assetModelCompositeModelExternalId = builder.assetModelCompositeModelExternalId;
        this.assetModelCompositeModelDescription = builder.assetModelCompositeModelDescription;
        this.assetModelCompositeModelName = builder.assetModelCompositeModelName;
        this.clientToken = builder.clientToken;
        this.assetModelCompositeModelProperties = builder.assetModelCompositeModelProperties;
    }

    /**
     * <p>
     * The ID of the asset model, in UUID format.
     * </p>
     * 
     * @return The ID of the asset model, in UUID format.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The ID of a composite model on this asset model.
     * </p>
     * 
     * @return The ID of a composite model on this asset model.
     */
    public final String assetModelCompositeModelId() {
        return assetModelCompositeModelId;
    }

    /**
     * <p>
     * An external ID to assign to the asset model. You can only set the external ID of the asset model if it wasn't set
     * when it was created, or you're setting it to the exact same thing as when it was created.
     * </p>
     * 
     * @return An external ID to assign to the asset model. You can only set the external ID of the asset model if it
     *         wasn't set when it was created, or you're setting it to the exact same thing as when it was created.
     */
    public final String assetModelCompositeModelExternalId() {
        return assetModelCompositeModelExternalId;
    }

    /**
     * <p>
     * A description for the composite model.
     * </p>
     * 
     * @return A description for the composite model.
     */
    public final String assetModelCompositeModelDescription() {
        return assetModelCompositeModelDescription;
    }

    /**
     * <p>
     * A unique name for the composite model.
     * </p>
     * 
     * @return A unique name for the composite model.
     */
    public final String assetModelCompositeModelName() {
        return assetModelCompositeModelName;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelCompositeModelProperties
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAssetModelCompositeModelProperties() {
        return assetModelCompositeModelProperties != null
                && !(assetModelCompositeModelProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The property definitions of the composite model. For more information, see <a href=
     * "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html#inline-composite-models">
     * Inline custom composite models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * You can specify up to 200 properties per composite model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise
     * User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelCompositeModelProperties}
     * method.
     * </p>
     * 
     * @return The property definitions of the composite model. For more information, see <a href=
     *         "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html#inline-composite-models"
     *         > Inline custom composite models</a> in the <i>IoT SiteWise User Guide</i>.</p>
     *         <p>
     *         You can specify up to 200 properties per composite model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     */
    public final List<AssetModelProperty> assetModelCompositeModelProperties() {
        return assetModelCompositeModelProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCompositeModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCompositeModelExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCompositeModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCompositeModelName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAssetModelCompositeModelProperties() ? assetModelCompositeModelProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssetModelCompositeModelRequest)) {
            return false;
        }
        UpdateAssetModelCompositeModelRequest other = (UpdateAssetModelCompositeModelRequest) obj;
        return Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(assetModelCompositeModelId(), other.assetModelCompositeModelId())
                && Objects.equals(assetModelCompositeModelExternalId(), other.assetModelCompositeModelExternalId())
                && Objects.equals(assetModelCompositeModelDescription(), other.assetModelCompositeModelDescription())
                && Objects.equals(assetModelCompositeModelName(), other.assetModelCompositeModelName())
                && Objects.equals(clientToken(), other.clientToken())
                && hasAssetModelCompositeModelProperties() == other.hasAssetModelCompositeModelProperties()
                && Objects.equals(assetModelCompositeModelProperties(), other.assetModelCompositeModelProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateAssetModelCompositeModelRequest")
                .add("AssetModelId", assetModelId())
                .add("AssetModelCompositeModelId", assetModelCompositeModelId())
                .add("AssetModelCompositeModelExternalId", assetModelCompositeModelExternalId())
                .add("AssetModelCompositeModelDescription", assetModelCompositeModelDescription())
                .add("AssetModelCompositeModelName", assetModelCompositeModelName())
                .add("ClientToken", clientToken())
                .add("AssetModelCompositeModelProperties",
                        hasAssetModelCompositeModelProperties() ? assetModelCompositeModelProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "assetModelCompositeModelId":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelId()));
        case "assetModelCompositeModelExternalId":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelExternalId()));
        case "assetModelCompositeModelDescription":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelDescription()));
        case "assetModelCompositeModelName":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "assetModelCompositeModelProperties":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssetModelCompositeModelRequest, T> g) {
        return obj -> g.apply((UpdateAssetModelCompositeModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAssetModelCompositeModelRequest> {
        /**
         * <p>
         * The ID of the asset model, in UUID format.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model, in UUID format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The ID of a composite model on this asset model.
         * </p>
         * 
         * @param assetModelCompositeModelId
         *        The ID of a composite model on this asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelId(String assetModelCompositeModelId);

        /**
         * <p>
         * An external ID to assign to the asset model. You can only set the external ID of the asset model if it wasn't
         * set when it was created, or you're setting it to the exact same thing as when it was created.
         * </p>
         * 
         * @param assetModelCompositeModelExternalId
         *        An external ID to assign to the asset model. You can only set the external ID of the asset model if it
         *        wasn't set when it was created, or you're setting it to the exact same thing as when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelExternalId(String assetModelCompositeModelExternalId);

        /**
         * <p>
         * A description for the composite model.
         * </p>
         * 
         * @param assetModelCompositeModelDescription
         *        A description for the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelDescription(String assetModelCompositeModelDescription);

        /**
         * <p>
         * A unique name for the composite model.
         * </p>
         * 
         * @param assetModelCompositeModelName
         *        A unique name for the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelName(String assetModelCompositeModelName);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The property definitions of the composite model. For more information, see <a href=
         * "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html#inline-composite-models"
         * > Inline custom composite models</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 200 properties per composite model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelCompositeModelProperties
         *        The property definitions of the composite model. For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html#inline-composite-models"
         *        > Inline custom composite models</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        You can specify up to 200 properties per composite model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         *        SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelProperties(Collection<AssetModelProperty> assetModelCompositeModelProperties);

        /**
         * <p>
         * The property definitions of the composite model. For more information, see <a href=
         * "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html#inline-composite-models"
         * > Inline custom composite models</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 200 properties per composite model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelCompositeModelProperties
         *        The property definitions of the composite model. For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html#inline-composite-models"
         *        > Inline custom composite models</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        You can specify up to 200 properties per composite model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         *        SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelProperties(AssetModelProperty... assetModelCompositeModelProperties);

        /**
         * <p>
         * The property definitions of the composite model. For more information, see <a href=
         * "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html#inline-composite-models"
         * > Inline custom composite models</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 200 properties per composite model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModelCompositeModelProperties(List<AssetModelProperty>)}.
         * 
         * @param assetModelCompositeModelProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelCompositeModelProperties(java.util.Collection<AssetModelProperty>)
         */
        Builder assetModelCompositeModelProperties(Consumer<AssetModelProperty.Builder>... assetModelCompositeModelProperties);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetModelId;

        private String assetModelCompositeModelId;

        private String assetModelCompositeModelExternalId;

        private String assetModelCompositeModelDescription;

        private String assetModelCompositeModelName;

        private String clientToken;

        private List<AssetModelProperty> assetModelCompositeModelProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssetModelCompositeModelRequest model) {
            super(model);
            assetModelId(model.assetModelId);
            assetModelCompositeModelId(model.assetModelCompositeModelId);
            assetModelCompositeModelExternalId(model.assetModelCompositeModelExternalId);
            assetModelCompositeModelDescription(model.assetModelCompositeModelDescription);
            assetModelCompositeModelName(model.assetModelCompositeModelName);
            clientToken(model.clientToken);
            assetModelCompositeModelProperties(model.assetModelCompositeModelProperties);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getAssetModelCompositeModelId() {
            return assetModelCompositeModelId;
        }

        public final void setAssetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
        }

        @Override
        public final Builder assetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
            return this;
        }

        public final String getAssetModelCompositeModelExternalId() {
            return assetModelCompositeModelExternalId;
        }

        public final void setAssetModelCompositeModelExternalId(String assetModelCompositeModelExternalId) {
            this.assetModelCompositeModelExternalId = assetModelCompositeModelExternalId;
        }

        @Override
        public final Builder assetModelCompositeModelExternalId(String assetModelCompositeModelExternalId) {
            this.assetModelCompositeModelExternalId = assetModelCompositeModelExternalId;
            return this;
        }

        public final String getAssetModelCompositeModelDescription() {
            return assetModelCompositeModelDescription;
        }

        public final void setAssetModelCompositeModelDescription(String assetModelCompositeModelDescription) {
            this.assetModelCompositeModelDescription = assetModelCompositeModelDescription;
        }

        @Override
        public final Builder assetModelCompositeModelDescription(String assetModelCompositeModelDescription) {
            this.assetModelCompositeModelDescription = assetModelCompositeModelDescription;
            return this;
        }

        public final String getAssetModelCompositeModelName() {
            return assetModelCompositeModelName;
        }

        public final void setAssetModelCompositeModelName(String assetModelCompositeModelName) {
            this.assetModelCompositeModelName = assetModelCompositeModelName;
        }

        @Override
        public final Builder assetModelCompositeModelName(String assetModelCompositeModelName) {
            this.assetModelCompositeModelName = assetModelCompositeModelName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<AssetModelProperty.Builder> getAssetModelCompositeModelProperties() {
            List<AssetModelProperty.Builder> result = AssetModelPropertiesCopier
                    .copyToBuilder(this.assetModelCompositeModelProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModelProperties(
                Collection<AssetModelProperty.BuilderImpl> assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties = AssetModelPropertiesCopier
                    .copyFromBuilder(assetModelCompositeModelProperties);
        }

        @Override
        public final Builder assetModelCompositeModelProperties(Collection<AssetModelProperty> assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties = AssetModelPropertiesCopier.copy(assetModelCompositeModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelProperties(AssetModelProperty... assetModelCompositeModelProperties) {
            assetModelCompositeModelProperties(Arrays.asList(assetModelCompositeModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelProperties(
                Consumer<AssetModelProperty.Builder>... assetModelCompositeModelProperties) {
            assetModelCompositeModelProperties(Stream.of(assetModelCompositeModelProperties)
                    .map(c -> AssetModelProperty.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssetModelCompositeModelRequest build() {
            return new UpdateAssetModelCompositeModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
