/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.iotsitewise.model.AssociateAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.AssociateAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.AssociateTimeSeriesToAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.AssociateTimeSeriesToAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse;
import software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelCompositeModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelCompositeModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreatePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreatePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.CreateProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.CreateProjectResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelCompositeModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelCompositeModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeletePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeletePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteProjectResponse;
import software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeActionRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeActionResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetCompositeModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetCompositeModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelCompositeModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelCompositeModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeLoggingOptionsRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeLoggingOptionsResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeProjectResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.ExecuteActionRequest;
import software.amazon.awssdk.services.iotsitewise.model.ExecuteActionResponse;
import software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryRequest;
import software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueResponse;
import software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListActionsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListActionsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListDashboardsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.TagResourceRequest;
import software.amazon.awssdk.services.iotsitewise.model.TagResourceResponse;
import software.amazon.awssdk.services.iotsitewise.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotsitewise.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelCompositeModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelCompositeModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdatePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.UpdateProjectRequest;
import software.amazon.awssdk.services.iotsitewise.model.UpdateProjectResponse;
import software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyAggregatesPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueHistoryPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValuePublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ExecuteQueryPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyAggregatesPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyValueHistoryPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.GetInterpolatedAssetPropertyValuesPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAccessPoliciesPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListActionsPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelCompositeModelsPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelPropertiesPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelsPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAssetPropertiesPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAssetRelationshipsPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAssetsPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListAssociatedAssetsPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListBulkImportJobsPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListCompositionRelationshipsPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListDashboardsPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListGatewaysPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListPortalsPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListProjectAssetsPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListProjectsPublisher;
import software.amazon.awssdk.services.iotsitewise.paginators.ListTimeSeriesPublisher;
import software.amazon.awssdk.services.iotsitewise.waiters.IoTSiteWiseAsyncWaiter;

/**
 * Service client for accessing AWS IoT SiteWise asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Welcome to the IoT SiteWise API Reference. IoT SiteWise is an Amazon Web Services service that connects <a
 * href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">Industrial Internet of Things
 * (IIoT)</a> devices to the power of the Amazon Web Services Cloud. For more information, see the <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/">IoT SiteWise User Guide</a>. For information about
 * IoT SiteWise quotas, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a>
 * in the <i>IoT SiteWise User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IoTSiteWiseAsyncClient extends AwsClient {
    String SERVICE_NAME = "iotsitewise";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "iotsitewise";

    /**
     * <p>
     * Associates a child asset with the given parent asset through a hierarchy defined in the parent asset's model. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html">Associating
     * assets</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param associateAssetsRequest
     * @return A Java Future containing the result of the AssociateAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.AssociateAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateAssetsResponse> associateAssets(AssociateAssetsRequest associateAssetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a child asset with the given parent asset through a hierarchy defined in the parent asset's model. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html">Associating
     * assets</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAssetsRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateAssetsRequest#builder()}
     * </p>
     *
     * @param associateAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.AssociateAssetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.AssociateAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateAssetsResponse> associateAssets(
            Consumer<AssociateAssetsRequest.Builder> associateAssetsRequest) {
        return associateAssets(AssociateAssetsRequest.builder().applyMutation(associateAssetsRequest).build());
    }

    /**
     * <p>
     * Associates a time series (data stream) with an asset property.
     * </p>
     *
     * @param associateTimeSeriesToAssetPropertyRequest
     * @return A Java Future containing the result of the AssociateTimeSeriesToAssetProperty operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.AssociateTimeSeriesToAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateTimeSeriesToAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTimeSeriesToAssetPropertyResponse> associateTimeSeriesToAssetProperty(
            AssociateTimeSeriesToAssetPropertyRequest associateTimeSeriesToAssetPropertyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a time series (data stream) with an asset property.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTimeSeriesToAssetPropertyRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateTimeSeriesToAssetPropertyRequest#builder()}
     * </p>
     *
     * @param associateTimeSeriesToAssetPropertyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.AssociateTimeSeriesToAssetPropertyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateTimeSeriesToAssetProperty operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.AssociateTimeSeriesToAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateTimeSeriesToAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTimeSeriesToAssetPropertyResponse> associateTimeSeriesToAssetProperty(
            Consumer<AssociateTimeSeriesToAssetPropertyRequest.Builder> associateTimeSeriesToAssetPropertyRequest) {
        return associateTimeSeriesToAssetProperty(AssociateTimeSeriesToAssetPropertyRequest.builder()
                .applyMutation(associateTimeSeriesToAssetPropertyRequest).build());
    }

    /**
     * <p>
     * Associates a group (batch) of assets with an IoT SiteWise Monitor project.
     * </p>
     *
     * @param batchAssociateProjectAssetsRequest
     * @return A Java Future containing the result of the BatchAssociateProjectAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchAssociateProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchAssociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateProjectAssetsResponse> batchAssociateProjectAssets(
            BatchAssociateProjectAssetsRequest batchAssociateProjectAssetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a group (batch) of assets with an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchAssociateProjectAssetsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchAssociateProjectAssetsRequest#builder()}
     * </p>
     *
     * @param batchAssociateProjectAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchAssociateProjectAssetsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchAssociateProjectAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchAssociateProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchAssociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateProjectAssetsResponse> batchAssociateProjectAssets(
            Consumer<BatchAssociateProjectAssetsRequest.Builder> batchAssociateProjectAssetsRequest) {
        return batchAssociateProjectAssets(BatchAssociateProjectAssetsRequest.builder()
                .applyMutation(batchAssociateProjectAssetsRequest).build());
    }

    /**
     * <p>
     * Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.
     * </p>
     *
     * @param batchDisassociateProjectAssetsRequest
     * @return A Java Future containing the result of the BatchDisassociateProjectAssets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchDisassociateProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchDisassociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateProjectAssetsResponse> batchDisassociateProjectAssets(
            BatchDisassociateProjectAssetsRequest batchDisassociateProjectAssetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDisassociateProjectAssetsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDisassociateProjectAssetsRequest#builder()}
     * </p>
     *
     * @param batchDisassociateProjectAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchDisassociateProjectAssetsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchDisassociateProjectAssets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchDisassociateProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchDisassociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateProjectAssetsResponse> batchDisassociateProjectAssets(
            Consumer<BatchDisassociateProjectAssetsRequest.Builder> batchDisassociateProjectAssetsRequest) {
        return batchDisassociateProjectAssets(BatchDisassociateProjectAssetsRequest.builder()
                .applyMutation(batchDisassociateProjectAssetsRequest).build());
    }

    /**
     * <p>
     * Gets aggregated values (for example, average, minimum, and maximum) for one or more asset properties. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchGetAssetPropertyAggregatesRequest
     * @return A Java Future containing the result of the BatchGetAssetPropertyAggregates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAssetPropertyAggregatesResponse> batchGetAssetPropertyAggregates(
            BatchGetAssetPropertyAggregatesRequest batchGetAssetPropertyAggregatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets aggregated values (for example, average, minimum, and maximum) for one or more asset properties. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAssetPropertyAggregatesRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetAssetPropertyAggregatesRequest#builder()}
     * </p>
     *
     * @param batchGetAssetPropertyAggregatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchGetAssetPropertyAggregates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAssetPropertyAggregatesResponse> batchGetAssetPropertyAggregates(
            Consumer<BatchGetAssetPropertyAggregatesRequest.Builder> batchGetAssetPropertyAggregatesRequest) {
        return batchGetAssetPropertyAggregates(BatchGetAssetPropertyAggregatesRequest.builder()
                .applyMutation(batchGetAssetPropertyAggregatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #batchGetAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyAggregatesPublisher publisher = client.batchGetAssetPropertyAggregatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyAggregatesPublisher publisher = client.batchGetAssetPropertyAggregatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param batchGetAssetPropertyAggregatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyAggregatesPublisher batchGetAssetPropertyAggregatesPaginator(
            BatchGetAssetPropertyAggregatesRequest batchGetAssetPropertyAggregatesRequest) {
        return new BatchGetAssetPropertyAggregatesPublisher(this, batchGetAssetPropertyAggregatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #batchGetAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyAggregatesPublisher publisher = client.batchGetAssetPropertyAggregatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyAggregatesPublisher publisher = client.batchGetAssetPropertyAggregatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAssetPropertyAggregatesRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetAssetPropertyAggregatesRequest#builder()}
     * </p>
     *
     * @param batchGetAssetPropertyAggregatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyAggregatesPublisher batchGetAssetPropertyAggregatesPaginator(
            Consumer<BatchGetAssetPropertyAggregatesRequest.Builder> batchGetAssetPropertyAggregatesRequest) {
        return batchGetAssetPropertyAggregatesPaginator(BatchGetAssetPropertyAggregatesRequest.builder()
                .applyMutation(batchGetAssetPropertyAggregatesRequest).build());
    }

    /**
     * <p>
     * Gets the current value for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchGetAssetPropertyValueRequest
     * @return A Java Future containing the result of the BatchGetAssetPropertyValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAssetPropertyValueResponse> batchGetAssetPropertyValue(
            BatchGetAssetPropertyValueRequest batchGetAssetPropertyValueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the current value for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAssetPropertyValueRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetAssetPropertyValueRequest#builder()}
     * </p>
     *
     * @param batchGetAssetPropertyValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchGetAssetPropertyValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAssetPropertyValueResponse> batchGetAssetPropertyValue(
            Consumer<BatchGetAssetPropertyValueRequest.Builder> batchGetAssetPropertyValueRequest) {
        return batchGetAssetPropertyValue(BatchGetAssetPropertyValueRequest.builder()
                .applyMutation(batchGetAssetPropertyValueRequest).build());
    }

    /**
     * <p>
     * Gets the historical values for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchGetAssetPropertyValueHistoryRequest
     * @return A Java Future containing the result of the BatchGetAssetPropertyValueHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAssetPropertyValueHistoryResponse> batchGetAssetPropertyValueHistory(
            BatchGetAssetPropertyValueHistoryRequest batchGetAssetPropertyValueHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the historical values for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAssetPropertyValueHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetAssetPropertyValueHistoryRequest#builder()}
     * </p>
     *
     * @param batchGetAssetPropertyValueHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchGetAssetPropertyValueHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAssetPropertyValueHistoryResponse> batchGetAssetPropertyValueHistory(
            Consumer<BatchGetAssetPropertyValueHistoryRequest.Builder> batchGetAssetPropertyValueHistoryRequest) {
        return batchGetAssetPropertyValueHistory(BatchGetAssetPropertyValueHistoryRequest.builder()
                .applyMutation(batchGetAssetPropertyValueHistoryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #batchGetAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueHistoryPublisher publisher = client.batchGetAssetPropertyValueHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueHistoryPublisher publisher = client.batchGetAssetPropertyValueHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param batchGetAssetPropertyValueHistoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyValueHistoryPublisher batchGetAssetPropertyValueHistoryPaginator(
            BatchGetAssetPropertyValueHistoryRequest batchGetAssetPropertyValueHistoryRequest) {
        return new BatchGetAssetPropertyValueHistoryPublisher(this, batchGetAssetPropertyValueHistoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #batchGetAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueHistoryPublisher publisher = client.batchGetAssetPropertyValueHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValueHistoryPublisher publisher = client.batchGetAssetPropertyValueHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAssetPropertyValueHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetAssetPropertyValueHistoryRequest#builder()}
     * </p>
     *
     * @param batchGetAssetPropertyValueHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyValueHistoryPublisher batchGetAssetPropertyValueHistoryPaginator(
            Consumer<BatchGetAssetPropertyValueHistoryRequest.Builder> batchGetAssetPropertyValueHistoryRequest) {
        return batchGetAssetPropertyValueHistoryPaginator(BatchGetAssetPropertyValueHistoryRequest.builder()
                .applyMutation(batchGetAssetPropertyValueHistoryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #batchGetAssetPropertyValue(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValuePublisher publisher = client.batchGetAssetPropertyValuePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValuePublisher publisher = client.batchGetAssetPropertyValuePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetAssetPropertyValue(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest)}
     * operation.</b>
     * </p>
     *
     * @param batchGetAssetPropertyValueRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyValuePublisher batchGetAssetPropertyValuePaginator(
            BatchGetAssetPropertyValueRequest batchGetAssetPropertyValueRequest) {
        return new BatchGetAssetPropertyValuePublisher(this, batchGetAssetPropertyValueRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #batchGetAssetPropertyValue(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValuePublisher publisher = client.batchGetAssetPropertyValuePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.BatchGetAssetPropertyValuePublisher publisher = client.batchGetAssetPropertyValuePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetAssetPropertyValue(software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAssetPropertyValueRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetAssetPropertyValueRequest#builder()}
     * </p>
     *
     * @param batchGetAssetPropertyValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchGetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAssetPropertyValuePublisher batchGetAssetPropertyValuePaginator(
            Consumer<BatchGetAssetPropertyValueRequest.Builder> batchGetAssetPropertyValueRequest) {
        return batchGetAssetPropertyValuePaginator(BatchGetAssetPropertyValueRequest.builder()
                .applyMutation(batchGetAssetPropertyValueRequest).build());
    }

    /**
     * <p>
     * Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value (TQV) data point.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html">Ingesting data using the API</a>
     * in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more than 7 days in
     * the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps outside of the inclusive
     * range of [-7 days, +10 minutes] and returns a <code>TimestampOutOfRangeException</code> error.
     * </p>
     * <p>
     * For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer TQV has a
     * different quality. For example, if you store a TQV <code>{T1, GOOD, V1}</code>, then storing
     * <code>{T1, GOOD, V2}</code> replaces the existing TQV.
     * </p>
     * </important>
     * <p>
     * IoT SiteWise authorizes access to each <code>BatchPutAssetPropertyValue</code> entry individually. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action"
     * >BatchPutAssetPropertyValue authorization</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param batchPutAssetPropertyValueRequest
     * @return A Java Future containing the result of the BatchPutAssetPropertyValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchPutAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchPutAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutAssetPropertyValueResponse> batchPutAssetPropertyValue(
            BatchPutAssetPropertyValueRequest batchPutAssetPropertyValueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value (TQV) data point.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html">Ingesting data using the API</a>
     * in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more than 7 days in
     * the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps outside of the inclusive
     * range of [-7 days, +10 minutes] and returns a <code>TimestampOutOfRangeException</code> error.
     * </p>
     * <p>
     * For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer TQV has a
     * different quality. For example, if you store a TQV <code>{T1, GOOD, V1}</code>, then storing
     * <code>{T1, GOOD, V2}</code> replaces the existing TQV.
     * </p>
     * </important>
     * <p>
     * IoT SiteWise authorizes access to each <code>BatchPutAssetPropertyValue</code> entry individually. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action"
     * >BatchPutAssetPropertyValue authorization</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutAssetPropertyValueRequest.Builder} avoiding
     * the need to create one manually via {@link BatchPutAssetPropertyValueRequest#builder()}
     * </p>
     *
     * @param batchPutAssetPropertyValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyValueRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchPutAssetPropertyValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.BatchPutAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchPutAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutAssetPropertyValueResponse> batchPutAssetPropertyValue(
            Consumer<BatchPutAssetPropertyValueRequest.Builder> batchPutAssetPropertyValueRequest) {
        return batchPutAssetPropertyValue(BatchPutAssetPropertyValueRequest.builder()
                .applyMutation(batchPutAssetPropertyValueRequest).build());
    }

    /**
     * <p>
     * Creates an access policy that grants the specified identity (IAM Identity Center user, IAM Identity Center group,
     * or IAM user) access to the specified IoT SiteWise Monitor portal or project resource.
     * </p>
     *
     * @param createAccessPolicyRequest
     * @return A Java Future containing the result of the CreateAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessPolicyResponse> createAccessPolicy(CreateAccessPolicyRequest createAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an access policy that grants the specified identity (IAM Identity Center user, IAM Identity Center group,
     * or IAM user) access to the specified IoT SiteWise Monitor portal or project resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAccessPolicyRequest#builder()}
     * </p>
     *
     * @param createAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessPolicyResponse> createAccessPolicy(
            Consumer<CreateAccessPolicyRequest.Builder> createAccessPolicyRequest) {
        return createAccessPolicy(CreateAccessPolicyRequest.builder().applyMutation(createAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Creates an asset from an existing asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param createAssetRequest
     * @return A Java Future containing the result of the CreateAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssetResponse> createAsset(CreateAssetRequest createAssetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an asset from an existing asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAssetRequest#builder()}
     * </p>
     *
     * @param createAssetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.CreateAssetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssetResponse> createAsset(Consumer<CreateAssetRequest.Builder> createAssetRequest) {
        return createAsset(CreateAssetRequest.builder().applyMutation(createAssetRequest).build());
    }

    /**
     * <p>
     * Creates an asset model from specified property and hierarchy definitions. You create assets from asset models.
     * With asset models, you can easily create assets of the same type that have standardized definitions. Each asset
     * created from a model inherits the asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * You can create two types of asset models, <code>ASSET_MODEL</code> or <code>COMPONENT_MODEL</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a component
     * in another asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models.
     * You can't create assets directly from this type of asset model.
     * </p>
     * </li>
     * </ul>
     *
     * @param createAssetModelRequest
     * @return A Java Future containing the result of the CreateAssetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssetModelResponse> createAssetModel(CreateAssetModelRequest createAssetModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an asset model from specified property and hierarchy definitions. You create assets from asset models.
     * With asset models, you can easily create assets of the same type that have standardized definitions. Each asset
     * created from a model inherits the asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * You can create two types of asset models, <code>ASSET_MODEL</code> or <code>COMPONENT_MODEL</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a component
     * in another asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models.
     * You can't create assets directly from this type of asset model.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetModelRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssetModelRequest#builder()}
     * </p>
     *
     * @param createAssetModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAssetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssetModelResponse> createAssetModel(
            Consumer<CreateAssetModelRequest.Builder> createAssetModelRequest) {
        return createAssetModel(CreateAssetModelRequest.builder().applyMutation(createAssetModelRequest).build());
    }

    /**
     * <p>
     * Creates a custom composite model from specified property and hierarchy definitions. There are two types of custom
     * composite models, <code>inline</code> and <code>component-model-based</code>.
     * </p>
     * <p>
     * Use component-model-based custom composite models to define standard, reusable components. A
     * component-model-based custom composite model consists of a name, a description, and the ID of the component model
     * it references. A component-model-based custom composite model has no properties of its own; its referenced
     * component model provides its associated properties to any created assets. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html">Custom composite
     * models (Components)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * Use inline custom composite models to organize the properties of an asset model. The properties of inline custom
     * composite models are local to the asset model where they are included and can't be used to create multiple
     * assets.
     * </p>
     * <p>
     * To create a component-model-based model, specify the <code>composedAssetModelId</code> of an existing asset model
     * with <code>assetModelType</code> of <code>COMPONENT_MODEL</code>.
     * </p>
     * <p>
     * To create an inline model, specify the <code>assetModelCompositeModelProperties</code> and don't include an
     * <code>composedAssetModelId</code>.
     * </p>
     *
     * @param createAssetModelCompositeModelRequest
     * @return A Java Future containing the result of the CreateAssetModelCompositeModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request-header fields evaluated to
     *         <code>FALSE</code>.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateAssetModelCompositeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModelCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAssetModelCompositeModelResponse> createAssetModelCompositeModel(
            CreateAssetModelCompositeModelRequest createAssetModelCompositeModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom composite model from specified property and hierarchy definitions. There are two types of custom
     * composite models, <code>inline</code> and <code>component-model-based</code>.
     * </p>
     * <p>
     * Use component-model-based custom composite models to define standard, reusable components. A
     * component-model-based custom composite model consists of a name, a description, and the ID of the component model
     * it references. A component-model-based custom composite model has no properties of its own; its referenced
     * component model provides its associated properties to any created assets. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html">Custom composite
     * models (Components)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * Use inline custom composite models to organize the properties of an asset model. The properties of inline custom
     * composite models are local to the asset model where they are included and can't be used to create multiple
     * assets.
     * </p>
     * <p>
     * To create a component-model-based model, specify the <code>composedAssetModelId</code> of an existing asset model
     * with <code>assetModelType</code> of <code>COMPONENT_MODEL</code>.
     * </p>
     * <p>
     * To create an inline model, specify the <code>assetModelCompositeModelProperties</code> and don't include an
     * <code>composedAssetModelId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssetModelCompositeModelRequest.Builder}
     * avoiding the need to create one manually via {@link CreateAssetModelCompositeModelRequest#builder()}
     * </p>
     *
     * @param createAssetModelCompositeModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelCompositeModelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateAssetModelCompositeModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request-header fields evaluated to
     *         <code>FALSE</code>.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateAssetModelCompositeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModelCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAssetModelCompositeModelResponse> createAssetModelCompositeModel(
            Consumer<CreateAssetModelCompositeModelRequest.Builder> createAssetModelCompositeModelRequest) {
        return createAssetModelCompositeModel(CreateAssetModelCompositeModelRequest.builder()
                .applyMutation(createAssetModelCompositeModelRequest).build());
    }

    /**
     * <p>
     * Defines a job to ingest data to IoT SiteWise from Amazon S3. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/CreateBulkImportJob.html">Create a bulk import
     * job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <important>
     * <p>
     * Before you create a bulk import job, you must enable IoT SiteWise warm tier or IoT SiteWise cold tier. For more
     * information about how to configure storage settings, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_PutStorageConfiguration.html"
     * >PutStorageConfiguration</a>.
     * </p>
     * <p>
     * Bulk import is designed to store historical data to IoT SiteWise. It does not trigger computations or
     * notifications on IoT SiteWise warm or cold tier storage.
     * </p>
     * </important>
     *
     * @param createBulkImportJobRequest
     * @return A Java Future containing the result of the CreateBulkImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateBulkImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBulkImportJobResponse> createBulkImportJob(
            CreateBulkImportJobRequest createBulkImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines a job to ingest data to IoT SiteWise from Amazon S3. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/CreateBulkImportJob.html">Create a bulk import
     * job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <important>
     * <p>
     * Before you create a bulk import job, you must enable IoT SiteWise warm tier or IoT SiteWise cold tier. For more
     * information about how to configure storage settings, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_PutStorageConfiguration.html"
     * >PutStorageConfiguration</a>.
     * </p>
     * <p>
     * Bulk import is designed to store historical data to IoT SiteWise. It does not trigger computations or
     * notifications on IoT SiteWise warm or cold tier storage.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBulkImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBulkImportJobRequest#builder()}
     * </p>
     *
     * @param createBulkImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateBulkImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateBulkImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBulkImportJobResponse> createBulkImportJob(
            Consumer<CreateBulkImportJobRequest.Builder> createBulkImportJobRequest) {
        return createBulkImportJob(CreateBulkImportJobRequest.builder().applyMutation(createBulkImportJobRequest).build());
    }

    /**
     * <p>
     * Creates a dashboard in an IoT SiteWise Monitor project.
     * </p>
     *
     * @param createDashboardRequest
     * @return A Java Future containing the result of the CreateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDashboardResponse> createDashboard(CreateDashboardRequest createDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a dashboard in an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDashboardRequest#builder()}
     * </p>
     *
     * @param createDashboardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.CreateDashboardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDashboardResponse> createDashboard(
            Consumer<CreateDashboardRequest.Builder> createDashboardRequest) {
        return createDashboard(CreateDashboardRequest.builder().applyMutation(createDashboardRequest).build());
    }

    /**
     * <p>
     * Creates a gateway, which is a virtual or edge device that delivers industrial data streams from local servers to
     * IoT SiteWise. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a
     * gateway</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param createGatewayRequest
     * @return A Java Future containing the result of the CreateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGatewayResponse> createGateway(CreateGatewayRequest createGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a gateway, which is a virtual or edge device that delivers industrial data streams from local servers to
     * IoT SiteWise. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a
     * gateway</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGatewayRequest#builder()}
     * </p>
     *
     * @param createGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.CreateGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGatewayResponse> createGateway(Consumer<CreateGatewayRequest.Builder> createGatewayRequest) {
        return createGateway(CreateGatewayRequest.builder().applyMutation(createGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses IAM Identity Center or IAM
     * to authenticate portal users and manage user permissions.
     * </p>
     * <note>
     * <p>
     * Before you can sign in to a new portal, you must add at least one identity to that portal. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins"
     * >Adding or removing portal administrators</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * </note>
     *
     * @param createPortalRequest
     * @return A Java Future containing the result of the CreatePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePortalResponse> createPortal(CreatePortalRequest createPortalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses IAM Identity Center or IAM
     * to authenticate portal users and manage user permissions.
     * </p>
     * <note>
     * <p>
     * Before you can sign in to a new portal, you must add at least one identity to that portal. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins"
     * >Adding or removing portal administrators</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePortalRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePortalRequest#builder()}
     * </p>
     *
     * @param createPortalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.CreatePortalRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePortalResponse> createPortal(Consumer<CreatePortalRequest.Builder> createPortalRequest) {
        return createPortal(CreatePortalRequest.builder().applyMutation(createPortalRequest).build());
    }

    /**
     * <p>
     * Creates a project in the specified portal.
     * </p>
     * <note>
     * <p>
     * Make sure that the project name and description don't contain confidential information.
     * </p>
     * </note>
     *
     * @param createProjectRequest
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a project in the specified portal.
     * </p>
     * <note>
     * <p>
     * Make sure that the project name and description don't contain confidential information.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.CreateProjectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest) {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Deletes an access policy that grants the specified identity access to the specified IoT SiteWise Monitor
     * resource. You can use this operation to revoke access to an IoT SiteWise Monitor resource.
     * </p>
     *
     * @param deleteAccessPolicyRequest
     * @return A Java Future containing the result of the DeleteAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessPolicyResponse> deleteAccessPolicy(DeleteAccessPolicyRequest deleteAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an access policy that grants the specified identity access to the specified IoT SiteWise Monitor
     * resource. You can use this operation to revoke access to an IoT SiteWise Monitor resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAccessPolicyRequest#builder()}
     * </p>
     *
     * @param deleteAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DeleteAccessPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessPolicyResponse> deleteAccessPolicy(
            Consumer<DeleteAccessPolicyRequest.Builder> deleteAccessPolicyRequest) {
        return deleteAccessPolicy(DeleteAccessPolicyRequest.builder().applyMutation(deleteAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an asset. This action can't be undone. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't delete an asset that's associated to another asset. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html"
     * >DisassociateAssets</a>.
     * </p>
     * </note>
     *
     * @param deleteAssetRequest
     * @return A Java Future containing the result of the DeleteAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssetResponse> deleteAsset(DeleteAssetRequest deleteAssetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an asset. This action can't be undone. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't delete an asset that's associated to another asset. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html"
     * >DisassociateAssets</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAssetRequest#builder()}
     * </p>
     *
     * @param deleteAssetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DeleteAssetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssetResponse> deleteAsset(Consumer<DeleteAssetRequest.Builder> deleteAssetRequest) {
        return deleteAsset(DeleteAssetRequest.builder().applyMutation(deleteAssetRequest).build());
    }

    /**
     * <p>
     * Deletes an asset model. This action can't be undone. You must delete all assets created from an asset model
     * before you can delete the model. Also, you can't delete an asset model if a parent asset model exists that
     * contains a property formula expression that depends on the asset model that you want to delete. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param deleteAssetModelRequest
     * @return A Java Future containing the result of the DeleteAssetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request-header fields evaluated to
     *         <code>FALSE</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAssetModelResponse> deleteAssetModel(DeleteAssetModelRequest deleteAssetModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an asset model. This action can't be undone. You must delete all assets created from an asset model
     * before you can delete the model. Also, you can't delete an asset model if a parent asset model exists that
     * contains a property formula expression that depends on the asset model that you want to delete. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetModelRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssetModelRequest#builder()}
     * </p>
     *
     * @param deleteAssetModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAssetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request-header fields evaluated to
     *         <code>FALSE</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAssetModelResponse> deleteAssetModel(
            Consumer<DeleteAssetModelRequest.Builder> deleteAssetModelRequest) {
        return deleteAssetModel(DeleteAssetModelRequest.builder().applyMutation(deleteAssetModelRequest).build());
    }

    /**
     * <p>
     * Deletes a composite model. This action can't be undone. You must delete all assets created from a composite model
     * before you can delete the model. Also, you can't delete a composite model if a parent asset model exists that
     * contains a property formula expression that depends on the asset model that you want to delete. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param deleteAssetModelCompositeModelRequest
     * @return A Java Future containing the result of the DeleteAssetModelCompositeModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request-header fields evaluated to
     *         <code>FALSE</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteAssetModelCompositeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModelCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssetModelCompositeModelResponse> deleteAssetModelCompositeModel(
            DeleteAssetModelCompositeModelRequest deleteAssetModelCompositeModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a composite model. This action can't be undone. You must delete all assets created from a composite model
     * before you can delete the model. Also, you can't delete a composite model if a parent asset model exists that
     * contains a property formula expression that depends on the asset model that you want to delete. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssetModelCompositeModelRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAssetModelCompositeModelRequest#builder()}
     * </p>
     *
     * @param deleteAssetModelCompositeModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelCompositeModelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAssetModelCompositeModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request-header fields evaluated to
     *         <code>FALSE</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteAssetModelCompositeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModelCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAssetModelCompositeModelResponse> deleteAssetModelCompositeModel(
            Consumer<DeleteAssetModelCompositeModelRequest.Builder> deleteAssetModelCompositeModelRequest) {
        return deleteAssetModelCompositeModel(DeleteAssetModelCompositeModelRequest.builder()
                .applyMutation(deleteAssetModelCompositeModelRequest).build());
    }

    /**
     * <p>
     * Deletes a dashboard from IoT SiteWise Monitor.
     * </p>
     *
     * @param deleteDashboardRequest
     * @return A Java Future containing the result of the DeleteDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDashboardResponse> deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dashboard from IoT SiteWise Monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDashboardRequest#builder()}
     * </p>
     *
     * @param deleteDashboardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDashboardResponse> deleteDashboard(
            Consumer<DeleteDashboardRequest.Builder> deleteDashboardRequest) {
        return deleteDashboard(DeleteDashboardRequest.builder().applyMutation(deleteDashboardRequest).build());
    }

    /**
     * <p>
     * Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain in your
     * gateway's file system.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return A Java Future containing the result of the DeleteGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGatewayResponse> deleteGateway(DeleteGatewayRequest deleteGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain in your
     * gateway's file system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGatewayRequest#builder()}
     * </p>
     *
     * @param deleteGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DeleteGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGatewayResponse> deleteGateway(Consumer<DeleteGatewayRequest.Builder> deleteGatewayRequest) {
        return deleteGateway(DeleteGatewayRequest.builder().applyMutation(deleteGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a portal from IoT SiteWise Monitor.
     * </p>
     *
     * @param deletePortalRequest
     * @return A Java Future containing the result of the DeletePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeletePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeletePortal" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePortalResponse> deletePortal(DeletePortalRequest deletePortalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a portal from IoT SiteWise Monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePortalRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePortalRequest#builder()}
     * </p>
     *
     * @param deletePortalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DeletePortalRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeletePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeletePortal" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePortalResponse> deletePortal(Consumer<DeletePortalRequest.Builder> deletePortalRequest) {
        return deletePortal(DeletePortalRequest.builder().applyMutation(deletePortalRequest).build());
    }

    /**
     * <p>
     * Deletes a project from IoT SiteWise Monitor.
     * </p>
     *
     * @param deleteProjectRequest
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a project from IoT SiteWise Monitor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DeleteProjectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest) {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Deletes a time series (data stream). If you delete a time series that's associated with an asset property, the
     * asset property still exists, but the time series will no longer be associated with this asset property.
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     *
     * @param deleteTimeSeriesRequest
     * @return A Java Future containing the result of the DeleteTimeSeries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTimeSeriesResponse> deleteTimeSeries(DeleteTimeSeriesRequest deleteTimeSeriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a time series (data stream). If you delete a time series that's associated with an asset property, the
     * asset property still exists, but the time series will no longer be associated with this asset property.
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTimeSeriesRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTimeSeriesRequest#builder()}
     * </p>
     *
     * @param deleteTimeSeriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTimeSeries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DeleteTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTimeSeriesResponse> deleteTimeSeries(
            Consumer<DeleteTimeSeriesRequest.Builder> deleteTimeSeriesRequest) {
        return deleteTimeSeries(DeleteTimeSeriesRequest.builder().applyMutation(deleteTimeSeriesRequest).build());
    }

    /**
     * <p>
     * Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or project.
     * </p>
     *
     * @param describeAccessPolicyRequest
     * @return A Java Future containing the result of the DescribeAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccessPolicyResponse> describeAccessPolicy(
            DescribeAccessPolicyRequest describeAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccessPolicyRequest#builder()}
     * </p>
     *
     * @param describeAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccessPolicyResponse> describeAccessPolicy(
            Consumer<DescribeAccessPolicyRequest.Builder> describeAccessPolicyRequest) {
        return describeAccessPolicy(DescribeAccessPolicyRequest.builder().applyMutation(describeAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an action.
     * </p>
     *
     * @param describeActionRequest
     * @return A Java Future containing the result of the DescribeAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeActionResponse> describeAction(DescribeActionRequest describeActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActionRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeActionRequest#builder()}
     * </p>
     *
     * @param describeActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeActionResponse> describeAction(Consumer<DescribeActionRequest.Builder> describeActionRequest) {
        return describeAction(DescribeActionRequest.builder().applyMutation(describeActionRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an asset.
     * </p>
     *
     * @param describeAssetRequest
     * @return A Java Future containing the result of the DescribeAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAssetResponse> describeAsset(DescribeAssetRequest describeAssetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssetRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAssetRequest#builder()}
     * </p>
     *
     * @param describeAssetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAssetResponse> describeAsset(Consumer<DescribeAssetRequest.Builder> describeAssetRequest) {
        return describeAsset(DescribeAssetRequest.builder().applyMutation(describeAssetRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an asset composite model (also known as an asset component). An
     * <code>AssetCompositeModel</code> is an instance of an <code>AssetModelCompositeModel</code>. If you want to see
     * information about the model this is based on, call <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModelCompositeModel.html"
     * >DescribeAssetModelCompositeModel</a>.
     * </p>
     *
     * @param describeAssetCompositeModelRequest
     * @return A Java Future containing the result of the DescribeAssetCompositeModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAssetCompositeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssetCompositeModelResponse> describeAssetCompositeModel(
            DescribeAssetCompositeModelRequest describeAssetCompositeModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an asset composite model (also known as an asset component). An
     * <code>AssetCompositeModel</code> is an instance of an <code>AssetModelCompositeModel</code>. If you want to see
     * information about the model this is based on, call <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModelCompositeModel.html"
     * >DescribeAssetModelCompositeModel</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssetCompositeModelRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAssetCompositeModelRequest#builder()}
     * </p>
     *
     * @param describeAssetCompositeModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeAssetCompositeModelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAssetCompositeModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAssetCompositeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssetCompositeModelResponse> describeAssetCompositeModel(
            Consumer<DescribeAssetCompositeModelRequest.Builder> describeAssetCompositeModelRequest) {
        return describeAssetCompositeModel(DescribeAssetCompositeModelRequest.builder()
                .applyMutation(describeAssetCompositeModelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an asset model.
     * </p>
     *
     * @param describeAssetModelRequest
     * @return A Java Future containing the result of the DescribeAssetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssetModelResponse> describeAssetModel(DescribeAssetModelRequest describeAssetModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an asset model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssetModelRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAssetModelRequest#builder()}
     * </p>
     *
     * @param describeAssetModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAssetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssetModelResponse> describeAssetModel(
            Consumer<DescribeAssetModelRequest.Builder> describeAssetModelRequest) {
        return describeAssetModel(DescribeAssetModelRequest.builder().applyMutation(describeAssetModelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an asset model composite model (also known as an asset model component). For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html">Custom composite
     * models (Components)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param describeAssetModelCompositeModelRequest
     * @return A Java Future containing the result of the DescribeAssetModelCompositeModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAssetModelCompositeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModelCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssetModelCompositeModelResponse> describeAssetModelCompositeModel(
            DescribeAssetModelCompositeModelRequest describeAssetModelCompositeModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an asset model composite model (also known as an asset model component). For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html">Custom composite
     * models (Components)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssetModelCompositeModelRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAssetModelCompositeModelRequest#builder()}
     * </p>
     *
     * @param describeAssetModelCompositeModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelCompositeModelRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeAssetModelCompositeModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAssetModelCompositeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModelCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssetModelCompositeModelResponse> describeAssetModelCompositeModel(
            Consumer<DescribeAssetModelCompositeModelRequest.Builder> describeAssetModelCompositeModelRequest) {
        return describeAssetModelCompositeModel(DescribeAssetModelCompositeModelRequest.builder()
                .applyMutation(describeAssetModelCompositeModelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an asset property.
     * </p>
     * <note>
     * <p>
     * When you call this operation for an attribute property, this response includes the default attribute value that
     * you define in the asset model. If you update the default value in the model, this operation's response includes
     * the new default value.
     * </p>
     * </note>
     * <p>
     * This operation doesn't return the value of the asset property. To get the value of an asset property, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html">
     * GetAssetPropertyValue</a>.
     * </p>
     *
     * @param describeAssetPropertyRequest
     * @return A Java Future containing the result of the DescribeAssetProperty operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssetPropertyResponse> describeAssetProperty(
            DescribeAssetPropertyRequest describeAssetPropertyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an asset property.
     * </p>
     * <note>
     * <p>
     * When you call this operation for an attribute property, this response includes the default attribute value that
     * you define in the asset model. If you update the default value in the model, this operation's response includes
     * the new default value.
     * </p>
     * </note>
     * <p>
     * This operation doesn't return the value of the asset property. To get the value of an asset property, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html">
     * GetAssetPropertyValue</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssetPropertyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAssetPropertyRequest#builder()}
     * </p>
     *
     * @param describeAssetPropertyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeAssetPropertyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAssetProperty operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssetPropertyResponse> describeAssetProperty(
            Consumer<DescribeAssetPropertyRequest.Builder> describeAssetPropertyRequest) {
        return describeAssetProperty(DescribeAssetPropertyRequest.builder().applyMutation(describeAssetPropertyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a bulk import job request. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/DescribeBulkImportJob.html">Describe a bulk
     * import job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     *
     * @param describeBulkImportJobRequest
     * @return A Java Future containing the result of the DescribeBulkImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeBulkImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBulkImportJobResponse> describeBulkImportJob(
            DescribeBulkImportJobRequest describeBulkImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a bulk import job request. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/DescribeBulkImportJob.html">Describe a bulk
     * import job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBulkImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBulkImportJobRequest#builder()}
     * </p>
     *
     * @param describeBulkImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeBulkImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeBulkImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBulkImportJobResponse> describeBulkImportJob(
            Consumer<DescribeBulkImportJobRequest.Builder> describeBulkImportJobRequest) {
        return describeBulkImportJob(DescribeBulkImportJobRequest.builder().applyMutation(describeBulkImportJobRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a dashboard.
     * </p>
     *
     * @param describeDashboardRequest
     * @return A Java Future containing the result of the DescribeDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDashboardResponse> describeDashboard(DescribeDashboardRequest describeDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a dashboard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDashboardRequest#builder()}
     * </p>
     *
     * @param describeDashboardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeDashboardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDashboardResponse> describeDashboard(
            Consumer<DescribeDashboardRequest.Builder> describeDashboardRequest) {
        return describeDashboard(DescribeDashboardRequest.builder().applyMutation(describeDashboardRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in the
     * default or specified Region. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param describeDefaultEncryptionConfigurationRequest
     * @return A Java Future containing the result of the DescribeDefaultEncryptionConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDefaultEncryptionConfigurationResponse> describeDefaultEncryptionConfiguration(
            DescribeDefaultEncryptionConfigurationRequest describeDefaultEncryptionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in the
     * default or specified Region. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeDefaultEncryptionConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeDefaultEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param describeDefaultEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeDefaultEncryptionConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDefaultEncryptionConfigurationResponse> describeDefaultEncryptionConfiguration(
            Consumer<DescribeDefaultEncryptionConfigurationRequest.Builder> describeDefaultEncryptionConfigurationRequest) {
        return describeDefaultEncryptionConfiguration(DescribeDefaultEncryptionConfigurationRequest.builder()
                .applyMutation(describeDefaultEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a gateway.
     * </p>
     *
     * @param describeGatewayRequest
     * @return A Java Future containing the result of the DescribeGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGatewayResponse> describeGateway(DescribeGatewayRequest describeGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeGatewayRequest#builder()}
     * </p>
     *
     * @param describeGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGatewayResponse> describeGateway(
            Consumer<DescribeGatewayRequest.Builder> describeGatewayRequest) {
        return describeGateway(DescribeGatewayRequest.builder().applyMutation(describeGatewayRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a gateway capability configuration. Each gateway capability defines data sources for
     * a gateway. A capability configuration can contain multiple data source configurations. If you define OPC-UA
     * sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in one capability
     * configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     *
     * @param describeGatewayCapabilityConfigurationRequest
     * @return A Java Future containing the result of the DescribeGatewayCapabilityConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeGatewayCapabilityConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGatewayCapabilityConfigurationResponse> describeGatewayCapabilityConfiguration(
            DescribeGatewayCapabilityConfigurationRequest describeGatewayCapabilityConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a gateway capability configuration. Each gateway capability defines data sources for
     * a gateway. A capability configuration can contain multiple data source configurations. If you define OPC-UA
     * sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in one capability
     * configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeGatewayCapabilityConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeGatewayCapabilityConfigurationRequest#builder()}
     * </p>
     *
     * @param describeGatewayCapabilityConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeGatewayCapabilityConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeGatewayCapabilityConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGatewayCapabilityConfigurationResponse> describeGatewayCapabilityConfiguration(
            Consumer<DescribeGatewayCapabilityConfigurationRequest.Builder> describeGatewayCapabilityConfigurationRequest) {
        return describeGatewayCapabilityConfiguration(DescribeGatewayCapabilityConfigurationRequest.builder()
                .applyMutation(describeGatewayCapabilityConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the current IoT SiteWise logging options.
     * </p>
     *
     * @param describeLoggingOptionsRequest
     * @return A Java Future containing the result of the DescribeLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingOptionsResponse> describeLoggingOptions(
            DescribeLoggingOptionsRequest describeLoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current IoT SiteWise logging options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoggingOptionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param describeLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeLoggingOptionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingOptionsResponse> describeLoggingOptions(
            Consumer<DescribeLoggingOptionsRequest.Builder> describeLoggingOptionsRequest) {
        return describeLoggingOptions(DescribeLoggingOptionsRequest.builder().applyMutation(describeLoggingOptionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a portal.
     * </p>
     *
     * @param describePortalRequest
     * @return A Java Future containing the result of the DescribePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePortalResponse> describePortal(DescribePortalRequest describePortalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePortalRequest.Builder} avoiding the need to
     * create one manually via {@link DescribePortalRequest#builder()}
     * </p>
     *
     * @param describePortalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribePortalRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePortalResponse> describePortal(Consumer<DescribePortalRequest.Builder> describePortalRequest) {
        return describePortal(DescribePortalRequest.builder().applyMutation(describePortalRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a project.
     * </p>
     *
     * @param describeProjectRequest
     * @return A Java Future containing the result of the DescribeProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeProjectResponse> describeProject(DescribeProjectRequest describeProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProjectRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProjectRequest#builder()}
     * </p>
     *
     * @param describeProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeProjectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeProjectResponse> describeProject(
            Consumer<DescribeProjectRequest.Builder> describeProjectRequest) {
        return describeProject(DescribeProjectRequest.builder().applyMutation(describeProjectRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the storage configuration for IoT SiteWise.
     * </p>
     *
     * @param describeStorageConfigurationRequest
     * @return A Java Future containing the result of the DescribeStorageConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStorageConfigurationResponse> describeStorageConfiguration(
            DescribeStorageConfigurationRequest describeStorageConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the storage configuration for IoT SiteWise.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStorageConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStorageConfigurationRequest#builder()}
     * </p>
     *
     * @param describeStorageConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeStorageConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStorageConfigurationResponse> describeStorageConfiguration(
            Consumer<DescribeStorageConfigurationRequest.Builder> describeStorageConfigurationRequest) {
        return describeStorageConfiguration(DescribeStorageConfigurationRequest.builder()
                .applyMutation(describeStorageConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a time series (data stream).
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     *
     * @param describeTimeSeriesRequest
     * @return A Java Future containing the result of the DescribeTimeSeries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTimeSeriesResponse> describeTimeSeries(DescribeTimeSeriesRequest describeTimeSeriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a time series (data stream).
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTimeSeriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTimeSeriesRequest#builder()}
     * </p>
     *
     * @param describeTimeSeriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTimeSeries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DescribeTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeTimeSeries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTimeSeriesResponse> describeTimeSeries(
            Consumer<DescribeTimeSeriesRequest.Builder> describeTimeSeriesRequest) {
        return describeTimeSeries(DescribeTimeSeriesRequest.builder().applyMutation(describeTimeSeriesRequest).build());
    }

    /**
     * <p>
     * Disassociates a child asset from the given parent asset through a hierarchy defined in the parent asset's model.
     * </p>
     *
     * @param disassociateAssetsRequest
     * @return A Java Future containing the result of the DisassociateAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DisassociateAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAssetsResponse> disassociateAssets(DisassociateAssetsRequest disassociateAssetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a child asset from the given parent asset through a hierarchy defined in the parent asset's model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateAssetsRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateAssetsRequest#builder()}
     * </p>
     *
     * @param disassociateAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DisassociateAssetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DisassociateAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAssetsResponse> disassociateAssets(
            Consumer<DisassociateAssetsRequest.Builder> disassociateAssetsRequest) {
        return disassociateAssets(DisassociateAssetsRequest.builder().applyMutation(disassociateAssetsRequest).build());
    }

    /**
     * <p>
     * Disassociates a time series (data stream) from an asset property.
     * </p>
     *
     * @param disassociateTimeSeriesFromAssetPropertyRequest
     * @return A Java Future containing the result of the DisassociateTimeSeriesFromAssetProperty operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DisassociateTimeSeriesFromAssetProperty
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateTimeSeriesFromAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateTimeSeriesFromAssetPropertyResponse> disassociateTimeSeriesFromAssetProperty(
            DisassociateTimeSeriesFromAssetPropertyRequest disassociateTimeSeriesFromAssetPropertyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a time series (data stream) from an asset property.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateTimeSeriesFromAssetPropertyRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateTimeSeriesFromAssetPropertyRequest#builder()}
     * </p>
     *
     * @param disassociateTimeSeriesFromAssetPropertyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.DisassociateTimeSeriesFromAssetPropertyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateTimeSeriesFromAssetProperty operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.DisassociateTimeSeriesFromAssetProperty
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateTimeSeriesFromAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateTimeSeriesFromAssetPropertyResponse> disassociateTimeSeriesFromAssetProperty(
            Consumer<DisassociateTimeSeriesFromAssetPropertyRequest.Builder> disassociateTimeSeriesFromAssetPropertyRequest) {
        return disassociateTimeSeriesFromAssetProperty(DisassociateTimeSeriesFromAssetPropertyRequest.builder()
                .applyMutation(disassociateTimeSeriesFromAssetPropertyRequest).build());
    }

    /**
     * <p>
     * Executes an action on a target resource.
     * </p>
     *
     * @param executeActionRequest
     * @return A Java Future containing the result of the ExecuteAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ExecuteAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ExecuteAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecuteActionResponse> executeAction(ExecuteActionRequest executeActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes an action on a target resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteActionRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteActionRequest#builder()}
     * </p>
     *
     * @param executeActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ExecuteActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExecuteAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ExecuteAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ExecuteAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecuteActionResponse> executeAction(Consumer<ExecuteActionRequest.Builder> executeActionRequest) {
        return executeAction(ExecuteActionRequest.builder().applyMutation(executeActionRequest).build());
    }

    /**
     * <p>
     * Run SQL queries to retrieve metadata and time-series data from asset models, assets, measurements, metrics,
     * transforms, and aggregates.
     * </p>
     *
     * @param executeQueryRequest
     * @return A Java Future containing the result of the ExecuteQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ValidationException The validation failed for this query.</li>
     *         <li>QueryTimeoutException The query timed out.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecuteQueryResponse> executeQuery(ExecuteQueryRequest executeQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Run SQL queries to retrieve metadata and time-series data from asset models, assets, measurements, metrics,
     * transforms, and aggregates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteQueryRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteQueryRequest#builder()}
     * </p>
     *
     * @param executeQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ExecuteQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ValidationException The validation failed for this query.</li>
     *         <li>QueryTimeoutException The query timed out.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExecuteQueryResponse> executeQuery(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest) {
        return executeQuery(ExecuteQueryRequest.builder().applyMutation(executeQueryRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #executeQuery(software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ExecuteQueryPublisher publisher = client.executeQueryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ExecuteQueryPublisher publisher = client.executeQueryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #executeQuery(software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryRequest)} operation.</b>
     * </p>
     *
     * @param executeQueryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ValidationException The validation failed for this query.</li>
     *         <li>QueryTimeoutException The query timed out.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default ExecuteQueryPublisher executeQueryPaginator(ExecuteQueryRequest executeQueryRequest) {
        return new ExecuteQueryPublisher(this, executeQueryRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #executeQuery(software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ExecuteQueryPublisher publisher = client.executeQueryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ExecuteQueryPublisher publisher = client.executeQueryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #executeQuery(software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteQueryRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteQueryRequest#builder()}
     * </p>
     *
     * @param executeQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ValidationException The validation failed for this query.</li>
     *         <li>QueryTimeoutException The query timed out.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default ExecuteQueryPublisher executeQueryPaginator(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest) {
        return executeQueryPaginator(ExecuteQueryRequest.builder().applyMutation(executeQueryRequest).build());
    }

    /**
     * <p>
     * Gets aggregated values for an asset property. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetPropertyAggregatesRequest
     * @return A Java Future containing the result of the GetAssetPropertyAggregates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssetPropertyAggregatesResponse> getAssetPropertyAggregates(
            GetAssetPropertyAggregatesRequest getAssetPropertyAggregatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets aggregated values for an asset property. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetPropertyAggregatesRequest.Builder} avoiding
     * the need to create one manually via {@link GetAssetPropertyAggregatesRequest#builder()}
     * </p>
     *
     * @param getAssetPropertyAggregatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetAssetPropertyAggregates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssetPropertyAggregatesResponse> getAssetPropertyAggregates(
            Consumer<GetAssetPropertyAggregatesRequest.Builder> getAssetPropertyAggregatesRequest) {
        return getAssetPropertyAggregates(GetAssetPropertyAggregatesRequest.builder()
                .applyMutation(getAssetPropertyAggregatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyAggregatesPublisher publisher = client.getAssetPropertyAggregatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyAggregatesPublisher publisher = client.getAssetPropertyAggregatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAssetPropertyAggregatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyAggregatesPublisher getAssetPropertyAggregatesPaginator(
            GetAssetPropertyAggregatesRequest getAssetPropertyAggregatesRequest) {
        return new GetAssetPropertyAggregatesPublisher(this, getAssetPropertyAggregatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyAggregatesPublisher publisher = client.getAssetPropertyAggregatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyAggregatesPublisher publisher = client.getAssetPropertyAggregatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAssetPropertyAggregates(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetPropertyAggregatesRequest.Builder} avoiding
     * the need to create one manually via {@link GetAssetPropertyAggregatesRequest#builder()}
     * </p>
     *
     * @param getAssetPropertyAggregatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetAssetPropertyAggregates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyAggregatesPublisher getAssetPropertyAggregatesPaginator(
            Consumer<GetAssetPropertyAggregatesRequest.Builder> getAssetPropertyAggregatesRequest) {
        return getAssetPropertyAggregatesPaginator(GetAssetPropertyAggregatesRequest.builder()
                .applyMutation(getAssetPropertyAggregatesRequest).build());
    }

    /**
     * <p>
     * Gets an asset property's current value. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetPropertyValueRequest
     * @return A Java Future containing the result of the GetAssetPropertyValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssetPropertyValueResponse> getAssetPropertyValue(
            GetAssetPropertyValueRequest getAssetPropertyValueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an asset property's current value. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetPropertyValueRequest.Builder} avoiding the
     * need to create one manually via {@link GetAssetPropertyValueRequest#builder()}
     * </p>
     *
     * @param getAssetPropertyValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAssetPropertyValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetAssetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssetPropertyValueResponse> getAssetPropertyValue(
            Consumer<GetAssetPropertyValueRequest.Builder> getAssetPropertyValueRequest) {
        return getAssetPropertyValue(GetAssetPropertyValueRequest.builder().applyMutation(getAssetPropertyValueRequest).build());
    }

    /**
     * <p>
     * Gets the history of an asset property's values. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getAssetPropertyValueHistoryRequest
     * @return A Java Future containing the result of the GetAssetPropertyValueHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssetPropertyValueHistoryResponse> getAssetPropertyValueHistory(
            GetAssetPropertyValueHistoryRequest getAssetPropertyValueHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the history of an asset property's values. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetPropertyValueHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link GetAssetPropertyValueHistoryRequest#builder()}
     * </p>
     *
     * @param getAssetPropertyValueHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetAssetPropertyValueHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssetPropertyValueHistoryResponse> getAssetPropertyValueHistory(
            Consumer<GetAssetPropertyValueHistoryRequest.Builder> getAssetPropertyValueHistoryRequest) {
        return getAssetPropertyValueHistory(GetAssetPropertyValueHistoryRequest.builder()
                .applyMutation(getAssetPropertyValueHistoryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyValueHistoryPublisher publisher = client.getAssetPropertyValueHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyValueHistoryPublisher publisher = client.getAssetPropertyValueHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAssetPropertyValueHistoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyValueHistoryPublisher getAssetPropertyValueHistoryPaginator(
            GetAssetPropertyValueHistoryRequest getAssetPropertyValueHistoryRequest) {
        return new GetAssetPropertyValueHistoryPublisher(this, getAssetPropertyValueHistoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyValueHistoryPublisher publisher = client.getAssetPropertyValueHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetAssetPropertyValueHistoryPublisher publisher = client.getAssetPropertyValueHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAssetPropertyValueHistory(software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetPropertyValueHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link GetAssetPropertyValueHistoryRequest#builder()}
     * </p>
     *
     * @param getAssetPropertyValueHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetAssetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssetPropertyValueHistoryPublisher getAssetPropertyValueHistoryPaginator(
            Consumer<GetAssetPropertyValueHistoryRequest.Builder> getAssetPropertyValueHistoryRequest) {
        return getAssetPropertyValueHistoryPaginator(GetAssetPropertyValueHistoryRequest.builder()
                .applyMutation(getAssetPropertyValueHistoryRequest).build());
    }

    /**
     * <p>
     * Get interpolated values for an asset property for a specified time interval, during a period of time. If your
     * time series is missing data points during the specified time interval, you can use interpolation to estimate the
     * missing data.
     * </p>
     * <p>
     * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24
     * hours over a duration of 7 days.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getInterpolatedAssetPropertyValuesRequest
     * @return A Java Future containing the result of the GetInterpolatedAssetPropertyValues operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetInterpolatedAssetPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetInterpolatedAssetPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInterpolatedAssetPropertyValuesResponse> getInterpolatedAssetPropertyValues(
            GetInterpolatedAssetPropertyValuesRequest getInterpolatedAssetPropertyValuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get interpolated values for an asset property for a specified time interval, during a period of time. If your
     * time series is missing data points during the specified time interval, you can use interpolation to estimate the
     * missing data.
     * </p>
     * <p>
     * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24
     * hours over a duration of 7 days.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInterpolatedAssetPropertyValuesRequest.Builder}
     * avoiding the need to create one manually via {@link GetInterpolatedAssetPropertyValuesRequest#builder()}
     * </p>
     *
     * @param getInterpolatedAssetPropertyValuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetInterpolatedAssetPropertyValues operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetInterpolatedAssetPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetInterpolatedAssetPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInterpolatedAssetPropertyValuesResponse> getInterpolatedAssetPropertyValues(
            Consumer<GetInterpolatedAssetPropertyValuesRequest.Builder> getInterpolatedAssetPropertyValuesRequest) {
        return getInterpolatedAssetPropertyValues(GetInterpolatedAssetPropertyValuesRequest.builder()
                .applyMutation(getInterpolatedAssetPropertyValuesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getInterpolatedAssetPropertyValues(software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetInterpolatedAssetPropertyValuesPublisher publisher = client.getInterpolatedAssetPropertyValuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetInterpolatedAssetPropertyValuesPublisher publisher = client.getInterpolatedAssetPropertyValuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInterpolatedAssetPropertyValues(software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getInterpolatedAssetPropertyValuesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetInterpolatedAssetPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetInterpolatedAssetPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInterpolatedAssetPropertyValuesPublisher getInterpolatedAssetPropertyValuesPaginator(
            GetInterpolatedAssetPropertyValuesRequest getInterpolatedAssetPropertyValuesRequest) {
        return new GetInterpolatedAssetPropertyValuesPublisher(this, getInterpolatedAssetPropertyValuesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getInterpolatedAssetPropertyValues(software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetInterpolatedAssetPropertyValuesPublisher publisher = client.getInterpolatedAssetPropertyValuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.GetInterpolatedAssetPropertyValuesPublisher publisher = client.getInterpolatedAssetPropertyValuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInterpolatedAssetPropertyValues(software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInterpolatedAssetPropertyValuesRequest.Builder}
     * avoiding the need to create one manually via {@link GetInterpolatedAssetPropertyValuesRequest#builder()}
     * </p>
     *
     * @param getInterpolatedAssetPropertyValuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ServiceUnavailableException The requested service is unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.GetInterpolatedAssetPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetInterpolatedAssetPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInterpolatedAssetPropertyValuesPublisher getInterpolatedAssetPropertyValuesPaginator(
            Consumer<GetInterpolatedAssetPropertyValuesRequest.Builder> getInterpolatedAssetPropertyValuesRequest) {
        return getInterpolatedAssetPropertyValuesPaginator(GetInterpolatedAssetPropertyValuesRequest.builder()
                .applyMutation(getInterpolatedAssetPropertyValuesRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of access policies for an identity (an IAM Identity Center user, an IAM Identity
     * Center group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
     * </p>
     *
     * @param listAccessPoliciesRequest
     * @return A Java Future containing the result of the ListAccessPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessPoliciesResponse> listAccessPolicies(ListAccessPoliciesRequest listAccessPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of access policies for an identity (an IAM Identity Center user, an IAM Identity
     * Center group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccessPoliciesRequest#builder()}
     * </p>
     *
     * @param listAccessPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAccessPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessPoliciesResponse> listAccessPolicies(
            Consumer<ListAccessPoliciesRequest.Builder> listAccessPoliciesRequest) {
        return listAccessPolicies(ListAccessPoliciesRequest.builder().applyMutation(listAccessPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessPolicies(software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAccessPoliciesPublisher publisher = client.listAccessPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAccessPoliciesPublisher publisher = client.listAccessPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessPolicies(software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPoliciesPublisher listAccessPoliciesPaginator(ListAccessPoliciesRequest listAccessPoliciesRequest) {
        return new ListAccessPoliciesPublisher(this, listAccessPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessPolicies(software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAccessPoliciesPublisher publisher = client.listAccessPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAccessPoliciesPublisher publisher = client.listAccessPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessPolicies(software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccessPoliciesRequest#builder()}
     * </p>
     *
     * @param listAccessPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPoliciesPublisher listAccessPoliciesPaginator(
            Consumer<ListAccessPoliciesRequest.Builder> listAccessPoliciesRequest) {
        return listAccessPoliciesPaginator(ListAccessPoliciesRequest.builder().applyMutation(listAccessPoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of actions for a specific target resource.
     * </p>
     *
     * @param listActionsRequest
     * @return A Java Future containing the result of the ListActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListActionsResponse> listActions(ListActionsRequest listActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of actions for a specific target resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListActionsRequest#builder()}
     * </p>
     *
     * @param listActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListActionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListActionsResponse> listActions(Consumer<ListActionsRequest.Builder> listActionsRequest) {
        return listActions(ListActionsRequest.builder().applyMutation(listActionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listActions(software.amazon.awssdk.services.iotsitewise.model.ListActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListActionsPublisher publisher = client.listActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListActionsPublisher publisher = client.listActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActions(software.amazon.awssdk.services.iotsitewise.model.ListActionsRequest)} operation.</b>
     * </p>
     *
     * @param listActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActionsPublisher listActionsPaginator(ListActionsRequest listActionsRequest) {
        return new ListActionsPublisher(this, listActionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listActions(software.amazon.awssdk.services.iotsitewise.model.ListActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListActionsPublisher publisher = client.listActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListActionsPublisher publisher = client.listActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActions(software.amazon.awssdk.services.iotsitewise.model.ListActionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListActionsRequest#builder()}
     * </p>
     *
     * @param listActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListActionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListActionsPublisher listActionsPaginator(Consumer<ListActionsRequest.Builder> listActionsRequest) {
        return listActionsPaginator(ListActionsRequest.builder().applyMutation(listActionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of composite models associated with the asset model
     * </p>
     *
     * @param listAssetModelCompositeModelsRequest
     * @return A Java Future containing the result of the ListAssetModelCompositeModels operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModelCompositeModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelCompositeModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssetModelCompositeModelsResponse> listAssetModelCompositeModels(
            ListAssetModelCompositeModelsRequest listAssetModelCompositeModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of composite models associated with the asset model
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetModelCompositeModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAssetModelCompositeModelsRequest#builder()}
     * </p>
     *
     * @param listAssetModelCompositeModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAssetModelCompositeModels operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModelCompositeModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelCompositeModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssetModelCompositeModelsResponse> listAssetModelCompositeModels(
            Consumer<ListAssetModelCompositeModelsRequest.Builder> listAssetModelCompositeModelsRequest) {
        return listAssetModelCompositeModels(ListAssetModelCompositeModelsRequest.builder()
                .applyMutation(listAssetModelCompositeModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetModelCompositeModels(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelCompositeModelsPublisher publisher = client.listAssetModelCompositeModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelCompositeModelsPublisher publisher = client.listAssetModelCompositeModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetModelCompositeModels(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssetModelCompositeModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModelCompositeModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelCompositeModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetModelCompositeModelsPublisher listAssetModelCompositeModelsPaginator(
            ListAssetModelCompositeModelsRequest listAssetModelCompositeModelsRequest) {
        return new ListAssetModelCompositeModelsPublisher(this, listAssetModelCompositeModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetModelCompositeModels(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelCompositeModelsPublisher publisher = client.listAssetModelCompositeModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelCompositeModelsPublisher publisher = client.listAssetModelCompositeModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetModelCompositeModels(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetModelCompositeModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAssetModelCompositeModelsRequest#builder()}
     * </p>
     *
     * @param listAssetModelCompositeModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModelCompositeModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelCompositeModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetModelCompositeModelsPublisher listAssetModelCompositeModelsPaginator(
            Consumer<ListAssetModelCompositeModelsRequest.Builder> listAssetModelCompositeModelsRequest) {
        return listAssetModelCompositeModelsPaginator(ListAssetModelCompositeModelsRequest.builder()
                .applyMutation(listAssetModelCompositeModelsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset model. If you update properties associated with
     * the model before you finish listing all the properties, you need to start all over again.
     * </p>
     *
     * @param listAssetModelPropertiesRequest
     * @return A Java Future containing the result of the ListAssetModelProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModelProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssetModelPropertiesResponse> listAssetModelProperties(
            ListAssetModelPropertiesRequest listAssetModelPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset model. If you update properties associated with
     * the model before you finish listing all the properties, you need to start all over again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetModelPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssetModelPropertiesRequest#builder()}
     * </p>
     *
     * @param listAssetModelPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAssetModelProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModelProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssetModelPropertiesResponse> listAssetModelProperties(
            Consumer<ListAssetModelPropertiesRequest.Builder> listAssetModelPropertiesRequest) {
        return listAssetModelProperties(ListAssetModelPropertiesRequest.builder().applyMutation(listAssetModelPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetModelProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelPropertiesPublisher publisher = client.listAssetModelPropertiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelPropertiesPublisher publisher = client.listAssetModelPropertiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetModelProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssetModelPropertiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModelProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetModelPropertiesPublisher listAssetModelPropertiesPaginator(
            ListAssetModelPropertiesRequest listAssetModelPropertiesRequest) {
        return new ListAssetModelPropertiesPublisher(this, listAssetModelPropertiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetModelProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelPropertiesPublisher publisher = client.listAssetModelPropertiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelPropertiesPublisher publisher = client.listAssetModelPropertiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetModelProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetModelPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssetModelPropertiesRequest#builder()}
     * </p>
     *
     * @param listAssetModelPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModelProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetModelPropertiesPublisher listAssetModelPropertiesPaginator(
            Consumer<ListAssetModelPropertiesRequest.Builder> listAssetModelPropertiesRequest) {
        return listAssetModelPropertiesPaginator(ListAssetModelPropertiesRequest.builder()
                .applyMutation(listAssetModelPropertiesRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of summaries of all asset models.
     * </p>
     *
     * @param listAssetModelsRequest
     * @return A Java Future containing the result of the ListAssetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssetModelsResponse> listAssetModels(ListAssetModelsRequest listAssetModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of summaries of all asset models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetModelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssetModelsRequest#builder()}
     * </p>
     *
     * @param listAssetModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssetModelsResponse> listAssetModels(
            Consumer<ListAssetModelsRequest.Builder> listAssetModelsRequest) {
        return listAssetModels(ListAssetModelsRequest.builder().applyMutation(listAssetModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetModels(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelsPublisher publisher = client.listAssetModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelsPublisher publisher = client.listAssetModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetModels(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest)} operation.</b>
     * </p>
     *
     * @param listAssetModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetModelsPublisher listAssetModelsPaginator(ListAssetModelsRequest listAssetModelsRequest) {
        return new ListAssetModelsPublisher(this, listAssetModelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetModels(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelsPublisher publisher = client.listAssetModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetModelsPublisher publisher = client.listAssetModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetModels(software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetModelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssetModelsRequest#builder()}
     * </p>
     *
     * @param listAssetModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetModelsPublisher listAssetModelsPaginator(Consumer<ListAssetModelsRequest.Builder> listAssetModelsRequest) {
        return listAssetModelsPaginator(ListAssetModelsRequest.builder().applyMutation(listAssetModelsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset. If you update properties associated with the
     * model before you finish listing all the properties, you need to start all over again.
     * </p>
     *
     * @param listAssetPropertiesRequest
     * @return A Java Future containing the result of the ListAssetProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssetPropertiesResponse> listAssetProperties(
            ListAssetPropertiesRequest listAssetPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset. If you update properties associated with the
     * model before you finish listing all the properties, you need to start all over again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetPropertiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetPropertiesRequest#builder()}
     * </p>
     *
     * @param listAssetPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssetProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssetPropertiesResponse> listAssetProperties(
            Consumer<ListAssetPropertiesRequest.Builder> listAssetPropertiesRequest) {
        return listAssetProperties(ListAssetPropertiesRequest.builder().applyMutation(listAssetPropertiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetPropertiesPublisher publisher = client.listAssetPropertiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetPropertiesPublisher publisher = client.listAssetPropertiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssetPropertiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetPropertiesPublisher listAssetPropertiesPaginator(ListAssetPropertiesRequest listAssetPropertiesRequest) {
        return new ListAssetPropertiesPublisher(this, listAssetPropertiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetPropertiesPublisher publisher = client.listAssetPropertiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetPropertiesPublisher publisher = client.listAssetPropertiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetProperties(software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetPropertiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetPropertiesRequest#builder()}
     * </p>
     *
     * @param listAssetPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetPropertiesPublisher listAssetPropertiesPaginator(
            Consumer<ListAssetPropertiesRequest.Builder> listAssetPropertiesRequest) {
        return listAssetPropertiesPaginator(ListAssetPropertiesRequest.builder().applyMutation(listAssetPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a paginated list of asset relationships for an asset. You can use this operation to identify an asset's
     * root asset and all associated assets between that asset and its root.
     * </p>
     *
     * @param listAssetRelationshipsRequest
     * @return A Java Future containing the result of the ListAssetRelationships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssetRelationshipsResponse> listAssetRelationships(
            ListAssetRelationshipsRequest listAssetRelationshipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of asset relationships for an asset. You can use this operation to identify an asset's
     * root asset and all associated assets between that asset and its root.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetRelationshipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetRelationshipsRequest#builder()}
     * </p>
     *
     * @param listAssetRelationshipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListAssetRelationships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssetRelationshipsResponse> listAssetRelationships(
            Consumer<ListAssetRelationshipsRequest.Builder> listAssetRelationshipsRequest) {
        return listAssetRelationships(ListAssetRelationshipsRequest.builder().applyMutation(listAssetRelationshipsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetRelationships(software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetRelationshipsPublisher publisher = client.listAssetRelationshipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetRelationshipsPublisher publisher = client.listAssetRelationshipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetRelationships(software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssetRelationshipsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetRelationshipsPublisher listAssetRelationshipsPaginator(
            ListAssetRelationshipsRequest listAssetRelationshipsRequest) {
        return new ListAssetRelationshipsPublisher(this, listAssetRelationshipsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetRelationships(software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetRelationshipsPublisher publisher = client.listAssetRelationshipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetRelationshipsPublisher publisher = client.listAssetRelationshipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetRelationships(software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetRelationshipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetRelationshipsRequest#builder()}
     * </p>
     *
     * @param listAssetRelationshipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssetRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetRelationshipsPublisher listAssetRelationshipsPaginator(
            Consumer<ListAssetRelationshipsRequest.Builder> listAssetRelationshipsRequest) {
        return listAssetRelationshipsPaginator(ListAssetRelationshipsRequest.builder()
                .applyMutation(listAssetRelationshipsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of asset summaries.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List assets based on a specific asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * List top-level assets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't use this operation to list all assets. To retrieve summaries for all of your assets, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels</a>
     * to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.
     * </p>
     *
     * @param listAssetsRequest
     * @return A Java Future containing the result of the ListAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssetsResponse> listAssets(ListAssetsRequest listAssetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of asset summaries.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List assets based on a specific asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * List top-level assets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't use this operation to list all assets. To retrieve summaries for all of your assets, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels</a>
     * to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssetsRequest#builder()}
     * </p>
     *
     * @param listAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssetsResponse> listAssets(Consumer<ListAssetsRequest.Builder> listAssetsRequest) {
        return listAssets(ListAssetsRequest.builder().applyMutation(listAssetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetsPublisher publisher = client.listAssetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetsPublisher publisher = client.listAssetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest)} operation.</b>
     * </p>
     *
     * @param listAssetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetsPublisher listAssetsPaginator(ListAssetsRequest listAssetsRequest) {
        return new ListAssetsPublisher(this, listAssetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetsPublisher publisher = client.listAssetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssetsPublisher publisher = client.listAssetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssetsRequest#builder()}
     * </p>
     *
     * @param listAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetsPublisher listAssetsPaginator(Consumer<ListAssetsRequest.Builder> listAssetsRequest) {
        return listAssetsPaginator(ListAssetsRequest.builder().applyMutation(listAssetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of associated assets.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHILD</code> - List all child assets associated to the asset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PARENT</code> - List the asset's parent asset.
     * </p>
     * </li>
     * </ul>
     *
     * @param listAssociatedAssetsRequest
     * @return A Java Future containing the result of the ListAssociatedAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssociatedAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssociatedAssetsResponse> listAssociatedAssets(
            ListAssociatedAssetsRequest listAssociatedAssetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of associated assets.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHILD</code> - List all child assets associated to the asset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PARENT</code> - List the asset's parent asset.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedAssetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssociatedAssetsRequest#builder()}
     * </p>
     *
     * @param listAssociatedAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssociatedAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssociatedAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssociatedAssetsResponse> listAssociatedAssets(
            Consumer<ListAssociatedAssetsRequest.Builder> listAssociatedAssetsRequest) {
        return listAssociatedAssets(ListAssociatedAssetsRequest.builder().applyMutation(listAssociatedAssetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssociatedAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssociatedAssetsPublisher publisher = client.listAssociatedAssetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssociatedAssetsPublisher publisher = client.listAssociatedAssetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssociatedAssetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssociatedAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedAssetsPublisher listAssociatedAssetsPaginator(ListAssociatedAssetsRequest listAssociatedAssetsRequest) {
        return new ListAssociatedAssetsPublisher(this, listAssociatedAssetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssociatedAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssociatedAssetsPublisher publisher = client.listAssociatedAssetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListAssociatedAssetsPublisher publisher = client.listAssociatedAssetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedAssets(software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedAssetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssociatedAssetsRequest#builder()}
     * </p>
     *
     * @param listAssociatedAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListAssociatedAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedAssetsPublisher listAssociatedAssetsPaginator(
            Consumer<ListAssociatedAssetsRequest.Builder> listAssociatedAssetsRequest) {
        return listAssociatedAssetsPaginator(ListAssociatedAssetsRequest.builder().applyMutation(listAssociatedAssetsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a paginated list of bulk import job requests. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ListBulkImportJobs.html">List bulk import jobs
     * (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param listBulkImportJobsRequest
     * @return A Java Future containing the result of the ListBulkImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListBulkImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListBulkImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBulkImportJobsResponse> listBulkImportJobs(ListBulkImportJobsRequest listBulkImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of bulk import job requests. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ListBulkImportJobs.html">List bulk import jobs
     * (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBulkImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBulkImportJobsRequest#builder()}
     * </p>
     *
     * @param listBulkImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBulkImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListBulkImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListBulkImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBulkImportJobsResponse> listBulkImportJobs(
            Consumer<ListBulkImportJobsRequest.Builder> listBulkImportJobsRequest) {
        return listBulkImportJobs(ListBulkImportJobsRequest.builder().applyMutation(listBulkImportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBulkImportJobs(software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListBulkImportJobsPublisher publisher = client.listBulkImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListBulkImportJobsPublisher publisher = client.listBulkImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBulkImportJobs(software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBulkImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListBulkImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListBulkImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBulkImportJobsPublisher listBulkImportJobsPaginator(ListBulkImportJobsRequest listBulkImportJobsRequest) {
        return new ListBulkImportJobsPublisher(this, listBulkImportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBulkImportJobs(software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListBulkImportJobsPublisher publisher = client.listBulkImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListBulkImportJobsPublisher publisher = client.listBulkImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBulkImportJobs(software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBulkImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBulkImportJobsRequest#builder()}
     * </p>
     *
     * @param listBulkImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListBulkImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListBulkImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBulkImportJobsPublisher listBulkImportJobsPaginator(
            Consumer<ListBulkImportJobsRequest.Builder> listBulkImportJobsRequest) {
        return listBulkImportJobsPaginator(ListBulkImportJobsRequest.builder().applyMutation(listBulkImportJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of composition relationships for an asset model of type <code>COMPONENT_MODEL</code>.
     * </p>
     *
     * @param listCompositionRelationshipsRequest
     * @return A Java Future containing the result of the ListCompositionRelationships operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListCompositionRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListCompositionRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCompositionRelationshipsResponse> listCompositionRelationships(
            ListCompositionRelationshipsRequest listCompositionRelationshipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of composition relationships for an asset model of type <code>COMPONENT_MODEL</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCompositionRelationshipsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCompositionRelationshipsRequest#builder()}
     * </p>
     *
     * @param listCompositionRelationshipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListCompositionRelationships operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListCompositionRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListCompositionRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCompositionRelationshipsResponse> listCompositionRelationships(
            Consumer<ListCompositionRelationshipsRequest.Builder> listCompositionRelationshipsRequest) {
        return listCompositionRelationships(ListCompositionRelationshipsRequest.builder()
                .applyMutation(listCompositionRelationshipsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCompositionRelationships(software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListCompositionRelationshipsPublisher publisher = client.listCompositionRelationshipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListCompositionRelationshipsPublisher publisher = client.listCompositionRelationshipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompositionRelationships(software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCompositionRelationshipsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListCompositionRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListCompositionRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCompositionRelationshipsPublisher listCompositionRelationshipsPaginator(
            ListCompositionRelationshipsRequest listCompositionRelationshipsRequest) {
        return new ListCompositionRelationshipsPublisher(this, listCompositionRelationshipsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCompositionRelationships(software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListCompositionRelationshipsPublisher publisher = client.listCompositionRelationshipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListCompositionRelationshipsPublisher publisher = client.listCompositionRelationshipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompositionRelationships(software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCompositionRelationshipsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCompositionRelationshipsRequest#builder()}
     * </p>
     *
     * @param listCompositionRelationshipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListCompositionRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListCompositionRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCompositionRelationshipsPublisher listCompositionRelationshipsPaginator(
            Consumer<ListCompositionRelationshipsRequest.Builder> listCompositionRelationshipsRequest) {
        return listCompositionRelationshipsPaginator(ListCompositionRelationshipsRequest.builder()
                .applyMutation(listCompositionRelationshipsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
     * </p>
     *
     * @param listDashboardsRequest
     * @return A Java Future containing the result of the ListDashboards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDashboardsResponse> listDashboards(ListDashboardsRequest listDashboardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDashboardsRequest#builder()}
     * </p>
     *
     * @param listDashboardsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDashboards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDashboardsResponse> listDashboards(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest) {
        return listDashboards(ListDashboardsRequest.builder().applyMutation(listDashboardsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDashboards(software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListDashboardsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListDashboardsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboards(software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest)} operation.</b>
     * </p>
     *
     * @param listDashboardsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDashboardsPublisher listDashboardsPaginator(ListDashboardsRequest listDashboardsRequest) {
        return new ListDashboardsPublisher(this, listDashboardsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDashboards(software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListDashboardsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListDashboardsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboards(software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDashboardsRequest#builder()}
     * </p>
     *
     * @param listDashboardsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListDashboardsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDashboardsPublisher listDashboardsPaginator(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest) {
        return listDashboardsPaginator(ListDashboardsRequest.builder().applyMutation(listDashboardsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of gateways.
     * </p>
     *
     * @param listGatewaysRequest
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGatewaysResponse> listGateways(ListGatewaysRequest listGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGatewaysResponse> listGateways(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest) {
        return listGateways(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listGateways(software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest)} operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewaysPublisher listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) {
        return new ListGatewaysPublisher(this, listGatewaysRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listGateways(software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListGatewaysRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewaysPublisher listGatewaysPaginator(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest) {
        return listGatewaysPaginator(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of IoT SiteWise Monitor portals.
     * </p>
     *
     * @param listPortalsRequest
     * @return A Java Future containing the result of the ListPortals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPortalsResponse> listPortals(ListPortalsRequest listPortalsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of IoT SiteWise Monitor portals.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPortalsRequest#builder()}
     * </p>
     *
     * @param listPortalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPortals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPortalsResponse> listPortals(Consumer<ListPortalsRequest.Builder> listPortalsRequest) {
        return listPortals(ListPortalsRequest.builder().applyMutation(listPortalsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPortals(software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListPortalsPublisher publisher = client.listPortalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListPortalsPublisher publisher = client.listPortalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortals(software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest)} operation.</b>
     * </p>
     *
     * @param listPortalsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPortalsPublisher listPortalsPaginator(ListPortalsRequest listPortalsRequest) {
        return new ListPortalsPublisher(this, listPortalsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listPortals(software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListPortalsPublisher publisher = client.listPortalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListPortalsPublisher publisher = client.listPortalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortals(software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPortalsRequest#builder()}
     * </p>
     *
     * @param listPortalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPortalsPublisher listPortalsPaginator(Consumer<ListPortalsRequest.Builder> listPortalsRequest) {
        return listPortalsPaginator(ListPortalsRequest.builder().applyMutation(listPortalsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
     * </p>
     *
     * @param listProjectAssetsRequest
     * @return A Java Future containing the result of the ListProjectAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListProjectAssetsResponse> listProjectAssets(ListProjectAssetsRequest listProjectAssetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectAssetsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProjectAssetsRequest#builder()}
     * </p>
     *
     * @param listProjectAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListProjectAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListProjectAssetsResponse> listProjectAssets(
            Consumer<ListProjectAssetsRequest.Builder> listProjectAssetsRequest) {
        return listProjectAssets(ListProjectAssetsRequest.builder().applyMutation(listProjectAssetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProjectAssets(software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectAssetsPublisher publisher = client.listProjectAssetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectAssetsPublisher publisher = client.listProjectAssetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectAssets(software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProjectAssetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectAssetsPublisher listProjectAssetsPaginator(ListProjectAssetsRequest listProjectAssetsRequest) {
        return new ListProjectAssetsPublisher(this, listProjectAssetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProjectAssets(software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectAssetsPublisher publisher = client.listProjectAssetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectAssetsPublisher publisher = client.listProjectAssetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjectAssets(software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectAssetsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProjectAssetsRequest#builder()}
     * </p>
     *
     * @param listProjectAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListProjectAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProjectAssetsPublisher listProjectAssetsPaginator(
            Consumer<ListProjectAssetsRequest.Builder> listProjectAssetsRequest) {
        return listProjectAssetsPaginator(ListProjectAssetsRequest.builder().applyMutation(listProjectAssetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
     * </p>
     *
     * @param listProjectsRequest
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects(ListProjectsRequest listProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator(ListProjectsRequest listProjectsRequest) {
        return new ListProjectsPublisher(this, listProjectsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of tags for an IoT SiteWise resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>UnauthorizedException You are not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of tags for an IoT SiteWise resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>UnauthorizedException You are not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of time series (data streams).
     * </p>
     *
     * @param listTimeSeriesRequest
     * @return A Java Future containing the result of the ListTimeSeries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTimeSeriesResponse> listTimeSeries(ListTimeSeriesRequest listTimeSeriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of time series (data streams).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTimeSeriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTimeSeriesRequest#builder()}
     * </p>
     *
     * @param listTimeSeriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTimeSeries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTimeSeriesResponse> listTimeSeries(Consumer<ListTimeSeriesRequest.Builder> listTimeSeriesRequest) {
        return listTimeSeries(ListTimeSeriesRequest.builder().applyMutation(listTimeSeriesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTimeSeries(software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListTimeSeriesPublisher publisher = client.listTimeSeriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListTimeSeriesPublisher publisher = client.listTimeSeriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTimeSeries(software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest)} operation.</b>
     * </p>
     *
     * @param listTimeSeriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTimeSeriesPublisher listTimeSeriesPaginator(ListTimeSeriesRequest listTimeSeriesRequest) {
        return new ListTimeSeriesPublisher(this, listTimeSeriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTimeSeries(software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListTimeSeriesPublisher publisher = client.listTimeSeriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsitewise.paginators.ListTimeSeriesPublisher publisher = client.listTimeSeriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTimeSeries(software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTimeSeriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTimeSeriesRequest#builder()}
     * </p>
     *
     * @param listTimeSeriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.ListTimeSeries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTimeSeriesPublisher listTimeSeriesPaginator(Consumer<ListTimeSeriesRequest.Builder> listTimeSeriesRequest) {
        return listTimeSeriesPaginator(ListTimeSeriesRequest.builder().applyMutation(listTimeSeriesRequest).build());
    }

    /**
     * <p>
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param putDefaultEncryptionConfigurationRequest
     * @return A Java Future containing the result of the PutDefaultEncryptionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.PutDefaultEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDefaultEncryptionConfigurationResponse> putDefaultEncryptionConfiguration(
            PutDefaultEncryptionConfigurationRequest putDefaultEncryptionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDefaultEncryptionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutDefaultEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param putDefaultEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutDefaultEncryptionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.PutDefaultEncryptionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDefaultEncryptionConfigurationResponse> putDefaultEncryptionConfiguration(
            Consumer<PutDefaultEncryptionConfigurationRequest.Builder> putDefaultEncryptionConfigurationRequest) {
        return putDefaultEncryptionConfiguration(PutDefaultEncryptionConfigurationRequest.builder()
                .applyMutation(putDefaultEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Sets logging options for IoT SiteWise.
     * </p>
     *
     * @param putLoggingOptionsRequest
     * @return A Java Future containing the result of the PutLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutLoggingOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutLoggingOptionsResponse> putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets logging options for IoT SiteWise.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLoggingOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link PutLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param putLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.PutLoggingOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.PutLoggingOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutLoggingOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutLoggingOptionsResponse> putLoggingOptions(
            Consumer<PutLoggingOptionsRequest.Builder> putLoggingOptionsRequest) {
        return putLoggingOptions(PutLoggingOptionsRequest.builder().applyMutation(putLoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Configures storage settings for IoT SiteWise.
     * </p>
     *
     * @param putStorageConfigurationRequest
     * @return A Java Future containing the result of the PutStorageConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.PutStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutStorageConfigurationResponse> putStorageConfiguration(
            PutStorageConfigurationRequest putStorageConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures storage settings for IoT SiteWise.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutStorageConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutStorageConfigurationRequest#builder()}
     * </p>
     *
     * @param putStorageConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutStorageConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.PutStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutStorageConfigurationResponse> putStorageConfiguration(
            Consumer<PutStorageConfigurationRequest.Builder> putStorageConfigurationRequest) {
        return putStorageConfiguration(PutStorageConfigurationRequest.builder().applyMutation(putStorageConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation updates the tag's
     * value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>UnauthorizedException You are not authorized.</li>
     *         <li>TooManyTagsException You've reached the limit for the number of tags allowed for a resource. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag naming limits
     *         and requirements</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation updates the tag's
     * value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>UnauthorizedException You are not authorized.</li>
     *         <li>TooManyTagsException You've reached the limit for the number of tags allowed for a resource. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag naming limits
     *         and requirements</a> in the <i>Amazon Web Services General Reference</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from an IoT SiteWise resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>UnauthorizedException You are not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from an IoT SiteWise resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>UnauthorizedException You are not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor portal or
     * project resource.
     * </p>
     *
     * @param updateAccessPolicyRequest
     * @return A Java Future containing the result of the UpdateAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccessPolicyResponse> updateAccessPolicy(UpdateAccessPolicyRequest updateAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor portal or
     * project resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAccessPolicyRequest#builder()}
     * </p>
     *
     * @param updateAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccessPolicyResponse> updateAccessPolicy(
            Consumer<UpdateAccessPolicyRequest.Builder> updateAccessPolicyRequest) {
        return updateAccessPolicy(UpdateAccessPolicyRequest.builder().applyMutation(updateAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Updates an asset's name. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param updateAssetRequest
     * @return A Java Future containing the result of the UpdateAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAssetResponse> updateAsset(UpdateAssetRequest updateAssetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an asset's name. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAssetRequest#builder()}
     * </p>
     *
     * @param updateAssetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.UpdateAssetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAsset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAssetResponse> updateAsset(Consumer<UpdateAssetRequest.Builder> updateAssetRequest) {
        return updateAsset(UpdateAssetRequest.builder().applyMutation(updateAssetRequest).build());
    }

    /**
     * <p>
     * Updates an asset model and all of the assets that were created from the model. Each asset created from the model
     * inherits the updated asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <important>
     * <p>
     * If you remove a property from an asset model, IoT SiteWise deletes all previous data for that property. You can’t
     * change the type or data type of an existing property.
     * </p>
     * <p>
     * To replace an existing asset model property with a new one with the same <code>name</code>, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Submit an <code>UpdateAssetModel</code> request with the entire existing property removed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a second <code>UpdateAssetModel</code> request that includes the new property. The new asset property will
     * have the same <code>name</code> as the previous one and IoT SiteWise will generate a new unique <code>id</code>.
     * </p>
     * </li>
     * </ol>
     * </important>
     *
     * @param updateAssetModelRequest
     * @return A Java Future containing the result of the UpdateAssetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request-header fields evaluated to
     *         <code>FALSE</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAssetModelResponse> updateAssetModel(UpdateAssetModelRequest updateAssetModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an asset model and all of the assets that were created from the model. Each asset created from the model
     * inherits the updated asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <important>
     * <p>
     * If you remove a property from an asset model, IoT SiteWise deletes all previous data for that property. You can’t
     * change the type or data type of an existing property.
     * </p>
     * <p>
     * To replace an existing asset model property with a new one with the same <code>name</code>, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Submit an <code>UpdateAssetModel</code> request with the entire existing property removed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a second <code>UpdateAssetModel</code> request that includes the new property. The new asset property will
     * have the same <code>name</code> as the previous one and IoT SiteWise will generate a new unique <code>id</code>.
     * </p>
     * </li>
     * </ol>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssetModelRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAssetModelRequest#builder()}
     * </p>
     *
     * @param updateAssetModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAssetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request-header fields evaluated to
     *         <code>FALSE</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAssetModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAssetModelResponse> updateAssetModel(
            Consumer<UpdateAssetModelRequest.Builder> updateAssetModelRequest) {
        return updateAssetModel(UpdateAssetModelRequest.builder().applyMutation(updateAssetModelRequest).build());
    }

    /**
     * <p>
     * Updates a composite model and all of the assets that were created from the model. Each asset created from the
     * model inherits the updated asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <important>
     * <p>
     * If you remove a property from a composite asset model, IoT SiteWise deletes all previous data for that property.
     * You can’t change the type or data type of an existing property.
     * </p>
     * <p>
     * To replace an existing composite asset model property with a new one with the same <code>name</code>, do the
     * following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Submit an <code>UpdateAssetModelCompositeModel</code> request with the entire existing property removed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a second <code>UpdateAssetModelCompositeModel</code> request that includes the new property. The new asset
     * property will have the same <code>name</code> as the previous one and IoT SiteWise will generate a new unique
     * <code>id</code>.
     * </p>
     * </li>
     * </ol>
     * </important>
     *
     * @param updateAssetModelCompositeModelRequest
     * @return A Java Future containing the result of the UpdateAssetModelCompositeModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request-header fields evaluated to
     *         <code>FALSE</code>.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAssetModelCompositeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModelCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssetModelCompositeModelResponse> updateAssetModelCompositeModel(
            UpdateAssetModelCompositeModelRequest updateAssetModelCompositeModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a composite model and all of the assets that were created from the model. Each asset created from the
     * model inherits the updated asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <important>
     * <p>
     * If you remove a property from a composite asset model, IoT SiteWise deletes all previous data for that property.
     * You can’t change the type or data type of an existing property.
     * </p>
     * <p>
     * To replace an existing composite asset model property with a new one with the same <code>name</code>, do the
     * following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Submit an <code>UpdateAssetModelCompositeModel</code> request with the entire existing property removed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a second <code>UpdateAssetModelCompositeModel</code> request that includes the new property. The new asset
     * property will have the same <code>name</code> as the previous one and IoT SiteWise will generate a new unique
     * <code>id</code>.
     * </p>
     * </li>
     * </ol>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssetModelCompositeModelRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAssetModelCompositeModelRequest#builder()}
     * </p>
     *
     * @param updateAssetModelCompositeModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelCompositeModelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAssetModelCompositeModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request-header fields evaluated to
     *         <code>FALSE</code>.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAssetModelCompositeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModelCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssetModelCompositeModelResponse> updateAssetModelCompositeModel(
            Consumer<UpdateAssetModelCompositeModelRequest.Builder> updateAssetModelCompositeModelRequest) {
        return updateAssetModelCompositeModel(UpdateAssetModelCompositeModelRequest.builder()
                .applyMutation(updateAssetModelCompositeModelRequest).build());
    }

    /**
     * <p>
     * Updates an asset property's alias and notification state.
     * </p>
     * <important>
     * <p>
     * This operation overwrites the property's existing alias and notification state. To keep your existing property's
     * alias or notification state, you must include the existing values in the UpdateAssetProperty request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html"
     * >DescribeAssetProperty</a>.
     * </p>
     * </important>
     *
     * @param updateAssetPropertyRequest
     * @return A Java Future containing the result of the UpdateAssetProperty operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssetPropertyResponse> updateAssetProperty(
            UpdateAssetPropertyRequest updateAssetPropertyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an asset property's alias and notification state.
     * </p>
     * <important>
     * <p>
     * This operation overwrites the property's existing alias and notification state. To keep your existing property's
     * alias or notification state, you must include the existing values in the UpdateAssetProperty request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html"
     * >DescribeAssetProperty</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssetPropertyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAssetPropertyRequest#builder()}
     * </p>
     *
     * @param updateAssetPropertyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAssetProperty operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateAssetProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAssetPropertyResponse> updateAssetProperty(
            Consumer<UpdateAssetPropertyRequest.Builder> updateAssetPropertyRequest) {
        return updateAssetProperty(UpdateAssetPropertyRequest.builder().applyMutation(updateAssetPropertyRequest).build());
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor dashboard.
     * </p>
     *
     * @param updateDashboardRequest
     * @return A Java Future containing the result of the UpdateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDashboardResponse> updateDashboard(UpdateDashboardRequest updateDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor dashboard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDashboardRequest#builder()}
     * </p>
     *
     * @param updateDashboardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDashboardResponse> updateDashboard(
            Consumer<UpdateDashboardRequest.Builder> updateDashboardRequest) {
        return updateDashboard(UpdateDashboardRequest.builder().applyMutation(updateDashboardRequest).build());
    }

    /**
     * <p>
     * Updates a gateway's name.
     * </p>
     *
     * @param updateGatewayRequest
     * @return A Java Future containing the result of the UpdateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGatewayResponse> updateGateway(UpdateGatewayRequest updateGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a gateway's name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGatewayRequest#builder()}
     * </p>
     *
     * @param updateGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGatewayResponse> updateGateway(Consumer<UpdateGatewayRequest.Builder> updateGatewayRequest) {
        return updateGateway(UpdateGatewayRequest.builder().applyMutation(updateGatewayRequest).build());
    }

    /**
     * <p>
     * Updates a gateway capability configuration or defines a new capability configuration. Each gateway capability
     * defines data sources for a gateway. A capability configuration can contain multiple data source configurations.
     * If you define OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in
     * one capability configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     *
     * @param updateGatewayCapabilityConfigurationRequest
     * @return A Java Future containing the result of the UpdateGatewayCapabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateGatewayCapabilityConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayCapabilityConfigurationResponse> updateGatewayCapabilityConfiguration(
            UpdateGatewayCapabilityConfigurationRequest updateGatewayCapabilityConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a gateway capability configuration or defines a new capability configuration. Each gateway capability
     * defines data sources for a gateway. A capability configuration can contain multiple data source configurations.
     * If you define OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in
     * one capability configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateGatewayCapabilityConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateGatewayCapabilityConfigurationRequest#builder()}
     * </p>
     *
     * @param updateGatewayCapabilityConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateGatewayCapabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>LimitExceededException You've reached the limit for a resource. For example, this can occur if you're
     *         trying to associate more than the allowed number of child assets or attempting to create more than the
     *         allowed number of properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateGatewayCapabilityConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayCapabilityConfigurationResponse> updateGatewayCapabilityConfiguration(
            Consumer<UpdateGatewayCapabilityConfigurationRequest.Builder> updateGatewayCapabilityConfigurationRequest) {
        return updateGatewayCapabilityConfiguration(UpdateGatewayCapabilityConfigurationRequest.builder()
                .applyMutation(updateGatewayCapabilityConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor portal.
     * </p>
     *
     * @param updatePortalRequest
     * @return A Java Future containing the result of the UpdatePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePortalResponse> updatePortal(UpdatePortalRequest updatePortalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePortalRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePortalRequest#builder()}
     * </p>
     *
     * @param updatePortalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdatePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>ConflictingOperationException Your request has conflicting operations. This can occur if you're
     *         trying to perform more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePortalResponse> updatePortal(Consumer<UpdatePortalRequest.Builder> updatePortalRequest) {
        return updatePortal(UpdatePortalRequest.builder().applyMutation(updatePortalRequest).build());
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor project.
     * </p>
     *
     * @param updateProjectRequest
     * @return A Java Future containing the result of the UpdateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProjectResponse> updateProject(UpdateProjectRequest updateProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an IoT SiteWise Monitor project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProjectRequest#builder()}
     * </p>
     *
     * @param updateProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotsitewise.model.UpdateProjectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request isn't valid. This can occur if your request contains malformed
     *         JSON or unsupported characters. Check your request and try again.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>InternalFailureException IoT SiteWise can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a rate limit. For example, you might have exceeded the
     *         number of IoT SiteWise assets that can be created per second, the allowed number of messages per second,
     *         and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSiteWiseException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IoTSiteWiseAsyncClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProjectResponse> updateProject(Consumer<UpdateProjectRequest.Builder> updateProjectRequest) {
        return updateProject(UpdateProjectRequest.builder().applyMutation(updateProjectRequest).build());
    }

    /**
     * Create an instance of {@link IoTSiteWiseAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link IoTSiteWiseAsyncWaiter}
     */
    default IoTSiteWiseAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default IoTSiteWiseServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IoTSiteWiseAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IoTSiteWiseAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IoTSiteWiseAsyncClient}.
     */
    static IoTSiteWiseAsyncClientBuilder builder() {
        return new DefaultIoTSiteWiseAsyncClientBuilder();
    }
}
