/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssetCompositeModelResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeAssetCompositeModelResponse.Builder, DescribeAssetCompositeModelResponse> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(DescribeAssetCompositeModelResponse::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> ASSET_COMPOSITE_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetCompositeModelId").getter(getter(DescribeAssetCompositeModelResponse::assetCompositeModelId))
            .setter(setter(Builder::assetCompositeModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelId").build())
            .build();

    private static final SdkField<String> ASSET_COMPOSITE_MODEL_EXTERNAL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("assetCompositeModelExternalId")
            .getter(getter(DescribeAssetCompositeModelResponse::assetCompositeModelExternalId))
            .setter(setter(Builder::assetCompositeModelExternalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelExternalId")
                    .build()).build();

    private static final SdkField<List<AssetCompositeModelPathSegment>> ASSET_COMPOSITE_MODEL_PATH_FIELD = SdkField
            .<List<AssetCompositeModelPathSegment>> builder(MarshallingType.LIST)
            .memberName("assetCompositeModelPath")
            .getter(getter(DescribeAssetCompositeModelResponse::assetCompositeModelPath))
            .setter(setter(Builder::assetCompositeModelPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelPath").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetCompositeModelPathSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetCompositeModelPathSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ASSET_COMPOSITE_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetCompositeModelName").getter(getter(DescribeAssetCompositeModelResponse::assetCompositeModelName))
            .setter(setter(Builder::assetCompositeModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelName").build())
            .build();

    private static final SdkField<String> ASSET_COMPOSITE_MODEL_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("assetCompositeModelDescription")
            .getter(getter(DescribeAssetCompositeModelResponse::assetCompositeModelDescription))
            .setter(setter(Builder::assetCompositeModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelDescription")
                    .build()).build();

    private static final SdkField<String> ASSET_COMPOSITE_MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetCompositeModelType").getter(getter(DescribeAssetCompositeModelResponse::assetCompositeModelType))
            .setter(setter(Builder::assetCompositeModelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelType").build())
            .build();

    private static final SdkField<List<AssetProperty>> ASSET_COMPOSITE_MODEL_PROPERTIES_FIELD = SdkField
            .<List<AssetProperty>> builder(MarshallingType.LIST)
            .memberName("assetCompositeModelProperties")
            .getter(getter(DescribeAssetCompositeModelResponse::assetCompositeModelProperties))
            .setter(setter(Builder::assetCompositeModelProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelProperties")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetCompositeModelSummary>> ASSET_COMPOSITE_MODEL_SUMMARIES_FIELD = SdkField
            .<List<AssetCompositeModelSummary>> builder(MarshallingType.LIST)
            .memberName("assetCompositeModelSummaries")
            .getter(getter(DescribeAssetCompositeModelResponse::assetCompositeModelSummaries))
            .setter(setter(Builder::assetCompositeModelSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetCompositeModelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetCompositeModelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ActionDefinition>> ACTION_DEFINITIONS_FIELD = SdkField
            .<List<ActionDefinition>> builder(MarshallingType.LIST)
            .memberName("actionDefinitions")
            .getter(getter(DescribeAssetCompositeModelResponse::actionDefinitions))
            .setter(setter(Builder::actionDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            ASSET_COMPOSITE_MODEL_ID_FIELD, ASSET_COMPOSITE_MODEL_EXTERNAL_ID_FIELD, ASSET_COMPOSITE_MODEL_PATH_FIELD,
            ASSET_COMPOSITE_MODEL_NAME_FIELD, ASSET_COMPOSITE_MODEL_DESCRIPTION_FIELD, ASSET_COMPOSITE_MODEL_TYPE_FIELD,
            ASSET_COMPOSITE_MODEL_PROPERTIES_FIELD, ASSET_COMPOSITE_MODEL_SUMMARIES_FIELD, ACTION_DEFINITIONS_FIELD));

    private final String assetId;

    private final String assetCompositeModelId;

    private final String assetCompositeModelExternalId;

    private final List<AssetCompositeModelPathSegment> assetCompositeModelPath;

    private final String assetCompositeModelName;

    private final String assetCompositeModelDescription;

    private final String assetCompositeModelType;

    private final List<AssetProperty> assetCompositeModelProperties;

    private final List<AssetCompositeModelSummary> assetCompositeModelSummaries;

    private final List<ActionDefinition> actionDefinitions;

    private DescribeAssetCompositeModelResponse(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.assetCompositeModelId = builder.assetCompositeModelId;
        this.assetCompositeModelExternalId = builder.assetCompositeModelExternalId;
        this.assetCompositeModelPath = builder.assetCompositeModelPath;
        this.assetCompositeModelName = builder.assetCompositeModelName;
        this.assetCompositeModelDescription = builder.assetCompositeModelDescription;
        this.assetCompositeModelType = builder.assetCompositeModelType;
        this.assetCompositeModelProperties = builder.assetCompositeModelProperties;
        this.assetCompositeModelSummaries = builder.assetCompositeModelSummaries;
        this.actionDefinitions = builder.actionDefinitions;
    }

    /**
     * <p>
     * The ID of the asset, in UUID format. This ID uniquely identifies the asset within IoT SiteWise and can be used
     * with other IoT SiteWise APIs.
     * </p>
     * 
     * @return The ID of the asset, in UUID format. This ID uniquely identifies the asset within IoT SiteWise and can be
     *         used with other IoT SiteWise APIs.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The ID of a composite model on this asset.
     * </p>
     * 
     * @return The ID of a composite model on this asset.
     */
    public final String assetCompositeModelId() {
        return assetCompositeModelId;
    }

    /**
     * <p>
     * An external ID to assign to the asset model.
     * </p>
     * <p>
     * If the composite model is a component-based composite model, or one nested inside a component model, you can only
     * set the external ID using <code>UpdateAssetModelCompositeModel</code> and specifying the derived ID of the model
     * or property from the created model it's a part of.
     * </p>
     * 
     * @return An external ID to assign to the asset model.</p>
     *         <p>
     *         If the composite model is a component-based composite model, or one nested inside a component model, you
     *         can only set the external ID using <code>UpdateAssetModelCompositeModel</code> and specifying the derived
     *         ID of the model or property from the created model it's a part of.
     */
    public final String assetCompositeModelExternalId() {
        return assetCompositeModelExternalId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetCompositeModelPath property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssetCompositeModelPath() {
        return assetCompositeModelPath != null && !(assetCompositeModelPath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The path to the composite model listing the parent composite models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetCompositeModelPath} method.
     * </p>
     * 
     * @return The path to the composite model listing the parent composite models.
     */
    public final List<AssetCompositeModelPathSegment> assetCompositeModelPath() {
        return assetCompositeModelPath;
    }

    /**
     * <p>
     * The unique, friendly name for the composite model.
     * </p>
     * 
     * @return The unique, friendly name for the composite model.
     */
    public final String assetCompositeModelName() {
        return assetCompositeModelName;
    }

    /**
     * <p>
     * A description for the composite model.
     * </p>
     * 
     * @return A description for the composite model.
     */
    public final String assetCompositeModelDescription() {
        return assetCompositeModelDescription;
    }

    /**
     * <p>
     * The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or
     * <code> AWS/L4E_ANOMALY</code>.
     * </p>
     * 
     * @return The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or
     *         <code> AWS/L4E_ANOMALY</code>.
     */
    public final String assetCompositeModelType() {
        return assetCompositeModelType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetCompositeModelProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssetCompositeModelProperties() {
        return assetCompositeModelProperties != null && !(assetCompositeModelProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The property definitions of the composite model that was used to create the asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetCompositeModelProperties} method.
     * </p>
     * 
     * @return The property definitions of the composite model that was used to create the asset.
     */
    public final List<AssetProperty> assetCompositeModelProperties() {
        return assetCompositeModelProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetCompositeModelSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssetCompositeModelSummaries() {
        return assetCompositeModelSummaries != null && !(assetCompositeModelSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of composite model summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetCompositeModelSummaries} method.
     * </p>
     * 
     * @return The list of composite model summaries.
     */
    public final List<AssetCompositeModelSummary> assetCompositeModelSummaries() {
        return assetCompositeModelSummaries;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionDefinitions() {
        return actionDefinitions != null && !(actionDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The available actions for a composite model on this asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionDefinitions} method.
     * </p>
     * 
     * @return The available actions for a composite model on this asset.
     */
    public final List<ActionDefinition> actionDefinitions() {
        return actionDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(assetCompositeModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetCompositeModelExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetCompositeModelPath() ? assetCompositeModelPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assetCompositeModelName());
        hashCode = 31 * hashCode + Objects.hashCode(assetCompositeModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(assetCompositeModelType());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetCompositeModelProperties() ? assetCompositeModelProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetCompositeModelSummaries() ? assetCompositeModelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActionDefinitions() ? actionDefinitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetCompositeModelResponse)) {
            return false;
        }
        DescribeAssetCompositeModelResponse other = (DescribeAssetCompositeModelResponse) obj;
        return Objects.equals(assetId(), other.assetId())
                && Objects.equals(assetCompositeModelId(), other.assetCompositeModelId())
                && Objects.equals(assetCompositeModelExternalId(), other.assetCompositeModelExternalId())
                && hasAssetCompositeModelPath() == other.hasAssetCompositeModelPath()
                && Objects.equals(assetCompositeModelPath(), other.assetCompositeModelPath())
                && Objects.equals(assetCompositeModelName(), other.assetCompositeModelName())
                && Objects.equals(assetCompositeModelDescription(), other.assetCompositeModelDescription())
                && Objects.equals(assetCompositeModelType(), other.assetCompositeModelType())
                && hasAssetCompositeModelProperties() == other.hasAssetCompositeModelProperties()
                && Objects.equals(assetCompositeModelProperties(), other.assetCompositeModelProperties())
                && hasAssetCompositeModelSummaries() == other.hasAssetCompositeModelSummaries()
                && Objects.equals(assetCompositeModelSummaries(), other.assetCompositeModelSummaries())
                && hasActionDefinitions() == other.hasActionDefinitions()
                && Objects.equals(actionDefinitions(), other.actionDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeAssetCompositeModelResponse")
                .add("AssetId", assetId())
                .add("AssetCompositeModelId", assetCompositeModelId())
                .add("AssetCompositeModelExternalId", assetCompositeModelExternalId())
                .add("AssetCompositeModelPath", hasAssetCompositeModelPath() ? assetCompositeModelPath() : null)
                .add("AssetCompositeModelName", assetCompositeModelName())
                .add("AssetCompositeModelDescription", assetCompositeModelDescription())
                .add("AssetCompositeModelType", assetCompositeModelType())
                .add("AssetCompositeModelProperties", hasAssetCompositeModelProperties() ? assetCompositeModelProperties() : null)
                .add("AssetCompositeModelSummaries", hasAssetCompositeModelSummaries() ? assetCompositeModelSummaries() : null)
                .add("ActionDefinitions", hasActionDefinitions() ? actionDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "assetCompositeModelId":
            return Optional.ofNullable(clazz.cast(assetCompositeModelId()));
        case "assetCompositeModelExternalId":
            return Optional.ofNullable(clazz.cast(assetCompositeModelExternalId()));
        case "assetCompositeModelPath":
            return Optional.ofNullable(clazz.cast(assetCompositeModelPath()));
        case "assetCompositeModelName":
            return Optional.ofNullable(clazz.cast(assetCompositeModelName()));
        case "assetCompositeModelDescription":
            return Optional.ofNullable(clazz.cast(assetCompositeModelDescription()));
        case "assetCompositeModelType":
            return Optional.ofNullable(clazz.cast(assetCompositeModelType()));
        case "assetCompositeModelProperties":
            return Optional.ofNullable(clazz.cast(assetCompositeModelProperties()));
        case "assetCompositeModelSummaries":
            return Optional.ofNullable(clazz.cast(assetCompositeModelSummaries()));
        case "actionDefinitions":
            return Optional.ofNullable(clazz.cast(actionDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetCompositeModelResponse, T> g) {
        return obj -> g.apply((DescribeAssetCompositeModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAssetCompositeModelResponse> {
        /**
         * <p>
         * The ID of the asset, in UUID format. This ID uniquely identifies the asset within IoT SiteWise and can be
         * used with other IoT SiteWise APIs.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset, in UUID format. This ID uniquely identifies the asset within IoT SiteWise and can
         *        be used with other IoT SiteWise APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The ID of a composite model on this asset.
         * </p>
         * 
         * @param assetCompositeModelId
         *        The ID of a composite model on this asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelId(String assetCompositeModelId);

        /**
         * <p>
         * An external ID to assign to the asset model.
         * </p>
         * <p>
         * If the composite model is a component-based composite model, or one nested inside a component model, you can
         * only set the external ID using <code>UpdateAssetModelCompositeModel</code> and specifying the derived ID of
         * the model or property from the created model it's a part of.
         * </p>
         * 
         * @param assetCompositeModelExternalId
         *        An external ID to assign to the asset model.</p>
         *        <p>
         *        If the composite model is a component-based composite model, or one nested inside a component model,
         *        you can only set the external ID using <code>UpdateAssetModelCompositeModel</code> and specifying the
         *        derived ID of the model or property from the created model it's a part of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelExternalId(String assetCompositeModelExternalId);

        /**
         * <p>
         * The path to the composite model listing the parent composite models.
         * </p>
         * 
         * @param assetCompositeModelPath
         *        The path to the composite model listing the parent composite models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelPath(Collection<AssetCompositeModelPathSegment> assetCompositeModelPath);

        /**
         * <p>
         * The path to the composite model listing the parent composite models.
         * </p>
         * 
         * @param assetCompositeModelPath
         *        The path to the composite model listing the parent composite models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelPath(AssetCompositeModelPathSegment... assetCompositeModelPath);

        /**
         * <p>
         * The path to the composite model listing the parent composite models.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelPathSegment.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelPathSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelPathSegment.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #assetCompositeModelPath(List<AssetCompositeModelPathSegment>)}.
         * 
         * @param assetCompositeModelPath
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelPathSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetCompositeModelPath(java.util.Collection<AssetCompositeModelPathSegment>)
         */
        Builder assetCompositeModelPath(Consumer<AssetCompositeModelPathSegment.Builder>... assetCompositeModelPath);

        /**
         * <p>
         * The unique, friendly name for the composite model.
         * </p>
         * 
         * @param assetCompositeModelName
         *        The unique, friendly name for the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelName(String assetCompositeModelName);

        /**
         * <p>
         * A description for the composite model.
         * </p>
         * 
         * @param assetCompositeModelDescription
         *        A description for the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelDescription(String assetCompositeModelDescription);

        /**
         * <p>
         * The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or
         * <code> AWS/L4E_ANOMALY</code>.
         * </p>
         * 
         * @param assetCompositeModelType
         *        The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or
         *        <code> AWS/L4E_ANOMALY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelType(String assetCompositeModelType);

        /**
         * <p>
         * The property definitions of the composite model that was used to create the asset.
         * </p>
         * 
         * @param assetCompositeModelProperties
         *        The property definitions of the composite model that was used to create the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelProperties(Collection<AssetProperty> assetCompositeModelProperties);

        /**
         * <p>
         * The property definitions of the composite model that was used to create the asset.
         * </p>
         * 
         * @param assetCompositeModelProperties
         *        The property definitions of the composite model that was used to create the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelProperties(AssetProperty... assetCompositeModelProperties);

        /**
         * <p>
         * The property definitions of the composite model that was used to create the asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetProperty.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotsitewise.model.AssetProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetProperty.Builder#build()} is called immediately
         * and its result is passed to {@link #assetCompositeModelProperties(List<AssetProperty>)}.
         * 
         * @param assetCompositeModelProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetCompositeModelProperties(java.util.Collection<AssetProperty>)
         */
        Builder assetCompositeModelProperties(Consumer<AssetProperty.Builder>... assetCompositeModelProperties);

        /**
         * <p>
         * The list of composite model summaries.
         * </p>
         * 
         * @param assetCompositeModelSummaries
         *        The list of composite model summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelSummaries(Collection<AssetCompositeModelSummary> assetCompositeModelSummaries);

        /**
         * <p>
         * The list of composite model summaries.
         * </p>
         * 
         * @param assetCompositeModelSummaries
         *        The list of composite model summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelSummaries(AssetCompositeModelSummary... assetCompositeModelSummaries);

        /**
         * <p>
         * The list of composite model summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #assetCompositeModelSummaries(List<AssetCompositeModelSummary>)}.
         * 
         * @param assetCompositeModelSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetCompositeModelSummaries(java.util.Collection<AssetCompositeModelSummary>)
         */
        Builder assetCompositeModelSummaries(Consumer<AssetCompositeModelSummary.Builder>... assetCompositeModelSummaries);

        /**
         * <p>
         * The available actions for a composite model on this asset.
         * </p>
         * 
         * @param actionDefinitions
         *        The available actions for a composite model on this asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDefinitions(Collection<ActionDefinition> actionDefinitions);

        /**
         * <p>
         * The available actions for a composite model on this asset.
         * </p>
         * 
         * @param actionDefinitions
         *        The available actions for a composite model on this asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDefinitions(ActionDefinition... actionDefinitions);

        /**
         * <p>
         * The available actions for a composite model on this asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.ActionDefinition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotsitewise.model.ActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.ActionDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #actionDefinitions(List<ActionDefinition>)}.
         * 
         * @param actionDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.ActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionDefinitions(java.util.Collection<ActionDefinition>)
         */
        Builder actionDefinitions(Consumer<ActionDefinition.Builder>... actionDefinitions);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String assetId;

        private String assetCompositeModelId;

        private String assetCompositeModelExternalId;

        private List<AssetCompositeModelPathSegment> assetCompositeModelPath = DefaultSdkAutoConstructList.getInstance();

        private String assetCompositeModelName;

        private String assetCompositeModelDescription;

        private String assetCompositeModelType;

        private List<AssetProperty> assetCompositeModelProperties = DefaultSdkAutoConstructList.getInstance();

        private List<AssetCompositeModelSummary> assetCompositeModelSummaries = DefaultSdkAutoConstructList.getInstance();

        private List<ActionDefinition> actionDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetCompositeModelResponse model) {
            super(model);
            assetId(model.assetId);
            assetCompositeModelId(model.assetCompositeModelId);
            assetCompositeModelExternalId(model.assetCompositeModelExternalId);
            assetCompositeModelPath(model.assetCompositeModelPath);
            assetCompositeModelName(model.assetCompositeModelName);
            assetCompositeModelDescription(model.assetCompositeModelDescription);
            assetCompositeModelType(model.assetCompositeModelType);
            assetCompositeModelProperties(model.assetCompositeModelProperties);
            assetCompositeModelSummaries(model.assetCompositeModelSummaries);
            actionDefinitions(model.actionDefinitions);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetCompositeModelId() {
            return assetCompositeModelId;
        }

        public final void setAssetCompositeModelId(String assetCompositeModelId) {
            this.assetCompositeModelId = assetCompositeModelId;
        }

        @Override
        public final Builder assetCompositeModelId(String assetCompositeModelId) {
            this.assetCompositeModelId = assetCompositeModelId;
            return this;
        }

        public final String getAssetCompositeModelExternalId() {
            return assetCompositeModelExternalId;
        }

        public final void setAssetCompositeModelExternalId(String assetCompositeModelExternalId) {
            this.assetCompositeModelExternalId = assetCompositeModelExternalId;
        }

        @Override
        public final Builder assetCompositeModelExternalId(String assetCompositeModelExternalId) {
            this.assetCompositeModelExternalId = assetCompositeModelExternalId;
            return this;
        }

        public final List<AssetCompositeModelPathSegment.Builder> getAssetCompositeModelPath() {
            List<AssetCompositeModelPathSegment.Builder> result = AssetCompositeModelPathCopier
                    .copyToBuilder(this.assetCompositeModelPath);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetCompositeModelPath(
                Collection<AssetCompositeModelPathSegment.BuilderImpl> assetCompositeModelPath) {
            this.assetCompositeModelPath = AssetCompositeModelPathCopier.copyFromBuilder(assetCompositeModelPath);
        }

        @Override
        public final Builder assetCompositeModelPath(Collection<AssetCompositeModelPathSegment> assetCompositeModelPath) {
            this.assetCompositeModelPath = AssetCompositeModelPathCopier.copy(assetCompositeModelPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelPath(AssetCompositeModelPathSegment... assetCompositeModelPath) {
            assetCompositeModelPath(Arrays.asList(assetCompositeModelPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelPath(Consumer<AssetCompositeModelPathSegment.Builder>... assetCompositeModelPath) {
            assetCompositeModelPath(Stream.of(assetCompositeModelPath)
                    .map(c -> AssetCompositeModelPathSegment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAssetCompositeModelName() {
            return assetCompositeModelName;
        }

        public final void setAssetCompositeModelName(String assetCompositeModelName) {
            this.assetCompositeModelName = assetCompositeModelName;
        }

        @Override
        public final Builder assetCompositeModelName(String assetCompositeModelName) {
            this.assetCompositeModelName = assetCompositeModelName;
            return this;
        }

        public final String getAssetCompositeModelDescription() {
            return assetCompositeModelDescription;
        }

        public final void setAssetCompositeModelDescription(String assetCompositeModelDescription) {
            this.assetCompositeModelDescription = assetCompositeModelDescription;
        }

        @Override
        public final Builder assetCompositeModelDescription(String assetCompositeModelDescription) {
            this.assetCompositeModelDescription = assetCompositeModelDescription;
            return this;
        }

        public final String getAssetCompositeModelType() {
            return assetCompositeModelType;
        }

        public final void setAssetCompositeModelType(String assetCompositeModelType) {
            this.assetCompositeModelType = assetCompositeModelType;
        }

        @Override
        public final Builder assetCompositeModelType(String assetCompositeModelType) {
            this.assetCompositeModelType = assetCompositeModelType;
            return this;
        }

        public final List<AssetProperty.Builder> getAssetCompositeModelProperties() {
            List<AssetProperty.Builder> result = AssetPropertiesCopier.copyToBuilder(this.assetCompositeModelProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetCompositeModelProperties(Collection<AssetProperty.BuilderImpl> assetCompositeModelProperties) {
            this.assetCompositeModelProperties = AssetPropertiesCopier.copyFromBuilder(assetCompositeModelProperties);
        }

        @Override
        public final Builder assetCompositeModelProperties(Collection<AssetProperty> assetCompositeModelProperties) {
            this.assetCompositeModelProperties = AssetPropertiesCopier.copy(assetCompositeModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelProperties(AssetProperty... assetCompositeModelProperties) {
            assetCompositeModelProperties(Arrays.asList(assetCompositeModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelProperties(Consumer<AssetProperty.Builder>... assetCompositeModelProperties) {
            assetCompositeModelProperties(Stream.of(assetCompositeModelProperties)
                    .map(c -> AssetProperty.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetCompositeModelSummary.Builder> getAssetCompositeModelSummaries() {
            List<AssetCompositeModelSummary.Builder> result = AssetCompositeModelSummariesCopier
                    .copyToBuilder(this.assetCompositeModelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetCompositeModelSummaries(
                Collection<AssetCompositeModelSummary.BuilderImpl> assetCompositeModelSummaries) {
            this.assetCompositeModelSummaries = AssetCompositeModelSummariesCopier.copyFromBuilder(assetCompositeModelSummaries);
        }

        @Override
        public final Builder assetCompositeModelSummaries(Collection<AssetCompositeModelSummary> assetCompositeModelSummaries) {
            this.assetCompositeModelSummaries = AssetCompositeModelSummariesCopier.copy(assetCompositeModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelSummaries(AssetCompositeModelSummary... assetCompositeModelSummaries) {
            assetCompositeModelSummaries(Arrays.asList(assetCompositeModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelSummaries(
                Consumer<AssetCompositeModelSummary.Builder>... assetCompositeModelSummaries) {
            assetCompositeModelSummaries(Stream.of(assetCompositeModelSummaries)
                    .map(c -> AssetCompositeModelSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ActionDefinition.Builder> getActionDefinitions() {
            List<ActionDefinition.Builder> result = ActionDefinitionsCopier.copyToBuilder(this.actionDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionDefinitions(Collection<ActionDefinition.BuilderImpl> actionDefinitions) {
            this.actionDefinitions = ActionDefinitionsCopier.copyFromBuilder(actionDefinitions);
        }

        @Override
        public final Builder actionDefinitions(Collection<ActionDefinition> actionDefinitions) {
            this.actionDefinitions = ActionDefinitionsCopier.copy(actionDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionDefinitions(ActionDefinition... actionDefinitions) {
            actionDefinitions(Arrays.asList(actionDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionDefinitions(Consumer<ActionDefinition.Builder>... actionDefinitions) {
            actionDefinitions(Stream.of(actionDefinitions).map(c -> ActionDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAssetCompositeModelResponse build() {
            return new DescribeAssetCompositeModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
