/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies a property value used in an expression.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VariableValue implements SdkPojo, Serializable, ToCopyableBuilder<VariableValue.Builder, VariableValue> {
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyId").getter(getter(VariableValue::propertyId)).setter(setter(Builder::propertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()).build();

    private static final SdkField<String> HIERARCHY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hierarchyId").getter(getter(VariableValue::hierarchyId)).setter(setter(Builder::hierarchyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hierarchyId").build()).build();

    private static final SdkField<List<AssetModelPropertyPathSegment>> PROPERTY_PATH_FIELD = SdkField
            .<List<AssetModelPropertyPathSegment>> builder(MarshallingType.LIST)
            .memberName("propertyPath")
            .getter(getter(VariableValue::propertyPath))
            .setter(setter(Builder::propertyPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyPath").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelPropertyPathSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelPropertyPathSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_ID_FIELD,
            HIERARCHY_ID_FIELD, PROPERTY_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String propertyId;

    private final String hierarchyId;

    private final List<AssetModelPropertyPathSegment> propertyPath;

    private VariableValue(BuilderImpl builder) {
        this.propertyId = builder.propertyId;
        this.hierarchyId = builder.hierarchyId;
        this.propertyPath = builder.propertyPath;
    }

    /**
     * <p>
     * The ID of the property to use as the variable. You can use the property <code>name</code> if it's from the same
     * asset model. If the property has an external ID, you can specify <code>externalId:</code> followed by the
     * external ID. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
     * IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the property to use as the variable. You can use the property <code>name</code> if it's from
     *         the same asset model. If the property has an external ID, you can specify <code>externalId:</code>
     *         followed by the external ID. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
     *         external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String propertyId() {
        return propertyId;
    }

    /**
     * <p>
     * The ID of the hierarchy to query for the property ID. You can use the hierarchy's name instead of the hierarchy's
     * ID. If the hierarchy has an external ID, you can specify <code>externalId:</code> followed by the external ID.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
     * IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same model and
     * therefore the same <code>propertyId</code>. For example, you might have separately grouped assets that come from
     * the same asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the hierarchy to query for the property ID. You can use the hierarchy's name instead of the
     *         hierarchy's ID. If the hierarchy has an external ID, you can specify <code>externalId:</code> followed by
     *         the external ID. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
     *         external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>
     *         <p>
     *         You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same
     *         model and therefore the same <code>propertyId</code>. For example, you might have separately grouped
     *         assets that come from the same asset model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
     *         hierarchies</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String hierarchyId() {
        return hierarchyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyPath property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyPath() {
        return propertyPath != null && !(propertyPath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The path of the property.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyPath} method.
     * </p>
     * 
     * @return The path of the property.
     */
    public final List<AssetModelPropertyPathSegment> propertyPath() {
        return propertyPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyPath() ? propertyPath() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableValue)) {
            return false;
        }
        VariableValue other = (VariableValue) obj;
        return Objects.equals(propertyId(), other.propertyId()) && Objects.equals(hierarchyId(), other.hierarchyId())
                && hasPropertyPath() == other.hasPropertyPath() && Objects.equals(propertyPath(), other.propertyPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VariableValue").add("PropertyId", propertyId()).add("HierarchyId", hierarchyId())
                .add("PropertyPath", hasPropertyPath() ? propertyPath() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "propertyId":
            return Optional.ofNullable(clazz.cast(propertyId()));
        case "hierarchyId":
            return Optional.ofNullable(clazz.cast(hierarchyId()));
        case "propertyPath":
            return Optional.ofNullable(clazz.cast(propertyPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VariableValue, T> g) {
        return obj -> g.apply((VariableValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VariableValue> {
        /**
         * <p>
         * The ID of the property to use as the variable. You can use the property <code>name</code> if it's from the
         * same asset model. If the property has an external ID, you can specify <code>externalId:</code> followed by
         * the external ID. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
         * IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param propertyId
         *        The ID of the property to use as the variable. You can use the property <code>name</code> if it's from
         *        the same asset model. If the property has an external ID, you can specify <code>externalId:</code>
         *        followed by the external ID. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
         *        external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyId(String propertyId);

        /**
         * <p>
         * The ID of the hierarchy to query for the property ID. You can use the hierarchy's name instead of the
         * hierarchy's ID. If the hierarchy has an external ID, you can specify <code>externalId:</code> followed by the
         * external ID. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
         * IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same model
         * and therefore the same <code>propertyId</code>. For example, you might have separately grouped assets that
         * come from the same asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param hierarchyId
         *        The ID of the hierarchy to query for the property ID. You can use the hierarchy's name instead of the
         *        hierarchy's ID. If the hierarchy has an external ID, you can specify <code>externalId:</code> followed
         *        by the external ID. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
         *        external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same
         *        model and therefore the same <code>propertyId</code>. For example, you might have separately grouped
         *        assets that come from the same asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
         *        hierarchies</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyId(String hierarchyId);

        /**
         * <p>
         * The path of the property.
         * </p>
         * 
         * @param propertyPath
         *        The path of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyPath(Collection<AssetModelPropertyPathSegment> propertyPath);

        /**
         * <p>
         * The path of the property.
         * </p>
         * 
         * @param propertyPath
         *        The path of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyPath(AssetModelPropertyPathSegment... propertyPath);

        /**
         * <p>
         * The path of the property.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyPathSegment.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyPathSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyPathSegment.Builder#build()} is
         * called immediately and its result is passed to {@link #propertyPath(List<AssetModelPropertyPathSegment>)}.
         * 
         * @param propertyPath
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyPathSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyPath(java.util.Collection<AssetModelPropertyPathSegment>)
         */
        Builder propertyPath(Consumer<AssetModelPropertyPathSegment.Builder>... propertyPath);
    }

    static final class BuilderImpl implements Builder {
        private String propertyId;

        private String hierarchyId;

        private List<AssetModelPropertyPathSegment> propertyPath = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VariableValue model) {
            propertyId(model.propertyId);
            hierarchyId(model.hierarchyId);
            propertyPath(model.propertyPath);
        }

        public final String getPropertyId() {
            return propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final String getHierarchyId() {
            return hierarchyId;
        }

        public final void setHierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
        }

        @Override
        public final Builder hierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
            return this;
        }

        public final List<AssetModelPropertyPathSegment.Builder> getPropertyPath() {
            List<AssetModelPropertyPathSegment.Builder> result = AssetModelPropertyPathCopier.copyToBuilder(this.propertyPath);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyPath(Collection<AssetModelPropertyPathSegment.BuilderImpl> propertyPath) {
            this.propertyPath = AssetModelPropertyPathCopier.copyFromBuilder(propertyPath);
        }

        @Override
        public final Builder propertyPath(Collection<AssetModelPropertyPathSegment> propertyPath) {
            this.propertyPath = AssetModelPropertyPathCopier.copy(propertyPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyPath(AssetModelPropertyPathSegment... propertyPath) {
            propertyPath(Arrays.asList(propertyPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyPath(Consumer<AssetModelPropertyPathSegment.Builder>... propertyPath) {
            propertyPath(Stream.of(propertyPath).map(c -> AssetModelPropertyPathSegment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public VariableValue build() {
            return new VariableValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
