/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class BatchGetAssetPropertyAggregatesSkippedEntriesCopier {
    static List<BatchGetAssetPropertyAggregatesSkippedEntry> copy(
            Collection<? extends BatchGetAssetPropertyAggregatesSkippedEntry> batchGetAssetPropertyAggregatesSkippedEntriesParam) {
        List<BatchGetAssetPropertyAggregatesSkippedEntry> list;
        if (batchGetAssetPropertyAggregatesSkippedEntriesParam == null
                || batchGetAssetPropertyAggregatesSkippedEntriesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchGetAssetPropertyAggregatesSkippedEntry> modifiableList = new ArrayList<>(
                    batchGetAssetPropertyAggregatesSkippedEntriesParam.size());
            batchGetAssetPropertyAggregatesSkippedEntriesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchGetAssetPropertyAggregatesSkippedEntry> copyFromBuilder(
            Collection<? extends BatchGetAssetPropertyAggregatesSkippedEntry.Builder> batchGetAssetPropertyAggregatesSkippedEntriesParam) {
        List<BatchGetAssetPropertyAggregatesSkippedEntry> list;
        if (batchGetAssetPropertyAggregatesSkippedEntriesParam == null
                || batchGetAssetPropertyAggregatesSkippedEntriesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchGetAssetPropertyAggregatesSkippedEntry> modifiableList = new ArrayList<>(
                    batchGetAssetPropertyAggregatesSkippedEntriesParam.size());
            batchGetAssetPropertyAggregatesSkippedEntriesParam.forEach(entry -> {
                BatchGetAssetPropertyAggregatesSkippedEntry member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchGetAssetPropertyAggregatesSkippedEntry.Builder> copyToBuilder(
            Collection<? extends BatchGetAssetPropertyAggregatesSkippedEntry> batchGetAssetPropertyAggregatesSkippedEntriesParam) {
        List<BatchGetAssetPropertyAggregatesSkippedEntry.Builder> list;
        if (batchGetAssetPropertyAggregatesSkippedEntriesParam == null
                || batchGetAssetPropertyAggregatesSkippedEntriesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchGetAssetPropertyAggregatesSkippedEntry.Builder> modifiableList = new ArrayList<>(
                    batchGetAssetPropertyAggregatesSkippedEntriesParam.size());
            batchGetAssetPropertyAggregatesSkippedEntriesParam.forEach(entry -> {
                BatchGetAssetPropertyAggregatesSkippedEntry.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
