/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a gateway's platform information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatewayPlatform implements SdkPojo, Serializable, ToCopyableBuilder<GatewayPlatform.Builder, GatewayPlatform> {
    private static final SdkField<Greengrass> GREENGRASS_FIELD = SdkField.<Greengrass> builder(MarshallingType.SDK_POJO)
            .memberName("greengrass").getter(getter(GatewayPlatform::greengrass)).setter(setter(Builder::greengrass))
            .constructor(Greengrass::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrass").build()).build();

    private static final SdkField<GreengrassV2> GREENGRASS_V2_FIELD = SdkField.<GreengrassV2> builder(MarshallingType.SDK_POJO)
            .memberName("greengrassV2").getter(getter(GatewayPlatform::greengrassV2)).setter(setter(Builder::greengrassV2))
            .constructor(GreengrassV2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassV2").build()).build();

    private static final SdkField<SiemensIE> SIEMENS_IE_FIELD = SdkField.<SiemensIE> builder(MarshallingType.SDK_POJO)
            .memberName("siemensIE").getter(getter(GatewayPlatform::siemensIE)).setter(setter(Builder::siemensIE))
            .constructor(SiemensIE::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("siemensIE").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GREENGRASS_FIELD,
            GREENGRASS_V2_FIELD, SIEMENS_IE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Greengrass greengrass;

    private final GreengrassV2 greengrassV2;

    private final SiemensIE siemensIE;

    private GatewayPlatform(BuilderImpl builder) {
        this.greengrass = builder.greengrass;
        this.greengrassV2 = builder.greengrassV2;
        this.siemensIE = builder.siemensIE;
    }

    /**
     * <p>
     * A gateway that runs on IoT Greengrass.
     * </p>
     * 
     * @return A gateway that runs on IoT Greengrass.
     */
    public final Greengrass greengrass() {
        return greengrass;
    }

    /**
     * <p>
     * A gateway that runs on IoT Greengrass V2.
     * </p>
     * 
     * @return A gateway that runs on IoT Greengrass V2.
     */
    public final GreengrassV2 greengrassV2() {
        return greengrassV2;
    }

    /**
     * <p>
     * A SiteWise Edge gateway that runs on a Siemens Industrial Edge Device.
     * </p>
     * 
     * @return A SiteWise Edge gateway that runs on a Siemens Industrial Edge Device.
     */
    public final SiemensIE siemensIE() {
        return siemensIE;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(greengrass());
        hashCode = 31 * hashCode + Objects.hashCode(greengrassV2());
        hashCode = 31 * hashCode + Objects.hashCode(siemensIE());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayPlatform)) {
            return false;
        }
        GatewayPlatform other = (GatewayPlatform) obj;
        return Objects.equals(greengrass(), other.greengrass()) && Objects.equals(greengrassV2(), other.greengrassV2())
                && Objects.equals(siemensIE(), other.siemensIE());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GatewayPlatform").add("Greengrass", greengrass()).add("GreengrassV2", greengrassV2())
                .add("SiemensIE", siemensIE()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "greengrass":
            return Optional.ofNullable(clazz.cast(greengrass()));
        case "greengrassV2":
            return Optional.ofNullable(clazz.cast(greengrassV2()));
        case "siemensIE":
            return Optional.ofNullable(clazz.cast(siemensIE()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatewayPlatform, T> g) {
        return obj -> g.apply((GatewayPlatform) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatewayPlatform> {
        /**
         * <p>
         * A gateway that runs on IoT Greengrass.
         * </p>
         * 
         * @param greengrass
         *        A gateway that runs on IoT Greengrass.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greengrass(Greengrass greengrass);

        /**
         * <p>
         * A gateway that runs on IoT Greengrass.
         * </p>
         * This is a convenience method that creates an instance of the {@link Greengrass.Builder} avoiding the need to
         * create one manually via {@link Greengrass#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Greengrass.Builder#build()} is called immediately and its result
         * is passed to {@link #greengrass(Greengrass)}.
         * 
         * @param greengrass
         *        a consumer that will call methods on {@link Greengrass.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greengrass(Greengrass)
         */
        default Builder greengrass(Consumer<Greengrass.Builder> greengrass) {
            return greengrass(Greengrass.builder().applyMutation(greengrass).build());
        }

        /**
         * <p>
         * A gateway that runs on IoT Greengrass V2.
         * </p>
         * 
         * @param greengrassV2
         *        A gateway that runs on IoT Greengrass V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greengrassV2(GreengrassV2 greengrassV2);

        /**
         * <p>
         * A gateway that runs on IoT Greengrass V2.
         * </p>
         * This is a convenience method that creates an instance of the {@link GreengrassV2.Builder} avoiding the need
         * to create one manually via {@link GreengrassV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GreengrassV2.Builder#build()} is called immediately and its
         * result is passed to {@link #greengrassV2(GreengrassV2)}.
         * 
         * @param greengrassV2
         *        a consumer that will call methods on {@link GreengrassV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greengrassV2(GreengrassV2)
         */
        default Builder greengrassV2(Consumer<GreengrassV2.Builder> greengrassV2) {
            return greengrassV2(GreengrassV2.builder().applyMutation(greengrassV2).build());
        }

        /**
         * <p>
         * A SiteWise Edge gateway that runs on a Siemens Industrial Edge Device.
         * </p>
         * 
         * @param siemensIE
         *        A SiteWise Edge gateway that runs on a Siemens Industrial Edge Device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siemensIE(SiemensIE siemensIE);

        /**
         * <p>
         * A SiteWise Edge gateway that runs on a Siemens Industrial Edge Device.
         * </p>
         * This is a convenience method that creates an instance of the {@link SiemensIE.Builder} avoiding the need to
         * create one manually via {@link SiemensIE#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SiemensIE.Builder#build()} is called immediately and its result
         * is passed to {@link #siemensIE(SiemensIE)}.
         * 
         * @param siemensIE
         *        a consumer that will call methods on {@link SiemensIE.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #siemensIE(SiemensIE)
         */
        default Builder siemensIE(Consumer<SiemensIE.Builder> siemensIE) {
            return siemensIE(SiemensIE.builder().applyMutation(siemensIE).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Greengrass greengrass;

        private GreengrassV2 greengrassV2;

        private SiemensIE siemensIE;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayPlatform model) {
            greengrass(model.greengrass);
            greengrassV2(model.greengrassV2);
            siemensIE(model.siemensIE);
        }

        public final Greengrass.Builder getGreengrass() {
            return greengrass != null ? greengrass.toBuilder() : null;
        }

        public final void setGreengrass(Greengrass.BuilderImpl greengrass) {
            this.greengrass = greengrass != null ? greengrass.build() : null;
        }

        @Override
        public final Builder greengrass(Greengrass greengrass) {
            this.greengrass = greengrass;
            return this;
        }

        public final GreengrassV2.Builder getGreengrassV2() {
            return greengrassV2 != null ? greengrassV2.toBuilder() : null;
        }

        public final void setGreengrassV2(GreengrassV2.BuilderImpl greengrassV2) {
            this.greengrassV2 = greengrassV2 != null ? greengrassV2.build() : null;
        }

        @Override
        public final Builder greengrassV2(GreengrassV2 greengrassV2) {
            this.greengrassV2 = greengrassV2;
            return this;
        }

        public final SiemensIE.Builder getSiemensIE() {
            return siemensIE != null ? siemensIE.toBuilder() : null;
        }

        public final void setSiemensIE(SiemensIE.BuilderImpl siemensIE) {
            this.siemensIE = siemensIE != null ? siemensIE.build() : null;
        }

        @Override
        public final Builder siemensIE(SiemensIE siemensIE) {
            this.siemensIE = siemensIE;
            return this;
        }

        @Override
        public GatewayPlatform build() {
            return new GatewayPlatform(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
