/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssociatedAssetsRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<ListAssociatedAssetsRequest.Builder, ListAssociatedAssetsRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(ListAssociatedAssetsRequest::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetId").build()).build();

    private static final SdkField<String> HIERARCHY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hierarchyId").getter(getter(ListAssociatedAssetsRequest::hierarchyId))
            .setter(setter(Builder::hierarchyId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("hierarchyId").build()).build();

    private static final SdkField<String> TRAVERSAL_DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traversalDirection").getter(getter(ListAssociatedAssetsRequest::traversalDirectionAsString))
            .setter(setter(Builder::traversalDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("traversalDirection").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssociatedAssetsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAssociatedAssetsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            HIERARCHY_ID_FIELD, TRAVERSAL_DIRECTION_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String assetId;

    private final String hierarchyId;

    private final String traversalDirection;

    private final String nextToken;

    private final Integer maxResults;

    private ListAssociatedAssetsRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.hierarchyId = builder.hierarchyId;
        this.traversalDirection = builder.traversalDirection;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the asset to query. This can be either the actual ID in UUID format, or else <code>externalId:</code>
     * followed by the external ID, if it has one. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the asset to query. This can be either the actual ID in UUID format, or else
     *         <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     *         >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * (Optional) If you don't provide a <code>hierarchyId</code>, all the immediate assets in the
     * <code>traversalDirection</code> will be returned.
     * </p>
     * <p>
     * The ID of the hierarchy by which child assets are associated to the asset. (This can be either the actual ID in
     * UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information,
     * see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">
     * Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.)
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return (Optional) If you don't provide a <code>hierarchyId</code>, all the immediate assets in the
     *         <code>traversalDirection</code> will be returned. </p>
     *         <p>
     *         The ID of the hierarchy by which child assets are associated to the asset. (This can be either the actual
     *         ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     *         >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.)
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
     *         hierarchies</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String hierarchyId() {
        return hierarchyId;
    }

    /**
     * <p>
     * The direction to list associated assets. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHILD</code> – The list includes all child assets associated to the asset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PARENT</code> – The list includes the asset's parent asset.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>CHILD</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #traversalDirection} will return {@link TraversalDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #traversalDirectionAsString}.
     * </p>
     * 
     * @return The direction to list associated assets. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CHILD</code> – The list includes all child assets associated to the asset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PARENT</code> – The list includes the asset's parent asset.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>CHILD</code>
     * @see TraversalDirection
     */
    public final TraversalDirection traversalDirection() {
        return TraversalDirection.fromValue(traversalDirection);
    }

    /**
     * <p>
     * The direction to list associated assets. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CHILD</code> – The list includes all child assets associated to the asset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PARENT</code> – The list includes the asset's parent asset.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>CHILD</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #traversalDirection} will return {@link TraversalDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #traversalDirectionAsString}.
     * </p>
     * 
     * @return The direction to list associated assets. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CHILD</code> – The list includes all child assets associated to the asset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PARENT</code> – The list includes the asset's parent asset.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>CHILD</code>
     * @see TraversalDirection
     */
    public final String traversalDirectionAsString() {
        return traversalDirection;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return for each paginated request.
     * </p>
     * <p>
     * Default: 50
     * </p>
     * 
     * @return The maximum number of results to return for each paginated request.</p>
     *         <p>
     *         Default: 50
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyId());
        hashCode = 31 * hashCode + Objects.hashCode(traversalDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedAssetsRequest)) {
            return false;
        }
        ListAssociatedAssetsRequest other = (ListAssociatedAssetsRequest) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(hierarchyId(), other.hierarchyId())
                && Objects.equals(traversalDirectionAsString(), other.traversalDirectionAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssociatedAssetsRequest").add("AssetId", assetId()).add("HierarchyId", hierarchyId())
                .add("TraversalDirection", traversalDirectionAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "hierarchyId":
            return Optional.ofNullable(clazz.cast(hierarchyId()));
        case "traversalDirection":
            return Optional.ofNullable(clazz.cast(traversalDirectionAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociatedAssetsRequest, T> g) {
        return obj -> g.apply((ListAssociatedAssetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAssociatedAssetsRequest> {
        /**
         * <p>
         * The ID of the asset to query. This can be either the actual ID in UUID format, or else
         * <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset to query. This can be either the actual ID in UUID format, or else
         *        <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * (Optional) If you don't provide a <code>hierarchyId</code>, all the immediate assets in the
         * <code>traversalDirection</code> will be returned.
         * </p>
         * <p>
         * The ID of the hierarchy by which child assets are associated to the asset. (This can be either the actual ID
         * in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.)
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param hierarchyId
         *        (Optional) If you don't provide a <code>hierarchyId</code>, all the immediate assets in the
         *        <code>traversalDirection</code> will be returned. </p>
         *        <p>
         *        The ID of the hierarchy by which child assets are associated to the asset. (This can be either the
         *        actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one.
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.)
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
         *        hierarchies</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyId(String hierarchyId);

        /**
         * <p>
         * The direction to list associated assets. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHILD</code> – The list includes all child assets associated to the asset.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PARENT</code> – The list includes the asset's parent asset.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>CHILD</code>
         * </p>
         * 
         * @param traversalDirection
         *        The direction to list associated assets. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHILD</code> – The list includes all child assets associated to the asset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PARENT</code> – The list includes the asset's parent asset.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>CHILD</code>
         * @see TraversalDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TraversalDirection
         */
        Builder traversalDirection(String traversalDirection);

        /**
         * <p>
         * The direction to list associated assets. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CHILD</code> – The list includes all child assets associated to the asset.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PARENT</code> – The list includes the asset's parent asset.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>CHILD</code>
         * </p>
         * 
         * @param traversalDirection
         *        The direction to list associated assets. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CHILD</code> – The list includes all child assets associated to the asset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PARENT</code> – The list includes the asset's parent asset.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>CHILD</code>
         * @see TraversalDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TraversalDirection
         */
        Builder traversalDirection(TraversalDirection traversalDirection);

        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return for each paginated request.
         * </p>
         * <p>
         * Default: 50
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for each paginated request.</p>
         *        <p>
         *        Default: 50
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetId;

        private String hierarchyId;

        private String traversalDirection;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedAssetsRequest model) {
            super(model);
            assetId(model.assetId);
            hierarchyId(model.hierarchyId);
            traversalDirection(model.traversalDirection);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getHierarchyId() {
            return hierarchyId;
        }

        public final void setHierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
        }

        @Override
        public final Builder hierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
            return this;
        }

        public final String getTraversalDirection() {
            return traversalDirection;
        }

        public final void setTraversalDirection(String traversalDirection) {
            this.traversalDirection = traversalDirection;
        }

        @Override
        public final Builder traversalDirection(String traversalDirection) {
            this.traversalDirection = traversalDirection;
            return this;
        }

        @Override
        public final Builder traversalDirection(TraversalDirection traversalDirection) {
            this.traversalDirection(traversalDirection == null ? null : traversalDirection.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssociatedAssetsRequest build() {
            return new ListAssociatedAssetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
