/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.ColumnName;
import software.amazon.awssdk.services.iotsitewise.model.ColumnNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Csv
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Csv> {
    private static final SdkField<List<String>> COLUMN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("columnNames").getter(Csv.getter(Csv::columnNamesAsStrings)).setter(Csv.setter(Builder::columnNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("columnNames", COLUMN_NAMES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> columnNames;

    private Csv(BuilderImpl builder) {
        this.columnNames = builder.columnNames;
    }

    public final List<ColumnName> columnNames() {
        return ColumnNamesCopier.copyStringToEnum(this.columnNames);
    }

    public final boolean hasColumnNames() {
        return this.columnNames != null && !(this.columnNames instanceof SdkAutoConstructList);
    }

    public final List<String> columnNamesAsStrings() {
        return this.columnNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnNames() ? this.columnNamesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Csv)) {
            return false;
        }
        Csv other = (Csv)obj;
        return this.hasColumnNames() == other.hasColumnNames() && Objects.equals(this.columnNamesAsStrings(), other.columnNamesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Csv").add("ColumnNames", this.hasColumnNames() ? this.columnNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columnNames": {
                return Optional.ofNullable(clazz.cast(this.columnNamesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Csv, T> g) {
        return obj -> g.apply((Csv)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> columnNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Csv model) {
            this.columnNamesWithStrings(model.columnNames);
        }

        public final Collection<String> getColumnNames() {
            if (this.columnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnNames;
        }

        public final void setColumnNames(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
        }

        @Override
        public final Builder columnNamesWithStrings(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNamesWithStrings(String ... columnNames) {
            this.columnNamesWithStrings(Arrays.asList(columnNames));
            return this;
        }

        @Override
        public final Builder columnNames(Collection<ColumnName> columnNames) {
            this.columnNames = ColumnNamesCopier.copyEnumToString(columnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNames(ColumnName ... columnNames) {
            this.columnNames(Arrays.asList(columnNames));
            return this;
        }

        public Csv build() {
            return new Csv(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Csv> {
        public Builder columnNamesWithStrings(Collection<String> var1);

        public Builder columnNamesWithStrings(String ... var1);

        public Builder columnNames(Collection<ColumnName> var1);

        public Builder columnNames(ColumnName ... var1);
    }
}

