/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssetModelRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, DescribeAssetModelRequest> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(DescribeAssetModelRequest.getter(DescribeAssetModelRequest::assetModelId)).setter(DescribeAssetModelRequest.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelId").build()}).build();
    private static final SdkField<Boolean> EXCLUDE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("excludeProperties").getter(DescribeAssetModelRequest.getter(DescribeAssetModelRequest::excludeProperties)).setter(DescribeAssetModelRequest.setter(Builder::excludeProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("excludeProperties").build()}).build();
    private static final SdkField<String> ASSET_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelVersion").getter(DescribeAssetModelRequest.getter(DescribeAssetModelRequest::assetModelVersion)).setter(DescribeAssetModelRequest.setter(Builder::assetModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD, EXCLUDE_PROPERTIES_FIELD, ASSET_MODEL_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assetModelId", ASSET_MODEL_ID_FIELD);
            this.put("excludeProperties", EXCLUDE_PROPERTIES_FIELD);
            this.put("assetModelVersion", ASSET_MODEL_VERSION_FIELD);
        }
    });
    private final String assetModelId;
    private final Boolean excludeProperties;
    private final String assetModelVersion;

    private DescribeAssetModelRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.excludeProperties = builder.excludeProperties;
        this.assetModelVersion = builder.assetModelVersion;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final Boolean excludeProperties() {
        return this.excludeProperties;
    }

    public final String assetModelVersion() {
        return this.assetModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetModelRequest)) {
            return false;
        }
        DescribeAssetModelRequest other = (DescribeAssetModelRequest)((Object)obj);
        return Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.excludeProperties(), other.excludeProperties()) && Objects.equals(this.assetModelVersion(), other.assetModelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssetModelRequest").add("AssetModelId", (Object)this.assetModelId()).add("ExcludeProperties", (Object)this.excludeProperties()).add("AssetModelVersion", (Object)this.assetModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "excludeProperties": {
                return Optional.ofNullable(clazz.cast(this.excludeProperties()));
            }
            case "assetModelVersion": {
                return Optional.ofNullable(clazz.cast(this.assetModelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetModelRequest, T> g) {
        return obj -> g.apply((DescribeAssetModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetModelId;
        private Boolean excludeProperties;
        private String assetModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetModelRequest model) {
            super(model);
            this.assetModelId(model.assetModelId);
            this.excludeProperties(model.excludeProperties);
            this.assetModelVersion(model.assetModelVersion);
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final Boolean getExcludeProperties() {
            return this.excludeProperties;
        }

        public final void setExcludeProperties(Boolean excludeProperties) {
            this.excludeProperties = excludeProperties;
        }

        @Override
        public final Builder excludeProperties(Boolean excludeProperties) {
            this.excludeProperties = excludeProperties;
            return this;
        }

        public final String getAssetModelVersion() {
            return this.assetModelVersion;
        }

        public final void setAssetModelVersion(String assetModelVersion) {
            this.assetModelVersion = assetModelVersion;
        }

        @Override
        public final Builder assetModelVersion(String assetModelVersion) {
            this.assetModelVersion = assetModelVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAssetModelRequest build() {
            return new DescribeAssetModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssetModelRequest> {
        public Builder assetModelId(String var1);

        public Builder excludeProperties(Boolean var1);

        public Builder assetModelVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

