/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.DatasetSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListDatasetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListDatasetsResponse;

public class ListDatasetsPublisher
implements SdkPublisher<ListDatasetsResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListDatasetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatasetsPublisher(IoTSiteWiseAsyncClient client, ListDatasetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatasetsPublisher(IoTSiteWiseAsyncClient client, ListDatasetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatasetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatasetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DatasetSummary> datasetSummaries() {
        Function<ListDatasetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasetSummaries() != null) {
                return response.datasetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDatasetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDatasetsResponseFetcher
    implements AsyncPageFetcher<ListDatasetsResponse> {
        private ListDatasetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatasetsResponse> nextPage(ListDatasetsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetsPublisher.this.client.listDatasets(ListDatasetsPublisher.this.firstRequest);
            }
            return ListDatasetsPublisher.this.client.listDatasets((ListDatasetsRequest)((Object)ListDatasetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

