/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a definition for an action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionDefinition.Builder, ActionDefinition> {
    private static final SdkField<String> ACTION_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionDefinitionId").getter(getter(ActionDefinition::actionDefinitionId))
            .setter(setter(Builder::actionDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionDefinitionId").build())
            .build();

    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionName").getter(getter(ActionDefinition::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionType").getter(getter(ActionDefinition::actionType)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_DEFINITION_ID_FIELD,
            ACTION_NAME_FIELD, ACTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionDefinitionId;

    private final String actionName;

    private final String actionType;

    private ActionDefinition(BuilderImpl builder) {
        this.actionDefinitionId = builder.actionDefinitionId;
        this.actionName = builder.actionName;
        this.actionType = builder.actionType;
    }

    /**
     * <p>
     * The ID of the action definition.
     * </p>
     * 
     * @return The ID of the action definition.
     */
    public final String actionDefinitionId() {
        return actionDefinitionId;
    }

    /**
     * <p>
     * The name of the action definition.
     * </p>
     * 
     * @return The name of the action definition.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * <p>
     * The type of the action definition.
     * </p>
     * 
     * @return The type of the action definition.
     */
    public final String actionType() {
        return actionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(actionType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionDefinition)) {
            return false;
        }
        ActionDefinition other = (ActionDefinition) obj;
        return Objects.equals(actionDefinitionId(), other.actionDefinitionId())
                && Objects.equals(actionName(), other.actionName()) && Objects.equals(actionType(), other.actionType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionDefinition").add("ActionDefinitionId", actionDefinitionId())
                .add("ActionName", actionName()).add("ActionType", actionType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionDefinitionId":
            return Optional.ofNullable(clazz.cast(actionDefinitionId()));
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionDefinitionId", ACTION_DEFINITION_ID_FIELD);
        map.put("actionName", ACTION_NAME_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionDefinition, T> g) {
        return obj -> g.apply((ActionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionDefinition> {
        /**
         * <p>
         * The ID of the action definition.
         * </p>
         * 
         * @param actionDefinitionId
         *        The ID of the action definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDefinitionId(String actionDefinitionId);

        /**
         * <p>
         * The name of the action definition.
         * </p>
         * 
         * @param actionName
         *        The name of the action definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The type of the action definition.
         * </p>
         * 
         * @param actionType
         *        The type of the action definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionType(String actionType);
    }

    static final class BuilderImpl implements Builder {
        private String actionDefinitionId;

        private String actionName;

        private String actionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionDefinition model) {
            actionDefinitionId(model.actionDefinitionId);
            actionName(model.actionName);
            actionType(model.actionType);
        }

        public final String getActionDefinitionId() {
            return actionDefinitionId;
        }

        public final void setActionDefinitionId(String actionDefinitionId) {
            this.actionDefinitionId = actionDefinitionId;
        }

        @Override
        public final Builder actionDefinitionId(String actionDefinitionId) {
            this.actionDefinitionId = actionDefinitionId;
            return this;
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public ActionDefinition build() {
            return new ActionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
