/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of the composite model for a specific asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetCompositeModelSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetCompositeModelSummary.Builder, AssetCompositeModelSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssetCompositeModelSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(AssetCompositeModelSummary::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssetCompositeModelSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AssetCompositeModelSummary::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AssetCompositeModelSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<AssetCompositeModelPathSegment>> PATH_FIELD = SdkField
            .<List<AssetCompositeModelPathSegment>> builder(MarshallingType.LIST)
            .memberName("path")
            .getter(getter(AssetCompositeModelSummary::path))
            .setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetCompositeModelPathSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetCompositeModelPathSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EXTERNAL_ID_FIELD,
            NAME_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String externalId;

    private final String name;

    private final String type;

    private final String description;

    private final List<AssetCompositeModelPathSegment> path;

    private AssetCompositeModelSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.externalId = builder.externalId;
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.path = builder.path;
    }

    /**
     * <p>
     * The ID of the composite model that this summary describes.
     * </p>
     * 
     * @return The ID of the composite model that this summary describes.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * An external ID to assign to the asset model.
     * </p>
     * <p>
     * If the composite model is a derived composite model, or one nested inside a component model, you can only set the
     * external ID using <code>UpdateAssetModelCompositeModel</code> and specifying the derived ID of the model or
     * property from the created model it's a part of.
     * </p>
     * 
     * @return An external ID to assign to the asset model.</p>
     *         <p>
     *         If the composite model is a derived composite model, or one nested inside a component model, you can only
     *         set the external ID using <code>UpdateAssetModelCompositeModel</code> and specifying the derived ID of
     *         the model or property from the created model it's a part of.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The name of the composite model that this summary describes.
     * </p>
     * 
     * @return The name of the composite model that this summary describes.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of asset model.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a component
     * in another asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models.
     * You can't create assets directly from this type of asset model.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of asset model.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a
     *         component in another asset model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset
     *         models. You can't create assets directly from this type of asset model.
     *         </p>
     *         </li>
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * A description of the composite model that this summary describes.
     * </p>
     * 
     * @return A description of the composite model that this summary describes.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Path property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPath() {
        return path != null && !(path instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The path that includes all the components of the asset model for the asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPath} method.
     * </p>
     * 
     * @return The path that includes all the components of the asset model for the asset.
     */
    public final List<AssetCompositeModelPathSegment> path() {
        return path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasPath() ? path() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetCompositeModelSummary)) {
            return false;
        }
        AssetCompositeModelSummary other = (AssetCompositeModelSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(externalId(), other.externalId())
                && Objects.equals(name(), other.name()) && Objects.equals(type(), other.type())
                && Objects.equals(description(), other.description()) && hasPath() == other.hasPath()
                && Objects.equals(path(), other.path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetCompositeModelSummary").add("Id", id()).add("ExternalId", externalId()).add("Name", name())
                .add("Type", type()).add("Description", description()).add("Path", hasPath() ? path() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("path", PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetCompositeModelSummary, T> g) {
        return obj -> g.apply((AssetCompositeModelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetCompositeModelSummary> {
        /**
         * <p>
         * The ID of the composite model that this summary describes.
         * </p>
         * 
         * @param id
         *        The ID of the composite model that this summary describes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * An external ID to assign to the asset model.
         * </p>
         * <p>
         * If the composite model is a derived composite model, or one nested inside a component model, you can only set
         * the external ID using <code>UpdateAssetModelCompositeModel</code> and specifying the derived ID of the model
         * or property from the created model it's a part of.
         * </p>
         * 
         * @param externalId
         *        An external ID to assign to the asset model.</p>
         *        <p>
         *        If the composite model is a derived composite model, or one nested inside a component model, you can
         *        only set the external ID using <code>UpdateAssetModelCompositeModel</code> and specifying the derived
         *        ID of the model or property from the created model it's a part of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The name of the composite model that this summary describes.
         * </p>
         * 
         * @param name
         *        The name of the composite model that this summary describes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of asset model.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a
         * component in another asset model.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset
         * models. You can't create assets directly from this type of asset model.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of asset model.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as
         *        a component in another asset model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other
         *        asset models. You can't create assets directly from this type of asset model.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * A description of the composite model that this summary describes.
         * </p>
         * 
         * @param description
         *        A description of the composite model that this summary describes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The path that includes all the components of the asset model for the asset.
         * </p>
         * 
         * @param path
         *        The path that includes all the components of the asset model for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(Collection<AssetCompositeModelPathSegment> path);

        /**
         * <p>
         * The path that includes all the components of the asset model for the asset.
         * </p>
         * 
         * @param path
         *        The path that includes all the components of the asset model for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(AssetCompositeModelPathSegment... path);

        /**
         * <p>
         * The path that includes all the components of the asset model for the asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelPathSegment.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelPathSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelPathSegment.Builder#build()} is
         * called immediately and its result is passed to {@link #path(List<AssetCompositeModelPathSegment>)}.
         * 
         * @param path
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelPathSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #path(java.util.Collection<AssetCompositeModelPathSegment>)
         */
        Builder path(Consumer<AssetCompositeModelPathSegment.Builder>... path);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String externalId;

        private String name;

        private String type;

        private String description;

        private List<AssetCompositeModelPathSegment> path = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetCompositeModelSummary model) {
            id(model.id);
            externalId(model.externalId);
            name(model.name);
            type(model.type);
            description(model.description);
            path(model.path);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AssetCompositeModelPathSegment.Builder> getPath() {
            List<AssetCompositeModelPathSegment.Builder> result = AssetCompositeModelPathCopier.copyToBuilder(this.path);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPath(Collection<AssetCompositeModelPathSegment.BuilderImpl> path) {
            this.path = AssetCompositeModelPathCopier.copyFromBuilder(path);
        }

        @Override
        public final Builder path(Collection<AssetCompositeModelPathSegment> path) {
            this.path = AssetCompositeModelPathCopier.copy(path);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(AssetCompositeModelPathSegment... path) {
            path(Arrays.asList(path));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(Consumer<AssetCompositeModelPathSegment.Builder>... path) {
            path(Stream.of(path).map(c -> AssetCompositeModelPathSegment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssetCompositeModelSummary build() {
            return new AssetCompositeModelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
