/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an asset hierarchy that contains a hierarchy's name, ID, and child asset model ID that specifies the type
 * of asset that can be in this hierarchy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetModelHierarchy implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetModelHierarchy.Builder, AssetModelHierarchy> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssetModelHierarchy::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(AssetModelHierarchy::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssetModelHierarchy::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CHILD_ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("childAssetModelId").getter(getter(AssetModelHierarchy::childAssetModelId))
            .setter(setter(Builder::childAssetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childAssetModelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EXTERNAL_ID_FIELD,
            NAME_FIELD, CHILD_ASSET_MODEL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String externalId;

    private final String name;

    private final String childAssetModelId;

    private AssetModelHierarchy(BuilderImpl builder) {
        this.id = builder.id;
        this.externalId = builder.externalId;
        this.name = builder.name;
        this.childAssetModelId = builder.childAssetModelId;
    }

    /**
     * <p>
     * The ID of the asset model hierarchy. This ID is a <code>hierarchyId</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are callling <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
     * >UpdateAssetModel</a> to create a <i>new</i> hierarchy: You can specify its ID here, if desired. IoT SiteWise
     * automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to
     * supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be
     * globally unique.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are calling UpdateAssetModel to modify an <i>existing</i> hierarchy: This can be either the actual ID in
     * UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information,
     * see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">
     * Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ID of the asset model hierarchy. This ID is a <code>hierarchyId</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are callling <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
     *         >UpdateAssetModel</a> to create a <i>new</i> hierarchy: You can specify its ID here, if desired. IoT
     *         SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if
     *         you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your own
     *         ID, it must be globally unique.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are calling UpdateAssetModel to modify an <i>existing</i> hierarchy: This can be either the actual
     *         ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     *         >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     *         </p>
     *         </li>
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The external ID (if any) provided in the <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html"
     * >CreateAssetModel</a> or <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
     * >UpdateAssetModel</a> operation. You can assign an external ID by specifying this value as part of a call to <a
     * href
     * ="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a>.
     * However, you can't change the external ID if one is already assigned. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
     * IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The external ID (if any) provided in the <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html"
     *         >CreateAssetModel</a> or <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
     *         >UpdateAssetModel</a> operation. You can assign an external ID by specifying this value as part of a call
     *         to <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">
     *         UpdateAssetModel</a>. However, you can't change the external ID if one is already assigned. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
     *         external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The name of the asset model hierarchy that you specify by using the <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html"
     * >CreateAssetModel</a> or <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
     * >UpdateAssetModel</a> API operation.
     * </p>
     * 
     * @return The name of the asset model hierarchy that you specify by using the <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html"
     *         >CreateAssetModel</a> or <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
     *         >UpdateAssetModel</a> API operation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the asset model, in UUID format. All assets in this hierarchy must be instances of the
     * <code>childAssetModelId</code> asset model. IoT SiteWise will always return the actual asset model ID for this
     * value. However, when you are specifying this value as part of a call to <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
     * >UpdateAssetModel</a>, you may provide either the asset model ID or else <code>externalId:</code> followed by the
     * asset model's external ID. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
     * IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the asset model, in UUID format. All assets in this hierarchy must be instances of the
     *         <code>childAssetModelId</code> asset model. IoT SiteWise will always return the actual asset model ID for
     *         this value. However, when you are specifying this value as part of a call to <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
     *         >UpdateAssetModel</a>, you may provide either the asset model ID or else <code>externalId:</code>
     *         followed by the asset model's external ID. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
     *         external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String childAssetModelId() {
        return childAssetModelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(childAssetModelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetModelHierarchy)) {
            return false;
        }
        AssetModelHierarchy other = (AssetModelHierarchy) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(externalId(), other.externalId())
                && Objects.equals(name(), other.name()) && Objects.equals(childAssetModelId(), other.childAssetModelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetModelHierarchy").add("Id", id()).add("ExternalId", externalId()).add("Name", name())
                .add("ChildAssetModelId", childAssetModelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "childAssetModelId":
            return Optional.ofNullable(clazz.cast(childAssetModelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("childAssetModelId", CHILD_ASSET_MODEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetModelHierarchy, T> g) {
        return obj -> g.apply((AssetModelHierarchy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetModelHierarchy> {
        /**
         * <p>
         * The ID of the asset model hierarchy. This ID is a <code>hierarchyId</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are callling <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
         * >UpdateAssetModel</a> to create a <i>new</i> hierarchy: You can specify its ID here, if desired. IoT SiteWise
         * automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to
         * supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be
         * globally unique.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are calling UpdateAssetModel to modify an <i>existing</i> hierarchy: This can be either the actual ID
         * in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param id
         *        The ID of the asset model hierarchy. This ID is a <code>hierarchyId</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are callling <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
         *        >UpdateAssetModel</a> to create a <i>new</i> hierarchy: You can specify its ID here, if desired. IoT
         *        SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if
         *        you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your
         *        own ID, it must be globally unique.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are calling UpdateAssetModel to modify an <i>existing</i> hierarchy: This can be either the
         *        actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one.
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The external ID (if any) provided in the <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html"
         * >CreateAssetModel</a> or <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
         * >UpdateAssetModel</a> operation. You can assign an external ID by specifying this value as part of a call to
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">
         * UpdateAssetModel</a>. However, you can't change the external ID if one is already assigned. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
         * IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param externalId
         *        The external ID (if any) provided in the <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html"
         *        >CreateAssetModel</a> or <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
         *        >UpdateAssetModel</a> operation. You can assign an external ID by specifying this value as part of a
         *        call to <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
         *        >UpdateAssetModel</a>. However, you can't change the external ID if one is already assigned. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
         *        external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The name of the asset model hierarchy that you specify by using the <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html"
         * >CreateAssetModel</a> or <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
         * >UpdateAssetModel</a> API operation.
         * </p>
         * 
         * @param name
         *        The name of the asset model hierarchy that you specify by using the <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html"
         *        >CreateAssetModel</a> or <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
         *        >UpdateAssetModel</a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the asset model, in UUID format. All assets in this hierarchy must be instances of the
         * <code>childAssetModelId</code> asset model. IoT SiteWise will always return the actual asset model ID for
         * this value. However, when you are specifying this value as part of a call to <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
         * >UpdateAssetModel</a>, you may provide either the asset model ID or else <code>externalId:</code> followed by
         * the asset model's external ID. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
         * IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param childAssetModelId
         *        The ID of the asset model, in UUID format. All assets in this hierarchy must be instances of the
         *        <code>childAssetModelId</code> asset model. IoT SiteWise will always return the actual asset model ID
         *        for this value. However, when you are specifying this value as part of a call to <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html"
         *        >UpdateAssetModel</a>, you may provide either the asset model ID or else <code>externalId:</code>
         *        followed by the asset model's external ID. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
         *        external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childAssetModelId(String childAssetModelId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String externalId;

        private String name;

        private String childAssetModelId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetModelHierarchy model) {
            id(model.id);
            externalId(model.externalId);
            name(model.name);
            childAssetModelId(model.childAssetModelId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getChildAssetModelId() {
            return childAssetModelId;
        }

        public final void setChildAssetModelId(String childAssetModelId) {
            this.childAssetModelId = childAssetModelId;
        }

        @Override
        public final Builder childAssetModelId(String childAssetModelId) {
            this.childAssetModelId = childAssetModelId;
            return this;
        }

        @Override
        public AssetModelHierarchy build() {
            return new AssetModelHierarchy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
