/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateProjectAssetsRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<BatchAssociateProjectAssetsRequest.Builder, BatchAssociateProjectAssetsRequest> {
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(BatchAssociateProjectAssetsRequest::projectId))
            .setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectId").build()).build();

    private static final SdkField<List<String>> ASSET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("assetIds")
            .getter(getter(BatchAssociateProjectAssetsRequest::assetIds))
            .setter(setter(Builder::assetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(BatchAssociateProjectAssetsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ID_FIELD,
            ASSET_IDS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String projectId;

    private final List<String> assetIds;

    private final String clientToken;

    private BatchAssociateProjectAssetsRequest(BuilderImpl builder) {
        super(builder);
        this.projectId = builder.projectId;
        this.assetIds = builder.assetIds;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the project to which to associate the assets.
     * </p>
     * 
     * @return The ID of the project to which to associate the assets.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAssetIds() {
        return assetIds != null && !(assetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the assets to be associated to the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetIds} method.
     * </p>
     * 
     * @return The IDs of the assets to be associated to the project.
     */
    public final List<String> assetIds() {
        return assetIds;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetIds() ? assetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateProjectAssetsRequest)) {
            return false;
        }
        BatchAssociateProjectAssetsRequest other = (BatchAssociateProjectAssetsRequest) obj;
        return Objects.equals(projectId(), other.projectId()) && hasAssetIds() == other.hasAssetIds()
                && Objects.equals(assetIds(), other.assetIds()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAssociateProjectAssetsRequest").add("ProjectId", projectId())
                .add("AssetIds", hasAssetIds() ? assetIds() : null).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "assetIds":
            return Optional.ofNullable(clazz.cast(assetIds()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("assetIds", ASSET_IDS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateProjectAssetsRequest, T> g) {
        return obj -> g.apply((BatchAssociateProjectAssetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateProjectAssetsRequest> {
        /**
         * <p>
         * The ID of the project to which to associate the assets.
         * </p>
         * 
         * @param projectId
         *        The ID of the project to which to associate the assets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The IDs of the assets to be associated to the project.
         * </p>
         * 
         * @param assetIds
         *        The IDs of the assets to be associated to the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetIds(Collection<String> assetIds);

        /**
         * <p>
         * The IDs of the assets to be associated to the project.
         * </p>
         * 
         * @param assetIds
         *        The IDs of the assets to be associated to the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetIds(String... assetIds);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String projectId;

        private List<String> assetIds = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateProjectAssetsRequest model) {
            super(model);
            projectId(model.projectId);
            assetIds(model.assetIds);
            clientToken(model.clientToken);
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final Collection<String> getAssetIds() {
            if (assetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return assetIds;
        }

        public final void setAssetIds(Collection<String> assetIds) {
            this.assetIds = IDsCopier.copy(assetIds);
        }

        @Override
        public final Builder assetIds(Collection<String> assetIds) {
            this.assetIds = IDsCopier.copy(assetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetIds(String... assetIds) {
            assetIds(Arrays.asList(assetIds));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateProjectAssetsRequest build() {
            return new BatchAssociateProjectAssetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
